/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.debug;

import net.ffxml.swtforms.layout.CellConstraints;
import net.ffxml.swtforms.layout.ColumnSpec;
import net.ffxml.swtforms.layout.FormLayout;
import net.ffxml.swtforms.layout.RowSpec;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public final class FormDebugUtils {
    public static void dumpAll(Composite composite) {
        if (!(composite.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout layout = (FormLayout)composite.getLayout();
        FormDebugUtils.dumpColumnSpecs(layout);
        FormDebugUtils.dumpRowSpecs(layout);
        System.out.println();
        FormDebugUtils.dumpColumnGroups(layout);
        FormDebugUtils.dumpRowGroups(layout);
        System.out.println();
        FormDebugUtils.dumpConstraints(composite);
        FormDebugUtils.dumpGridBounds(composite);
    }

    public static void dumpColumnSpecs(FormLayout layout) {
        System.out.print("COLUMN SPECS:");
        for (int col = 1; col <= layout.getColumnCount(); ++col) {
            ColumnSpec colSpec = layout.getColumnSpec(col);
            System.out.print(colSpec.toShortString());
            if (col >= layout.getColumnCount()) continue;
            System.out.print(", ");
        }
        System.out.println();
    }

    public static void dumpRowSpecs(FormLayout layout) {
        System.out.print("ROW SPECS:   ");
        for (int row = 1; row <= layout.getRowCount(); ++row) {
            RowSpec rowSpec = layout.getRowSpec(row);
            System.out.print(rowSpec.toShortString());
            if (row >= layout.getRowCount()) continue;
            System.out.print(", ");
        }
        System.out.println();
    }

    public static void dumpColumnGroups(FormLayout layout) {
        FormDebugUtils.dumpGroups("COLUMN GROUPS: ", layout.getColumnGroups());
    }

    public static void dumpRowGroups(FormLayout layout) {
        FormDebugUtils.dumpGroups("ROW GROUPS:    ", layout.getRowGroups());
    }

    public static void dumpGridBounds(Composite composite) {
        System.out.println("GRID BOUNDS");
        FormDebugUtils.dumpGridBounds(FormDebugUtils.getLayoutInfo(composite));
    }

    public static void dumpGridBounds(FormLayout.LayoutInfo layoutInfo) {
        System.out.print("COLUMN ORIGINS: ");
        for (int col = 0; col < layoutInfo.columnOrigins.length; ++col) {
            System.out.print(layoutInfo.columnOrigins[col] + " ");
        }
        System.out.println();
        System.out.print("ROW ORIGINS:    ");
        for (int row = 0; row < layoutInfo.rowOrigins.length; ++row) {
            System.out.print(layoutInfo.rowOrigins[row] + " ");
        }
        System.out.println();
    }

    public static void dumpConstraints(Composite composite) {
        System.out.println("COMPONENT CONSTRAINTS");
        if (!(composite.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout layout = (FormLayout)composite.getLayout();
        int childCount = composite.getChildren().length;
        for (int i = 0; i < childCount; ++i) {
            Control child = composite.getChildren()[i];
            CellConstraints cc = layout.getConstraints(child);
            String ccString = cc == null ? "no constraints" : cc.toShortString(layout);
            System.out.print(ccString);
            System.out.print("; ");
            String childType = child.getClass().getName();
            System.out.print(childType);
            if (child instanceof Label) {
                Label label = (Label)child;
                System.out.print("      \"" + label.getText() + "\"");
            }
            System.out.println();
        }
        System.out.println();
    }

    private static void dumpGroups(String title, int[][] allGroups) {
        System.out.print(title + " {");
        for (int group = 0; group < allGroups.length; ++group) {
            int[] groupIndices = allGroups[group];
            System.out.print(" {");
            for (int i = 0; i < groupIndices.length; ++i) {
                System.out.print(groupIndices[i]);
                if (i >= groupIndices.length - 1) continue;
                System.out.print(", ");
            }
            System.out.print("} ");
            if (group >= allGroups.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println("}");
    }

    public static FormLayout.LayoutInfo getLayoutInfo(Composite composite) {
        if (!(composite.getLayout() instanceof FormLayout)) {
            throw new IllegalArgumentException("The container must use an instance of FormLayout.");
        }
        FormLayout layout = (FormLayout)composite.getLayout();
        return layout.getLayoutInfo(composite);
    }

    public static void debugLayout(Composite composite) {
        FormDebugUtils.debugLayout(composite, false, null);
    }

    public static void debugLayout(Composite composite, Color gridColor) {
        FormDebugUtils.debugLayout(composite, false, gridColor);
    }

    public static void debugLayout(Composite composite, boolean paintDiagonals) {
        FormDebugUtils.debugLayout(composite, paintDiagonals, null);
    }

    public static void debugLayout(Composite composite, boolean paintDiagonals, Color gridColor) {
        FormDebug debug = new FormDebug();
        if (gridColor == null) {
            gridColor = new Color((Device)Display.getCurrent(), 255, 0, 0);
            composite.addDisposeListener((DisposeListener)debug);
        }
        debug.color = gridColor;
        debug.paintDiagonals = paintDiagonals;
        debug.composite = composite;
        composite.addPaintListener((PaintListener)debug);
    }

    static class FormDebug
    implements DisposeListener,
    PaintListener {
        Composite composite = null;
        Color color = null;
        boolean paintDiagonals = false;

        FormDebug() {
        }

        public void paintControl(PaintEvent paintEvent) {
            if (!(this.composite.getLayout() instanceof FormLayout)) {
                return;
            }
            FormLayout.LayoutInfo layoutInfo = FormDebugUtils.getLayoutInfo(this.composite);
            int left = layoutInfo.getX();
            int top = layoutInfo.getY();
            int width = layoutInfo.getWidth();
            int height = layoutInfo.getHeight();
            GC gc = paintEvent.gc;
            gc.setForeground(this.color);
            for (int col = 0; col < layoutInfo.columnOrigins.length; ++col) {
                gc.drawLine(layoutInfo.columnOrigins[col], top, layoutInfo.columnOrigins[col], top + height);
            }
            for (int row = 0; row < layoutInfo.rowOrigins.length; ++row) {
                gc.drawLine(left, layoutInfo.rowOrigins[row], left + width, layoutInfo.rowOrigins[row]);
            }
            if (this.paintDiagonals) {
                gc.drawLine(left, top, left + width, top + height);
                gc.drawLine(left, top + height, left + width, top);
            }
        }

        public void widgetDisposed(DisposeEvent arg0) {
            this.color.dispose();
        }
    }
}

