/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.builder;

import net.ffxml.swtforms.builder.AbstractFormBuilder;
import net.ffxml.swtforms.factories.Borders;
import net.ffxml.swtforms.factories.ComponentFactory;
import net.ffxml.swtforms.factories.DefaultComponentFactory;
import net.ffxml.swtforms.layout.Border;
import net.ffxml.swtforms.layout.CellConstraints;
import net.ffxml.swtforms.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class PanelBuilder
extends AbstractFormBuilder {
    private ComponentFactory componentFactory;
    protected Composite composite;

    public PanelBuilder(Composite panel, FormLayout layout) {
        super(panel, layout);
        this.composite = panel;
    }

    public final Composite getComposite() {
        return this.getContainer();
    }

    public final void setBorder(Border border) {
        this.getLayout().setBorder(border);
    }

    public final void setDefaultDialogBorder() {
        this.setBorder(Borders.DIALOG_BORDER);
    }

    public final Label addLabel(String textWithMnemonic, CellConstraints constraints) {
        Label label = this.getComponentFactory().createLabel(this.composite, textWithMnemonic);
        this.add((Control)label, constraints);
        return label;
    }

    public final Label addLabel(String textWithMnemonic, String encodedConstraints) {
        return this.addLabel(textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final Label addLabel(String textWithMnemonic) {
        return this.addLabel(textWithMnemonic, this.cellConstraints());
    }

    public final Label add(Label label, CellConstraints labelConstraints, Control component, CellConstraints componentConstraints) {
        this.add((Control)label, labelConstraints);
        this.add(component, componentConstraints);
        return label;
    }

    public final Label addTitle(String text, CellConstraints constraints) {
        Label titleLabel = this.getComponentFactory().createTitle(this.composite, text);
        this.add((Control)titleLabel, constraints);
        return titleLabel;
    }

    public final Label addTitle(String text, String encodedConstraints) {
        return this.addTitle(text, new CellConstraints(encodedConstraints));
    }

    public final Label addTitle(String text) {
        return this.addTitle(text, this.cellConstraints());
    }

    public final Control addSeparator(String text, CellConstraints constraints) {
        int titleAlignment = (this.getComposite().getStyle() & 0x2000000) == 0x2000000 ? 2 : 4;
        Control titledSeparator = this.getComponentFactory().createSeparator(this.composite, text, titleAlignment);
        this.add(titledSeparator, constraints);
        return titledSeparator;
    }

    public final Control addSeparator(String text, String encodedConstraints) {
        return this.addSeparator(text, new CellConstraints(encodedConstraints));
    }

    public final Control addSeparator(String text, int columnSpan) {
        return this.addSeparator(text, new CellConstraints(this.getColumn(), this.getRow(), columnSpan, 1));
    }

    public final Control addSeparator(String text) {
        return this.addSeparator(text, this.getLayout().getColumnCount());
    }

    protected final ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = DefaultComponentFactory.getInstance();
        }
        return this.componentFactory;
    }

    protected final void setComponentFactory(ComponentFactory newFactory) {
        this.componentFactory = newFactory;
    }

    public Button addButton(String text, int style) {
        return this.addButton(text, style, this.cellConstraints());
    }

    public Button addButton(String text, int style, String encodedConstraints) {
        return this.addButton(text, style, new CellConstraints(encodedConstraints));
    }

    public Button addButton(String text, int style, CellConstraints constraints) {
        Button button = new Button(this.composite, style);
        button.setText(text);
        this.add((Control)button, constraints);
        return button;
    }
}

