/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.builder;

import net.ffxml.swtforms.builder.PanelBuilder;
import net.ffxml.swtforms.factories.FormFactory;
import net.ffxml.swtforms.layout.ColumnSpec;
import net.ffxml.swtforms.layout.ConstantSize;
import net.ffxml.swtforms.layout.FormLayout;
import net.ffxml.swtforms.layout.RowSpec;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class ButtonStackBuilder
extends PanelBuilder {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[]{FormFactory.BUTTON_COLSPEC};
    private static final RowSpec[] ROW_SPECS = new RowSpec[0];
    private static final String NARROW_KEY = "jgoodies.isNarrow";

    public ButtonStackBuilder(Composite composite) {
        super(composite, new FormLayout(COL_SPECS, ROW_SPECS));
    }

    public void addButtons(Button[] buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            this.addGridded((Control)buttons[i]);
            if (i >= buttons.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addFixed(Control control) {
        this.getLayout().appendRow(FormFactory.PREF_ROWSPEC);
        this.add(control);
        this.nextRow();
    }

    public void addGridded(Control control) {
        this.getLayout().appendRow(FormFactory.PREF_ROWSPEC);
        this.getLayout().addGroupedRow(this.getRow());
        this.add(control);
        this.nextRow();
    }

    public void addGriddedNarrow(Control control) {
        control.setData(NARROW_KEY, (Object)Boolean.TRUE);
        this.addGridded(control);
    }

    public void addGlue() {
        this.appendGlueRow();
        this.nextRow();
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapRow();
        this.nextRow();
    }

    public void addUnrelatedGap() {
        this.appendUnrelatedComponentsGapRow();
        this.nextRow();
    }

    public void addStrut(ConstantSize size) {
        this.getLayout().appendRow(new RowSpec(RowSpec.TOP, size, 0.0));
        this.nextRow();
    }
}

