/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.builder;

import net.ffxml.swtforms.builder.PanelBuilder;
import net.ffxml.swtforms.factories.Borders;
import net.ffxml.swtforms.factories.FormFactory;
import net.ffxml.swtforms.layout.ColumnSpec;
import net.ffxml.swtforms.layout.ConstantSize;
import net.ffxml.swtforms.layout.FormLayout;
import net.ffxml.swtforms.layout.RowSpec;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class ButtonBarBuilder
extends PanelBuilder {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[0];
    private static final RowSpec ROW_SPEC = new RowSpec("center:pref");
    private static final RowSpec[] ROW_SPECS = new RowSpec[]{ROW_SPEC};
    private static final String NARROW_KEY = "jgoodies.isNarrow";

    public ButtonBarBuilder(Composite composite) {
        super(composite, new FormLayout(COL_SPECS, ROW_SPECS));
    }

    public void setDefaultButtonBarGapBorder() {
        this.getLayout().setBorder(Borders.BUTTON_BAR_GAP_BORDER);
    }

    public void addGriddedButtons(Button[] buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            this.addGridded((Control)buttons[i]);
            if (i >= buttons.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addGriddedNarrowButtons(Button[] buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            this.addGriddedNarrow((Control)buttons[i]);
            if (i >= buttons.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addGriddedGrowingButtons(Button[] buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            this.addGriddedGrowing((Control)buttons[i]);
            if (i >= buttons.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addFixed(Control control) {
        this.getLayout().appendColumn(FormFactory.PREF_COLSPEC);
        this.add(control);
        this.nextColumn();
    }

    public void addFixedNarrow(Control control) {
        control.setData(NARROW_KEY, (Object)Boolean.TRUE);
        this.addFixed(control);
    }

    public void addGridded(Control control) {
        this.getLayout().appendColumn(FormFactory.BUTTON_COLSPEC);
        this.getLayout().addGroupedColumn(this.getColumn());
        control.setData(NARROW_KEY, (Object)Boolean.TRUE);
        this.add(control);
        this.nextColumn();
    }

    public void addGriddedNarrow(Control control) {
        this.addGridded(control);
    }

    public void addGriddedGrowing(Control control) {
        this.getLayout().appendColumn(FormFactory.GROWING_BUTTON_COLSPEC);
        this.getLayout().addGroupedColumn(this.getColumn());
        control.setData(NARROW_KEY, (Object)Boolean.TRUE);
        this.add(control);
        this.nextColumn();
    }

    public void addGriddedGrowingNarrow(Control control) {
        control.setData(NARROW_KEY, (Object)Boolean.TRUE);
        this.addGriddedGrowing(control);
    }

    public void addGlue() {
        this.appendGlueColumn();
        this.nextColumn();
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapColumn();
        this.nextColumn();
    }

    public void addUnrelatedGap() {
        this.appendUnrelatedComponentsGapColumn();
        this.nextColumn();
    }

    public void addStrut(ConstantSize size) {
        this.getLayout().appendColumn(new ColumnSpec(ColumnSpec.LEFT, size, 0.0));
        this.nextColumn();
    }
}

