/*
 * Decompiled with CFR 0.152.
 */
package net.ffxml.swtforms.builder;

import net.ffxml.swtforms.factories.FormFactory;
import net.ffxml.swtforms.layout.CellConstraints;
import net.ffxml.swtforms.layout.ColumnSpec;
import net.ffxml.swtforms.layout.FormLayout;
import net.ffxml.swtforms.layout.RowSpec;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractFormBuilder {
    private final Composite container;
    private final FormLayout layout;
    private CellConstraints currentCellConstraints;
    private boolean leftToRight = true;

    public AbstractFormBuilder(Composite container, FormLayout layout) {
        this.container = container;
        this.layout = layout;
        container.setLayout((Layout)layout);
        this.currentCellConstraints = new CellConstraints();
    }

    public final Composite getContainer() {
        return this.container;
    }

    public final FormLayout getLayout() {
        return this.layout;
    }

    public final int getColumnCount() {
        return this.getLayout().getColumnCount();
    }

    public final int getRowCount() {
        return this.getLayout().getRowCount();
    }

    public final boolean isLeftToRight() {
        return this.leftToRight;
    }

    public final void setLeftToRight(boolean b) {
        this.leftToRight = b;
    }

    public final int getColumn() {
        return this.currentCellConstraints.gridX;
    }

    public final void setColumn(int column) {
        this.currentCellConstraints.gridX = column;
    }

    public final int getRow() {
        return this.currentCellConstraints.gridY;
    }

    public final void setRow(int row) {
        this.currentCellConstraints.gridY = row;
    }

    public final void setColumnSpan(int columnSpan) {
        this.currentCellConstraints.gridWidth = columnSpan;
    }

    public final void setRowSpan(int rowSpan) {
        this.currentCellConstraints.gridHeight = rowSpan;
    }

    public final void setOrigin(int column, int row) {
        this.setColumn(column);
        this.setRow(row);
    }

    public final void setExtent(int columnSpan, int rowSpan) {
        this.setColumnSpan(columnSpan);
        this.setRowSpan(rowSpan);
    }

    public final void setBounds(int column, int row, int columnSpan, int rowSpan) {
        this.setColumn(column);
        this.setRow(row);
        this.setColumnSpan(columnSpan);
        this.setRowSpan(rowSpan);
    }

    public final void nextColumn() {
        this.nextColumn(1);
    }

    public final void nextColumn(int columns) {
        this.currentCellConstraints.gridX += columns * this.getColumnIncrementSign();
    }

    public final void nextRow() {
        this.nextRow(1);
    }

    public final void nextRow(int rows) {
        this.currentCellConstraints.gridY += rows;
    }

    public final void nextLine() {
        this.nextLine(1);
    }

    public final void nextLine(int lines) {
        this.nextRow(lines);
        this.setColumn(this.getLeadingColumn());
    }

    public final void setHAlignment(CellConstraints.Alignment alignment) {
        this.currentCellConstraints.hAlign = alignment;
    }

    public final void setVAlignment(CellConstraints.Alignment alignment) {
        this.currentCellConstraints.vAlign = alignment;
    }

    public final void setAlignment(CellConstraints.Alignment hAlign, CellConstraints.Alignment vAlign) {
        this.setHAlignment(hAlign);
        this.setVAlignment(vAlign);
    }

    public final void appendColumn(ColumnSpec columnSpec) {
        this.getLayout().appendColumn(columnSpec);
    }

    public final void appendColumn(String encodedColumnSpec) {
        this.appendColumn(new ColumnSpec(encodedColumnSpec));
    }

    public final void appendGlueColumn() {
        this.appendColumn(FormFactory.GLUE_COLSPEC);
    }

    public final void appendRelatedComponentsGapColumn() {
        this.appendColumn(FormFactory.RELATED_GAP_COLSPEC);
    }

    public final void appendUnrelatedComponentsGapColumn() {
        this.appendColumn(FormFactory.UNRELATED_GAP_COLSPEC);
    }

    public final void appendRow(RowSpec rowSpec) {
        this.getLayout().appendRow(rowSpec);
    }

    public final void appendRow(String encodedRowSpec) {
        this.appendRow(new RowSpec(encodedRowSpec));
    }

    public final void appendGlueRow() {
        this.appendRow(FormFactory.GLUE_ROWSPEC);
    }

    public final void appendRelatedComponentsGapRow() {
        this.appendRow(FormFactory.RELATED_GAP_ROWSPEC);
    }

    public final void appendUnrelatedComponentsGapRow() {
        this.appendRow(FormFactory.UNRELATED_GAP_ROWSPEC);
    }

    public final Control add(Control component, CellConstraints cellConstraints) {
        component.setLayoutData((Object)cellConstraints);
        this.layout.addLayoutComponent(component, cellConstraints);
        return component;
    }

    public final Control add(Control component, String encodedCellConstraints) {
        component.setParent(this.container);
        CellConstraints cc = new CellConstraints(encodedCellConstraints);
        component.setLayoutData((Object)cc);
        this.layout.addLayoutComponent(component, cc);
        return component;
    }

    public final Control add(Control component) {
        this.add(component, this.currentCellConstraints);
        this.layout.addLayoutComponent(component, this.currentCellConstraints);
        return component;
    }

    protected final CellConstraints cellConstraints() {
        return this.currentCellConstraints;
    }

    protected int getLeadingColumn() {
        return this.isLeftToRight() ? 1 : this.getColumnCount();
    }

    protected final int getColumnIncrementSign() {
        return this.isLeftToRight() ? 1 : -1;
    }
}

