/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class TreeSubItemCheckListener
implements Listener {
    public void handleEvent(Event event) {
        if (event.detail == 32 && event.item instanceof TreeItem) {
            this.checkAllSubItems((TreeItem)event.item);
            this.checkParentState((TreeItem)event.item);
        }
    }

    public void checkAllSubItems(TreeItem item) {
        TreeItem[] subItems = item.getItems();
        if (subItems != null) {
            for (int i = 0; i < subItems.length; ++i) {
                subItems[i].setChecked(item.getChecked());
            }
        }
    }

    public void checkParentState(TreeItem item) {
        TreeItem parent = item.getParentItem();
        if (parent != null && parent.getItems() != null) {
            TreeItem[] children = parent.getItems();
            boolean allChecked = true;
            boolean noneChecked = true;
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].getChecked()) {
                    allChecked = false;
                    continue;
                }
                noneChecked = false;
            }
            if (noneChecked) {
                parent.setChecked(false);
                parent.setGrayed(false);
            } else if (!allChecked) {
                parent.setChecked(true);
                parent.setGrayed(true);
            } else {
                parent.setChecked(true);
                parent.setGrayed(false);
            }
        } else {
            item.setGrayed(false);
        }
    }
}

