/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    private static final int BUTTON_WIDTH = 16;
    private Text text;
    private Button up;
    private Button down;
    private int minimum;
    private int maximum;
    private int increment;

    public Spinner(Composite parent, int style) {
        super(parent, style);
        this.text = new Text((Composite)this, style | 4 | 0x800);
        this.up = new Button((Composite)this, style | 4 | 0x80);
        this.down = new Button((Composite)this, style | 4 | 0x400);
        this.text.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.verify(e);
            }
        });
        this.text.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.traverse(e);
            }
        });
        this.up.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.up();
            }
        });
        this.down.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.down();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.resize();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.focusIn();
            }
        });
        this.text.setFont(this.getFont());
        this.minimum = 0;
        this.maximum = 9;
        this.increment = 1;
        this.setSelection(this.minimum);
    }

    public void setIncrement(int incr) {
        this.increment = incr;
    }

    public void setEnabled(boolean enabled) {
        this.text.setEditable(enabled);
        this.up.setEnabled(enabled);
        this.down.setEnabled(enabled);
    }

    public int getIncrement() {
        return this.increment;
    }

    void verify(Event e) {
        try {
            if (e.text == null || !e.text.equals("")) {
                Integer.parseInt(e.text);
            }
        }
        catch (NumberFormatException ex) {
            e.doit = false;
        }
    }

    void traverse(Event e) {
        switch (e.detail) {
            case 32: {
                if (e.keyCode != 0x1000001) break;
                e.doit = true;
                e.detail = 0;
                this.up();
                break;
            }
            case 64: {
                if (e.keyCode != 0x1000002) break;
                e.doit = true;
                e.detail = 0;
                this.down();
            }
        }
    }

    void up() {
        int sel = this.getMinimum();
        try {
            sel = this.getSelection();
        }
        catch (NumberFormatException nfe) {
            sel = this.getMinimum();
        }
        this.setSelection(sel + this.getIncrement());
        this.notifyListeners(13, new Event());
    }

    void down() {
        try {
            this.setSelection(this.getSelection() - this.getIncrement());
        }
        catch (NumberFormatException nfe) {
            this.setSelection(this.getMinimum());
        }
        this.notifyListeners(13, new Event());
    }

    void focusIn() {
        this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
    }

    public void setSelection(int selection) {
        if (selection < this.minimum) {
            selection = this.minimum;
        } else if (selection > this.maximum) {
            selection = this.maximum;
        }
        this.text.setText(String.valueOf(selection));
        this.text.selectAll();
        this.text.setFocus();
    }

    public int getSelection() {
        return Integer.parseInt(this.text.getText());
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        this.maximum = maximum;
        this.resize();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    void resize() {
        Point pt = this.computeSize(-1, -1);
        int textWidth = pt.x - 16;
        int buttonHeight = pt.y / 2;
        this.text.setBounds(0, 0, textWidth, pt.y);
        this.up.setBounds(textWidth, 0, 16, buttonHeight);
        this.down.setBounds(textWidth, pt.y - buttonHeight, 16, buttonHeight);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this.text);
        Point textExtent = gc.textExtent(String.valueOf(this.maximum));
        gc.dispose();
        Point pt = this.text.computeSize(textExtent.x, textExtent.y);
        int width = pt.x + 16;
        int height = pt.y;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new SWTError(4);
        }
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)listener));
    }
}

