/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.ExceptionUtility;
import com.agitar.common.util.IOUtility;
import com.agitar.eclipse.core.AgUIException;
import com.agitar.eclipse.core.util.AgErrorDialog;
import com.agitar.eclipse.core.util.AgSelectionConverter;
import com.agitar.lib.NoObfuscation;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.browser.MockWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class PluginUtils
implements NoObfuscation {
    public static final String RESOURCES_PLUGIN_ID = "org.eclipse.core.resources";
    private static boolean isUnderTest = false;

    private PluginUtils() {
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IJavaElement getEditorInputJavaElement(IEditorInput editorInput) {
        return (IJavaElement)editorInput.getAdapter(IJavaElement.class);
    }

    private static Map createModificationStampMap(List files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            map.put(file, new Long(file.getModificationStamp()));
        }
        return map;
    }

    private static IStatus addModified(IStatus status, IFile file) {
        Status entry = new Status(4, RESOURCES_PLUGIN_ID, 10003, "File " + file.getFullPath().toString() + " has been modified since the beginning of the operation", null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("com.agitar.eclipse.coverage", 10003, "There are modified resources", null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }

    public static IStatus makeCommittable(IResource[] resources, Object context) {
        ArrayList<IResource> readOnlyFiles = new ArrayList<IResource>();
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            if (resource.getType() != 1 || !resource.isReadOnly()) continue;
            readOnlyFiles.add(resource);
        }
        if (readOnlyFiles.size() == 0) {
            return new Status(0, "com.agitar.eclipse.coverage", 0, "", null);
        }
        Map oldTimeStamps = PluginUtils.createModificationStampMap(readOnlyFiles);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]), context);
        if (!status.isOK()) {
            return status;
        }
        IStatus modified = null;
        Map newTimeStamps = PluginUtils.createModificationStampMap(readOnlyFiles);
        Iterator iter = oldTimeStamps.keySet().iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            if (oldTimeStamps.get(file).equals(newTimeStamps.get(file))) continue;
            modified = PluginUtils.addModified(modified, file);
        }
        if (modified != null) {
            return modified;
        }
        return new Status(0, RESOURCES_PLUGIN_ID, 0, "", null);
    }

    public static IJavaElement getEditorInputJavaElement(IEditorPart editor, boolean primaryOnly) {
        Assert.isNotNull((Object)editor);
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IJavaElement je = PluginUtils.getEditorInputJavaElement(editorInput);
        if (je != null || primaryOnly) {
            return je;
        }
        return (IJavaElement)editorInput.getAdapter(IJavaElement.class);
    }

    public static File getFile(IResource resource) {
        return IOUtility.getCanonicalFile((File)resource.getLocation().toFile());
    }

    public static String getCanonicalPath(IResource resource) {
        return IOUtility.getCanonicalPath((File)resource.getLocation().toFile());
    }

    public static boolean isEclipse30() {
        Bundle bundle = ResourcesPlugin.getPlugin().getBundle();
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        PluginVersionIdentifier ident = new PluginVersionIdentifier(version);
        return ident.getMajorComponent() == 3 && ident.getMinorComponent() == 0;
    }

    public static boolean isEclipse32() {
        Bundle bundle = ResourcesPlugin.getPlugin().getBundle();
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        PluginVersionIdentifier ident = new PluginVersionIdentifier(version);
        return ident.getMajorComponent() == 3 && ident.getMinorComponent() == 2;
    }

    public static IStatus makeStatus(Exception ex, String pluginID) {
        return new Status(4, pluginID, -1, ExceptionUtility.getMessageFromThrowable((Throwable)ex), (Throwable)ex);
    }

    private static void checkLocationDeleted(IProject project, final Shell shell) throws CoreException {
        if (!project.exists()) {
            return;
        }
        File location = PluginUtils.getFile((IResource)project);
        if (!location.exists()) {
            final String message = MessageFormat.format("The location for project ''{0}'' ({1}) has been deleted.\n Delete ''{0}'' from the workspace?", project.getName(), location.getAbsolutePath());
            final boolean[] result = new boolean[1];
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    result[0] = MessageDialog.openQuestion((Shell)shell, (String)"Project location has been deleted", (String)message);
                }
            });
            if (result[0]) {
                project.delete(true, true, null);
            }
        }
    }

    public static IStatus validateEdit(Shell shell, IFile[] ifiles) {
        MessageDialog dialog;
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(ifiles, (Object)shell);
        while (shell != null && status.getSeverity() != 0 && status.getCode() == 279 && (dialog = new MessageDialog(shell, "Warning", null, status.getMessage(), 3, new String[]{IDialogConstants.RETRY_LABEL, IDialogConstants.CANCEL_LABEL}, 0)).open() == 0) {
            status = ResourcesPlugin.getWorkspace().validateEdit(ifiles, (Object)shell);
        }
        return status;
    }

    public static Path findFileInPlugin(String plugin, String file) throws MalformedURLException, IOException {
        URL pluginURL = Platform.find((Bundle)Platform.getBundle((String)plugin), (IPath)new Path("/"));
        if (pluginURL == null) {
            return null;
        }
        URL jarURL = new URL(pluginURL, file);
        URL localJarURL = Platform.asLocalURL((URL)jarURL);
        return new Path(localJarURL.getPath());
    }

    public static IEditorPart openInEditor(IType sourceElement) throws PartInitException, JavaModelException {
        IEditorPart part = JavaUI.openInEditor((IJavaElement)sourceElement);
        if (part != null) {
            JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)sourceElement);
        }
        return part;
    }

    public static Object getFirstSelection(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            return ssel.isEmpty() ? null : ssel.getFirstElement();
        }
        return null;
    }

    public static String makeRealAbsolutePath(IPath path) {
        IPath fileLoc;
        IResource rc = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        String str = null;
        if (rc != null && (fileLoc = rc.getLocation()) != null) {
            str = fileLoc.toOSString();
        }
        if (str == null) {
            str = path.makeAbsolute().toOSString();
        }
        return IOUtility.getCanonicalPath((File)new File(str));
    }

    public static IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window == null ? null : window.getActivePage();
    }

    public static void hideView(IViewPart view) {
        IWorkbenchPage page = PluginUtils.getPage();
        if (page != null) {
            page.hideView(view);
        }
    }

    public static IViewPart showView(String id) throws PartInitException {
        IWorkbenchPage page = PluginUtils.getPage();
        return page == null ? null : page.showView(id);
    }

    public static void setUnderTest(boolean b) {
        isUnderTest = b;
    }

    public static boolean isUnderTest() {
        return isUnderTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void displayExceptionInfo(Shell shell, Throwable ex, String pluginID) {
        String version;
        if (PluginUtils.isUnderTest()) {
            TestingError e = new TestingError("displayExceptionInfo was called under test...: " + ex.toString());
            PluginUtils.logExceptionInfo(ex, pluginID);
            e.initCause(ex);
            throw e;
        }
        Bundle b = Platform.getBundle((String)pluginID);
        StringBuffer buffer = new StringBuffer();
        if (b != null) {
            String vendor = (String)b.getHeaders().get("Bundle-Vendor");
            String name = (String)b.getHeaders().get("Bundle-Name");
            if (vendor != null) {
                buffer.append("Plug-in Provider: ");
                buffer.append(vendor);
            }
            if (name != null) {
                buffer.append("\nPlug-in Name: ");
                buffer.append(name);
            }
        }
        buffer.append("\nPlug-in ID: ");
        buffer.append(pluginID);
        if (b != null && (version = (String)b.getHeaders().get("Bundle-Version")) != null) {
            buffer.append("\nVersion: ");
            buffer.append(version);
        }
        try {
            if (shell != null) {
                if (ex instanceof AgUIException) {
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)PluginUtils.quoteMessage(ExceptionUtility.getMessageFromThrowable((Throwable)ex)));
                } else if (ex instanceof CoreException) {
                    CoreException ce = (CoreException)ex;
                    MultiStatus ms = new MultiStatus(pluginID, ce.getStatus().getCode(), ce.getMessage(), ce.getStatus().getException());
                    ms.merge((IStatus)new Status(4, pluginID, 0, "", (Throwable)new AgUIException(buffer.toString())));
                    AgErrorDialog.openError(shell, "Error", null, (IStatus)ms);
                } else {
                    String message = ExceptionUtility.getMessageFromThrowable((Throwable)ex);
                    Status details = new Status(4, "Details", 0, PluginUtils.quoteMessage(message), (Throwable)new AgUIException(buffer.toString()));
                    AgErrorDialog.openError(shell, "Message", null, (IStatus)details);
                }
            }
        }
        finally {
            PluginUtils.logExceptionInfo(ex, pluginID);
        }
    }

    public static String quoteMessage(String message) {
        return message.replaceAll("\\&", "&&");
    }

    public static void log(String message, String pluginID) {
        AgitarLogger.getDiagnosticLogger((String)"gui").log(AgitarLevel.WARNING, message);
        ILog logger = Platform.getLog((Bundle)Platform.getBundle((String)pluginID));
        logger.log((IStatus)new Status(4, pluginID, 4, "Error: " + message, null));
    }

    public static void logExceptionInfo(Throwable ex, String pluginID) {
        PluginUtils.logExceptionInfo(ex, AgitarLevel.WARNING, pluginID);
    }

    public static void logExceptionInfo(Throwable ex, Level level, String pluginID) {
        if (PluginUtils.isUnderTest() && !AgitarLevel.FINE.equals(level)) {
            ex.printStackTrace();
        }
        if (PluginUtils.isUnderTest() || ex instanceof RuntimeException || ex instanceof CoreException) {
            ILog logger = ResourcesPlugin.getPlugin().getLog();
            if (ex instanceof CoreException) {
                logger.log(((CoreException)ex).getStatus());
            } else {
                logger.log((IStatus)new Status(4, pluginID, 4, "Error: " + ExceptionUtility.getMessageFromThrowable((Throwable)ex), ex));
            }
            AgitarLogger.getDiagnosticLogger((String)"gui").log(level, ex.getMessage(), ex);
        } else {
            AgitarLogger.getDiagnosticLogger((String)"gui").log(level, ex.getMessage(), ex);
        }
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getActiveEditor();
    }

    public static void mkdirs(IFolder folder) throws CoreException {
        if (folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            PluginUtils.mkdirs((IFolder)parent);
        }
        folder.create(true, true, null);
    }

    public static IFile[] getEclipseFiles(IProject eProj, List listOfFiles) throws IOException {
        if (listOfFiles == null || listOfFiles.size() == 0) {
            return new IFile[0];
        }
        ArrayList<IFile> ret = new ArrayList<IFile>();
        for (int i = 0; i < listOfFiles.size(); ++i) {
            IFile ifile = PluginUtils.getEclipseFile(eProj, (File)listOfFiles.get(i));
            if (ifile == null) continue;
            ret.add(ifile);
        }
        return ret.toArray(new IFile[0]);
    }

    public static IFile getEclipseFile(IProject eProj, File f) throws IOException {
        String s = IOUtility.createRelativePath((String)IOUtility.getCanonicalPath((File)f), (String)IOUtility.getCanonicalPath((File)eProj.getLocation().toFile()));
        IFile ifile = eProj.getFile((IPath)new Path(s));
        if (ifile != null && ifile.exists()) {
            return ifile;
        }
        Path path = new Path(IOUtility.getCanonicalPath((File)f));
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getProject().equals(eProj)) continue;
            return files[i];
        }
        return ifile;
    }

    public static void removeDupliateMethodBreakpoints(IJavaMethodBreakpoint methodBreakpoint) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        for (int i = 0; i < breakpoints.length; ++i) {
            try {
                if (breakpoints[i].getMarker().getId() == methodBreakpoint.getMarker().getId()) continue;
                if (!(breakpoints[i] instanceof IJavaMethodBreakpoint)) {
                    if (!(breakpoints[i] instanceof ILineBreakpoint) || methodBreakpoint.getLineNumber() < 0 || methodBreakpoint.getLineNumber() != ((ILineBreakpoint)breakpoints[i]).getLineNumber()) continue;
                    breakpoints[i].delete();
                    continue;
                }
                if (!methodBreakpoint.getMethodSignature().equals(((IJavaMethodBreakpoint)breakpoints[i]).getMethodSignature())) continue;
                breakpoints[i].delete();
                continue;
            }
            catch (CoreException e) {
                PluginUtils.logExceptionInfo(e, RESOURCES_PLUGIN_ID);
            }
        }
    }

    public static boolean editBreakPoint(Shell shell, IBreakpoint bp, boolean deleteOnCancel) throws CoreException {
        PropertyPageManager pageManager = new PropertyPageManager();
        if (bp == null) {
            if (deleteOnCancel) {
                bp.delete();
            }
            return false;
        }
        PropertyPageContributorManager manager = PropertyPageContributorManager.getManager();
        Method m = null;
        try {
            m = manager.getClass().getMethod("contribute", PropertyPageManager.class, IAdaptable.class);
        }
        catch (Exception e) {
            try {
                m = manager.getClass().getMethod("contribute", PropertyPageManager.class, Object.class);
            }
            catch (Exception ex) {
                PluginUtils.logExceptionInfo(ex, RESOURCES_PLUGIN_ID);
            }
        }
        try {
            if (m == null) {
                throw new AgUIException("Error launching breakpoint editor.");
            }
            m.invoke((Object)manager, pageManager, bp);
        }
        catch (Exception e) {
            throw new CoreException(PluginUtils.makeStatus(e, RESOURCES_PLUGIN_ID));
        }
        Iterator pages = pageManager.getElements(0).iterator();
        if (!pages.hasNext()) {
            if (deleteOnCancel) {
                bp.delete();
            }
            return false;
        }
        PropertyDialog propertyDialog = new PropertyDialog(shell, (PreferenceManager)pageManager, (ISelection)new StructuredSelection((Object)bp));
        propertyDialog.create();
        propertyDialog.getShell().setText(deleteOnCancel ? "Create Breakpoint" : "Edit Breakpoint");
        if (0 != propertyDialog.open()) {
            bp.delete();
            return false;
        }
        return true;
    }

    public static void appendToClassPath(IProject project, String classPath, IProgressMonitor monitor) throws CoreException {
        PluginUtils.appendToClassPath(project, classPath, null, monitor);
    }

    public static void appendToClassPath(IProject project, String classPath, String specificOutputLocation, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        IClasspathEntry newSource = specificOutputLocation != null ? JavaCore.newSourceEntry((IPath)new Path(classPath), (IPath[])new Path[0], (IPath)new Path(specificOutputLocation)) : JavaCore.newSourceEntry((IPath)new Path(classPath), (IPath[])new Path[0]);
        javaProject.setRawClasspath(PluginUtils.addClassPath(newSource, javaProject.getRawClasspath()), javaProject.getOutputLocation(), monitor);
        javaProject.save(monitor, true);
    }

    private static IClasspathEntry[] addClassPath(IClasspathEntry p, IClasspathEntry[] cps) {
        int n = cps.length;
        IClasspathEntry[] ret = new IClasspathEntry[n + 1];
        System.arraycopy(cps, 0, ret, 0, n);
        ret[n] = p;
        return ret;
    }

    public static void appendToLibPath(IProject project, IPath libPath, String libSrcPath, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        IClasspathEntry newLib = libSrcPath != null ? JavaCore.newLibraryEntry((IPath)libPath, (IPath)new Path(libSrcPath), null) : JavaCore.newLibraryEntry((IPath)libPath, null, null);
        javaProject.setRawClasspath(PluginUtils.addClassPath(newLib, javaProject.getRawClasspath()), javaProject.getOutputLocation(), monitor);
        javaProject.save(monitor, true);
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)window);
    }

    public static void createAgitatorJREInstall() {
        int i;
        VMStandin detectedVMStandin = null;
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        HashSet<String> installLocations = new HashSet<String>();
        for (i = 0; i < vmTypes.length; ++i) {
            IVMInstall[] installs = vmTypes[i].getVMInstalls();
            for (int j = 0; j < installs.length; ++j) {
                installLocations.add(IOUtility.getCanonicalPath((File)installs[j].getInstallLocation()));
            }
        }
        for (i = 0; i < vmTypes.length; ++i) {
            File detectedLocation = vmTypes[i].detectInstallLocation();
            if (detectedLocation == null || detectedVMStandin != null || installLocations.contains(IOUtility.getCanonicalPath((File)detectedLocation))) continue;
            int unique = i;
            IVMInstallType vmType = vmTypes[i];
            while (vmType.findVMInstall(String.valueOf(unique)) != null) {
                ++unique;
            }
            String vmID = String.valueOf(unique);
            detectedVMStandin = new VMStandin(vmType, vmID);
            detectedVMStandin.setInstallLocation(detectedLocation);
            detectedVMStandin.setName(detectedVMStandin.getInstallLocation().getName());
            if (!(vmType instanceof AbstractVMInstallType)) continue;
            AbstractVMInstallType abs = (AbstractVMInstallType)vmType;
            URL url = abs.getDefaultJavadocLocation(detectedLocation);
            detectedVMStandin.setJavadocLocation(url);
        }
        if (detectedVMStandin != null) {
            detectedVMStandin.convertToRealVM();
        }
    }

    public static void selectLineInClass(IJavaProject project, String className, int lineNumber) throws Exception {
        IType t = project.findType(className);
        if (t == null) {
            throw new AgUIException("Couldn't find class: " + className);
        }
        IEditorPart editor = PluginUtils.openInEditor(t);
        ITextEditor textEditor = (ITextEditor)editor;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        textEditor.selectAndReveal(document.getLineOffset(lineNumber), 0);
    }

    public static int[] selectRangeInClass(IJavaProject project, String className, int startLine, int endLine) throws Exception {
        IType t = project.findType(className);
        if (t == null) {
            throw new AgUIException("Couldn't find class: " + className);
        }
        IEditorPart editor = PluginUtils.openInEditor(t);
        ITextEditor textEditor = (ITextEditor)editor;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        int startOffset = 0;
        for (int i = 0; i < startLine; ++i) {
            startOffset += document.getLineLength(i);
        }
        int length = 0;
        for (int i = startLine; i <= endLine; ++i) {
            length += document.getLineLength(i);
        }
        textEditor.setFocus();
        PluginUtils.selectLineInClass(project, className, startLine);
        return new int[]{startOffset, startOffset + length};
    }

    public static IContainer getEclipseContainer(IProject eProj, File folder) throws IOException {
        String s = IOUtility.createRelativePath((String)IOUtility.getCanonicalPath((File)folder), (String)IOUtility.getCanonicalPath((File)eProj.getLocation().toFile()));
        try {
            IFolder container;
            if (!".".equals(s) && (container = eProj.getFolder((IPath)new Path(s))) != null && container.exists()) {
                return container;
            }
        }
        catch (Exception ex) {
            PluginUtils.logExceptionInfo(ex, RESOURCES_PLUGIN_ID);
        }
        IContainer[] containers = eProj.getWorkspace().getRoot().findContainersForLocation((IPath)new Path(IOUtility.getCanonicalPath((File)folder)));
        for (int i = 0; i < containers.length; ++i) {
            if (!containers[i].getProject().equals(eProj)) continue;
            return containers[i];
        }
        return null;
    }

    private static void getClassPath(String pluginID, LinkedHashSet results) throws BundleException, IOException {
        Path p;
        Bundle b = Platform.getBundle((String)pluginID);
        if (pluginID.startsWith("org.eclipse") || pluginID.startsWith("com.ibm") || pluginID.startsWith("org.apache") || pluginID.startsWith("com.jcraft")) {
            return;
        }
        URL root = null;
        try {
            root = Platform.asLocalURL((URL)Platform.find((Bundle)Platform.getBundle((String)pluginID), (IPath)new Path("/")));
        }
        catch (Exception ex) {
            PluginUtils.logExceptionInfo(ex, RESOURCES_PLUGIN_ID);
        }
        File rootPath = root == null ? null : IOUtility.getCanonicalFile((String)root.getPath());
        try {
            p = PluginUtils.findFileInPlugin(pluginID, "resources");
            results.add(IOUtility.getCanonicalPath((File)p.toFile()));
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            p = PluginUtils.findFileInPlugin(pluginID, "classes");
            results.add(IOUtility.getCanonicalPath((File)p.toFile()));
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            p = PluginUtils.findFileInPlugin(pluginID, "output/classes");
            results.add(IOUtility.getCanonicalPath((File)p.toFile()));
        }
        catch (IOException ex) {
            // empty catch block
        }
        ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)b.getHeaders().get("Bundle-ClassPath")));
        if (elements == null || rootPath == null) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            File f = new File(rootPath, elements[i].getValue());
            if (!f.exists()) continue;
            results.add(IOUtility.getCanonicalPath((File)f));
        }
    }

    private static void getClassPathForPlugins(String[] pluginIDs, LinkedHashSet results, HashSet visitedPlugins) throws BundleException, IOException {
        int i;
        for (i = 0; i < pluginIDs.length; ++i) {
            if (visitedPlugins.contains(pluginIDs[i])) continue;
            visitedPlugins.add(pluginIDs[i]);
            try {
                PluginUtils.getClassPath(pluginIDs[i], results);
                continue;
            }
            catch (Exception ex) {
                PluginUtils.logExceptionInfo(ex, RESOURCES_PLUGIN_ID);
            }
        }
        for (i = 0; i < pluginIDs.length; ++i) {
            Bundle b = Platform.getBundle((String)pluginIDs[i]);
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)b.getHeaders().get("Require-Bundle")));
            if (elements == null) continue;
            String[] ids = new String[elements.length];
            for (int j = 0; j < elements.length; ++j) {
                ids[j] = elements[j].getValue();
            }
            PluginUtils.getClassPathForPlugins(ids, results, visitedPlugins);
        }
    }

    public static String[] getClassPathForPlugins(String[] pluginIDs) throws BundleException, IOException {
        LinkedHashSet results = new LinkedHashSet();
        HashSet visited = new HashSet();
        PluginUtils.getClassPathForPlugins(pluginIDs, results, visited);
        return results.toArray(new String[0]);
    }

    public static IStructuredSelection getStructuredSelection(IEditorPart editorPart) throws JavaModelException {
        return AgSelectionConverter.getStructuredSelection((IWorkbenchPart)editorPart);
    }

    public static IJavaElement getElementAtOffset(IJavaElement edElem, ITextSelection selection) throws JavaModelException {
        return AgSelectionConverter.getElementAtOffset(edElem, selection);
    }

    public static boolean openBrowser(URL url) throws Exception {
        if (url != null) {
            try {
                url = Platform.asLocalURL((URL)url);
            }
            catch (IOException e) {
                return false;
            }
        }
        if (url == null) {
            return false;
        }
        PluginUtils.openLink(url.toString());
        return true;
    }

    public static void openLink(String href) throws Exception {
        PluginUtils.openLink(href, false);
    }

    public static String urlEncodeForSpaces(char[] input) {
        StringBuffer retu = new StringBuffer(input.length);
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == ' ') {
                retu.append("%20");
                continue;
            }
            retu.append(input[i]);
        }
        return retu.toString();
    }

    public static String getSystemSummary() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println(MessageFormat.format("*** Date: {0}", new Date()));
        PluginUtils.appendExtensions(writer);
        writer.close();
        return out.toString();
    }

    public static boolean isActivated(Bundle bundle) {
        return bundle != null && (bundle.getState() & 0x38) != 0;
    }

    public static boolean isActivated(String bundleId) {
        return PluginUtils.isActivated(Platform.getBundle((String)bundleId));
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        try {
            if (PluginUtils.isActivated(element.getDeclaringExtension().getNamespace())) {
                return element.createExecutableExtension(classAttribute);
            }
            final Object[] ret = new Object[1];
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(classAttribute);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
            return ret[0];
        }
        catch (CoreException core) {
            throw core;
        }
        catch (Exception e) {
            throw new CoreException(PluginUtils.makeStatus(e, RESOURCES_PLUGIN_ID));
        }
    }

    private static void appendExtensions(PrintWriter writer) {
        IConfigurationElement[] configElements = PluginUtils.getSortedExtensions();
        for (int i = 0; i < configElements.length; ++i) {
            IConfigurationElement element = configElements[i];
            Object obj = null;
            try {
                obj = PluginUtils.createExtension(element, "class");
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            }
            writer.println();
            writer.println(MessageFormat.format("*** {0}:", element.getAttribute("sectionTitle")));
            if (obj instanceof ISystemSummarySection) {
                ISystemSummarySection logSection = (ISystemSummarySection)obj;
                logSection.write(writer);
                continue;
            }
            writer.println("Could not write section, see error log.");
        }
    }

    private static IConfigurationElement[] getSortedExtensions() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "systemSummarySections");
        Arrays.sort(configElements, new Comparator(){
            Collator collator = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                IConfigurationElement element1 = (IConfigurationElement)a;
                IConfigurationElement element2 = (IConfigurationElement)b;
                String id1 = element1.getAttribute("id");
                String id2 = element2.getAttribute("id");
                if (id1 != null && id2 != null && !id1.equals(id2)) {
                    return this.collator.compare(id1, id2);
                }
                String title1 = element1.getAttribute("sectionTitle");
                String title2 = element2.getAttribute("sectionTitle");
                if (title1 == null) {
                    title1 = "";
                }
                if (title2 == null) {
                    title2 = "";
                }
                return this.collator.compare(title1, title2);
            }
        });
        return configElements;
    }

    public static IStructuredSelection convertToResources(IStructuredSelection originalSelection) {
        Class resourceClass = IResource.class;
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator elements = originalSelection.iterator();
        while (elements.hasNext()) {
            Object adapter;
            Object currentElement = elements.next();
            if (resourceClass.isInstance(currentElement)) {
                result.add(currentElement);
                continue;
            }
            if (!(currentElement instanceof IAdaptable) || !resourceClass.isInstance(adapter = ((IAdaptable)currentElement).getAdapter(resourceClass))) continue;
            result.add(adapter);
        }
        if (result.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(result.toArray());
    }

    public static Object eval(ClassLoader loader, String className, String methodName, String[] paramTypes, Object obj, Object[] params) {
        try {
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<?> klass = Class.forName(className, true, loader);
            Class[] ptypes = paramTypes == null ? new Class[]{} : new Class[paramTypes.length];
            for (int i = 0; i < ptypes.length; ++i) {
                ptypes[i] = Class.forName(paramTypes[i], true, loader);
            }
            if (params == null) {
                params = new Object[]{};
            }
            Method method = klass.getMethod(methodName, ptypes);
            return method.invoke(obj, params);
        }
        catch (Throwable x) {
            x.printStackTrace();
            StringBuffer sb = new StringBuffer(className + '.' + methodName + '(');
            if (paramTypes != null) {
                int len = paramTypes.length;
                for (int i = 0; i < len; ++i) {
                    sb.append(paramTypes[i]);
                    if (i >= len - 1) continue;
                    sb.append(',');
                }
            }
            sb.append(')');
            AssertionError err = new AssertionError((Object)(sb.toString() + ": " + x.toString()));
            ((Throwable)((Object)err)).initCause(x);
            throw err;
        }
    }

    public static IEditorPart openInEditor(IWorkbenchPage page, IFile file, boolean activate) throws PartInitException, JavaModelException {
        return IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)activate);
    }

    public static void openLink(String href, boolean isJUnitFactory) throws Exception {
        if (href.startsWith("file:")) {
            href = href.substring(5);
            while (href.startsWith("/")) {
                href = href.substring(1);
            }
            href = "file:///" + href;
        }
        MockWorkbenchBrowserSupport support = null;
        if (!PluginUtils.isEclipse30()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Method m = IWorkbench.class.getDeclaredMethod("getBrowserSupport", new Class[0]);
            support = (IWorkbenchBrowserSupport)m.invoke((Object)workbench, new Object[0]);
        } else {
            support = new MockWorkbenchBrowserSupport();
        }
        IWebBrowser browser = support.getExternalBrowser();
        browser.openURL(new URL(PluginUtils.urlEncodeForSpaces(href.toCharArray())));
    }

    public static class TestingError
    extends RuntimeException {
        private static final long serialVersionUID = 3256725099892453428L;

        public TestingError(String cause) {
            super(cause);
        }
    }
}

