/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class NoteFieldEditor
extends FieldEditor {
    private Label label;

    protected NoteFieldEditor() {
    }

    public NoteFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.label.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Composite filler = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 3;
        gd.heightHint = new GC((Drawable)parent).getFontMetrics().getHeight();
        filler.setLayoutData((Object)gd);
        String text = this.getLabelText();
        this.label = this.getLabel(parent);
        gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 3;
        this.label.setLayoutData((Object)gd);
        if (text != null) {
            this.label.setText(text);
        }
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    public void store() {
    }

    protected void doStore() {
    }

    protected Label getLabel(Composite parent) {
        if (this.label == null) {
            this.label = new Label(parent, 16448);
            this.label.setFont(parent.getFont());
            this.label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    NoteFieldEditor.this.label = null;
                }
            });
        } else {
            this.checkParent((Control)this.label, parent);
        }
        return this.label;
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setFocus() {
    }

    public void setLabelText(String text) {
        if (this.label != null) {
            this.label.setText(text);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.getLabel(parent).setEnabled(enabled);
    }
}

