/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.common.types.ClassName;
import com.agitar.common.types.ClassName5;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.ArrayUtil;
import com.agitar.common.util.StringUtility;
import com.agitar.eclipse.core.util.EclipseClassUtility;
import com.agitar.eclipse.core.util.JavaElementUtils;
import com.agitar.eclipse.core.util.ReflectionHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class MappingHelper {
    public static final char C_EXTENDS = '+';
    public static final char C_SUPER = '-';

    public static IMethod findMethod(IType type, MethodSignature methodSignature) throws CoreException {
        int i;
        IMethod[] methods = type.getMethods();
        IMethod result = null;
        String compareName = methodSignature.getName();
        if (methodSignature.isConstructor()) {
            compareName = methodSignature.getClassName().getSimpleName();
        }
        for (i = 0; i < methods.length; ++i) {
            MethodSignature ms = MappingHelper.getUnresolvedAgitarMethodSignature(methods[i]);
            if (!methodSignature.fuzzyMatch(ms)) continue;
            if (result != null) {
                result = null;
                break;
            }
            result = methods[i];
        }
        if (result != null) {
            return result;
        }
        for (i = 0; i < methods.length; ++i) {
            if (!compareName.equals(methods[i].getElementName()) || !methodSignature.equals((Object)MappingHelper.getAgitarMethodSignature(methods[i]))) continue;
            return methods[i];
        }
        return null;
    }

    public static MethodSignature getFastMethodSignature(IMethod method) {
        String returnType;
        String className = method.getDeclaringType().getFullyQualifiedName();
        String[] types = method.getParameterTypes();
        ClassName[] paramTypes = new ClassName[types.length];
        for (int i = 0; i < types.length; ++i) {
            paramTypes[i] = ClassName.get((String)types[i]);
        }
        String methodName = method.getElementName();
        try {
            returnType = method.getReturnType();
        }
        catch (JavaModelException e) {
            returnType = "void";
        }
        return new MethodSignature(ClassName.get((String)className), methodName, paramTypes, ClassName.get((String)returnType));
    }

    public static MethodSignature getAgitarMethodSignature(IMethod method) throws CoreException, JavaModelException {
        boolean isInJava5 = JavaElementUtils.isInJava5Project((IJavaElement)method);
        ClassName declaringClass = MappingHelper.getClassName(method.getDeclaringType());
        String methodName = method.isConstructor() ? "<init>" : method.getElementName();
        String[] types = method.getParameterTypes();
        String[] names = method.getParameterNames();
        ClassName extraClassName = null;
        if (method.isConstructor() && !Flags.isStatic((int)method.getDeclaringType().getFlags()) && method.getDeclaringType().getDeclaringType() != null) {
            extraClassName = MappingHelper.getClassName(method.getDeclaringType().getDeclaringType());
        }
        ClassName[] resolvedTypes = new ClassName[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolvedTypes[i] = MappingHelper.getClassNameObj(types[i], method, isInJava5);
        }
        ClassName retType = method.isConstructor() ? declaringClass : MappingHelper.getClassNameObj(method.getReturnType(), method, isInJava5);
        if (extraClassName != null) {
            resolvedTypes = (ClassName[])ArrayUtil.cons((Object)extraClassName, (Object)resolvedTypes);
            names = (String[])ArrayUtil.cons((Object)"$1", (Object)names);
        }
        MethodSignature sig = new MethodSignature(declaringClass, methodName, resolvedTypes, names, retType);
        return sig;
    }

    public static ClassName getClassNameObj(String refTypeSig, IMethod method) throws JavaModelException {
        return MappingHelper.getClassNameObj(refTypeSig, method, JavaElementUtils.isInJava5Project((IJavaElement)method));
    }

    public static ClassName getClassNameObj(String refTypeSig, IMethod method, boolean isJava5) throws JavaModelException {
        if (isJava5) {
            return new ClassName5(EclipseClassUtility.getResolvedTypeWithDollars(refTypeSig, method), MappingHelper.getResolvedTypeWithGenerics(refTypeSig, method));
        }
        return ClassName.get((String)EclipseClassUtility.getResolvedTypeWithDollars(refTypeSig, method));
    }

    private static String splitArrayType(String type, boolean typePrefix) {
        int arrDex = type.indexOf("[");
        if (arrDex > 0) {
            String preType = type.substring(0, arrDex);
            String arrStr = type.substring(arrDex, type.length());
            return typePrefix ? preType : arrStr;
        }
        return typePrefix ? type : null;
    }

    private static String getResolvedTypeWithGenerics(String refTypeSig, IMethod method) throws JavaModelException {
        int genericStart = refTypeSig.indexOf(60);
        if (genericStart != -1) {
            StringBuffer buf = new StringBuffer();
            String erasure = MappingHelper.getResolvedTypeWithGenerics(ReflectionHelper.getTypeErasure(refTypeSig), method);
            String nonArrayErasure = MappingHelper.splitArrayType(erasure, true);
            String arrayStr = MappingHelper.splitArrayType(erasure, false);
            buf.append(nonArrayErasure);
            buf.append('<');
            String[] typeArguments = ReflectionHelper.getTypeArguments(refTypeSig);
            if (typeArguments.length > 0) {
                for (int i = 0; i < typeArguments.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(MappingHelper.getResolvedTypeWithGenerics(typeArguments[i], method));
                }
            }
            buf.append('>');
            if (!StringUtility.nullOrEmpty((String)arrayStr)) {
                buf.append(arrayStr);
            }
            return buf.toString();
        }
        if (refTypeSig.length() > 0) {
            switch (refTypeSig.charAt(0)) {
                case '[': {
                    int arrayCount = Signature.getArrayCount((String)refTypeSig);
                    StringBuffer buf = new StringBuffer();
                    buf.append(MappingHelper.getResolvedTypeWithGenerics(Signature.getElementType((String)refTypeSig), method));
                    for (int i = 0; i < arrayCount; ++i) {
                        buf.append("[]");
                    }
                    return buf.toString();
                }
                case 'L': 
                case 'Q': {
                    String resolvedTypeName = EclipseClassUtility.getResolvedTypeWithDollars(refTypeSig, method);
                    if (resolvedTypeName == null) break;
                    return resolvedTypeName;
                }
                case '+': {
                    return "? extends " + MappingHelper.getResolvedTypeWithGenerics(refTypeSig.substring(1), method);
                }
                case '-': {
                    return "? super " + MappingHelper.getResolvedTypeWithGenerics(refTypeSig.substring(1), method);
                }
            }
        }
        return Signature.toString((String)refTypeSig);
    }

    private static ClassName getClassName(IType type) throws JavaModelException {
        if (JavaElementUtils.isInJava5Project((IJavaElement)type)) {
            return new ClassName5(type.getFullyQualifiedName(), ReflectionHelper.getFullyQualifiedParameterizedName(type));
        }
        return ClassName.get((String)type.getFullyQualifiedName());
    }

    private static MethodSignature getUnresolvedAgitarMethodSignature(IMethod method) throws CoreException, JavaModelException {
        ClassName declaringClass = MappingHelper.getClassName(method.getDeclaringType());
        String methodName = method.isConstructor() ? "<init>" : method.getElementName();
        String[] types = method.getParameterTypes();
        String[] names = method.getParameterNames();
        ClassName extraClassName = null;
        if (method.isConstructor() && !Flags.isStatic((int)method.getDeclaringType().getFlags()) && method.getDeclaringType().getDeclaringType() != null) {
            extraClassName = ClassName.get((String)method.getDeclaringType().getDeclaringType().getElementName());
        }
        ClassName[] unresolvedTypes = new ClassName[types.length];
        for (int i = 0; i < types.length; ++i) {
            unresolvedTypes[i] = ClassName.get((String)MappingHelper.getUnResolvedTypeWithDollars(types[i], method));
        }
        ClassName retType = method.isConstructor() ? declaringClass : ClassName.get((String)MappingHelper.getUnResolvedTypeWithDollars(method.getReturnType(), method));
        if (extraClassName != null) {
            unresolvedTypes = (ClassName[])ArrayUtil.cons((Object)extraClassName, (Object)unresolvedTypes);
            names = (String[])ArrayUtil.cons((Object)"$1", (Object)names);
        }
        MethodSignature sig = new MethodSignature(declaringClass, methodName, unresolvedTypes, names, retType);
        return sig;
    }

    private static String getUnResolvedTypeWithDollars(String refTypeSig, IMethod method) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (refTypeSig.length() > 0 && refTypeSig.charAt(0) == '[') {
            StringBuffer buf = new StringBuffer();
            buf.append(MappingHelper.getUnResolvedTypeWithDollars(Signature.getElementType((String)refTypeSig), method));
            for (int i = 0; i < arrayCount; ++i) {
                buf.append("[]");
            }
            return buf.toString();
        }
        if (type == 'Q') {
            int i;
            String name = "";
            int bracket = refTypeSig.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                name = refTypeSig.substring(arrayCount + 1, bracket);
            } else {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    throw new IllegalArgumentException();
                }
                name = refTypeSig.substring(arrayCount + 1, semi);
            }
            String[] sigs = method.getDeclaringType().getTypeParameterSignatures();
            for (i = 0; i < sigs.length; ++i) {
                if (!name.equals(Signature.getTypeVariable((String)sigs[i]))) continue;
                String[] typeParms = Signature.getTypeParameterBounds((String)sigs[i]);
                if (typeParms == null || typeParms.length == 0) {
                    return "java.lang.Object";
                }
                return MappingHelper.getUnResolvedTypeWithDollars(typeParms[0], method);
            }
            sigs = method.getTypeParameterSignatures();
            for (i = 0; i < sigs.length; ++i) {
                if (!name.equals(Signature.getTypeVariable((String)sigs[i]))) continue;
                String[] typeParms = Signature.getTypeParameterBounds((String)sigs[i]);
                if (typeParms == null || typeParms.length == 0) {
                    return "java.lang.Object";
                }
                return MappingHelper.getUnResolvedTypeWithDollars(typeParms[0], method);
            }
            return name;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }
}

