/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.eclipse.core.util.AgSelectionConverter;
import com.agitar.eclipse.core.util.IJavaElementSelectionWrapper;
import com.agitar.eclipse.core.util.PluginUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class JavaElementUtils {
    private JavaElementUtils() {
    }

    public static String getFullyQualifiedName(IType type) {
        try {
            IType declaringType;
            if (type.isBinary() && !type.isAnonymous() && (declaringType = type.getDeclaringType()) != null) {
                return JavaElementUtils.getFullyQualifiedName(declaringType) + '.' + type.getElementName();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return type.getFullyQualifiedName('.');
    }

    public static void getTopLevelClasses(IJavaElement[] je, Set classes, TypeFilter filter) throws JavaModelException {
        for (int i = 0; je != null && i < je.length; ++i) {
            JavaElementUtils.getTopLevelClasses(je[i], classes, filter);
        }
    }

    public static void getTopLevelClasses(IJavaElement je, Set classes, TypeFilter filter) throws JavaModelException {
        if (je.getElementType() < 4 && je instanceof IParent) {
            IJavaElement[] children = ((IParent)je).getChildren();
            for (int i = 0; i < children.length; ++i) {
                JavaElementUtils.getTopLevelClasses(children[i], classes, filter);
            }
            return;
        }
        if (je instanceof IPackageFragment) {
            IPackageFragment pf = (IPackageFragment)je;
            ICompilationUnit[] units = pf.getCompilationUnits();
            for (int i = 0; i < units.length; ++i) {
                IType[] types = units[i].getTypes();
                for (int j = 0; j < types.length; ++j) {
                    IType targetType = filter.isTypeOK(types[j]);
                    if (targetType == null) continue;
                    classes.add(targetType.getFullyQualifiedName());
                }
            }
            return;
        }
        IMember member = JavaElementUtils.getSourceContainer(je);
        if (member == null) {
            return;
        }
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu == null) {
            return;
        }
        IType[] topLevelTypes = cu.getTypes();
        for (int i = 0; i < topLevelTypes.length; ++i) {
            IType type = topLevelTypes[i];
            IType targetType = filter.isTypeOK(type);
            if (targetType == null) continue;
            classes.add(targetType.getFullyQualifiedName());
        }
    }

    public static IJavaElement getCurrentEditorElement() {
        IEditorPart activeEditor = PluginUtils.getActiveEditor();
        return JavaElementUtils.getEditorElement(activeEditor);
    }

    public static IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            IJavaElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        if (input instanceof IClassFile) {
            IJavaElement ref = ((IClassFile)input).getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static IJavaElement getJavaElementFromSelection(ISelection selection) {
        Object o;
        if (selection instanceof ITextSelection) {
            return JavaElementUtils.getCurrentEditorElement();
        }
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IJavaElement) {
            return (IJavaElement)o;
        }
        return null;
    }

    public static IJavaElement[] getAllJavaElementsFromAgitarSelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return JavaElementUtils.getAllJavaElementsFromSelection(selection);
        }
        if (selection instanceof IStructuredSelection) {
            List elements = ((IStructuredSelection)selection).toList();
            ArrayList<IJavaElement> returnVals = new ArrayList<IJavaElement>();
            for (int i = 0; elements != null && i < elements.size(); ++i) {
                Object o = elements.get(i);
                if (!(o instanceof IJavaElementSelectionWrapper)) continue;
                IJavaElement elem = ((IJavaElementSelectionWrapper)o).getJavaElement();
                returnVals.add(elem);
            }
            return returnVals.toArray(new IJavaElement[returnVals.size()]);
        }
        return null;
    }

    public static IJavaElement[] getAllJavaElementsFromSelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            IJavaElement[] iJavaElementArray;
            IJavaElement je = JavaElementUtils.getCurrentEditorElement();
            if (je == null) {
                iJavaElementArray = new IJavaElement[]{};
            } else {
                IJavaElement[] iJavaElementArray2 = new IJavaElement[1];
                iJavaElementArray = iJavaElementArray2;
                iJavaElementArray2[0] = je;
            }
            return iJavaElementArray;
        }
        if (selection instanceof IStructuredSelection) {
            List elements = ((IStructuredSelection)selection).toList();
            ArrayList returnVals = new ArrayList();
            for (int i = 0; elements != null && i < elements.size(); ++i) {
                Object o = elements.get(i);
                if (!(o instanceof IJavaElement)) continue;
                returnVals.add(o);
            }
            return returnVals.toArray(new IJavaElement[returnVals.size()]);
        }
        return null;
    }

    public static IJavaElement getJavaElement(ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IJavaElement) {
            return (IJavaElement)o;
        }
        return null;
    }

    public static IJavaElement getEditorElement(IEditorPart editorPart) {
        if (!(editorPart instanceof AbstractTextEditor)) {
            return null;
        }
        try {
            AbstractTextEditor editor = (AbstractTextEditor)editorPart;
            return JavaElementUtils.getElementAtOffset(AgSelectionConverter.getInput((IEditorPart)editor), (ITextSelection)editor.getSelectionProvider().getSelection());
        }
        catch (Exception e) {
            PluginUtils.logExceptionInfo(e, "org.eclipse.core.resources");
            return null;
        }
    }

    public static void addToClasspath(IJavaProject project, IClasspathEntry entry) throws JavaModelException, InvocationTargetException, InterruptedException {
        IClasspathEntry[] oldEntries = project.getRawClasspath();
        for (int i = 0; i < oldEntries.length; ++i) {
            if (!oldEntries[i].equals(entry)) continue;
            return;
        }
        int nEntries = oldEntries.length;
        IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
        newEntries[nEntries] = entry;
        project.setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean isInJava5Project(IJavaElement je) {
        String sourceVersion = je.getJavaProject().getOption("org.eclipse.jdt.core.compiler.source", true);
        return sourceVersion != null ? sourceVersion.startsWith("1.5") || sourceVersion.startsWith("5.0") : false;
    }

    public static boolean hasSourceEntries(IJavaProject jp) {
        try {
            IClasspathEntry[] classPathEntries = jp.getRawClasspath();
            if (classPathEntries == null) {
                return false;
            }
            for (int i = 0; i < classPathEntries.length; ++i) {
                if (classPathEntries[i].getEntryKind() != 3) continue;
                return true;
            }
        }
        catch (JavaModelException e) {
            PluginUtils.logExceptionInfo(e, "org.eclipse.core.resources");
        }
        return false;
    }

    public static IType findTypeInWorkspace(String typeName) throws JavaModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        for (int i = 0; i < projects.length; ++i) {
            IType type = projects[i].findType(typeName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public static IMember getContainer(IJavaElement je) {
        IMember member;
        if (je == null) {
            return null;
        }
        if (je instanceof IJavaProject || je instanceof IPackageFragment) {
            return null;
        }
        if (je instanceof IPackageDeclaration) {
            je = je.getParent();
        }
        if (je instanceof IImportDeclaration) {
            je = je.getParent();
        }
        if (je instanceof IImportContainer) {
            je = je.getParent();
        }
        if (je instanceof ICompilationUnit) {
            ICompilationUnit compUnit = (ICompilationUnit)je;
            je = compUnit.findPrimaryType();
        }
        if (je instanceof IClassFile) {
            try {
                je = ((IClassFile)je).getType();
            }
            catch (JavaModelException e1) {
                return null;
            }
        }
        if (!(je instanceof IMember)) {
            return null;
        }
        try {
            member = JavaElementUtils.getOutermostRealContainer((IMember)je);
        }
        catch (JavaModelException e1) {
            return null;
        }
        return member;
    }

    private static IMember getOutermostRealContainer(IMember m) throws JavaModelException {
        if (m == null) {
            return null;
        }
        if ((m instanceof IType || m instanceof IMethod) && !JavaElementUtils.isPartOfAnonymousType((IJavaElement)m)) {
            return m;
        }
        return JavaElementUtils.getOutermostRealContainer(JavaElementUtils.getContainerParent(m.getParent()));
    }

    private static IMember getContainerParent(IJavaElement je) {
        if (je == null) {
            return null;
        }
        if (je instanceof IMethod || je instanceof IType) {
            return (IMember)je;
        }
        return JavaElementUtils.getContainerParent(je.getParent());
    }

    private static boolean isPartOfAnonymousType(IJavaElement je) throws JavaModelException {
        if (je == null) {
            return false;
        }
        if (je instanceof IType && ((IType)je).isAnonymous()) {
            return true;
        }
        return JavaElementUtils.isPartOfAnonymousType(je.getParent());
    }

    public static IMember getSourceContainer(IJavaElement je) {
        IMember member = JavaElementUtils.getContainer(je);
        return member != null && member.getCompilationUnit() == null ? null : member;
    }

    public static interface TypeFilter {
        public IType isTypeOK(IType var1) throws JavaModelException;
    }
}

