/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.common.types.ClassName;
import com.agitar.common.types.ClassName5;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.ArrayUtil;
import com.agitar.common.util.Assertions;
import com.agitar.common.util.StringUtility;
import com.agitar.eclipse.core.util.JavaElementUtils;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.eclipse.core.util.ReflectionHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class EclipseClassUtility {
    public static final char C_EXTENDS = '+';
    public static final char C_SUPER = '-';

    public static String[] findRoommateClasses(String projectName, String className, boolean includingItself) {
        try {
            IProject iProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IJavaProject javaProj = (IJavaProject)iProj.getNature("org.eclipse.jdt.core.javanature");
            IType type = javaProj.findType(className);
            if (type != null) {
                IType[] types = type.getCompilationUnit().getAllTypes();
                String[] strs = new String[types.length];
                for (int i = 0; i < strs.length; ++i) {
                    strs[i] = types[i].getFullyQualifiedName();
                }
                return strs;
            }
        }
        catch (CoreException ce) {
            PluginUtils.logExceptionInfo(ce, "org.eclipse.core.resources");
        }
        return null;
    }

    public static String getLongFormAgitarMethodSignature(IMethod method) throws CoreException, JavaModelException {
        String declaringClass = method.getDeclaringType().getFullyQualifiedName();
        String methodName = method.isConstructor() ? "<init>" : method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        String[] paramNames = method.getParameterNames();
        String extraClassName = null;
        if (method.isConstructor() && !Flags.isStatic((int)method.getDeclaringType().getFlags()) && method.getDeclaringType().getDeclaringType() != null) {
            extraClassName = method.getDeclaringType().getDeclaringType().getFullyQualifiedName();
        }
        String[] resolvedTypes = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            resolvedTypes[i] = EclipseClassUtility.getResolvedTypeWithDollars(paramTypes[i], method);
        }
        if (extraClassName != null) {
            resolvedTypes = (String[])ArrayUtil.cons((Object)extraClassName, (Object)resolvedTypes);
            paramNames = (String[])ArrayUtil.cons((Object)"$1", (Object)paramNames);
        }
        StringBuffer longBuf = new StringBuffer();
        longBuf.append(declaringClass).append('.').append(methodName).append('(');
        for (int i = 0; i < paramNames.length; ++i) {
            Assertions.assertNotNull((String)"null parameter name", (Object)paramNames[i]);
            Assertions.assertNotNull((String)"null parameter type", (Object)resolvedTypes[i]);
            if (i > 0) {
                longBuf.append(',').append(' ');
            }
            longBuf.append(resolvedTypes[i]).append(' ').append(paramNames[i]);
        }
        longBuf.append(')');
        return longBuf.toString();
    }

    public static String getResolvedTypeWithDollars(String refTypeSig, IMethod method) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (refTypeSig.length() > 0 && refTypeSig.charAt(0) == '[') {
            StringBuffer buf = new StringBuffer();
            buf.append(EclipseClassUtility.getResolvedTypeWithDollars(Signature.getElementType((String)refTypeSig), method));
            for (int i = 0; i < arrayCount; ++i) {
                buf.append("[]");
            }
            return buf.toString();
        }
        if (type == 'Q') {
            int i;
            int semi = (refTypeSig = ReflectionHelper.getTypeErasure(refTypeSig)).indexOf(59, arrayCount + 1);
            if (semi == -1) {
                throw new IllegalArgumentException();
            }
            String name = refTypeSig.substring(arrayCount + 1, semi);
            String[] sigs = method.getDeclaringType().getTypeParameterSignatures();
            for (i = 0; i < sigs.length; ++i) {
                if (!name.equals(Signature.getTypeVariable((String)sigs[i]))) continue;
                String[] typeParms = Signature.getTypeParameterBounds((String)sigs[i]);
                if (typeParms == null || typeParms.length == 0) {
                    return "java.lang.Object";
                }
                return EclipseClassUtility.getResolvedTypeWithDollars(typeParms[0], method);
            }
            sigs = method.getTypeParameterSignatures();
            for (i = 0; i < sigs.length; ++i) {
                if (!name.equals(Signature.getTypeVariable((String)sigs[i]))) continue;
                String[] typeParms = Signature.getTypeParameterBounds((String)sigs[i]);
                if (typeParms == null || typeParms.length == 0) {
                    return "java.lang.Object";
                }
                return EclipseClassUtility.getResolvedTypeWithDollars(typeParms[0], method);
            }
            String[][] resolvedNames = method.getDeclaringType().resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                resolvedNames[0][1] = resolvedNames[0][1].replace('.', '$');
                return EclipseClassUtility.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
            }
            return "java.lang.Object";
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static ClassName getClassName(IType type) throws JavaModelException {
        if (JavaElementUtils.isInJava5Project((IJavaElement)type)) {
            return new ClassName5(type.getFullyQualifiedName(), ReflectionHelper.getFullyQualifiedParameterizedName(type));
        }
        return ClassName.get((String)type.getFullyQualifiedName());
    }

    public static String getUnResolvedTypeWithDollars(String refTypeSig, IMethod method) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (refTypeSig.length() > 0 && refTypeSig.charAt(0) == '[') {
            StringBuffer buf = new StringBuffer();
            buf.append(EclipseClassUtility.getUnResolvedTypeWithDollars(Signature.getElementType((String)refTypeSig), method));
            for (int i = 0; i < arrayCount; ++i) {
                buf.append("[]");
            }
            return buf.toString();
        }
        if (type == 'Q') {
            int i;
            String name = "";
            int bracket = refTypeSig.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                name = refTypeSig.substring(arrayCount + 1, bracket);
            } else {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    throw new IllegalArgumentException();
                }
                name = refTypeSig.substring(arrayCount + 1, semi);
            }
            String[] sigs = method.getDeclaringType().getTypeParameterSignatures();
            for (i = 0; i < sigs.length; ++i) {
                if (!name.equals(Signature.getTypeVariable((String)sigs[i]))) continue;
                String[] typeParms = Signature.getTypeParameterBounds((String)sigs[i]);
                if (typeParms == null || typeParms.length == 0) {
                    return "java.lang.Object";
                }
                return EclipseClassUtility.getUnResolvedTypeWithDollars(typeParms[0], method);
            }
            sigs = method.getTypeParameterSignatures();
            for (i = 0; i < sigs.length; ++i) {
                if (!name.equals(Signature.getTypeVariable((String)sigs[i]))) continue;
                String[] typeParms = Signature.getTypeParameterBounds((String)sigs[i]);
                if (typeParms == null || typeParms.length == 0) {
                    return "java.lang.Object";
                }
                return EclipseClassUtility.getUnResolvedTypeWithDollars(typeParms[0], method);
            }
            return name;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static MethodSignature getUnresolvedAgitarMethodSignature(IMethod method) throws CoreException, JavaModelException {
        ClassName declaringClass = EclipseClassUtility.getClassName(method.getDeclaringType());
        String methodName = method.isConstructor() ? "<init>" : method.getElementName();
        String[] types = method.getParameterTypes();
        String[] names = method.getParameterNames();
        ClassName extraClassName = null;
        if (method.isConstructor() && !Flags.isStatic((int)method.getDeclaringType().getFlags()) && method.getDeclaringType().getDeclaringType() != null) {
            extraClassName = ClassName.get((String)method.getDeclaringType().getDeclaringType().getElementName());
        }
        ClassName[] unresolvedTypes = new ClassName[types.length];
        for (int i = 0; i < types.length; ++i) {
            unresolvedTypes[i] = ClassName.get((String)EclipseClassUtility.getUnResolvedTypeWithDollars(types[i], method));
        }
        ClassName retType = method.isConstructor() ? declaringClass : ClassName.get((String)EclipseClassUtility.getUnResolvedTypeWithDollars(method.getReturnType(), method));
        if (extraClassName != null) {
            unresolvedTypes = (ClassName[])ArrayUtil.cons((Object)extraClassName, (Object)unresolvedTypes);
            names = (String[])ArrayUtil.cons((Object)"$1", (Object)names);
        }
        MethodSignature sig = new MethodSignature(declaringClass, methodName, unresolvedTypes, names, retType);
        return sig;
    }

    public static MethodSignature getAgitarMethodSignature(IMethod method) throws CoreException, JavaModelException {
        boolean isInJava5 = JavaElementUtils.isInJava5Project((IJavaElement)method);
        ClassName declaringClass = EclipseClassUtility.getClassName(method.getDeclaringType());
        String methodName = method.isConstructor() ? "<init>" : method.getElementName();
        String[] types = method.getParameterTypes();
        String[] names = method.getParameterNames();
        ClassName extraClassName = null;
        if (method.isConstructor() && !Flags.isStatic((int)method.getDeclaringType().getFlags()) && method.getDeclaringType().getDeclaringType() != null) {
            extraClassName = EclipseClassUtility.getClassName(method.getDeclaringType().getDeclaringType());
        }
        ClassName[] resolvedTypes = new ClassName[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolvedTypes[i] = EclipseClassUtility.getClassNameObj(types[i], method, isInJava5);
        }
        ClassName retType = method.isConstructor() ? declaringClass : EclipseClassUtility.getClassNameObj(method.getReturnType(), method, isInJava5);
        if (extraClassName != null) {
            resolvedTypes = (ClassName[])ArrayUtil.cons((Object)extraClassName, (Object)resolvedTypes);
            names = (String[])ArrayUtil.cons((Object)"$1", (Object)names);
        }
        MethodSignature sig = new MethodSignature(declaringClass, methodName, resolvedTypes, names, retType);
        return sig;
    }

    public static ClassName getClassNameObj(String refTypeSig, IMethod method, boolean isJava5) throws JavaModelException {
        if (isJava5) {
            return new ClassName5(EclipseClassUtility.getResolvedTypeWithDollars(refTypeSig, method), EclipseClassUtility.getResolvedTypeWithGenerics(refTypeSig, method));
        }
        return ClassName.get((String)EclipseClassUtility.getResolvedTypeWithDollars(refTypeSig, method));
    }

    public static ClassName getClassNameObj(String refTypeSig, IMethod method) throws JavaModelException {
        return EclipseClassUtility.getClassNameObj(refTypeSig, method, JavaElementUtils.isInJava5Project((IJavaElement)method));
    }

    public static String getResolvedTypeWithGenerics(String refTypeSig, IMethod method) throws JavaModelException {
        int genericStart = refTypeSig.indexOf(60);
        if (genericStart != -1) {
            StringBuffer buf = new StringBuffer();
            String erasure = EclipseClassUtility.getResolvedTypeWithGenerics(ReflectionHelper.getTypeErasure(refTypeSig), method);
            String nonArrayErasure = EclipseClassUtility.splitArrayType(erasure, true);
            String arrayStr = EclipseClassUtility.splitArrayType(erasure, false);
            buf.append(nonArrayErasure);
            buf.append('<');
            String[] typeArguments = ReflectionHelper.getTypeArguments(refTypeSig);
            if (typeArguments.length > 0) {
                for (int i = 0; i < typeArguments.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(EclipseClassUtility.getResolvedTypeWithGenerics(typeArguments[i], method));
                }
            }
            buf.append('>');
            if (!StringUtility.nullOrEmpty((String)arrayStr)) {
                buf.append(arrayStr);
            }
            return buf.toString();
        }
        if (refTypeSig.length() > 0) {
            switch (refTypeSig.charAt(0)) {
                case '[': {
                    int arrayCount = Signature.getArrayCount((String)refTypeSig);
                    StringBuffer buf = new StringBuffer();
                    buf.append(EclipseClassUtility.getResolvedTypeWithGenerics(Signature.getElementType((String)refTypeSig), method));
                    for (int i = 0; i < arrayCount; ++i) {
                        buf.append("[]");
                    }
                    return buf.toString();
                }
                case 'L': 
                case 'Q': {
                    String resolvedTypeName = EclipseClassUtility.getResolvedTypeWithDollars(refTypeSig, method);
                    if (resolvedTypeName == null) break;
                    return resolvedTypeName;
                }
                case '+': {
                    return "? extends " + EclipseClassUtility.getResolvedTypeWithGenerics(refTypeSig.substring(1), method);
                }
                case '-': {
                    return "? super " + EclipseClassUtility.getResolvedTypeWithGenerics(refTypeSig.substring(1), method);
                }
            }
        }
        return Signature.toString((String)refTypeSig);
    }

    public static String splitArrayType(String type, boolean typePrefix) {
        int arrDex = type.indexOf("[");
        if (arrDex > 0) {
            String preType = type.substring(0, arrDex);
            String arrStr = type.substring(arrDex, type.length());
            return typePrefix ? preType : arrStr;
        }
        return typePrefix ? type : null;
    }

    public static IMethod findMethod(IType type, MethodSignature methodSignature) throws CoreException {
        int i;
        IMethod[] methods = type.getMethods();
        IMethod result = null;
        String compareName = methodSignature.getName();
        if (methodSignature.isConstructor()) {
            compareName = methodSignature.getClassName().getSimpleName();
        }
        for (i = 0; i < methods.length; ++i) {
            MethodSignature ms = EclipseClassUtility.getUnresolvedAgitarMethodSignature(methods[i]);
            if (!methodSignature.fuzzyMatch(ms)) continue;
            if (result != null) {
                result = null;
                break;
            }
            result = methods[i];
        }
        if (result != null) {
            return result;
        }
        for (i = 0; i < methods.length; ++i) {
            if (!compareName.equals(methods[i].getElementName()) || !methodSignature.equals((Object)EclipseClassUtility.getAgitarMethodSignature(methods[i]))) continue;
            return methods[i];
        }
        return null;
    }
}

