/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.common.util.StringUtility;
import com.agitar.lib.NoObfuscation;
import java.net.URL;
import java.util.Properties;

public class DefaultDashboardSettings
implements NoObfuscation {
    public static final String SERVER_HOST_NAME = "serverHostName";
    public static final String SERVER_PORT = "serverPort";
    public static final String USE_SSL = "useSSL";
    Properties properties;
    private String defaultServerHostName;
    private String defaultServerPort;
    private boolean defaultUseSSL;
    public static final String PROJECT_TARGET_TEST_POINTS = "projectTargetTestPoints";
    public static final int DEFAULT_TARGET_TEST_POINTS = 1;
    public static final String COVERAGE_LEVEL = "coverageLevel";
    public static final int DEFAULT_COVERAGE_LEVEL = 40;
    public static final String CLASSES_WITH_TEST_POINTS = "classesWithTestPoints";
    public static final int DEFAULT_CLASSES_WITH_TEST_POINTS = 1;
    public static final String METHODS_WITH_TEST_POINTS = "methodsWithTestPoints";
    public static final int DEFAULT_METHODS_WITH_TEST_POINTS = 1;
    public static final String URL_PATH = "/agitar-server/dashboards/automated";

    public DefaultDashboardSettings(Properties properties, String defaultServerHostName, String defaultServerPort, boolean defaultUseSSL) {
        this.defaultServerHostName = defaultServerHostName;
        this.defaultServerPort = defaultServerPort;
        this.defaultUseSSL = defaultUseSSL;
        this.properties = properties;
        if (StringUtility.nullOrEmpty((String)this.getServerRootURL())) {
            this.clearServerRootURL();
        }
    }

    public void setServerHostName(String hostName) {
        this.properties.setProperty(SERVER_HOST_NAME, hostName);
    }

    public String getServerHostName() {
        return this.properties.getProperty(SERVER_HOST_NAME, this.getDefaultServerHostName());
    }

    public void clearServerHostName() {
        this.properties.setProperty(SERVER_HOST_NAME, this.getDefaultServerHostName());
    }

    public void setServerPort(Integer port) {
        this.properties.setProperty(SERVER_PORT, "" + port);
    }

    public void setServerPort(String port) {
        this.properties.setProperty(SERVER_PORT, port);
    }

    public void clearServerPort() {
        this.properties.setProperty(SERVER_PORT, this.getDefaultServerPort());
    }

    public Integer getServerPort() {
        return new Integer(Integer.parseInt(this.properties.getProperty(SERVER_PORT, this.getDefaultServerPort())));
    }

    public void setUseSSL(boolean useSSL) {
        this.properties.setProperty(USE_SSL, Boolean.toString(useSSL));
    }

    public boolean isUseSSL() {
        return Boolean.valueOf(this.properties.getProperty(USE_SSL, this.getDefaultUseSSL()));
    }

    public void clearUseSSL() {
        this.properties.setProperty(USE_SSL, this.getDefaultUseSSL());
    }

    private String getDefaultServerPort() {
        return this.defaultServerPort;
    }

    private String getDefaultServerHostName() {
        return this.defaultServerHostName;
    }

    private String getDefaultUseSSL() {
        return Boolean.toString(this.defaultUseSSL);
    }

    public boolean isEmailFailureOnly() {
        return Boolean.valueOf(this.properties.getProperty("emailFailureOnly", "false"));
    }

    public void setEmailFailureOnly(boolean emailFailureOnly) {
        this.properties.setProperty("emailFailureOnly", Boolean.toString(emailFailureOnly));
    }

    public void clearEmailFailureOnly() {
        this.properties.setProperty("emailFailureOnly", Boolean.FALSE.toString());
    }

    public String getEmailPassword() {
        return this.properties.getProperty("emailPassword", "");
    }

    public void setEmailPassword(String emailPassword) {
        this.properties.setProperty("emailPassword", emailPassword);
    }

    public void clearEmailPassword() {
        this.properties.setProperty("emailPassword", "");
    }

    public Integer getEmailPort() {
        return new Integer(Integer.parseInt(this.properties.getProperty("emailPort", "25")));
    }

    public void setEmailPort(Integer emailPort) {
        this.properties.setProperty("emailPort", emailPort.toString());
    }

    public void clearEmailPort() {
        this.properties.setProperty("emailPort", "25");
    }

    public String getEmailSender() {
        return this.properties.getProperty("emailSender", "");
    }

    public void setEmailSender(String emailSender) {
        this.properties.setProperty("emailSender", emailSender);
    }

    public void clearEmailSender() {
        this.properties.setProperty("emailSender", "");
    }

    public String getEmailServer() {
        return this.properties.getProperty("emailServer", "");
    }

    public void setEmailServer(String emailServer) {
        this.properties.setProperty("emailServer", emailServer);
    }

    public void clearEmailServer() {
        this.properties.setProperty("emailServer", "");
    }

    public String getEmailUsername() {
        return this.properties.getProperty("emailUsername", "");
    }

    public void setEmailUsername(String emailUsername) {
        this.properties.setProperty("emailUsername", emailUsername);
    }

    public void clearEmailUsername() {
        this.properties.setProperty("emailUsername", "");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getTrendWindow() {
        return this.properties.getProperty("trendWindow", "");
    }

    public void setTrendWindow(String window) {
        this.properties.setProperty("trendWindow", window);
    }

    public void clearTrendWindow() {
        this.properties.setProperty("trendWindow", "");
    }

    public String getServerRootURL() {
        try {
            URL url = new URL(this.isUseSSL() ? "https" : "http", this.getServerHostName(), this.getServerPort(), URL_PATH);
            return url.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setServerRootURL(String url) {
        try {
            URL u = new URL(url);
            this.setServerHostName(u.getHost());
            this.setServerPort(new Integer(u.getPort()));
            this.setUseSSL(u.getProtocol().equals("https"));
        }
        catch (Exception e) {
            this.properties.setProperty("serverRootURL", "");
        }
    }

    public void clearServerRootURL() {
        this.properties.setProperty("serverRootURL", "");
    }

    public String getEmailRecipients() {
        return this.properties.getProperty("emailRecipients", "");
    }

    public void setEmailRecipients(String recipeients) {
        this.properties.setProperty("emailRecipients", recipeients);
    }

    public void clearEmailRecipients() {
        this.properties.setProperty("emailRecipients", "");
    }

    public String getAdminEmailAddress() {
        return this.properties.getProperty("adminEmailAddress", "");
    }

    public void setAdminEmailAddress(String recipeients) {
        this.properties.setProperty("adminEmailAddress", recipeients);
    }

    public void clearAdminEmailAddress() {
        this.properties.setProperty("adminEmailAddress", "");
    }

    public int getProjectTargetTestPoints() {
        String target = this.properties.getProperty(PROJECT_TARGET_TEST_POINTS, "1");
        try {
            return Integer.valueOf(target);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void setProjectTargetTestPoints(int target) {
        this.properties.setProperty(PROJECT_TARGET_TEST_POINTS, target + "");
    }

    public void clearProjectTargetTestPoints() {
        this.properties.setProperty(PROJECT_TARGET_TEST_POINTS, "1");
    }

    public int getCoverageLevel() {
        String target = this.properties.getProperty(COVERAGE_LEVEL, "40");
        try {
            return Integer.valueOf(target);
        }
        catch (Exception e) {
            return 40;
        }
    }

    public void setCoverageLevel(int target) {
        this.properties.setProperty(COVERAGE_LEVEL, target + "");
    }

    public void clearCoverageLevel() {
        this.properties.setProperty(COVERAGE_LEVEL, "40");
    }

    public int getClassesWithTestPoints() {
        String target = this.properties.getProperty(CLASSES_WITH_TEST_POINTS, "1");
        try {
            return Integer.valueOf(target);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void setClassesWithTestPoints(int target) {
        this.properties.setProperty(CLASSES_WITH_TEST_POINTS, target + "");
    }

    public void clearClassesWithTestPoints() {
        this.properties.setProperty(CLASSES_WITH_TEST_POINTS, "1");
    }

    public int getMethodsWithTestPoints() {
        String target = this.properties.getProperty(METHODS_WITH_TEST_POINTS, "1");
        try {
            return Integer.valueOf(target);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void setMethodsWithTestPoints(int target) {
        this.properties.setProperty(METHODS_WITH_TEST_POINTS, target + "");
    }

    public void clearMethodsWithTestPoints() {
        this.properties.setProperty(METHODS_WITH_TEST_POINTS, "1");
    }
}

