/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboFieldEditor
extends FieldEditor {
    private Combo fCombo;
    private Object fValue;
    private Object[][] fEntryNamesAndValues;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ComboFieldEditor(String name, String labelText, Object[][] entryNamesAndValues, Composite parent) {
        this.init(name, labelText);
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this.fEntryNamesAndValues = entryNamesAndValues;
        this.createControl(parent);
    }

    protected final void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected final void init(String name, String text) {
        super.init(name, text);
    }

    private boolean checkArray(Object[][] table) {
        if (table == null) {
            return false;
        }
        for (int i = 0; i < table.length; ++i) {
            Object[] array = table[i];
            if (array != null && array.length == 2) continue;
            return false;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        if (this.fEntryNamesAndValues[0][1] instanceof Boolean) {
            this.updateComboForValue(this.getPreferenceStore().getBoolean(this.getPreferenceName()));
        } else if (this.fEntryNamesAndValues[0][1] instanceof Integer) {
            this.updateComboForValue(new Integer(this.getPreferenceStore().getInt(this.getPreferenceName())));
        } else if (this.fEntryNamesAndValues[0][1] instanceof Long) {
            this.updateComboForValue(new Long(this.getPreferenceStore().getLong(this.getPreferenceName())));
        } else if (this.fEntryNamesAndValues[0][1] instanceof Float) {
            this.updateComboForValue(new Float(this.getPreferenceStore().getFloat(this.getPreferenceName())));
        } else if (this.fEntryNamesAndValues[0][1] instanceof Double) {
            this.updateComboForValue(new Double(this.getPreferenceStore().getDouble(this.getPreferenceName())));
        } else if (this.fEntryNamesAndValues[0][1] instanceof String) {
            this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    protected void doLoadDefault() {
        if (this.fEntryNamesAndValues[0][1] instanceof Boolean) {
            this.updateComboForValue(this.getPreferenceStore().getDefaultBoolean(this.getPreferenceName()));
        } else if (this.fEntryNamesAndValues[0][1] instanceof Integer) {
            this.updateComboForValue(new Integer(this.getPreferenceStore().getDefaultInt(this.getPreferenceName())));
        } else if (this.fEntryNamesAndValues[0][1] instanceof Long) {
            this.updateComboForValue(new Long(this.getPreferenceStore().getDefaultLong(this.getPreferenceName())));
        } else if (this.fEntryNamesAndValues[0][1] instanceof Float) {
            this.updateComboForValue(new Float(this.getPreferenceStore().getDefaultFloat(this.getPreferenceName())));
        } else if (this.fEntryNamesAndValues[0][1] instanceof Double) {
            this.updateComboForValue(new Double(this.getPreferenceStore().getDefaultDouble(this.getPreferenceName())));
        } else if (this.fEntryNamesAndValues[0][1] instanceof String) {
            this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        if (this.fValue instanceof Integer) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), ((Integer)this.fValue).intValue());
        } else if (this.fValue instanceof Long) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), ((Long)this.fValue).longValue());
        } else if (this.fValue instanceof Double) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), ((Double)this.fValue).doubleValue());
        } else if (this.fValue instanceof Float) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), ((Float)this.fValue).floatValue());
        } else if (this.fValue instanceof Boolean) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), ((Boolean)this.fValue).booleanValue());
        } else if (this.fValue instanceof String) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), (String)this.fValue);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            this.fCombo.setFont(parent.getFont());
            for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
                this.fCombo.add(this.fEntryNamesAndValues[i][0].toString(), i);
            }
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Object oldValue = ComboFieldEditor.this.fValue;
                    String name = ComboFieldEditor.this.fCombo.getText();
                    ComboFieldEditor.this.fValue = ComboFieldEditor.this.getValueForName(name);
                    ComboFieldEditor.this.setPresentsDefaultValue(false);
                    ComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, ComboFieldEditor.this.fValue);
                }
            });
        }
        return this.fCombo;
    }

    protected Object getValueForName(String name) {
        for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
            Object[] entry = this.fEntryNamesAndValues[i];
            if (!name.equals(entry[0])) continue;
            return entry[1];
        }
        return this.fEntryNamesAndValues[0][0];
    }

    protected void updateComboForValue(Object value) {
        this.fValue = value;
        for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
            if (!value.equals(this.fEntryNamesAndValues[i][1])) continue;
            this.fCombo.setText(this.fEntryNamesAndValues[i][0].toString());
            return;
        }
        if (this.fEntryNamesAndValues.length > 0) {
            this.fValue = this.fEntryNamesAndValues[0][1];
        }
    }

    static {
        $assertionsDisabled = !ComboFieldEditor.class.desiredAssertionStatus();
    }
}

