/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.eclipse.core.util.PluginUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BeanPreferenceStore
implements IPreferenceStore {
    private BeanInfo beanInfo;
    private boolean needsSaving = false;
    private ListenerList listeners = new ListenerList();
    private Object target;
    HashSet verifiedProperties = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BeanPreferenceStore(Object object) throws IntrospectionException {
        this.target = object;
        this.beanInfo = Introspector.getBeanInfo(this.target.getClass());
    }

    public Object getProperty(String name) {
        if (!this.verifiedProperties.contains(name = this.decapitalize(name))) {
            this.getWriteMethod(name);
            this.getClearMethod(name);
            this.verifiedProperties.add(name);
        }
        PropertyDescriptor[] descriptors = this.beanInfo.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i].getReadMethod() == null || !descriptors[i].getName().equals(name) || descriptors[i].getReadMethod().getParameterTypes().length != 0) continue;
            try {
                return descriptors[i].getReadMethod().invoke(this.target, new Object[0]);
            }
            catch (Exception e) {
                PluginUtils.logExceptionInfo(e, "com.agitar.eclipse.agitar");
                return null;
            }
        }
        PluginUtils.log("Couldn't find getter: " + name, "com.agitar.eclipse.agitar");
        return null;
    }

    public void setProperty(String name, Object value) {
        this.setProperty(name, value, true);
    }

    private Method getWriteMethod(String name) {
        name = this.decapitalize(name);
        PropertyDescriptor[] descriptors = this.beanInfo.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i].getWriteMethod() == null || !descriptors[i].getName().equals(name) || descriptors[i].getWriteMethod().getParameterTypes().length != 1) continue;
            return descriptors[i].getWriteMethod();
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Failed to find setter: " + name));
        }
        return null;
    }

    private Method getClearMethod(String name) {
        name = this.decapitalize(name);
        String clearName = "clear" + this.capitalize(name);
        MethodDescriptor[] descriptors = this.beanInfo.getMethodDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getName().equals(clearName) || descriptors[i].getMethod().getParameterTypes().length != 0) continue;
            return descriptors[i].getMethod();
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Failed to find clear method: " + clearName));
        }
        return null;
    }

    private void setProperty(String name, Object value, boolean firePropertyChange) {
        Method m = this.getWriteMethod(name);
        try {
            Object oldValue = this.getProperty(name);
            if (value == null) {
                m.invoke(this.target, new Object[]{null});
                this.firePropertyChangeEvent(name, oldValue, value);
            } else if (!value.equals(oldValue)) {
                m.invoke(this.target, value);
                this.firePropertyChangeEvent(name, oldValue, value);
            }
            return;
        }
        catch (Exception e) {
            Shell shell = Display.getDefault().getActiveShell();
            if (shell != null) {
                PluginUtils.displayExceptionInfo(shell, e, "com.agitar.eclipse.agitar");
            } else {
                PluginUtils.logExceptionInfo(e, "com.agitar.eclipse.agitar");
            }
            return;
        }
    }

    private String decapitalize(String name) {
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private String capitalize(String name) {
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private Object clearProperty(String name) {
        Method m = this.getClearMethod(name);
        try {
            m.invoke(this.target, new Object[0]);
            Object newValue = this.getProperty(name);
            return newValue;
        }
        catch (Exception e) {
            PluginUtils.logExceptionInfo(e, "com.agitar.eclipse.agitar");
            return this.getProperty(name);
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public boolean contains(String name) {
        PropertyDescriptor[] descriptors = this.beanInfo.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] finalListeners = this.listeners.getListeners();
        if (!(finalListeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            for (int i = 0; i < finalListeners.length; ++i) {
                IPropertyChangeListener l = (IPropertyChangeListener)finalListeners[i];
                l.propertyChange(pe);
            }
        }
    }

    public boolean getBoolean(String name) {
        return (Boolean)this.getProperty(name);
    }

    public boolean getDefaultBoolean(String name) {
        Boolean result = (Boolean)this.clearProperty(name);
        return result;
    }

    public double getDefaultDouble(String name) {
        Double result = (Double)this.clearProperty(name);
        return result;
    }

    public float getDefaultFloat(String name) {
        Float result = (Float)this.clearProperty(name);
        return result.floatValue();
    }

    public int getDefaultInt(String name) {
        Integer result = (Integer)this.clearProperty(name);
        return result;
    }

    public long getDefaultLong(String name) {
        Long result = (Long)this.clearProperty(name);
        return result;
    }

    public String getDefaultString(String name) {
        return (String)this.clearProperty(name);
    }

    public double getDouble(String name) {
        Double result = (Double)this.getProperty(name);
        return result;
    }

    public float getFloat(String name) {
        Float result = (Float)this.getProperty(name);
        return result.floatValue();
    }

    public int getInt(String name) {
        Integer result = (Integer)this.getProperty(name);
        return result;
    }

    public long getLong(String name) {
        Long result = (Long)this.getProperty(name);
        return result;
    }

    public String getString(String name) {
        String result = (String)this.getProperty(name);
        return result == null ? "" : result;
    }

    public Collection getCollection(String name) throws Exception {
        Collection result = (Collection)this.getProperty(name);
        return result;
    }

    public boolean isDefault(String name) {
        return false;
    }

    public boolean needsSaving() {
        return this.needsSaving;
    }

    public void putValue(String name, String value) {
        this.setProperty(name, value, false);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
    }

    public void setDefault(String name, int value) {
    }

    public void setDefault(String name, long value) {
    }

    public void setDefault(String name, String defaultObject) {
    }

    public void setDefault(String name, boolean value) {
    }

    public void setToDefault(String name) {
        this.clearProperty(name);
    }

    public void setValue(String name, Collection collection) {
        this.setProperty(name, collection);
    }

    public void setValue(String name, double value) {
        this.setProperty(name, new Double(value));
    }

    public void setValue(String name, float value) {
        this.setProperty(name, new Float(value));
    }

    public void setValue(String name, int value) {
        this.setProperty(name, new Integer(value));
    }

    public void setValue(String name, long value) {
        this.setProperty(name, new Long(value));
    }

    public void setValue(String name, String value) {
        this.setProperty(name, value);
    }

    public void setValue(String name, boolean value) {
        this.setProperty(name, value);
    }

    public Object getTarget() {
        return this.target;
    }

    static {
        $assertionsDisabled = !BeanPreferenceStore.class.desiredAssertionStatus();
    }
}

