/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.eclipse.core.util.IAgColorProvider;
import com.agitar.eclipse.core.util.IAgFontProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class AgTableViewer
extends TableViewer {
    public AgTableViewer(Composite parent) {
        super(parent);
    }

    public AgTableViewer(Table table) {
        super(table);
    }

    public AgTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            if (fullMap) {
                this.associate(element, (Item)item);
            } else {
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            IBaseLabelProvider prov = this.getLabelProvider();
            ITableLabelProvider tprov = null;
            ILabelProvider lprov = null;
            if (prov instanceof ITableLabelProvider) {
                tprov = (ITableLabelProvider)prov;
            } else {
                lprov = (ILabelProvider)prov;
            }
            int columnCount = this.getTable().getColumnCount();
            TableItem ti = item;
            for (int column = 0; column < columnCount || column == 0; ++column) {
                String text = "";
                Image image = null;
                if (tprov != null) {
                    text = tprov.getColumnText(element, column);
                    image = tprov.getColumnImage(element, column);
                } else if (column == 0) {
                    if (lprov instanceof IViewerLabelProvider) {
                        IViewerLabelProvider itemProvider = (IViewerLabelProvider)lprov;
                        ViewerLabel updateLabel = new ViewerLabel(item.getText(), item.getImage());
                        itemProvider.updateLabel(updateLabel, element);
                        text = updateLabel.getText();
                        image = updateLabel.getImage();
                    } else {
                        text = lprov.getText(element);
                        image = lprov.getImage(element);
                    }
                }
                ti.setText(column, text);
                if (ti.getImage(column) != image) {
                    ti.setImage(column, image);
                }
                if (prov instanceof IAgColorProvider) {
                    IAgColorProvider cprov = (IAgColorProvider)prov;
                    ti.setForeground(column, cprov.getForeground(element, column));
                    ti.setBackground(column, cprov.getBackground(element, column));
                }
                if (!(prov instanceof IAgFontProvider)) continue;
                IAgFontProvider fprov = (IAgFontProvider)prov;
                ti.setFont(column, fprov.getFont(element, column));
            }
        }
    }
}

