/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.eclipse.core.util.PluginUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class AgSelectionConverter {
    private static final IJavaElement[] EMPTY_RESULT = new IJavaElement[0];

    private AgSelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws JavaModelException {
        ISelection selection;
        if (part instanceof AbstractTextEditor) {
            return new StructuredSelection((Object[])AgSelectionConverter.codeResolve((AbstractTextEditor)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IJavaElement[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IJavaElement[] result = new IJavaElement[selection.size()];
            int i = 0;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IJavaElement)) {
                    return EMPTY_RESULT;
                }
                result[i] = (IJavaElement)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(AbstractTextEditor editor) {
        if (editor == null) {
            return false;
        }
        return AgSelectionConverter.getInput((IEditorPart)editor) != null;
    }

    public static IJavaElement[] codeResolveOrInputForked(AbstractTextEditor editor) throws InvocationTargetException, InterruptedException {
        ITextSelection selection;
        IJavaElement input = AgSelectionConverter.getInput((IEditorPart)editor);
        IJavaElement[] result = AgSelectionConverter.performForkedCodeResolve(input, selection = (ITextSelection)editor.getSelectionProvider().getSelection());
        if (result.length == 0) {
            result = new IJavaElement[]{input};
        }
        return result;
    }

    public static IJavaElement[] codeResolve(AbstractTextEditor editor) throws JavaModelException {
        return AgSelectionConverter.codeResolve(editor, true);
    }

    public static IJavaElement[] codeResolve(AbstractTextEditor editor, boolean primaryOnly) throws JavaModelException {
        return AgSelectionConverter.codeResolve(AgSelectionConverter.getInput((IEditorPart)editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaElement[] codeResolveForked(AbstractTextEditor editor, boolean primaryOnly) throws InvocationTargetException, InterruptedException {
        return AgSelectionConverter.performForkedCodeResolve(AgSelectionConverter.getInput((IEditorPart)editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaElement getElementAtOffset(AbstractTextEditor editor) throws JavaModelException {
        return AgSelectionConverter.getElementAtOffset(editor, true);
    }

    private static IJavaElement getElementAtOffset(AbstractTextEditor editor, boolean primaryOnly) throws JavaModelException {
        return AgSelectionConverter.getElementAtOffset(AgSelectionConverter.getInput((IEditorPart)editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IType getTypeAtOffset(AbstractTextEditor editor) throws JavaModelException {
        ICompilationUnit unit;
        IJavaElement element = AgSelectionConverter.getElementAtOffset(editor);
        IType type = (IType)element.getAncestor(7);
        if (type == null && (unit = AgSelectionConverter.getInputAsCompilationUnit((IEditorPart)editor)) != null) {
            type = unit.findPrimaryType();
        }
        return type;
    }

    public static IJavaElement getInput(IEditorPart editor) {
        return AgSelectionConverter.getInput(editor, true);
    }

    private static IJavaElement getInput(IEditorPart editor, boolean primaryOnly) {
        if (editor == null) {
            return null;
        }
        return PluginUtils.getEditorInputJavaElement(editor, primaryOnly);
    }

    public static ICompilationUnit getInputAsCompilationUnit(IEditorPart editor) {
        IJavaElement editorInput = AgSelectionConverter.getInput(editor);
        if (editorInput instanceof ICompilationUnit) {
            return (ICompilationUnit)editorInput;
        }
        return null;
    }

    private static IJavaElement[] performForkedCodeResolve(IJavaElement input, ITextSelection selection) throws InvocationTargetException, InterruptedException {
        final class CodeResolveRunnable
        implements IRunnableWithProgress {
            IJavaElement[] result;
            private final /* synthetic */ IJavaElement val$input;
            private final /* synthetic */ ITextSelection val$selection;

            CodeResolveRunnable(IJavaElement val$input, ITextSelection val$selection) {
                this.val$input = val$input;
                this.val$selection = val$selection;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.result = AgSelectionConverter.codeResolve(this.val$input, this.val$selection);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        CodeResolveRunnable runnable = new CodeResolveRunnable(input, selection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
        return runnable.result;
    }

    public static IJavaElement[] codeResolve(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICodeAssist) {
            IJavaElement[] elements;
            if (input instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)input;
                unit.reconcile(0, false, null, null);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset(), selection.getLength())) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            ICompilationUnit unit = (ICompilationUnit)input;
            unit.reconcile(0, false, null, null);
            IJavaElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        if (input instanceof IClassFile) {
            IJavaElement ref = ((IClassFile)input).getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static IJavaElement resolveEnclosingElement(IEditorPart editor, ITextSelection selection) throws JavaModelException {
        return AgSelectionConverter.resolveEnclosingElement(AgSelectionConverter.getInput(editor), selection);
    }

    public static IJavaElement resolveEnclosingElement(IJavaElement input, ITextSelection selection) throws JavaModelException {
        IJavaElement atOffset = null;
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            ICompilationUnit unit = (ICompilationUnit)input;
            unit.reconcile(0, false, null, null);
            atOffset = cunit.getElementAt(selection.getOffset());
        } else if (input instanceof IClassFile) {
            IClassFile cfile = (IClassFile)input;
            atOffset = cfile.getElementAt(selection.getOffset());
        } else {
            return null;
        }
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = selection.getOffset() + selection.getLength();
        IJavaElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }
}

