/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.eclipse.core.util.PixelConverter;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.icon.IconUtility;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class AgSWTUtilities {
    private static final String iconPath = "/icons/";
    private static final double LITTLE_FACTOR = 0.96;
    private static final double FACTOR = 0.7;

    private AgSWTUtilities() {
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Object executeOnEventQueue(Task task) throws Exception {
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            task.run();
        } else {
            Display.getDefault().syncExec((Runnable)task);
        }
        if (task.getException() != null) {
            throw task.getException();
        }
        return task.getResult();
    }

    public static void safeExecuteOnEventQueue(Runnable r) {
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            r.run();
        } else {
            Display.getDefault().asyncExec(r);
        }
    }

    public static void executeOnEventQueue(Runnable r) {
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            r.run();
        } else {
            Display.getDefault().syncExec(r);
        }
    }

    public static void setDialogSize(Dialog dialog, int width, int height) {
        Point computedSize = dialog.getShell().computeSize(-1, -1);
        width = Math.max(computedSize.x, width);
        height = Math.max(computedSize.y, height);
        dialog.getShell().setSize(width, height);
    }

    public static Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof Caret) {
            return ((Caret)widget).getParent().getShell();
        }
        if (widget instanceof DragSource) {
            return ((DragSource)widget).getControl().getShell();
        }
        if (widget instanceof DropTarget) {
            return ((DropTarget)widget).getControl().getShell();
        }
        if (widget instanceof Menu) {
            return ((Menu)widget).getParent().getShell();
        }
        if (widget instanceof ScrollBar) {
            return ((ScrollBar)widget).getParent().getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Font deriveFont(Font f, int style) {
        FontData[] fd = f.getFontData();
        FontData[] newFD = new FontData[fd.length];
        for (int i = 0; i < fd.length; ++i) {
            newFD[i] = new FontData(fd[i].getName(), fd[i].getHeight(), style);
        }
        return new Font((Device)Display.getCurrent(), newFD);
    }

    public static Font deriveFont(Font f, int style, int height) {
        FontData[] fd = f.getFontData();
        FontData[] newFD = new FontData[fd.length];
        for (int i = 0; i < fd.length; ++i) {
            newFD[i] = new FontData(fd[i].getName(), height, style);
        }
        return new Font((Device)Display.getCurrent(), newFD);
    }

    public static Image getImage(AbstractUIPlugin plugin, String img) {
        if (plugin.getImageRegistry().get(img) == null) {
            ImageDescriptor descriptor = AgSWTUtilities.getImageDescriptor(plugin, img);
            plugin.getImageRegistry().put(img, descriptor);
        }
        return plugin.getImageRegistry().get(img);
    }

    public static ImageDescriptor getImageDescriptor(AbstractUIPlugin plugin, String name) {
        ImageDescriptor id;
        Image i;
        URL url = Platform.find((Bundle)plugin.getBundle(), (IPath)new Path(iconPath + name));
        if (url != null && (i = (id = ImageDescriptor.createFromURL((URL)url)).createImage(false)) != null) {
            i.dispose();
            return id;
        }
        url = IconUtility.class.getResource(name);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static void displayExceptionInfo(Exception ex, Shell shell, String pluginID) {
        PluginUtils.displayExceptionInfo(shell, ex, pluginID);
    }

    public static Color littleBrighter(Display display, Color c) {
        return AgSWTUtilities.brighten(display, c, 0.96);
    }

    public static Color brighter(Display display, Color c) {
        return AgSWTUtilities.brighten(display, c, 0.7);
    }

    public static Color brighten(Display display, Color c, double factor) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color((Device)display, i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color((Device)display, Math.min((int)((double)r / factor), 255), Math.min((int)((double)g / factor), 255), Math.min((int)((double)b / factor), 255));
    }

    public static Color littleDarker(Display display, Color c) {
        return AgSWTUtilities.darken(display, c, 0.96);
    }

    public static Color darker(Display display, Color c) {
        return AgSWTUtilities.darken(display, c, 0.7);
    }

    public static Color darken(Display display, Color c, double factor) {
        return new Color((Device)display, Math.max((int)((double)c.getRed() * factor), 0), Math.max((int)((double)c.getGreen() * factor), 0), Math.max((int)((double)c.getBlue() * factor), 0));
    }

    public static void setHorizontalSpan(Control control, int span) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalSpan = span;
        } else if (span != 1) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            control.setLayoutData((Object)gd);
        }
    }

    public static abstract class Task
    implements Runnable {
        private Object result = null;
        private Exception exception = null;

        public final void run() {
            try {
                this.result = this.runEx();
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }

        public Exception getException() {
            return this.exception;
        }

        public Object getResult() {
            return this.result;
        }

        public abstract Object runEx() throws Exception;
    }
}

