/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import com.agitar.eclipse.core.util.ControlContentAssistHelper;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.lib.NoObfuscation;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CUPositionCompletionProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class AgJavaTypeCompletionProcessor
extends CUPositionCompletionProcessor
implements NoObfuscation {
    public static final String DUMMY_CLASS_NAME = "$$__$$";
    public static final String DUMMY_CU_NAME = "$$__$$.java";
    private static IPackageFragmentRoot initRoot;

    private AgJavaTypeCompletionProcessor(boolean enableBaseTypes, boolean enableVoid, boolean useDollarsNotDots) {
        super((CUPositionCompletionProcessor.CUPositionCompletionRequestor)new TypeCompletionRequestor(enableBaseTypes, enableVoid, useDollarsNotDots));
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public void setPackageFragment(IPackageFragment packageFragment) {
        if (packageFragment == null) {
            this.setCompletionContext(null, null, null);
        } else {
            String before = "public class $$__$$ { ";
            String after = " }";
            this.setCompletionContext(packageFragment.getCompilationUnit(DUMMY_CU_NAME), before, after);
        }
    }

    public void setExtendsCompletionContext(IJavaElement javaElement) {
        if (javaElement instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            ICompilationUnit cu = packageFragment.getCompilationUnit(DUMMY_CU_NAME);
            this.setCompletionContext(cu, "public class $$__$$ extends ", " {}");
        } else if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            String before = "public class " + type.getElementName() + " extends ";
            String after = " {}";
            IJavaElement parent = type.getParent();
            while (parent instanceof IType) {
                type = (IType)parent;
                before = before + "public class " + type.getElementName() + " {";
                after = after + "}";
                parent = type.getParent();
            }
            ICompilationUnit cu = type.getCompilationUnit();
            this.setCompletionContext(cu, before, after);
        } else {
            this.setCompletionContext(null, null, null);
        }
    }

    public static IContentAssistProcessor initContentAssist(boolean useDollarsNotDots, IJavaProject javaProject) {
        AgJavaTypeCompletionProcessor contentAssistProcessor = new AgJavaTypeCompletionProcessor(true, false, useDollarsNotDots);
        IPackageFragmentRoot initRoot = AgJavaTypeCompletionProcessor.initPackageFragmentRoot(javaProject);
        if (initRoot != null) {
            contentAssistProcessor.setPackageFragment(initRoot.getPackageFragment(""));
        }
        return contentAssistProcessor;
    }

    public static IContentAssistProcessor createContentAssistProcessorForCombo(Combo combo, boolean useDollarsNotDots, IJavaProject javaProject) {
        AgJavaTypeCompletionProcessor contentAssistProcessor = (AgJavaTypeCompletionProcessor)AgJavaTypeCompletionProcessor.initContentAssist(useDollarsNotDots, javaProject);
        if (AgJavaTypeCompletionProcessor.isOkToUse((Control)combo)) {
            ControlContentAssistHelper.createComboContentAssistant(combo, (IContentAssistProcessor)contentAssistProcessor);
        }
        return contentAssistProcessor;
    }

    public static IContentAssistProcessor createContentAssistProcessorForText(Text text, boolean useDollarsNotDots, IJavaProject javaProject) {
        AgJavaTypeCompletionProcessor contentAssistProcessor = (AgJavaTypeCompletionProcessor)AgJavaTypeCompletionProcessor.initContentAssist(useDollarsNotDots, javaProject);
        if (AgJavaTypeCompletionProcessor.isOkToUse((Control)text)) {
            ControlContentAssistHelper.createTextContentAssistant(text, (IContentAssistProcessor)contentAssistProcessor);
        }
        return contentAssistProcessor;
    }

    private static final boolean isOkToUse(Control control) {
        return control != null && Display.getCurrent() != null && !control.isDisposed();
    }

    private static IPackageFragmentRoot initPackageFragmentRoot(IJavaProject jproject) {
        if (jproject != null) {
            block5: {
                try {
                    initRoot = null;
                    if (!jproject.exists()) break block5;
                    IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                    for (int i = 0; i < roots.length; ++i) {
                        if (roots[i].getKind() != 1) continue;
                        initRoot = roots[i];
                        break;
                    }
                }
                catch (JavaModelException e) {
                    PluginUtils.logExceptionInfo(e, "org.eclipse.core.resources");
                }
            }
            if (initRoot == null) {
                initRoot = jproject.getPackageFragmentRoot(jproject.getResource());
            }
        }
        return initRoot;
    }

    protected static class TypeCompletionRequestor
    extends CUPositionCompletionProcessor.CUPositionCompletionRequestor
    implements NoObfuscation {
        private static final String VOID = "void";
        private static final List BASE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");
        private boolean fEnableBaseTypes;
        private boolean fEnableVoid;
        private boolean useDollars;

        public TypeCompletionRequestor(boolean enableBaseTypes, boolean enableVoid, boolean useDollarsNotDots) {
            this.fEnableBaseTypes = enableBaseTypes;
            this.fEnableVoid = enableVoid;
            this.useDollars = useDollarsNotDots;
        }

        public void accept(CompletionProposal proposal) {
            switch (proposal.getKind()) {
                case 8: {
                    char[] packageName = proposal.getDeclarationSignature();
                    if (TypeFilter.isFiltered((char[])packageName)) {
                        return;
                    }
                    this.addAdjustedCompletion(new String(packageName), new String(proposal.getCompletion()), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance(), JavaPluginImages.DESC_OBJS_PACKAGE);
                    return;
                }
                case 9: {
                    char[] fullName = Signature.toCharArray((char[])proposal.getSignature());
                    if (TypeFilter.isFiltered((char[])fullName)) {
                        return;
                    }
                    StringBuffer buf = new StringBuffer();
                    buf.append(Signature.getSimpleName((char[])fullName));
                    if (buf.length() == 0) {
                        return;
                    }
                    char[] typeQualifier = Signature.getQualifier((char[])fullName);
                    if (typeQualifier.length > 0) {
                        buf.append(" - ");
                        buf.append(typeQualifier);
                    }
                    String name = buf.toString();
                    Object id = null;
                    this.addAdjustedCompletion(name, new String(fullName), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance(), null);
                    return;
                }
                case 3: {
                    if (!this.fEnableBaseTypes) {
                        return;
                    }
                    String keyword = new String(proposal.getName());
                    if (this.fEnableVoid && VOID.equals(keyword) || this.fEnableBaseTypes && BASE_TYPES.contains(keyword)) {
                        this.addAdjustedCompletion(keyword, new String(proposal.getCompletion()), proposal.getReplaceStart(), proposal.getReplaceEnd(), proposal.getRelevance(), null);
                    }
                    return;
                }
            }
        }
    }
}

