/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.util;

import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class AgIntegerFieldEditor
extends IntegerFieldEditor {
    private int minValidValue = Integer.MIN_VALUE;
    private int maxValidValue = Integer.MAX_VALUE;
    private String errorPrefix;

    public AgIntegerFieldEditor() {
    }

    public AgIntegerFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public AgIntegerFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        super(name, labelText, parent, textLimit);
    }

    public void setValidRange(int min, int max) {
        super.setValidRange(min, max);
        this.minValidValue = min;
        this.maxValidValue = max;
    }

    public void setErrorPrefix(String prefix) {
        this.errorPrefix = prefix;
    }

    protected boolean checkState() {
        if (this.errorPrefix == null) {
            return super.checkState();
        }
        Text text = this.getTextControl();
        if (text == null) {
            return false;
        }
        String numberString = text.getText();
        try {
            int number = Integer.valueOf(numberString);
            if (number >= this.minValidValue && number <= this.maxValidValue) {
                this.clearErrorMessage();
                return true;
            }
            if (number < this.minValidValue) {
                this.setErrorMessage(this.errorPrefix + " must be greater than or equal to " + this.minValidValue + ".");
            } else {
                this.setErrorMessage(this.errorPrefix + " must be less than or equal to " + this.maxValidValue + ".");
            }
            this.showErrorMessage();
            return false;
        }
        catch (NumberFormatException e1) {
            if (this.errorPrefix != null) {
                this.setErrorMessage(this.errorPrefix + " must be an integer.");
            }
            this.showErrorMessage();
            return false;
        }
    }
}

