/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.resources;

import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.ArrayUtil;
import com.agitar.common.util.GUID;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.ReaderInputStream;
import com.agitar.common.util.StringUtility;
import com.agitar.common.util.XMLUtility;
import com.agitar.eclipse.core.AgUIException;
import com.agitar.eclipse.core.util.PluginUtils;
import com.agitar.lib.NoObfuscation;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DotAgitatorFile
implements NoObfuscation {
    public static final String DOT_AGITATOR_NAME = ".agitator";
    private static final String SCENARIO_DIR_NAME_DEFAULT = "scenarios";
    private static final String SCENARIO_DIR_NAME = "ConfigDirName";
    private static final String CONFIG_DIR_NAME_DEFAULT = "config";
    private static final String CONIG_DIR_NAME = "ConfigDirName";
    private static final String AGITAR_DIR_DEFAULT = "agitar";
    private static final String ROOT = "Agitator";
    public static final String AGITAR_DIR = "AgitarDirectory";
    private static final String TEST_GEN_SOURCE_DIR = "TestGenSourceDir";
    private static final String RUN_DIR = "RunDirectory";
    protected static final String VERSION = "Version";
    protected static final String VERSION_STR = "2.0";
    protected static final String UID = "GUID";
    protected static final String LIB_PATH = "LibraryPath";
    protected static final String JAVA_ARGS = "JavaArgs";
    protected static final String TEST_GEN_JAVA_ARGS = "TestGenJavaArgs";
    protected static final String EXPERT_PLUGINS = "xplugins";
    protected static final String EXPERT_PLUGIN = "plugin";
    protected static final String PATTERN = "pattern";
    private static final String DEFAULT_TEST_GEN_VM_ARGS = "-Xmx1024m";
    private String testGenVMArgs = "-Xmx1024m";
    public static final String CHARGEBACK_CODE = "ChargebackCode";
    public static final String DOC_TYPE;
    private static final String EXCLUSION_PATTERNS = "ExclusionPatterns";
    private IFile dotAgitatorFile = null;
    private String javaArgs = "-Xms128m -Xmx512m";
    private String agitarDir;
    private String extraLibPath = "";
    private boolean libPathDirty = false;
    private String runInDirectory;
    private String configDirName;
    private String eclipseProjectLocation;
    private GUID guid;
    private Set pluginNames;
    private String scenarioDirName;
    private String testGenSourceFolder;
    private String defaultTestGenSourceFolder;
    private IProject eclipseProject;
    private String chargebackCode = "";
    private Set exclusionPatterns;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DotAgitatorFile(IProject eproj) throws AgUIException {
        this.eclipseProject = eproj;
        this.dotAgitatorFile = eproj.getFile(DOT_AGITATOR_NAME);
        try {
            this.eclipseProjectLocation = IOUtility.getCanonicalPath((File)eproj.getLocation().toFile());
        }
        catch (Exception ex) {
            this.eclipseProjectLocation = eproj.getLocation().toFile().getAbsolutePath();
        }
        if (!this.dotAgitatorFile.isSynchronized(0)) {
            try {
                this.dotAgitatorFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new AgUIException("\".agitator\" is out of sync", e);
            }
        }
        try {
            try {
                this.parse();
            }
            catch (Exception ex) {
                throw new AgUIException("Could not read .agitator file: " + this.dotAgitatorFile.getLocation().toOSString() + " " + ex.getMessage());
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!StringUtility.nullOrEmpty((String)this.agitarDir)) throw throwable;
            this.agitarDir = this.eclipseProjectLocation + File.separator + AGITAR_DIR_DEFAULT;
            throw throwable;
        }
        if (StringUtility.nullOrEmpty((String)this.agitarDir)) {
            this.agitarDir = this.eclipseProjectLocation + File.separator + AGITAR_DIR_DEFAULT;
        }
        try {
            this.hideInternalDirs();
            return;
        }
        catch (Exception ex) {
            PluginUtils.logExceptionInfo(ex, "org.eclipse.core.resources");
        }
    }

    private boolean isWeird(IProject project) {
        try {
            IJavaProject jp = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            IClasspathEntry[] entries = jp.getResolvedClasspath(false);
            for (int i = 0; i < entries.length; ++i) {
                String s;
                if (entries[i].getEntryKind() != 3 || !StringUtility.nullOrEmpty((String)(s = entries[i].getPath().removeFirstSegments(1).toString()))) continue;
                return true;
            }
        }
        catch (Exception ex) {
            PluginUtils.logExceptionInfo(ex, "org.eclipse.core.resources");
        }
        return false;
    }

    public boolean exists() {
        return this.dotAgitatorFile.exists();
    }

    public File getFile() {
        return PluginUtils.getFile((IResource)this.dotAgitatorFile);
    }

    private void parse() throws Exception {
        if (!this.dotAgitatorFile.exists()) {
            return;
        }
        Document root = XMLUtility.parse((InputStream)this.dotAgitatorFile.getContents());
        Element agitator = (Element)root.getChildNodes().item(0);
        NodeList nodes = agitator.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            File f;
            if (nodes.item(i).getNodeType() != 1) continue;
            Element elm = (Element)nodes.item(i);
            String name = elm.getNodeName();
            String val = XMLUtility.getValueOfTextNode((Node)elm);
            String localVal = this.getLocalizedFilePath(val);
            if (name.equalsIgnoreCase(AGITAR_DIR)) {
                f = new File(localVal);
                if (f.isAbsolute()) {
                    this.setAgitarDir(localVal);
                    continue;
                }
                this.setAgitarDir(this.eclipseProjectLocation + File.separator + localVal);
                continue;
            }
            if (name.equalsIgnoreCase(TEST_GEN_SOURCE_DIR)) {
                f = new File(localVal);
                if (!f.isAbsolute()) {
                    this.setTestGenSourceFolder(localVal);
                    continue;
                }
                String relTestGenDir = IOUtility.createRelativePath((String)localVal, (String)this.eclipseProjectLocation);
                this.setTestGenSourceFolder(relTestGenDir);
                continue;
            }
            if (name.equalsIgnoreCase(CHARGEBACK_CODE)) {
                this.setChargebackCode(val);
                continue;
            }
            if (name.equalsIgnoreCase(JAVA_ARGS)) {
                this.setJavaArgs(val);
                continue;
            }
            if (name.equalsIgnoreCase(TEST_GEN_JAVA_ARGS)) {
                this.setTestGenJavaArgs(val);
                continue;
            }
            if (name.equalsIgnoreCase(LIB_PATH)) {
                this.extraLibPath = localVal == null ? "" : localVal;
                this.libPathDirty = false;
                continue;
            }
            if (name.equalsIgnoreCase(RUN_DIR)) {
                this.setRunInDirectory(localVal);
                continue;
            }
            if ("ConfigDirName".equalsIgnoreCase(name)) {
                this.configDirName = localVal;
                continue;
            }
            if (UID.equalsIgnoreCase(name)) {
                this.guid = GUID.fromString((String)val);
                continue;
            }
            if (EXPERT_PLUGINS.equalsIgnoreCase(name)) {
                this.parseEnabledExpertPlugins(elm);
                continue;
            }
            if ("ConfigDirName".equalsIgnoreCase(name)) {
                this.scenarioDirName = localVal;
                continue;
            }
            if (!EXCLUSION_PATTERNS.equalsIgnoreCase(name)) continue;
            this.parseExclusionPatterns(elm);
        }
        if (this.guid == null) {
            this.guid = this.getGUID();
            this.save(null);
        }
    }

    private void parseExclusionPatterns(Element elm) {
        this.exclusionPatterns = new HashSet();
        NodeList list = elm.getElementsByTagName(PATTERN);
        if (list != null) {
            int len = list.getLength();
            block0: for (int i = 0; i < len; ++i) {
                Element el = (Element)list.item(i);
                NodeList children = el.getChildNodes();
                int m = children.getLength();
                for (int j = 0; j < m; ++j) {
                    Node child = children.item(j);
                    if (child.getNodeType() != 3) continue;
                    this.exclusionPatterns.add(child.getNodeValue());
                    continue block0;
                }
            }
        }
    }

    private void parseEnabledExpertPlugins(Element elm) {
        this.pluginNames = new HashSet();
        NodeList list = elm.getElementsByTagName(EXPERT_PLUGIN);
        if (list != null) {
            int len = list.getLength();
            block0: for (int i = 0; i < len; ++i) {
                Element el = (Element)list.item(i);
                NodeList children = el.getChildNodes();
                int m = children.getLength();
                for (int j = 0; j < m; ++j) {
                    Node child = children.item(j);
                    if (child.getNodeType() != 3) continue;
                    this.pluginNames.add(child.getNodeValue());
                    continue block0;
                }
            }
        }
    }

    public boolean isLibPathDirty() {
        return this.libPathDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object context) throws Exception {
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{this.dotAgitatorFile}, context);
        if (status.getSeverity() != 0) {
            throw new AgUIException(status.getMessage(), status.getException());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            pw.println(DOC_TYPE);
            pw.print("<Agitator>");
            DotAgitatorFile.writeElement(pw, VERSION, VERSION_STR);
            String relativeAgitarDir = IOUtility.createRelativePath((String)this.getAgitarDir(), (String)this.eclipseProjectLocation);
            DotAgitatorFile.writeElement(pw, UID, this.getGUID().toString());
            DotAgitatorFile.writeElement(pw, AGITAR_DIR, relativeAgitarDir);
            DotAgitatorFile.writeElement(pw, TEST_GEN_SOURCE_DIR, this.getTestGenSourceFolder());
            DotAgitatorFile.writeElement(pw, JAVA_ARGS, this.getJavaArgs());
            if (!StringUtility.nullOrEmpty((String)this.getChargebackCode())) {
                DotAgitatorFile.writeElement(pw, CHARGEBACK_CODE, this.getChargebackCode());
            }
            DotAgitatorFile.writeElement(pw, TEST_GEN_JAVA_ARGS, this.getTestGenJavaArgs());
            DotAgitatorFile.writeElement(pw, LIB_PATH, this.extraLibPath);
            this.libPathDirty = false;
            DotAgitatorFile.writeElement(pw, RUN_DIR, this.getRunInDirectory());
            if (this.configDirName != null) {
                DotAgitatorFile.writeElement(pw, "ConfigDirName", this.getConfigDirName());
            }
            if (this.scenarioDirName != null) {
                DotAgitatorFile.writeElement(pw, "ConfigDirName", this.getScenarioDirName());
            }
            this.writeEnabledPlugins(pw);
            this.writeExclusionPatterns(pw);
            pw.println(XMLUtility.getEndTag((String)ROOT));
        }
        finally {
            pw.close();
        }
        StringReader sd = new StringReader(sw.getBuffer().toString());
        String s = this.getAgitarDir();
        IFolder agitarFolder = (IFolder)PluginUtils.getEclipseContainer(this.eclipseProject, new File(s));
        if (agitarFolder != null && !agitarFolder.exists()) {
            PluginUtils.mkdirs(agitarFolder);
        }
        if (!this.dotAgitatorFile.exists()) {
            this.dotAgitatorFile.create((InputStream)new ReaderInputStream((Reader)sd, "UTF-8"), true, null);
        } else {
            this.dotAgitatorFile.setContents((InputStream)new ReaderInputStream((Reader)sd, "UTF-8"), true, true, null);
        }
    }

    private void hideInternalDirs() throws Exception {
        String[] privateDirs = new String[]{".intel", ".intel_2", ".classes", ".logs", ".junitresults", ".results", ".pending_results"};
        String relativeAgitarDir = IOUtility.createRelativePath((String)this.getAgitarDir(), (String)this.eclipseProjectLocation);
        for (int i = 0; i < privateDirs.length; ++i) {
            IFolder f = this.dotAgitatorFile.getProject().getFolder(relativeAgitarDir + "/" + privateDirs[i]);
            try {
                if (!f.exists()) {
                    f.create(true, true, null);
                }
            }
            catch (Exception ex) {
                PluginUtils.logExceptionInfo(ex, "org.eclipse.core.resources");
            }
            if (!f.exists() || f.isTeamPrivateMember()) continue;
            f.setTeamPrivateMember(true);
        }
    }

    public String getScenarioDirName() {
        return this.scenarioDirName == null ? SCENARIO_DIR_NAME_DEFAULT : this.scenarioDirName;
    }

    private void writeExclusionPatterns(PrintWriter pw) {
        if (this.exclusionPatterns != null && this.exclusionPatterns.size() > 0) {
            pw.write("<ExclusionPatterns>\n");
            Iterator iter = this.exclusionPatterns.iterator();
            while (iter.hasNext()) {
                DotAgitatorFile.writeElement(pw, PATTERN, (String)iter.next());
            }
            pw.write("</");
            pw.write(EXCLUSION_PATTERNS);
            pw.write(">\n");
        }
    }

    private void writeEnabledPlugins(PrintWriter pw) {
        if (this.pluginNames != null && this.pluginNames.size() > 0) {
            pw.write("<xplugins>\n");
            Iterator iter = this.pluginNames.iterator();
            while (iter.hasNext()) {
                DotAgitatorFile.writeElement(pw, EXPERT_PLUGIN, (String)iter.next());
            }
            pw.write("</");
            pw.write(EXPERT_PLUGINS);
            pw.write(">\n");
        }
    }

    private String getLocalizedFilePath(String str) {
        if (str == null) {
            return null;
        }
        return str.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static void writeElement(PrintWriter pw, String name, String value) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty((String)name)) {
            throw new AssertionError();
        }
        if (value == null) {
            return;
        }
        pw.print("<");
        pw.print(name);
        pw.print(">");
        pw.print(XMLUtility.escape((String)value));
        pw.print("</");
        pw.print(name);
        pw.println(">");
    }

    public String getAgitarDir() {
        return this.agitarDir;
    }

    public String getRelativeAgitarDir() {
        return IOUtility.createRelativePath((String)this.agitarDir, (String)this.eclipseProjectLocation);
    }

    public String getRelativeExtraLibPath() {
        return this.extraLibPath;
    }

    public String getExtraLibPath() {
        if (this.extraLibPath == null) {
            this.extraLibPath = "";
        }
        String[] paths = StringUtility.split((String)this.extraLibPath, (String)";");
        File cwd = new File(this.getAgitarDir()).getParentFile();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            File f;
            if (i > 0) {
                buf.append(";");
            }
            if (!(f = new File(paths[i])).isAbsolute()) {
                f = new File(cwd, f.getPath());
            }
            buf.append(IOUtility.getCanonicalPath((File)f));
        }
        return buf.toString();
    }

    public String getJavaArgs() {
        return this.javaArgs;
    }

    public String getRunInDirectory() {
        return this.runInDirectory;
    }

    public File getResultsDir() {
        return new File(this.getAgitarDir(), ".results");
    }

    public File getPendingResultsDir() throws CoreException {
        return new File(this.getAgitarDir(), ".pending_results");
    }

    public File getServerDashboardHistoryDir() throws CoreException {
        return new File(this.getAgitarDir(), "dashboard_history");
    }

    public File getCoverageDir() {
        return new File(this.getAgitarDir(), ".results");
    }

    public String getConfigDirName() {
        return this.configDirName == null ? CONFIG_DIR_NAME_DEFAULT : this.configDirName;
    }

    public void setAgitarDir(String agitarDir) {
        this.agitarDir = agitarDir;
    }

    public void clearAgitarDir() {
        this.agitarDir = this.eclipseProjectLocation + File.separator + AGITAR_DIR_DEFAULT;
    }

    public String getChargebackCode() {
        return this.chargebackCode;
    }

    public void setChargebackCode(String code) {
        this.chargebackCode = code.trim();
    }

    public void clearChargebackCode() {
        this.chargebackCode = "";
    }

    public void clearJavaArgs() {
        this.javaArgs = "-Xms128m -Xmx512m";
    }

    public void clearExtraLibPath() {
        this.extraLibPath = "";
    }

    public void setExtraLibPath(String extraLibPath) {
        String[] paths = StringUtility.split((String)extraLibPath, (String)";");
        StringBuffer buf = new StringBuffer();
        String cwd = new File(this.getAgitarDir()).getParentFile().getAbsolutePath();
        for (int i = 0; i < paths.length; ++i) {
            if (i > 0) {
                buf.append(";");
            }
            buf.append(IOUtility.createRelativePath((String)paths[i], (String)cwd));
        }
        this.extraLibPath = buf.toString();
        this.libPathDirty = true;
    }

    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    public void setRunInDirectory(String runInDirectory) {
        this.runInDirectory = runInDirectory;
    }

    public GUID getGUID() {
        if (this.guid == null) {
            this.guid = new GUID(null);
        }
        return this.guid;
    }

    public Set getExclusionPatterns() {
        return this.exclusionPatterns == null ? ArrayUtil.EMPTYSET : this.exclusionPatterns;
    }

    public void setExclusionPatterns(Set patterns) {
        this.exclusionPatterns = patterns;
    }

    public Set getEnabledPlugins() {
        return this.pluginNames == null ? ArrayUtil.EMPTYSET : this.pluginNames;
    }

    public void setEnabledPlugins(Set pluginIds) {
        this.pluginNames = pluginIds;
    }

    public String getRelativeTestGenSourceFolder() {
        return IOUtility.createRelativePath((String)(this.eclipseProjectLocation + File.separator + this.getTestGenSourceFolder()), (String)new File(this.agitarDir).getParent());
    }

    public String getTestGenSourceFolder() {
        if (this.testGenSourceFolder == null) {
            this.testGenSourceFolder = this.getDefaultTestGenSourceFolder();
        }
        return this.testGenSourceFolder;
    }

    public void setTestGenSourceFolder(String folder) {
        this.testGenSourceFolder = folder;
    }

    public boolean isDefaultGenSourceFolder() {
        return this.testGenSourceFolder.equals(this.getDefaultTestGenSourceFolder());
    }

    public void clearTestGenSourceFolder() {
        this.testGenSourceFolder = this.getDefaultTestGenSourceFolder();
    }

    public String getDefaultTestGenSourceFolder() {
        if (this.defaultTestGenSourceFolder == null) {
            this.defaultTestGenSourceFolder = this.isWeird(this.eclipseProject) ? File.separator : this.getRelativeAgitarDir() + File.separator + "test";
            if (StringUtility.nullOrEmpty((String)this.testGenSourceFolder)) {
                this.testGenSourceFolder = this.getDefaultTestGenSourceFolder();
            }
        }
        return this.defaultTestGenSourceFolder;
    }

    public String getTestGenJavaArgs() {
        return StringUtility.nullOrEmpty((String)this.testGenVMArgs.trim()) ? DEFAULT_TEST_GEN_VM_ARGS : this.testGenVMArgs;
    }

    public void setTestGenJavaArgs(String val) {
        this.testGenVMArgs = val;
    }

    public void clearTestGenJavaArgs() {
        this.testGenVMArgs = DEFAULT_TEST_GEN_VM_ARGS;
    }

    static {
        $assertionsDisabled = !DotAgitatorFile.class.desiredAssertionStatus();
        DOC_TYPE = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + AgitarProperties.LINE_SEPARATOR;
    }
}

