/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.eclipse.core.action;

import com.agitar.eclipse.core.AgUIException;
import com.agitar.eclipse.core.util.AgSelectionConverter;
import com.agitar.eclipse.core.util.JavaElementUtils;
import com.agitar.eclipse.core.util.PluginUtils;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractEditorActionDelegate
implements IEditorActionDelegate,
IActionDelegate2 {
    private IWorkbenchWindow window;
    private IAction action;
    private IEditorPart currentEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.action = action;
        this.currentEditor = targetEditor;
        if (this.currentEditor == null) {
            return;
        }
        this.window = targetEditor.getSite().getWorkbenchWindow();
    }

    public IEditorPart getEditor() {
        return this.currentEditor;
    }

    protected IWorkbenchWindow getWorkbenchWindw() {
        return this.window;
    }

    public final void run(IAction a) {
        this.action = a;
        try {
            if (this.currentEditor == null) {
                this.action.setEnabled(false);
                throw new AgUIException("Operation not valid for current selection.");
            }
            this.runEx(this.currentEditor);
        }
        catch (Exception e) {
            PluginUtils.displayExceptionInfo(this.window.getShell(), e, "org.eclipse.core.resources");
        }
    }

    protected IAction getAction() {
        return this.action;
    }

    public void updateEnablement() {
        if (this.action == null || this.getEditor() == null) {
            return;
        }
        try {
            IStructuredSelection structSel = AgSelectionConverter.getStructuredSelection((IWorkbenchPart)this.getEditor());
            IJavaElement je = JavaElementUtils.getJavaElement((ISelection)structSel);
            this.action.setEnabled(this.enableForJavaElement(this.getEditor(), je));
        }
        catch (JavaModelException e) {
            PluginUtils.logExceptionInfo(e, "org.eclipse.core.resources");
            this.action.setEnabled(false);
        }
    }

    public abstract void runEx(IEditorPart var1) throws Exception;

    public abstract boolean enableForJavaElement(IEditorPart var1, IJavaElement var2);

    public void selectionChanged(IAction a, ISelection selection) {
        this.action = a;
    }

    public final void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void init(IAction a) {
        this.action = a;
    }

    public void dispose() {
    }

    public void runWithEvent(IAction a, Event event) {
        this.run(a);
    }
}

