/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.util;

import de.java2html.util.RGB;
import java.util.Hashtable;

public class HtmlUtilities {
    private static Hashtable entityTableEncode;
    private static final String[] ENTITIES;

    private HtmlUtilities() {
    }

    protected static void buildEntityTables() {
        entityTableEncode = new Hashtable(ENTITIES.length);
        for (int i = 0; i < ENTITIES.length; i += 2) {
            if (entityTableEncode.containsKey(ENTITIES[i + 1])) continue;
            entityTableEncode.put(ENTITIES[i + 1], ENTITIES[i]);
        }
    }

    public static final String encode(String s, String ignore) {
        return HtmlUtilities.encode(s, 0, s.length(), ignore);
    }

    public static final String encode(String s, int start, int end, String ignore) {
        if (entityTableEncode == null) {
            HtmlUtilities.buildEntityTables();
        }
        StringBuffer sb = new StringBuffer((end - start) * 2);
        for (int i = start; i < end; ++i) {
            char ch = s.charAt(i);
            if (ch >= '?' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ignore.indexOf(ch) != -1) {
                sb.append(ch);
                continue;
            }
            sb.append(HtmlUtilities.encodeSingleChar(String.valueOf(ch)));
        }
        return sb.toString();
    }

    protected static final String encodeSingleChar(String ch) {
        String s = (String)entityTableEncode.get(ch);
        return s == null ? ch : s;
    }

    public static final String toHTML(RGB color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    static {
        ENTITIES = new String[]{" ", " ", "-", "-", "'", "'", "`", "`", "&Uuml;", "\u2039", "&Auml;", "\u0192", "&Ouml;", "\u00f7", "&Euml;", "\u00c0", "&Ccedil;", "\u00ab", "&AElig;", "\u2206", "&Aring;", "\u2248", "&Oslash;", "\u00ff", "&uuml;", "\u00b8", "&auml;", "\u2030", "&ouml;", "\u02c6", "&euml;", "\u00ce", "&ccedil;", "\u00c1", "&aring;", "\u00c2", "&oslash;", "\u00af", "&grave;", "`", "&agrave;", "\u2021", "&egrave;", "\u00cb", "&igrave;", "\u00cf", "&ograve;", "\u00da", "&ugrave;", "\u02d8", "&amp;", "&", "&#34;", "\"", "&szlig;", "\ufb02", "&nbsp;", " ", "&gt;", ">", "&lt;", "<", "&copy;", "(C)", "&cent;", "\u00a2", "&pound;", "\u00a3", "&laquo;", "\u00b4", "&raquo;", "\u00aa", "&reg;", "(R)", "&middot;", " - ", "&times;", " x ", "&acute;", "'", "&aacute;", "\u00b7", "&uacute;", "\u02d9", "&oacute;", "\u00db", "&eacute;", "\u00c8", "&iacute;", "\u00cc", "&ntilde;", "\u00d2", "&sect;", "\u00df", "&egrave;", "\u00cb", "&icirc;", "\u00d3", "&ocirc;", "\u00d9", "&acirc;", "\u201a", "&ucirc;", "\u02da", "&ecirc;", "\u00cd", "&aelig;", "\u00ca", "&iexcl;", "\u00b0", "&#151;", "-", "&#0151;", "-", "&#0146;", "'", "&#146;", "'", "&#0145;", "'", "&#145;", "'", "&quot;", "\""};
    }
}

