## Draft HTTP Core Documents

This is the working area for the [IETF HTTP Working Group](https://httpwg.github.io/)'s documents that define the HTTP protocol; see also our [extensions repository](https://github.com/httpwg/http-extensions/). See [our contribution guidelines](CONTRIBUTING.md) for information about how to participate.

**Be aware that all contributions to our work fall under the "NOTE WELL" terms therein.**

The [building instructions](BUILDING.txt) explain how to build the drafts from source.


### HTTP/1.1 Message Syntax and Routing

* [RFC7230](http://httpwg.org/specs/rfc7230.html) ([plain text](https://www.rfc-editor.org/rfc/rfc7230.txt), [tracker](https://datatracker.ietf.org/doc/rfc7230/))
* [Editors' Draft](https://httpwg.github.io/http-core/draft-ietf-httpbis-messaging-latest.html) ([xml](https://httpwg.github.io/http-core/draft-ietf-httpbis-messaging-latest.xml))
* [Open Issues](https://github.com/httpwg/http-core/issues)

### HTTP Semantics

* [RFC7231](http://httpwg.org/specs/rfc7231.html) ([plain text](https://www.rfc-editor.org/rfc/rfc7231.txt), [tracker](https://datatracker.ietf.org/doc/rfc7231/))
* [Editors' Draft](https://httpwg.github.io/http-core/draft-ietf-httpbis-semantics-latest.html) ([xml](https://httpwg.github.io/http-core/draft-ietf-httpbis-semantics-latest.xml))
* [Open Issues](https://github.com/httpwg/http-core/issues)

### HTTP Conditional Requests

* [RFC7232](http://httpwg.org/specs/rfc7232.html) ([plain text](https://www.rfc-editor.org/rfc/rfc7232.txt), [tracker](https://datatracker.ietf.org/doc/rfc7232/))
* [Editors' Draft](https://httpwg.github.io/http-core/draft-ietf-httpbis-conditional-latest.html) ([xml](https://httpwg.github.io/http-core/draft-ietf-httpbis-conditional-latest.xml))
* [Open Issues](https://github.com/httpwg/http-core/issues)

### HTTP Range Requests

* [RFC7233](http://httpwg.org/specs/rfc7233.html) ([plain text](https://www.rfc-editor.org/rfc/rfc7233.txt), [tracker](https://datatracker.ietf.org/doc/rfc7233/))
* [Editors' Draft](https://httpwg.github.io/http-core/draft-ietf-httpbis-range-latest.html) ([xml](https://httpwg.github.io/http-core/draft-ietf-httpbis-range-latest.xml))
* [Open Issues](https://github.com/httpwg/http-core/issues)

### HTTP Caching

* [RFC7234](http://httpwg.org/specs/rfc7234.html) ([plain text](https://www.rfc-editor.org/rfc/rfc7234.txt), [tracker](https://datatracker.ietf.org/doc/rfc7234/))
* [Editors' Draft](https://httpwg.github.io/http-core/draft-ietf-httpbis-cache-latest.html) ([xml](https://httpwg.github.io/http-core/draft-ietf-httpbis-cache-latest.xml))
* [Open Issues](https://github.com/httpwg/http-core/issues)

### HTTP Authentication

* [RFC7235](http://httpwg.org/specs/rfc7235.html) ([plain text](https://www.rfc-editor.org/rfc/rfc7235.txt), [tracker](https://datatracker.ietf.org/doc/rfc7235/))
* [Editors' Draft](https://httpwg.github.io/http-core/draft-ietf-httpbis-auth-latest.html) ([xml](https://httpwg.github.io/http-core/draft-ietf-httpbis-auth-latest.xml))
* [Open Issues](https://github.com/httpwg/http-core/issues)

