<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:x="http://purl.org/net/xml2rfc/ext"
               xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
               version="1.0"
               xmlns:my="#my"
               exclude-result-prefixes="rdf x"
>

<xsl:output indent="yes" omit-xml-declaration="yes"/>

<my:data>
  <my:item>
    <iref item='stale-while-revalidate (cache directive)'>
      <xref target="RFC5861" x:fmt="," x:sec="3"/>
    </iref>
    <iref item='stale-if-error (cache directive)'>
      <xref target="RFC5861" x:fmt="," x:sec="4"/>
    </iref>
  </my:item>
</my:data>

<xsl:template match="/">
  <xsl:variable name="table">
    <texttable align="left" suppress-title="true" anchor="iana.cache.directive.registration.table">
      <ttcol>Cache Directive</ttcol>
      <ttcol>Reference</ttcol>
      <xsl:text>&#10;</xsl:text>
      <xsl:apply-templates select="//iref[contains(@item,' (cache directive)') and @primary='true']|document('')//iref">
        <xsl:sort select="@item"/>
      </xsl:apply-templates>
    </texttable>
    <xsl:text>&#10;</xsl:text>
  </xsl:variable>

  <xsl:comment>AUTOGENERATED FROM extract-cache-directives-defs.xslt, do not edit manually</xsl:comment>
  <xsl:text>&#10;</xsl:text>
  <xsl:copy-of select="$table"/>
  <xsl:comment>(END)</xsl:comment>
  <xsl:text>&#10;</xsl:text>
  
  <!-- check against current version -->
  <xsl:variable name="oldtable" select="//texttable[@anchor='iana.cache.directive.registration.table']" />

  <xsl:variable name="s">
    <xsl:apply-templates select="$table//texttable" mode="tostring"/>
  </xsl:variable>
  
  <xsl:variable name="s1">
    <xsl:apply-templates select="$oldtable" mode="tostring"/>
  </xsl:variable>

  <xsl:if test="$s != $s1">
    <xsl:message>WARNING: table contained inside source document needs to be updated</xsl:message>
    <xsl:message><xsl:value-of select="$s"/></xsl:message>
    <xsl:message><xsl:value-of select="$s1"/></xsl:message>
  </xsl:if>

</xsl:template>

<xsl:template match="*" mode="tostring">
  <xsl:text>&lt;</xsl:text>
  <xsl:value-of select="name()"/>
  <xsl:for-each select="@*">
    <xsl:sort select="name()"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="name()"/>
    <xsl:text>=</xsl:text>
    <xsl:value-of select="."/>
  </xsl:for-each>
  <xsl:text>&gt;</xsl:text>
  
  <xsl:apply-templates select="node()" mode="tostring"/>
  
  <xsl:text>&lt;/</xsl:text>
  <xsl:value-of select="name()"/>
  <xsl:text>&gt;</xsl:text>

</xsl:template>

<xsl:template match="text()" mode="tostring">
  <xsl:value-of select="."/>
</xsl:template>

<xsl:template match="texttable/text()" mode="tostring"/>
<xsl:template match="texttable/c[xref]/text()" mode="tostring"/>

<xsl:template match="iref">
  <xsl:variable name="t" select="@item"/>
  <xsl:variable name="dir" select="substring-before($t,' (cache directive)')"/>
  <xsl:if test="not(preceding::iref[@item=$t])">

    <xsl:text>&#10;</xsl:text>
    <c><xsl:value-of select="$dir"/></c>
    <c>
      <xsl:choose>
        <!-- from this XSLT? -->
        <xsl:when test="ancestor::my:item">
          <xsl:for-each select="xref">
            <xsl:if test="position()!=1">
              <xsl:text>, </xsl:text>
            </xsl:if>
            <xref>
              <xsl:copy-of select="@*"/>
            </xref>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="//*[iref[@item=$t]]">
            <xsl:if test="position()!=1">
              <xsl:text>, </xsl:text>
            </xsl:if>
            <xref target="{ancestor-or-self::*[@anchor][1]/@anchor}"/>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </c>
    
  </xsl:if>
</xsl:template>

</xsl:transform>