# Contributing to HTTP

Anyone can contribute to HTTP; you don't have to join the Working Group, because there is no "membership" -- anyone who participates in the work, as outlined below, is part of the HTTP Working Group.

Before doing so, it's a good idea to familiarize yourself with our current issues list,
[charter](https://datatracker.ietf.org/wg/httpbis/about/), and [working group home
page](https://httpwg.github.io/). If you're new to this, you may also want to read the [Tao of the
IETF](https://www.ietf.org/tao.html).

**Be aware that all contributions fall under the "NOTE WELL" terms outlined below.**


<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Following Discussion](#following-discussion)
- [Raising Issues](#raising-issues)
- [Resolving Issues](#resolving-issues)
- [Pull Requests](#pull-requests)
- [Code of Conduct](#code-of-conduct)
- [NOTE WELL](#note-well)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->


## Following Discussion

The Working Group has a few venues for discussion:

* We have a session at most [IETF meetings](https://www.ietf.org/meeting/), and sometimes in between. See our [meeting materials repository](https://github.com/httpwg/wg-materials), and the [official proceedings](https://datatracker.ietf.org/wg/httpbis/meetings/) for details.

* Our [mailing list](https://lists.w3.org/Archives/Public/ietf-http-wg/) is used for most communication, including notifications of meetings, new drafts, consensus calls and other business, as well as issue discussion.

* We also discuss specific issues on the [issues list](https://github.com/httpwg/http-core/issues) itself.

To be active in the Working Group, you can participate in any of these places. Most activity takes
place on the mailing list, but if you just want to comment on and raise issues, that's fine too.


## Raising Issues

We use our [issues list](https://github.com/httpwg/http-core/issues) to track items for
discussion and their resolution.

Before filing a new issue, please consider a few things:

* Issues should be just that; issues with our deliverables, **not proposals, questions or support requests**.

* Please review the issues list to make sure that you aren't filing a duplicate.

* If you're not sure how to phrase your issue, please ask on the [mailing list](https://lists.w3.org/Archives/Public/ietf-http-wg/).

Issues can also be raised on the [Working Group mailing
list](https://lists.w3.org/Archives/Public/ietf-http-wg/) by clearly marking them as such (e.g., in
the `Subject:` line).

Be aware that issues might be rephrased, changed in scope, or combined with others, so that the
group can focus its efforts. If you feel that such a change loses an important part of your
original issue, please bring it up, either in comments or on the list.

Off-topic and duplicate issues will be closed without discussion. Note that comments on individual
commits will only be responded to with best effort, and may not be seen.


## Resolving Issues

As in all IETF Working Groups, final consensus of the Working Group is determined during Working
Group Last Call; consensus established in discussion of issues provides a limited precedent, to
prevent revisiting topics unnecessarily. Our issues list provides a mechanism for tracking those
discussions and their outcome.

Issues will be labeled by the Chairs as either `editorial` or `design`:

* **Design** issues require discussion and consensus in the Working Group. This discussion can happen both in the issue and on the [Working Group mailing list](https://lists.w3.org/Archives/Public/ietf-http-wg/), as outlined below. 

* **Editorial** issues can be dealt with by the editor(s) without consensus or notification. Typically, any discussion will take place on the issue itself.

The `open` design issues in the issues list are those that we are currently or plan to discuss.
When a design issue is `closed`, it implies that the issue's proposed resolution is reflected in
the draft; if a closed design issue is labeled with `has-consensus`, it means that the incorporated resolution has Working Group consensus.

Design issues can be discussed on the mailing list or the issues list. The editors can also propose resolutions to design issues for the group's consideration by incorporating them into the draft(s).

When a new draft is published, the design issues that have been closed since the last draft will be highlighted on the mailing list, to aid reviewers. Once consensus is confirmed, those issues will be labeled with `has-consensus`.

Note that whether or not a design issue is closed does **not** reflect consensus of the Working Group; an issue's `open`/`closed` state is only used to organise our discussions. If you have a question or problem with an issue in the `closed` state, please comment on it (either in the issues list or mailing list), and we'll adjust its state accordingly. Note that reopening issues with `has-consensus` requires new information.


## Pull Requests

We welcome pull requests, both for editorial suggestions and to resolve open issues. In the latter
case, please identify the relevant issue.

Please do not use a pull request to open a new design issue.


## Code of Conduct

The [IETF Guidelines for Conduct](https://tools.ietf.org/html/rfc7154) applies to all Working Group
communications and meetings.


## NOTE WELL

Any submission to the [IETF](https://www.ietf.org/) intended by the Contributor for publication as
all or part of an IETF Internet-Draft or RFC and any statement made within the context of an IETF
activity is considered an "IETF Contribution". Such statements include oral statements in IETF
sessions, as well as written and electronic communications made at any time or place, which are
addressed to:

 * The IETF plenary session
 * The IESG, or any member thereof on behalf of the IESG
 * Any IETF mailing list, including the IETF list itself, any working group or design team list, or
   any other list functioning under IETF auspices
 * Any IETF working group or portion thereof
 * Any Birds of a Feather (BOF) session
 * The IAB or any member thereof on behalf of the IAB
 * The RFC Editor or the Internet-Drafts function
 * All IETF Contributions are subject to the rules of [RFC
   5378](https://tools.ietf.org/html/rfc5378) and [RFC 3979](https://tools.ietf.org/html/rfc3979)
   (updated by [RFC 4879](https://tools.ietf.org/html/rfc4879)).

Statements made outside of an IETF session, mailing list or other function, that are clearly not
intended to be input to an IETF activity, group or function, are not IETF Contributions in the
context of this notice.

Please consult [RFC 5378](https://tools.ietf.org/html/rfc5378) and [RFC
3979](https://tools.ietf.org/html/rfc3979) for details.

A participant in any IETF activity is deemed to accept all IETF rules of process, as documented in
Best Current Practices RFCs and IESG Statements.

A participant in any IETF activity acknowledges that written, audio and video records of meetings
may be made and may be available to the public.
