import { relayStylePagination } from '@apollo/client/utilities'
import { StrictTypedTypePolicies } from '@app/generated/civic.apollo-helpers'

export const CvcTypePolicies: StrictTypedTypePolicies = {
  Gene: {
    fields: {
      comments: relayStylePagination(),
      revisions: relayStylePagination(),
      events: relayStylePagination(),
      variants: relayStylePagination(),
    },
  },
  Query: {
    fields: {
      activities: relayStylePagination([
        'subject',
        'organizationId',
        'userId',
        'activityType',
        'subjectType',
        'linkedApprovalId',
      ]),
      browseFeatures: relayStylePagination([
        'name',
        'featureType',
        'therapyName',
        'featureAlias',
        'diseaseName',
      ]),
      browseVariants: relayStylePagination([
        'variantName',
        'entrezSymbol',
        'diseaseName',
        'therapayName',
        'variantTypeId',
        'variantGroupId',
        'variantCategory',
      ]),
      browseMolecularProfiles: relayStylePagination([
        'variantName',
        'entrezSymbol',
        'diseaseName',
        'therapyName',
        'molecularProfileScore',
        'molecularProfileAlias',
        'variantId',
      ]),
      browseVariantGroups: relayStylePagination([
        'name',
        'geneNames',
        'variantNames',
        'variantId',
      ]),
      browseSources: relayStylePagination([
        'name',
        'year',
        'sourceType',
        'citationId',
        'author',
        'journal',
        'clinicalTrialId',
        'id',
        'openAccess',
      ]),
      sourceSuggestions: relayStylePagination([
        'sourceType',
        'citationId',
        'sourceId',
        'molecularProfileName',
        'diseaseName',
        'comment',
        'submitter',
        'citation',
        'status',
        'submitterId',
      ]),
      browseTherapies: relayStylePagination([
        'name',
        'ncitId',
        'therapyAlias',
        'sortBy',
      ]),
      events: relayStylePagination([
        'subject',
        'organizationId',
        'originatingUserId',
        'eventType',
      ]),
      variants: relayStylePagination(['featureId', 'name']),
      molecularProfiles: relayStylePagination([
        'featureId',
        'name',
        'evidenceStatusFilter',
      ]),
      comments: relayStylePagination(['originatingUserId', 'subject']),
      evidenceItems: relayStylePagination([
        'diseaseName',
        'therapayName',
        'id',
        'description',
        'evidenceLevel',
        'evidenceDirection',
        'significance',
        'evidenceType',
        'evidenceRating',
        'variantOrigin',
        'variantId',
        'molecularProfileId',
        'assertionId',
        'organizationId',
        'userId',
        'phenotypeId',
        'diseaseId',
        'therapayId',
        'sourceId',
        'geneSymbol',
        'variantName',
        'status',
        'clinicalTrialId',
      ]),
      assertions: relayStylePagination([
        'diseaseName',
        'therapayName',
        'id',
        'name',
        'summary',
        'assertionDirection',
        'significance',
        'assertionType',
        'variantId',
        'molecularProfileId',
        'ampLevel',
        'geneName',
        'variantName',
        'evidenceId',
        'organizationId',
        'userId',
        'phenotypeId',
        'diseaseId',
        'therapayId',
        'status',
      ]),
      organizations: relayStylePagination(['name', 'id']),
      flags: relayStylePagination([
        'flaggable',
        'flaggingUserId',
        'resolvingUserId',
        'state',
      ]),
      browsePhenotypes: relayStylePagination(['hpoId', 'name', 'sortBy']),
      variantTypes: relayStylePagination(['soid', 'name', 'id']),
      browseDiseases: relayStylePagination([
        'name',
        'doid',
        'diseaseAlias',
        'featureName',
        'sortBy',
      ]),
      therapies: relayStylePagination(['ncitId', 'name', 'id']),
      clinicalTrials: relayStylePagination(['nctId', 'name', 'id']),
      notifications: relayStylePagination([
        'notificationReason',
        'subscriptionId',
        'originatingObject',
        'eventType',
        'originatingUserId',
        'organizationId',
        'includeRead',
      ]),
      revisions: relayStylePagination([
        'subject',
        'status',
        'originatingUserId',
        'fieldName',
        'revisionsetId',
      ]),
      users: relayStylePagination(['userName', 'orgName', 'userRole']),
    },
  },
}
