import { CommonModule } from '@angular/common'
import { Component, Input, OnInit } from '@angular/core'
import { CvcTagListModule } from '@app/components/shared/tag-list/tag-list.module'

import { NzDescriptionsModule } from 'ng-zorro-antd/descriptions'
import { NzGridModule } from 'ng-zorro-antd/grid'
import { NzTagModule } from 'ng-zorro-antd/tag'
import { CvcVariantTypeTagModule } from '@app/components/variant-types/variant-type-tag/variant-type-tag.module'
import { CvcCoordinatesCardModule } from '../coordinates-card/coordinates-card.module'
import { CvcLinkTagModule } from '@app/components/shared/link-tag/link-tag.module'
import { NzCardModule } from 'ng-zorro-antd/card'
import { CvcEmptyRevisableModule } from '@app/components/shared/empty-revisable/empty-revisable.module'
import { CvcMolecularProfilesTableModule } from '@app/components/molecular-profiles/molecular-profile-table/molecular-profile-table.module'
import { CvcMyVariantInfoModule } from '../my-variant-info/my-variant-info.module'
import { VariantSummaryFieldsFragment } from '@app/generated/civic.apollo'
import { CvcUserTagModule } from '@app/components/users/user-tag/user-tag.module'
import { CvcFeatureTagModule } from '@app/components/features/feature-tag/feature-tag.module'
import { CvcPipesModule } from '@app/core/pipes/pipes.module'
import { CvcNcitDetailsComponent } from '@app/components/factors/ncit-details/ncit-details.component'
import { NzTypographyModule } from 'ng-zorro-antd/typography'

@Component({
  selector: 'cvc-factor-variant-summary',
  templateUrl: './factor-variant-summary.page.html',
  styleUrls: ['./factor-variant-summary.page.less'],
  imports: [
    CommonModule,
    NzGridModule,
    NzDescriptionsModule,
    NzTagModule,
    NzCardModule,
    NzTypographyModule,
    CvcEmptyRevisableModule,
    CvcTagListModule,
    CvcVariantTypeTagModule,
    CvcCoordinatesCardModule,
    CvcLinkTagModule,
    CvcUserTagModule,
    CvcFeatureTagModule,
    CvcMolecularProfilesTableModule,
    CvcMyVariantInfoModule,
    CvcPipesModule,
    CvcNcitDetailsComponent,
  ],
})
export class CvcFactorVariantSummaryComponent implements OnInit {
  @Input() variant!: VariantSummaryFieldsFragment

  ngOnInit() {
    if (this.variant == undefined) {
      throw new Error('Must pass FactorVariant into FactorVariant summary')
    }
  }
}
