#!/usr/bin/env node
const fs = require('fs')
const path = require('path')
const mustache = require('mustache')

// Load the generated icon data JSON
const jsonDataPath = path.join(
  __dirname,
  '..',
  'src',
  'app',
  'generated',
  'civic.icons.data.json'
)
const iconData = JSON.parse(fs.readFileSync(jsonDataPath, 'utf-8'))

// Define the mustache template
const template = `
.. |{{alias}}| image:: /images/icons/{{{filepath}}}
   :class: 'cvc-icon'
`

// Render the RST using mustache
const renderedRst =
  '..\n   ' +
  'GENERATED BY CiVIC CLIENT DEV SCRIPT, DO NOT EDIT\n   ' +
  '(unless you know what you are doing)\n   ' +
  'Produced by `generate-icon-rst` script in civic-v2/client/scripts\n' +
  iconData.icons.map((icon) => mustache.render(template, icon)).join('\n')

// Define the path to the output RST file
const outputPath = path.join(
  __dirname,
  '..',
  'src',
  'app',
  'generated',
  'civic.docs-aliases.rst'
)

// Write the rendered RST to the file
fs.writeFileSync(outputPath, renderedRst)

console.log(
  `RST written to ${outputPath}, copy to civic-docs/docs/generated to update docs aliases.`
)
