# CIViC: Clinical Interpretations of Variants in Cancer 

CIViC is an open access, open source, community-driven web resource for Clinical Interpretation of Variants in Cancer, available online at [civicdb.org](https://civicdb.org/). Our goal is to enable precision medicine by providing an educational forum for dissemination of knowledge and active discussion of the clinical significance of cancer genome alterations. For more details and to cite CIViC please refer to [the CIViC publication in Nature Genetics](http://www.nature.com/ng/journal/v49/n2/full/ng.3774.html).

## Description

The CIViC knowledgebase project seeks to advance cancer precision medicine with community collaboration. Precision medicine refers to the use of prevention and treatment strategies that are tailored to the unique features of each individual and their disease. In the context of cancer this might involve the identification of specific mutations shown to predict response to a targeted therapy. The biomedical literature describing these associations is large and growing rapidly. Currently these interpretations exist largely in private or encumbered databases resulting in extensive repetition of effort. Realizing precision medicine will require this information to be centralized, debated, and interpreted for application in the clinic.

All content created in CIViC is, and will continue to be, freely available, without restriction with a Public Domain License. Anyone can contribute to CIViC by simply registering for an account. Users join the community with “Curator” level privileges that allow them to comment or propose additions or revisions on any knowledge in CIViC. Proposed additions and revisions are then reviewed by users with “Editor” level privileges before gaining “Accepted” status. Submitted content, not yet accepted, should be interpreted/used with caution. Community Curators work together with Editors towards comprehensive and accurate interpretations of the clinical relevance of variants in cancer.

## Getting Started
CIViC is a Rails backend serving a GraphQL API to an Angular frontend. The same API that powers the frontend is available for anyone to use. The easiest way to get started is to experiment in the [GraphiQL user interface](https://civicdb.org/api/graphiql). You can also browse autogenerated documentation [here](https://griffithlab.github.io/civic-v2/).
### Dependencies
* Ruby >= 3.3 (recommended install via rbenv)
* PostgreSQL >= 14
* Node >= 22

### Installing

* In `server/` 
    *  `gem install bundler && rbenv rehash`
    *  `bundle install`
    *  `rails db:create`
    *  `rails db:schema:load`
    *  `rails s` to start the server. It will be running on `127.0.0.1:3000`.

* In `client/` 
    *  `npm install -g yarn`
    *  `yarn install`
    *  `yarn start` will start the dev server at `127.0.0.1:4200` and proxy API requests to the backend

### Development

The backend Rails application uses `rubocop` for linting and formatting, `brakeman` for vulnerability scanning.

In the server directory you can run `./bin/rubocop -a` to autocorrect any formatting issues before pushing. If you want it to run automatically you can set up the [pre-commit](https://pre-commit.com) framework, or use an editor integration such as [conform.nvim](https://github.com/stevearc/conform.nvim) or [vscode-rubocop](https://github.com/rubocop/vscode-rubocop). Alternatively, if you want something more lightweight, an example pre-commit script is provided at `server/.pre-commit-sample`. This can simply be copied into `.git/hooks/pre-commit`. 

If the CI fails with a `brakeman` vulnerability, you will need to fix it. If it is a false positive, or not actually an issue, you can mark it as such. From the `server` directory you can run `./bin/brakeman -I`. This will display each warning to you. If you select the `n` option you can provide a note explaining why it should be skipped. This will get added to the `config/brakeman.ignore` file. Commit and push it and the CI will pass.

For `git blame` purposes, you will likely want to ignore the commits where linting and formatting was initially applied. This can be done by running the command `git config blame.ignoreRevsFile .git-blame-ignore-revs` from the project root. This will exclude the commits where `rubocop` and `prettier` were initially applied from appearing in `blame` commands.

## Version History
[See Releases Page](https://github.com/griffithlab/civic-v2/releases)

## License

The content of CIViC, hosted by [The McDonnell Genome Institute at Washington University School of Medicine](http://genome.wustl.edu/) is released under the [Creative Commons Public Domain Dedication (CC0 1.0 Universal)](https://creativecommons.org/publicdomain/zero/1.0/) and the source code for the CIViC server and client is licensed under the [MIT License](http://opensource.org/licenses/MIT).

