/* eslint-disable */
import { gql } from 'apollo-angular';
import { Injectable } from '@angular/core';
import * as Apollo from 'apollo-angular';
export type Maybe<T> = T | undefined;
export type InputMaybe<T> = T | undefined;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
export type MakeEmpty<T extends { [key: string]: unknown }, K extends keyof T> = { [_ in K]?: never };
export type Incremental<T> = T | { [P in keyof T]?: P extends ' $fragmentName' | '__typename' ? T[P] : never };
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: { input: string; output: string; }
  String: { input: string; output: string; }
  Boolean: { input: boolean; output: boolean; }
  Int: { input: number; output: number; }
  Float: { input: number; output: number; }
  /** An ISO 8601-encoded datetime */
  ISO8601DateTime: { input: any; output: any; }
  /** Represents untyped JSON */
  JSON: { input: any; output: any; }
};

export type AcceptRevisionsActivity = ActivityInterface & {
  __typename: 'AcceptRevisionsActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  revisions: Array<Revision>;
  subject: EventSubject;
  supersededRevisions: Array<Revision>;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of AcceptRevisions */
export type AcceptRevisionsInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Body of an optional comment to attach to the revision on acceptance. */
  comment?: InputMaybe<Scalars['String']['input']>;
  /** A list of IDs of the Revisions to accept. */
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** The ID of a revision set. */
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of AcceptRevisions. */
export type AcceptRevisionsPayload = {
  __typename: 'AcceptRevisionsPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** A list of  newly accepted Revisions. */
  revisions: Array<Revision>;
  /** A list of any revisions that were superseded by the acceptance of this one. */
  supersededRevisions: Array<Revision>;
};

export type AcmgCode = {
  __typename: 'AcmgCode';
  code: Scalars['String']['output'];
  description: Scalars['String']['output'];
  id: Scalars['Int']['output'];
  name: Scalars['String']['output'];
  tooltip: Scalars['String']['output'];
};

/** An activity done by a curator or editor */
export type ActivityInterface = {
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** The connection type for ActivityInterface. */
export type ActivityInterfaceConnection = {
  __typename: 'ActivityInterfaceConnection';
  /** List of activity types that have occurred on this entity. */
  activityTypes: Array<ActivityTypeInput>;
  /** A list of edges. */
  edges: Array<ActivityInterfaceEdge>;
  /** A list of nodes. */
  nodes: Array<ActivityInterface>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** List of all organizations who are involved in this activity stream. */
  participatingOrganizations: Array<Organization>;
  subjectTypes: Array<ActivitySubjectInput>;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
  /**
   * When filtered on a subject, user, or organization, the total number of events
   * for that subject/user/organization, irregardless of other filters.
   */
  unfilteredCount: Scalars['Int']['output'];
  /** List of all users that have performed an activity on the subject entity. */
  uniqueParticipants: Array<User>;
};

/** An edge in a connection. */
export type ActivityInterfaceEdge = {
  __typename: 'ActivityInterfaceEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<ActivityInterface>;
};

export enum ActivitySubjectInput {
  Assertion = 'ASSERTION',
  Comment = 'COMMENT',
  EvidenceItem = 'EVIDENCE_ITEM',
  Feature = 'FEATURE',
  Flag = 'FLAG',
  MolecularProfile = 'MOLECULAR_PROFILE',
  Revision = 'REVISION',
  RevisionSet = 'REVISION_SET',
  Source = 'SOURCE',
  SourceSuggestion = 'SOURCE_SUGGESTION',
  Variant = 'VARIANT',
  VariantGroup = 'VARIANT_GROUP'
}

export enum ActivityTypeInput {
  AcceptRevisions = 'ACCEPT_REVISIONS',
  Comment = 'COMMENT',
  CreateComplexMolecularProfile = 'CREATE_COMPLEX_MOLECULAR_PROFILE',
  CreateFeature = 'CREATE_FEATURE',
  CreateVariant = 'CREATE_VARIANT',
  DeleteComment = 'DELETE_COMMENT',
  DeprecateComplexMolecularProfile = 'DEPRECATE_COMPLEX_MOLECULAR_PROFILE',
  DeprecateFeature = 'DEPRECATE_FEATURE',
  DeprecateVariant = 'DEPRECATE_VARIANT',
  EndorseAssertion = 'ENDORSE_ASSERTION',
  FlagEntity = 'FLAG_ENTITY',
  ModerateAssertion = 'MODERATE_ASSERTION',
  ModerateEvidenceItem = 'MODERATE_EVIDENCE_ITEM',
  RejectRevisions = 'REJECT_REVISIONS',
  ResolveFlag = 'RESOLVE_FLAG',
  RevokeEndorsement = 'REVOKE_ENDORSEMENT',
  SubmitAssertion = 'SUBMIT_ASSERTION',
  SubmitEvidenceItem = 'SUBMIT_EVIDENCE_ITEM',
  SuggestRevision = 'SUGGEST_REVISION',
  SuggestSource = 'SUGGEST_SOURCE',
  UpdateSourceSuggestion = 'UPDATE_SOURCE_SUGGESTION'
}

/** Autogenerated input type of AddComment */
export type AddCommentInput = {
  /** Text of the comment. */
  body: Scalars['String']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** The commentable to attach the comment to. Specified by ID and Type. */
  subject: CommentableInput;
  /** Optional title for the comment. */
  title?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of AddComment. */
export type AddCommentPayload = {
  __typename: 'AddCommentPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created comment. */
  comment?: Maybe<Comment>;
};

/** Autogenerated input type of AddDisease */
export type AddDiseaseInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The DOID of the disease, if the disease is present in the Disease Ontology. */
  doid?: InputMaybe<Scalars['String']['input']>;
  /** The name of the disease. */
  name: Scalars['String']['input'];
};

/** Autogenerated return type of AddDisease. */
export type AddDiseasePayload = {
  __typename: 'AddDiseasePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created disease. */
  disease: Disease;
  /** True if the disease was newly created. False if the returned disease was already in the database. */
  new: Scalars['Boolean']['output'];
};

/** Autogenerated input type of AddRemoteCitation */
export type AddRemoteCitationInput = {
  /** The external id for the source to add. */
  citationId: Scalars['String']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The origin of the external source. */
  sourceType: SourceSource;
};

/** Autogenerated return type of AddRemoteCitation. */
export type AddRemoteCitationPayload = {
  __typename: 'AddRemoteCitationPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The stubbed in record for the newly created source. */
  newSource: SourceStub;
};

/** Autogenerated input type of AddTherapy */
export type AddTherapyInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The name of the therapy. */
  name: Scalars['String']['input'];
  /** The NCIt ID of the therapy, if the therapy is present in the NCIthesaurus. */
  ncitId?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of AddTherapy. */
export type AddTherapyPayload = {
  __typename: 'AddTherapyPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** True if the therapy was newly created. False if the returned therapy was already in the database. */
  new: Scalars['Boolean']['output'];
  /** The newly created therapy. */
  therapy: Therapy;
};

export type AdvancedSearchResult = {
  __typename: 'AdvancedSearchResult';
  permalinkId?: Maybe<Scalars['String']['output']>;
  resultIds: Array<Scalars['Int']['output']>;
  searchEndpoint: Scalars['String']['output'];
};

export enum AmpLevel {
  Na = 'NA',
  TierIii = 'TIER_III',
  TierIiLevelC = 'TIER_II_LEVEL_C',
  TierIiLevelD = 'TIER_II_LEVEL_D',
  TierIv = 'TIER_IV',
  TierILevelA = 'TIER_I_LEVEL_A',
  TierILevelB = 'TIER_I_LEVEL_B'
}

export type AmpLevelTypeSearchInput = {
  operator: EnumSearchOperator;
  value: AmpLevel;
};

export type ApiKey = {
  __typename: 'ApiKey';
  createdAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  id: Scalars['Int']['output'];
  reminder: Scalars['String']['output'];
  token?: Maybe<Scalars['String']['output']>;
};

export enum AreaOfExpertise {
  ClinicalScientist = 'CLINICAL_SCIENTIST',
  PatientAdvocate = 'PATIENT_ADVOCATE',
  ResearchScientist = 'RESEARCH_SCIENTIST'
}

export type Assertion = Commentable & EventOriginObject & EventSubject & Flaggable & WithRevisions & {
  __typename: 'Assertion';
  acceptanceEvent?: Maybe<Event>;
  acmgCodes: Array<AcmgCode>;
  ampLevel?: Maybe<AmpLevel>;
  assertionDirection: AssertionDirection;
  assertionType: AssertionType;
  clingenCodes: Array<ClingenCode>;
  /** List and filter comments. */
  comments: CommentConnection;
  description: Scalars['String']['output'];
  disease?: Maybe<Disease>;
  /** List and filter endorsements. */
  endorsements: EndorsementConnection;
  /** List and filter events for an object */
  events: EventConnection;
  evidenceItems: Array<EvidenceItem>;
  evidenceItemsCount: Scalars['Int']['output'];
  fdaCompanionTest?: Maybe<Scalars['Boolean']['output']>;
  fdaCompanionTestLastUpdated?: Maybe<Scalars['ISO8601DateTime']['output']>;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  molecularProfile: MolecularProfile;
  name: Scalars['String']['output'];
  nccnGuideline?: Maybe<NccnGuideline>;
  nccnGuidelineVersion?: Maybe<Scalars['String']['output']>;
  openRevisionCount: Scalars['Int']['output'];
  phenotypes: Array<Phenotype>;
  regulatoryApproval?: Maybe<Scalars['Boolean']['output']>;
  regulatoryApprovalLastUpdated?: Maybe<Scalars['ISO8601DateTime']['output']>;
  rejectionEvent?: Maybe<Event>;
  /** List and filter revisions. */
  revisions: RevisionConnection;
  significance: AssertionSignificance;
  status: EvidenceStatus;
  submissionActivity: SubmitAssertionActivity;
  submissionEvent: Event;
  summary: Scalars['String']['output'];
  therapies: Array<Therapy>;
  therapyInteractionType?: Maybe<TherapyInteraction>;
  variantOrigin: VariantOrigin;
};


export type AssertionCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type AssertionEndorsementsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  endorsingOrganizationId?: InputMaybe<Scalars['Int']['input']>;
  endorsingOrganizationIsApprovedVcep?: InputMaybe<Scalars['Boolean']['input']>;
  endorsingUserId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<EndorsementStatus>;
};


export type AssertionEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type AssertionFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


export type AssertionRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

/** The connection type for Assertion. */
export type AssertionConnection = {
  __typename: 'AssertionConnection';
  /** A list of edges. */
  edges: Array<AssertionEdge>;
  /** A list of nodes. */
  nodes: Array<Assertion>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

export enum AssertionDirection {
  DoesNotSupport = 'DOES_NOT_SUPPORT',
  Supports = 'SUPPORTS'
}

export type AssertionDirectionTypeSearchInput = {
  operator: EnumSearchOperator;
  value: AssertionDirection;
};

/** An edge in a connection. */
export type AssertionEdge = {
  __typename: 'AssertionEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Assertion>;
};

/** Fields on an Assertion that curators may propose revisions to. */
export type AssertionFields = {
  /** List of CIViC IDs for the ACMG/AMP codes associated with this Assertion */
  acmgCodeIds: Array<Scalars['Int']['input']>;
  /** The AMP/ASCO/CAP Category for this assertion. */
  ampLevel: NullableAmpLevelTypeInput;
  /** The evidence direction for this Assertion. */
  assertionDirection: AssertionDirection;
  /** The Type of the Assertion */
  assertionType: AssertionType;
  /** List of CIViC IDs for the ClinGen/CGC/VICC codes associated with this Assertion */
  clingenCodeIds: Array<Scalars['Int']['input']>;
  /** A detailed description of the Assertion including practice guidelines and approved tests. */
  description: NullableStringInput;
  /** The ID of the disease (if applicable) for this Assertion */
  diseaseId: NullableIntInput;
  /** IDs of evidence items that are included in this Assertion. */
  evidenceItemIds: Array<Scalars['Int']['input']>;
  /** Is an FDA companion test available that pertains to this Assertion. */
  fdaCompanionTest: NullableBooleanInput;
  /** Does the Assertion have FDA regulatory approval. */
  fdaRegulatoryApproval: NullableBooleanInput;
  /** The ID of the Molecular Profile to which this Assertion belongs */
  molecularProfileId: Scalars['Int']['input'];
  /** The internal CIViC ID of the NCCN guideline associated with this Assertion */
  nccnGuidelineId: NullableIntInput;
  /** The version of the NCCN Guideline specified */
  nccnGuidelineVersion: NullableStringInput;
  /** List of IDs of CIViC Phenotype entries for this Assertion. An empty list indicates none. */
  phenotypeIds: Array<Scalars['Int']['input']>;
  /** The Clinical Significance of the Assertion */
  significance: AssertionSignificance;
  /** A brief single sentence statement summarizing the clinical significance of this Assertion. */
  summary: NullableStringInput;
  /** List of IDs of CIViC Therapy entries for this Assertion. An empty list indicates none. */
  therapyIds: Array<Scalars['Int']['input']>;
  /** Therapy interaction type for cases where more than one therapy ID is provided. */
  therapyInteractionType: NullableTherapyInteractionTypeInput;
  /** The Variant Origin for this Assertion. */
  variantOrigin: VariantOrigin;
};

export type AssertionSearchFilter = {
  ampLevel?: InputMaybe<AmpLevelTypeSearchInput>;
  assertionDirection?: InputMaybe<AssertionDirectionTypeSearchInput>;
  assertionType?: InputMaybe<AssertionTypeTypeSearchInput>;
  booleanOperator?: InputMaybe<BooleanOperator>;
  description?: InputMaybe<StringSearchInput>;
  disease?: InputMaybe<DiseaseSearchFilter>;
  evidenceItemCount?: InputMaybe<IntSearchInput>;
  evidenceItems?: InputMaybe<EvidenceItemSearchFilter>;
  fdaCompanionTest?: InputMaybe<BooleanSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  isFlagged?: InputMaybe<BooleanSearchInput>;
  molecularProfile?: InputMaybe<MolecularProfileSearchFilter>;
  name?: InputMaybe<StringSearchInput>;
  phenotypes?: InputMaybe<PhenotypeSearchFilter>;
  regulatoryApproval?: InputMaybe<BooleanSearchInput>;
  significance?: InputMaybe<AssertionSignificanceTypeSearchInput>;
  status?: InputMaybe<EvidenceStatusTypeSearchInput>;
  subFilters?: InputMaybe<Array<AssertionSearchFilter>>;
  therapies?: InputMaybe<TherapySearchFilter>;
  variantOrigin?: InputMaybe<VariantOriginTypeSearchInput>;
};

export enum AssertionSignificance {
  AdverseResponse = 'ADVERSE_RESPONSE',
  Benign = 'BENIGN',
  BetterOutcome = 'BETTER_OUTCOME',
  LikelyBenign = 'LIKELY_BENIGN',
  LikelyOncogenic = 'LIKELY_ONCOGENIC',
  LikelyPathogenic = 'LIKELY_PATHOGENIC',
  Na = 'NA',
  Negative = 'NEGATIVE',
  Oncogenic = 'ONCOGENIC',
  Pathogenic = 'PATHOGENIC',
  PoorOutcome = 'POOR_OUTCOME',
  Positive = 'POSITIVE',
  ReducedSensitivity = 'REDUCED_SENSITIVITY',
  Resistance = 'RESISTANCE',
  Sensitivityresponse = 'SENSITIVITYRESPONSE',
  UncertainSignificance = 'UNCERTAIN_SIGNIFICANCE'
}

export type AssertionSignificanceTypeSearchInput = {
  operator: EnumSearchOperator;
  value: AssertionSignificance;
};

export type AssertionSort = {
  /** Available columns for sorting */
  column: AssertionSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum AssertionSortColumns {
  AmpLevel = 'AMP_LEVEL',
  AssertionDirection = 'ASSERTION_DIRECTION',
  AssertionType = 'ASSERTION_TYPE',
  DiseaseName = 'DISEASE_NAME',
  EvidenceItemsCount = 'EVIDENCE_ITEMS_COUNT',
  Id = 'ID',
  Significance = 'SIGNIFICANCE',
  Status = 'STATUS',
  Summary = 'SUMMARY'
}

export enum AssertionType {
  Diagnostic = 'DIAGNOSTIC',
  Oncogenic = 'ONCOGENIC',
  Predictive = 'PREDICTIVE',
  Predisposing = 'PREDISPOSING',
  Prognostic = 'PROGNOSTIC'
}

export type AssertionTypeTypeSearchInput = {
  operator: EnumSearchOperator;
  value: AssertionType;
};

export enum AssociatedEvidenceStatusFilter {
  /** Apply no status filter to an entity in order to display all entities regardless of attached evidence status. */
  All = 'ALL',
  /** Apply filter to an entity to display only those which have at least one accepted associated evidence item. */
  WithAccepted = 'WITH_ACCEPTED',
  /** Apply filter to an entity to display only those which have at least one accepted or submitted associated evidence item. */
  WithAcceptedOrSubmitted = 'WITH_ACCEPTED_OR_SUBMITTED',
  /** Apply filter to an entity to display only those which have at least one submitted associated evidence item. */
  WithSubmitted = 'WITH_SUBMITTED'
}

export enum BooleanOperator {
  And = 'AND',
  Or = 'OR'
}

export type BooleanSearchInput = {
  value: Scalars['Boolean']['input'];
};

export type BrowseClinicalTrial = {
  __typename: 'BrowseClinicalTrial';
  evidenceCount: Scalars['Int']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  nctId?: Maybe<Scalars['String']['output']>;
  sourceCount: Scalars['Int']['output'];
  url?: Maybe<Scalars['String']['output']>;
};

/** The connection type for BrowseClinicalTrial. */
export type BrowseClinicalTrialConnection = {
  __typename: 'BrowseClinicalTrialConnection';
  /** A list of edges. */
  edges: Array<BrowseClinicalTrialEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseClinicalTrial>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseClinicalTrialEdge = {
  __typename: 'BrowseClinicalTrialEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseClinicalTrial>;
};

export type BrowseDisease = {
  __typename: 'BrowseDisease';
  assertionCount: Scalars['Int']['output'];
  deprecated: Scalars['Boolean']['output'];
  diseaseAliases?: Maybe<Array<Scalars['String']['output']>>;
  diseaseUrl?: Maybe<Scalars['String']['output']>;
  displayName: Scalars['String']['output'];
  doid?: Maybe<Scalars['String']['output']>;
  evidenceItemCount: Scalars['Int']['output'];
  featureCount: Scalars['Int']['output'];
  features: Array<LinkableFeature>;
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  variantCount: Scalars['Int']['output'];
};

/** The connection type for BrowseDisease. */
export type BrowseDiseaseConnection = {
  __typename: 'BrowseDiseaseConnection';
  /** A list of edges. */
  edges: Array<BrowseDiseaseEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseDisease>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseDiseaseEdge = {
  __typename: 'BrowseDiseaseEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseDisease>;
};

export type BrowseFeature = Flaggable & {
  __typename: 'BrowseFeature';
  assertionCount: Scalars['Int']['output'];
  deprecated: Scalars['Boolean']['output'];
  description: Scalars['String']['output'];
  diseases?: Maybe<Array<Disease>>;
  evidenceItemCount: Scalars['Int']['output'];
  featureAliases?: Maybe<Array<Scalars['String']['output']>>;
  featureInstanceId: Scalars['Int']['output'];
  featureInstanceType: FeatureInstanceTypes;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  fullName?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  molecularProfileCount: Scalars['Int']['output'];
  name: Scalars['String']['output'];
  therapies?: Maybe<Array<Therapy>>;
  variantCount: Scalars['Int']['output'];
};


export type BrowseFeatureFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};

/** The connection type for BrowseFeature. */
export type BrowseFeatureConnection = {
  __typename: 'BrowseFeatureConnection';
  /** A list of edges. */
  edges: Array<BrowseFeatureEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseFeature>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseFeatureEdge = {
  __typename: 'BrowseFeatureEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseFeature>;
};

export type BrowseMolecularProfile = {
  __typename: 'BrowseMolecularProfile';
  aliases: Array<MolecularProfileAlias>;
  assertionCount: Scalars['Int']['output'];
  deprecated: Scalars['Boolean']['output'];
  diseases: Array<LinkableDisease>;
  evidenceItemCount: Scalars['Int']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  molecularProfileScore: Scalars['Float']['output'];
  name: Scalars['String']['output'];
  therapies: Array<LinkableTherapy>;
  variantCount: Scalars['Int']['output'];
  variants: Array<LinkableVariant>;
};

/** The connection type for BrowseMolecularProfile. */
export type BrowseMolecularProfileConnection = {
  __typename: 'BrowseMolecularProfileConnection';
  /** A list of edges. */
  edges: Array<BrowseMolecularProfileEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseMolecularProfile>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseMolecularProfileEdge = {
  __typename: 'BrowseMolecularProfileEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseMolecularProfile>;
};

export type BrowseOrganization = {
  __typename: 'BrowseOrganization';
  activityCount: Scalars['Int']['output'];
  childOrganizations: Array<Organization>;
  createdAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  description: Scalars['String']['output'];
  id: Scalars['Int']['output'];
  memberCount: Scalars['Int']['output'];
  mostRecentActivityTimestamp?: Maybe<Scalars['ISO8601DateTime']['output']>;
  name: Scalars['String']['output'];
  parentId?: Maybe<Scalars['Int']['output']>;
  updatedAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  url: Scalars['String']['output'];
};

/** The connection type for BrowseOrganization. */
export type BrowseOrganizationConnection = {
  __typename: 'BrowseOrganizationConnection';
  /** A list of edges. */
  edges: Array<BrowseOrganizationEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseOrganization>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseOrganizationEdge = {
  __typename: 'BrowseOrganizationEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseOrganization>;
};

export type BrowsePhenotype = {
  __typename: 'BrowsePhenotype';
  assertionCount: Scalars['Int']['output'];
  evidenceCount: Scalars['Int']['output'];
  hpoId: Scalars['String']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  url: Scalars['String']['output'];
};

/** The connection type for BrowsePhenotype. */
export type BrowsePhenotypeConnection = {
  __typename: 'BrowsePhenotypeConnection';
  /** A list of edges. */
  edges: Array<BrowsePhenotypeEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowsePhenotype>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowsePhenotypeEdge = {
  __typename: 'BrowsePhenotypeEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowsePhenotype>;
};

export type BrowseSource = {
  __typename: 'BrowseSource';
  authors: Array<Scalars['String']['output']>;
  citation: Scalars['String']['output'];
  citationId: Scalars['Int']['output'];
  clinicalTrials: Array<ClinicalTrial>;
  deprecated: Scalars['Boolean']['output'];
  displayType: Scalars['String']['output'];
  evidenceItemCount: Scalars['Int']['output'];
  id: Scalars['Int']['output'];
  journal?: Maybe<Scalars['String']['output']>;
  link: Scalars['String']['output'];
  name?: Maybe<Scalars['String']['output']>;
  openAccess: Scalars['Boolean']['output'];
  publicationYear?: Maybe<Scalars['Int']['output']>;
  retractionNature?: Maybe<Scalars['String']['output']>;
  sourceSuggestionCount: Scalars['Int']['output'];
  sourceType: SourceSource;
  sourceUrl: Scalars['String']['output'];
};

/** The connection type for BrowseSource. */
export type BrowseSourceConnection = {
  __typename: 'BrowseSourceConnection';
  /** A list of edges. */
  edges: Array<BrowseSourceEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseSource>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseSourceEdge = {
  __typename: 'BrowseSourceEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseSource>;
};

export type BrowseTherapy = {
  __typename: 'BrowseTherapy';
  assertionCount: Scalars['Int']['output'];
  deprecated: Scalars['Boolean']['output'];
  evidenceCount: Scalars['Int']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  ncitId?: Maybe<Scalars['String']['output']>;
  therapyAliases?: Maybe<Array<Scalars['String']['output']>>;
  therapyUrl?: Maybe<Scalars['String']['output']>;
};

/** The connection type for BrowseTherapy. */
export type BrowseTherapyConnection = {
  __typename: 'BrowseTherapyConnection';
  /** A list of edges. */
  edges: Array<BrowseTherapyEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseTherapy>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseTherapyEdge = {
  __typename: 'BrowseTherapyEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseTherapy>;
};

export type BrowseUser = {
  __typename: 'BrowseUser';
  apiKeys: Array<ApiKey>;
  areaOfExpertise?: Maybe<AreaOfExpertise>;
  bio?: Maybe<Scalars['String']['output']>;
  country?: Maybe<Country>;
  displayName: Scalars['String']['output'];
  email?: Maybe<Scalars['String']['output']>;
  events: EventConnection;
  evidenceCount: Scalars['Int']['output'];
  facebookProfile?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  joinDate?: Maybe<Scalars['ISO8601DateTime']['output']>;
  linkedinProfile?: Maybe<Scalars['String']['output']>;
  mostRecentActivityTimestamp?: Maybe<Scalars['ISO8601DateTime']['output']>;
  mostRecentConflictOfInterestStatement?: Maybe<Coi>;
  mostRecentEvent?: Maybe<Event>;
  mostRecentOrganizationId?: Maybe<Scalars['Int']['output']>;
  name?: Maybe<Scalars['String']['output']>;
  /** Filterable list of notifications for the logged in user. */
  notifications?: Maybe<NotificationConnection>;
  orcid?: Maybe<Scalars['String']['output']>;
  organizations: Array<Organization>;
  organizationsWithEndorsementPrivileges: Array<Organization>;
  profileImagePath?: Maybe<Scalars['String']['output']>;
  ranks: Ranks;
  revisionCount: Scalars['Int']['output'];
  role: UserRole;
  statsHash: Stats;
  twitterHandle?: Maybe<Scalars['String']['output']>;
  url?: Maybe<Scalars['String']['output']>;
  username: Scalars['String']['output'];
};


export type BrowseUserEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type BrowseUserNotificationsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeSeen?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  notificationType?: InputMaybe<NotificationReason>;
  subscriptionId?: InputMaybe<Scalars['Int']['input']>;
};


export type BrowseUserProfileImagePathArgs = {
  size?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for BrowseUser. */
export type BrowseUserConnection = {
  __typename: 'BrowseUserConnection';
  /** A list of edges. */
  edges: Array<BrowseUserEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseUser>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseUserEdge = {
  __typename: 'BrowseUserEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseUser>;
};

export type BrowseVariant = {
  __typename: 'BrowseVariant';
  aliases: Array<VariantAlias>;
  category: VariantCategories;
  deprecated: Scalars['Boolean']['output'];
  diseases: Array<Disease>;
  evidenceItemCount: Scalars['Int']['output'];
  featureDeprecated: Scalars['Boolean']['output'];
  featureFlagged: Scalars['Boolean']['output'];
  featureId: Scalars['Int']['output'];
  featureLink: Scalars['String']['output'];
  featureName: Scalars['String']['output'];
  flagged: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  therapies: Array<Therapy>;
  variantTypes: Array<LinkableVariantType>;
};

/** The connection type for BrowseVariant. */
export type BrowseVariantConnection = {
  __typename: 'BrowseVariantConnection';
  /** A list of edges. */
  edges: Array<BrowseVariantEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseVariant>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseVariantEdge = {
  __typename: 'BrowseVariantEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseVariant>;
};

export type BrowseVariantGroup = {
  __typename: 'BrowseVariantGroup';
  evidenceItemCount: Scalars['Int']['output'];
  featureNames: Array<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  variantCount: Scalars['Int']['output'];
  variantNames: Array<Scalars['String']['output']>;
};

/** The connection type for BrowseVariantGroup. */
export type BrowseVariantGroupConnection = {
  __typename: 'BrowseVariantGroupConnection';
  /** A list of edges. */
  edges: Array<BrowseVariantGroupEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseVariantGroup>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseVariantGroupEdge = {
  __typename: 'BrowseVariantGroupEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseVariantGroup>;
};

export type BrowseVariantType = {
  __typename: 'BrowseVariantType';
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  soid: Scalars['String']['output'];
  url?: Maybe<Scalars['String']['output']>;
  variantCount: Scalars['Int']['output'];
};

/** The connection type for BrowseVariantType. */
export type BrowseVariantTypeConnection = {
  __typename: 'BrowseVariantTypeConnection';
  /** A list of edges. */
  edges: Array<BrowseVariantTypeEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<BrowseVariantType>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type BrowseVariantTypeEdge = {
  __typename: 'BrowseVariantTypeEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<BrowseVariantType>;
};

export enum Chromosome {
  Chr_1 = 'CHR_1',
  Chr_2 = 'CHR_2',
  Chr_3 = 'CHR_3',
  Chr_4 = 'CHR_4',
  Chr_5 = 'CHR_5',
  Chr_6 = 'CHR_6',
  Chr_7 = 'CHR_7',
  Chr_8 = 'CHR_8',
  Chr_9 = 'CHR_9',
  Chr_10 = 'CHR_10',
  Chr_11 = 'CHR_11',
  Chr_12 = 'CHR_12',
  Chr_13 = 'CHR_13',
  Chr_14 = 'CHR_14',
  Chr_15 = 'CHR_15',
  Chr_16 = 'CHR_16',
  Chr_17 = 'CHR_17',
  Chr_18 = 'CHR_18',
  Chr_19 = 'CHR_19',
  Chr_20 = 'CHR_20',
  Chr_21 = 'CHR_21',
  Chr_22 = 'CHR_22',
  ChrX = 'CHR_X',
  ChrY = 'CHR_Y'
}

export type ChromosomeTypeSearchInput = {
  operator: EnumSearchOperator;
  value: Chromosome;
};

/** Counts of CIViC activity over time, used for the homepage */
export type CivicTimepointStats = {
  __typename: 'CivicTimepointStats';
  assertions: TimePointCounts;
  comments: TimePointCounts;
  diseases: TimePointCounts;
  evidenceItems: TimePointCounts;
  features: TimePointCounts;
  molecularProfiles: TimePointCounts;
  revisions: TimePointCounts;
  sources: TimePointCounts;
  therapies: TimePointCounts;
  users: TimePointCounts;
  variants: TimePointCounts;
};

export type ClingenCode = {
  __typename: 'ClingenCode';
  code: Scalars['String']['output'];
  description: Scalars['String']['output'];
  exclusive: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  name: Scalars['String']['output'];
  tooltip: Scalars['String']['output'];
};

export type ClinicalTrial = {
  __typename: 'ClinicalTrial';
  description: Scalars['String']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  nctId: Scalars['String']['output'];
  url?: Maybe<Scalars['String']['output']>;
};

export type ClinicalTrialSort = {
  /** Available columns for sorting */
  column: ClinicalTrialSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum ClinicalTrialSortColumns {
  EvidenceItemCount = 'EVIDENCE_ITEM_COUNT',
  Name = 'NAME',
  NctId = 'NCT_ID',
  SourceCount = 'SOURCE_COUNT'
}

/**
 * An input object representing possible ClinVar ID states.
 * You may specify either one or more Integer IDs OR either none found or not applicable.
 */
export type ClinvarInput = {
  /** The ClinVar ID(s) */
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  noneFound?: InputMaybe<Scalars['Boolean']['input']>;
  notApplicable?: InputMaybe<Scalars['Boolean']['input']>;
};

export type Coi = {
  __typename: 'Coi';
  coiPresent: Scalars['Boolean']['output'];
  coiStatement?: Maybe<Scalars['String']['output']>;
  coiStatus: CoiStatus;
  createdAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  expiresAt: Scalars['ISO8601DateTime']['output'];
  id: Scalars['Int']['output'];
};

export enum CoiStatus {
  Conflict = 'CONFLICT',
  Expired = 'EXPIRED',
  Missing = 'MISSING',
  Valid = 'VALID'
}

export type Comment = EventOriginObject & EventSubject & {
  __typename: 'Comment';
  comment: Scalars['String']['output'];
  commentable: Commentable;
  commenter: User;
  createdAt: Scalars['ISO8601DateTime']['output'];
  creationEvent?: Maybe<Event>;
  deleted: Scalars['Boolean']['output'];
  deletedAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  /** List and filter events for an object */
  events: EventConnection;
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  parsedComment: Array<CommentBodySegment>;
  title?: Maybe<Scalars['String']['output']>;
};


export type CommentEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};

export type CommentActivity = ActivityInterface & {
  __typename: 'CommentActivity';
  comment: Comment;
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Segment of a comment that can either be text or an object to be rendered as a tag */
export type CommentBodySegment = CommentTagSegment | CommentTagSegmentFlagged | CommentTagSegmentFlaggedAndDeprecated | CommentTagSegmentFlaggedAndWithStatus | CommentTextSegment | User;

/** The connection type for Comment. */
export type CommentConnection = {
  __typename: 'CommentConnection';
  /** A list of edges. */
  edges: Array<CommentEdge>;
  /** List of entities mentioned in this comment thread. */
  mentionedEntities: Array<CommentTagSegment>;
  /** List of roles mentioned in this comment thread */
  mentionedRoles: Array<CommentTagSegment>;
  /** List of users mentioned in this comment thread. */
  mentionedUsers: Array<User>;
  /** A list of nodes. */
  nodes: Array<Comment>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
  /**
   * When filtered on a subject, the total number of comments for that subject,
   * irregardless of other filters. Returns null when there is no subject.
   */
  unfilteredCountForSubject?: Maybe<Scalars['Int']['output']>;
  /** List of all users that have commented on this entity. */
  uniqueCommenters: Array<User>;
};

/** An edge in a connection. */
export type CommentEdge = {
  __typename: 'CommentEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Comment>;
};

export type CommentSearchFilter = {
  booleanOperator?: InputMaybe<BooleanOperator>;
  comment?: InputMaybe<StringSearchInput>;
  createdAt?: InputMaybe<DateSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  subFilters?: InputMaybe<Array<CommentSearchFilter>>;
};

export type CommentTagSegment = {
  __typename: 'CommentTagSegment';
  displayName: Scalars['String']['output'];
  entityId: Scalars['Int']['output'];
  feature?: Maybe<LinkableFeature>;
  link: Scalars['String']['output'];
  revisionSetId?: Maybe<Scalars['Int']['output']>;
  tagType: TaggableEntity;
};

export type CommentTagSegmentFlagged = {
  __typename: 'CommentTagSegmentFlagged';
  displayName: Scalars['String']['output'];
  entityId: Scalars['Int']['output'];
  feature?: Maybe<LinkableFeature>;
  flagged: Scalars['Boolean']['output'];
  link: Scalars['String']['output'];
  revisionSetId?: Maybe<Scalars['Int']['output']>;
  tagType: TaggableEntity;
};

export type CommentTagSegmentFlaggedAndDeprecated = {
  __typename: 'CommentTagSegmentFlaggedAndDeprecated';
  deprecated: Scalars['Boolean']['output'];
  displayName: Scalars['String']['output'];
  entityId: Scalars['Int']['output'];
  feature?: Maybe<LinkableFeature>;
  flagged: Scalars['Boolean']['output'];
  link: Scalars['String']['output'];
  revisionSetId?: Maybe<Scalars['Int']['output']>;
  tagType: TaggableEntity;
};

export type CommentTagSegmentFlaggedAndWithStatus = {
  __typename: 'CommentTagSegmentFlaggedAndWithStatus';
  displayName: Scalars['String']['output'];
  entityId: Scalars['Int']['output'];
  feature?: Maybe<LinkableFeature>;
  flagged: Scalars['Boolean']['output'];
  link: Scalars['String']['output'];
  revisionSetId?: Maybe<Scalars['Int']['output']>;
  status: EvidenceStatus;
  tagType: TaggableEntity;
};

export type CommentTextSegment = {
  __typename: 'CommentTextSegment';
  text: Scalars['String']['output'];
};

/** A CIViC entity that can have comments on it. */
export type Commentable = {
  /** List and filter comments. */
  comments: CommentConnection;
  id: Scalars['Int']['output'];
  lastCommentEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
};


/** A CIViC entity that can have comments on it. */
export type CommentableCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};

export enum CommentableEntities {
  Assertion = 'ASSERTION',
  EvidenceItem = 'EVIDENCE_ITEM',
  Feature = 'FEATURE',
  MolecularProfile = 'MOLECULAR_PROFILE',
  Source = 'SOURCE',
  Variant = 'VARIANT',
  VariantGroup = 'VARIANT_GROUP'
}

/** Entity to comment on */
export type CommentableInput = {
  /** The type of the entity to comment on. */
  entityType: CommentableEntities;
  /** ID of the entity to comment on. */
  id: Scalars['Int']['input'];
};

/** A user with all the unique kinds of actions they've performed on a given entity */
export type ContributingUser = {
  __typename: 'ContributingUser';
  lastActionDate: Scalars['ISO8601DateTime']['output'];
  totalActionCount: Scalars['Int']['output'];
  uniqueActions: Array<Contribution>;
  user: User;
};

export type ContributingUsersSummary = {
  __typename: 'ContributingUsersSummary';
  curators: Array<ContributingUser>;
  editors: Array<ContributingUser>;
};

export type Contribution = {
  __typename: 'Contribution';
  action: EventAction;
  count: Scalars['Int']['output'];
};

export type CoordinateSearchInput = {
  chromosome?: InputMaybe<ChromosomeTypeSearchInput>;
  referenceBases?: InputMaybe<DnaBaseStringInput>;
  start?: InputMaybe<IntSearchInput>;
  stop?: InputMaybe<IntSearchInput>;
  variantBases?: InputMaybe<DnaBaseStringInput>;
};

export type Country = {
  __typename: 'Country';
  id: Scalars['Int']['output'];
  iso: Scalars['String']['output'];
  name: Scalars['String']['output'];
};

export type CreateComplexMolecularProfileActivity = ActivityInterface & {
  __typename: 'CreateComplexMolecularProfileActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

export type CreateFeatureActivity = ActivityInterface & {
  __typename: 'CreateFeatureActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of CreateFeature */
export type CreateFeatureInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The Type of Feature you are creating */
  featureType: CreateableFeatureTypes;
  /** The name of the feature to create. */
  name: Scalars['String']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of CreateFeature. */
export type CreateFeaturePayload = {
  __typename: 'CreateFeaturePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created Feature. */
  feature: Feature;
  /** True if the feature was newly created. False if the returned feature was already in the database. */
  new: Scalars['Boolean']['output'];
};

/** Autogenerated input type of CreateFusionFeature */
export type CreateFusionFeatureInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The 5" fusion partner */
  fivePrimeGene: FusionPartnerInput;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** The 3" fusion partner */
  threePrimeGene: FusionPartnerInput;
};

/** Autogenerated return type of CreateFusionFeature. */
export type CreateFusionFeaturePayload = {
  __typename: 'CreateFusionFeaturePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created Feature. */
  feature: Feature;
  /** True if the feature was newly created. False if the returned feature was already in the database. */
  new: Scalars['Boolean']['output'];
};

/** Autogenerated input type of CreateFusionVariant */
export type CreateFusionVariantInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  coordinates: FusionVariantInput;
  /** The CIViC ID of the Feature to which the new variant belongs. */
  featureId: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of CreateFusionVariant. */
export type CreateFusionVariantPayload = {
  __typename: 'CreateFusionVariantPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created molecular profile for the new variant. */
  molecularProfile: MolecularProfile;
  /** True if the variant was newly created. False if the returned variant was already in the database. */
  new: Scalars['Boolean']['output'];
  /** The newly created Variant. */
  variant: VariantInterface;
};

/** Autogenerated input type of CreateMolecularProfile */
export type CreateMolecularProfileInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** Representation of the constituent parts of the Molecular Profile along with the logic used to combine them. */
  structure: MolecularProfileComponentInput;
};

/** Autogenerated return type of CreateMolecularProfile. */
export type CreateMolecularProfilePayload = {
  __typename: 'CreateMolecularProfilePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created (or already existing) Molecular Profile. */
  molecularProfile: MolecularProfile;
};

export type CreateVariantActivity = ActivityInterface & {
  __typename: 'CreateVariantActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  molecularProfile: MolecularProfile;
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of CreateVariant */
export type CreateVariantInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The CIViC ID of the Feature to which the new variant belongs. */
  featureId: Scalars['Int']['input'];
  /** The name of the variant to create. */
  name: Scalars['String']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of CreateVariant. */
export type CreateVariantPayload = {
  __typename: 'CreateVariantPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created molecular profile for the new variant. */
  molecularProfile: MolecularProfile;
  /** True if the variant was newly created. False if the returned variant was already in the database. */
  new: Scalars['Boolean']['output'];
  /** The newly created Variant. */
  variant: Variant;
};

/** Enum representing Feature types that can be user-created */
export enum CreateableFeatureTypes {
  Factor = 'FACTOR'
}

export type DataRelease = {
  __typename: 'DataRelease';
  acceptedAndSubmittedVariantsVcf?: Maybe<DownloadableFile>;
  acceptedVariantsVcf?: Maybe<DownloadableFile>;
  assertionTsv?: Maybe<DownloadableFile>;
  evidenceTsv?: Maybe<DownloadableFile>;
  featureTsv?: Maybe<DownloadableFile>;
  molecularProfileTsv?: Maybe<DownloadableFile>;
  name: Scalars['String']['output'];
  variantGroupTsv?: Maybe<DownloadableFile>;
  variantTsv?: Maybe<DownloadableFile>;
};

export type DateSearchInput = {
  date: Scalars['ISO8601DateTime']['input'];
  operator: DateSearchOperator;
};

export enum DateSearchOperator {
  After = 'AFTER',
  Before = 'BEFORE',
  OnOrAfter = 'ON_OR_AFTER',
  OnOrBefore = 'ON_OR_BEFORE'
}

export type DateSort = {
  /** Value to sort by. */
  column: DateSortColumns;
  /** Sort direction. */
  direction: SortDirection;
};

export enum DateSortColumns {
  Created = 'CREATED',
  LastModified = 'LAST_MODIFIED'
}

export type DeleteCommentActivity = ActivityInterface & {
  __typename: 'DeleteCommentActivity';
  comment: Comment;
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of DeleteComment */
export type DeleteCommentInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID of the comment to delete. */
  commentId: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of DeleteComment. */
export type DeleteCommentPayload = {
  __typename: 'DeleteCommentPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The deleted comment. */
  comment?: Maybe<Comment>;
};

export type DeprecateComplexMolecularProfileActivity = ActivityInterface & {
  __typename: 'DeprecateComplexMolecularProfileActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of DeprecateComplexMolecularProfile */
export type DeprecateComplexMolecularProfileInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text giving more context for deprecating this complex molecular profile. */
  comment: Scalars['String']['input'];
  /** The reason for deprecating this molecular profile. */
  deprecationReason: MolecularProfileDeprecationReasonMutationInput;
  /** The CIViC ID of the complex molecular profile to deprecate. */
  molecularProfileId: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of DeprecateComplexMolecularProfile. */
export type DeprecateComplexMolecularProfilePayload = {
  __typename: 'DeprecateComplexMolecularProfilePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The deprecated complex Molecular Profile. */
  molecularProfile?: Maybe<MolecularProfile>;
};

export type DeprecateFeatureActivity = ActivityInterface & {
  __typename: 'DeprecateFeatureActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  molecularProfiles: Array<MolecularProfile>;
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  variants: Array<VariantInterface>;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of DeprecateFeature */
export type DeprecateFeatureInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text giving more context for deprecation this feature. */
  comment: Scalars['String']['input'];
  /** The reason for deprecation this feature. */
  deprecationReason: FeatureDeprecationReason;
  /** The CIViC ID of the feature to deprecate. */
  featureId: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of DeprecateFeature. */
export type DeprecateFeaturePayload = {
  __typename: 'DeprecateFeaturePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The deprecated Feature. */
  feature?: Maybe<Feature>;
  /**
   * The molecular profiles linked to this feature's variants that weren't already
   * deprecated and have been newly deprecated by running this mutation.
   */
  newlyDeprecatedMolecularProfiles?: Maybe<Array<MolecularProfile>>;
  /** The variants linked to this feature that are newly deprecated. */
  newlyDeprecatedVariants?: Maybe<Array<VariantInterface>>;
};

export type DeprecateVariantActivity = ActivityInterface & {
  __typename: 'DeprecateVariantActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  molecularProfiles: Array<MolecularProfile>;
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of DeprecateVariant */
export type DeprecateVariantInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text giving more context for deprecation this variant. */
  comment: Scalars['String']['input'];
  /** The reason for deprecation this variant. */
  deprecationReason: VariantDeprecationReason;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** The CIViC ID of the variant to deprecate. */
  variantId: Scalars['Int']['input'];
};

/** Autogenerated return type of DeprecateVariant. */
export type DeprecateVariantPayload = {
  __typename: 'DeprecateVariantPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /**
   * The molecular profiles linked to this variant that weren't already deprecated
   * and have been newly deprecated by running this mutation.
   */
  newlyDeprecatedMolecularProfiles?: Maybe<Array<MolecularProfile>>;
  /** The deprecated Variant. */
  variant?: Maybe<VariantInterface>;
};

export enum Direction {
  Negative = 'NEGATIVE',
  Positive = 'POSITIVE'
}

export type Disease = {
  __typename: 'Disease';
  deprecated: Scalars['Boolean']['output'];
  diseaseAliases: Array<Scalars['String']['output']>;
  diseaseUrl?: Maybe<Scalars['String']['output']>;
  displayName: Scalars['String']['output'];
  doid?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  myDiseaseInfo?: Maybe<MyDiseaseInfo>;
  name: Scalars['String']['output'];
};

/** The connection type for Disease. */
export type DiseaseConnection = {
  __typename: 'DiseaseConnection';
  /** A list of edges. */
  edges: Array<DiseaseEdge>;
  /** A list of nodes. */
  nodes: Array<Disease>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type DiseaseEdge = {
  __typename: 'DiseaseEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Disease>;
};

export type DiseasePopover = {
  __typename: 'DiseasePopover';
  assertionCount: Scalars['Int']['output'];
  deprecated: Scalars['Boolean']['output'];
  diseaseAliases: Array<Scalars['String']['output']>;
  diseaseUrl?: Maybe<Scalars['String']['output']>;
  displayName: Scalars['String']['output'];
  doid?: Maybe<Scalars['String']['output']>;
  evidenceItemCount: Scalars['Int']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  molecularProfileCount: Scalars['Int']['output'];
  myDiseaseInfo?: Maybe<MyDiseaseInfo>;
  name: Scalars['String']['output'];
};

export type DiseaseSearchFilter = {
  booleanOperator?: InputMaybe<BooleanOperator>;
  deprecated?: InputMaybe<BooleanSearchInput>;
  diseaseAliases?: InputMaybe<StringSearchInput>;
  doid?: InputMaybe<StringSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  name?: InputMaybe<StringSearchInput>;
  subFilters?: InputMaybe<Array<DiseaseSearchFilter>>;
};

export type DiseasesSort = {
  /** Available columns for sorting */
  column: DiseasesSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum DiseasesSortColumns {
  AssertionCount = 'ASSERTION_COUNT',
  Doid = 'DOID',
  EvidenceItemCount = 'EVIDENCE_ITEM_COUNT',
  FeatureCount = 'FEATURE_COUNT',
  Name = 'NAME',
  VariantCount = 'VARIANT_COUNT'
}

/** String search input that only accepts DNA bases (A, C, T, G, /) */
export type DnaBaseStringInput = {
  operator: StringSearchOperator;
  value: Scalars['String']['input'];
};

export type DownloadableFile = {
  __typename: 'DownloadableFile';
  filename: Scalars['String']['output'];
  path: Scalars['String']['output'];
};

/** Autogenerated input type of EditUser */
export type EditUserInput = {
  /** The user's area of expertise */
  areaOfExpertise: NullableAreaOfExpertiseTypeInput;
  /**
   * A short biography describing the user's interests, accomplishments,
   * associations, and/or anything else about they would like to share with the
   * CIViC community.
   */
  bio: NullableStringInput;
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The internal CIViC ID of the country the user resides or studies in. */
  countryId: NullableIntInput;
  /** The user's email address */
  email: Scalars['String']['input'];
  /** The user's Facebook profile handle */
  facebookProfile: NullableStringInput;
  /** The user's LinkedIn username */
  linkedinProfile: NullableStringInput;
  /** The user's full name */
  name: NullableStringInput;
  /** The the user's ORCID (Open Research and Contributor ID) identifier */
  orcid: NullableIdInput;
  /** The user's twitter handle */
  twitterHandle: NullableStringInput;
  /** The user's personal website URL, omitting the https:// protocol part */
  url: NullableStringInput;
  /** The user's desired username */
  username: Scalars['String']['input'];
};

/** Autogenerated return type of EditUser. */
export type EditUserPayload = {
  __typename: 'EditUserPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  user: User;
};

export type EndorseAssertionActivity = ActivityInterface & {
  __typename: 'EndorseAssertionActivity';
  assertion: Assertion;
  createdAt: Scalars['ISO8601DateTime']['output'];
  endorsement: Endorsement;
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of EndorseAssertion */
export type EndorseAssertionInput = {
  /** ID of the Assertion to moderate */
  assertionId: Scalars['Int']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of EndorseAssertion. */
export type EndorseAssertionPayload = {
  __typename: 'EndorseAssertionPayload';
  /** The endorsed Assertion */
  assertion: Assertion;
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
};

export type Endorsement = {
  __typename: 'Endorsement';
  assertion: Assertion;
  createdAt: Scalars['ISO8601DateTime']['output'];
  endorsementActivity: EndorseAssertionActivity;
  id: Scalars['Int']['output'];
  lastReviewed: Scalars['ISO8601DateTime']['output'];
  organization: Organization;
  readyForClinvarSubmission: Scalars['Boolean']['output'];
  revocationActivity?: Maybe<RevokeEndorsementActivity>;
  status: EndorsementStatus;
  updatedAt: Scalars['ISO8601DateTime']['output'];
  user: User;
};

/** The connection type for Endorsement. */
export type EndorsementConnection = {
  __typename: 'EndorsementConnection';
  /** A list of edges. */
  edges: Array<EndorsementEdge>;
  /** A list of nodes. */
  nodes: Array<Endorsement>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type EndorsementEdge = {
  __typename: 'EndorsementEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Endorsement>;
};

export enum EndorsementStatus {
  Active = 'ACTIVE',
  RequiresReview = 'REQUIRES_REVIEW',
  Revoked = 'REVOKED'
}

export enum EnumSearchOperator {
  Eq = 'EQ',
  Ne = 'NE'
}

export type Event = {
  __typename: 'Event';
  action: EventAction;
  createdAt: Scalars['ISO8601DateTime']['output'];
  id: Scalars['Int']['output'];
  organization?: Maybe<Organization>;
  originatingObject?: Maybe<EventOriginObject>;
  originatingUser: User;
  subject?: Maybe<EventSubject>;
};

export enum EventAction {
  Accepted = 'ACCEPTED',
  AssertionAccepted = 'ASSERTION_ACCEPTED',
  AssertionEndorsed = 'ASSERTION_ENDORSED',
  AssertionEndorsmentRevoked = 'ASSERTION_ENDORSMENT_REVOKED',
  AssertionRejected = 'ASSERTION_REJECTED',
  AssertionReverted = 'ASSERTION_REVERTED',
  AssertionSubmitted = 'ASSERTION_SUBMITTED',
  Commented = 'COMMENTED',
  CommentDeleted = 'COMMENT_DELETED',
  ComplexMolecularProfileCreated = 'COMPLEX_MOLECULAR_PROFILE_CREATED',
  CuratedSourceSuggestion = 'CURATED_SOURCE_SUGGESTION',
  DeprecatedFeature = 'DEPRECATED_FEATURE',
  DeprecatedMolecularProfile = 'DEPRECATED_MOLECULAR_PROFILE',
  DeprecatedVariant = 'DEPRECATED_VARIANT',
  FeatureCreated = 'FEATURE_CREATED',
  Flagged = 'FLAGGED',
  FlagResolved = 'FLAG_RESOLVED',
  PublicationSuggested = 'PUBLICATION_SUGGESTED',
  Rejected = 'REJECTED',
  RejectedSourceSuggestion = 'REJECTED_SOURCE_SUGGESTION',
  RequeuedSourceSuggestion = 'REQUEUED_SOURCE_SUGGESTION',
  Reverted = 'REVERTED',
  RevisionAccepted = 'REVISION_ACCEPTED',
  RevisionRejected = 'REVISION_REJECTED',
  RevisionSuggested = 'REVISION_SUGGESTED',
  RevisionSuperseded = 'REVISION_SUPERSEDED',
  Submitted = 'SUBMITTED',
  VariantCreated = 'VARIANT_CREATED'
}

/** The connection type for Event. */
export type EventConnection = {
  __typename: 'EventConnection';
  /** A list of edges. */
  edges: Array<EventEdge>;
  /** List of event types that have occurred on this entity. */
  eventTypes: Array<EventAction>;
  /** A list of nodes. */
  nodes: Array<Event>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** List of all organizations who are involved in this event stream. */
  participatingOrganizations: Array<Organization>;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
  /**
   * When filtered on a subject, user, or organization, the total number of events
   * for that subject/user/organization, irregardless of other filters. Returns
   * null when there is no subject, user, or organization.
   */
  unfilteredCount: Scalars['Int']['output'];
  /** List of all users that have generated an event on the subject entity. */
  uniqueParticipants: Array<User>;
};

/** An edge in a connection. */
export type EventEdge = {
  __typename: 'EventEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Event>;
};

/**
 * The context of an event feed, i.e. what is the root subject of the feed. This
 * option is a no-op when accessing events via a parent.
 */
export enum EventFeedMode {
  Organization = 'ORGANIZATION',
  Subject = 'SUBJECT',
  Unscoped = 'UNSCOPED',
  User = 'USER'
}

/**
 * The originating object for an event.
 * This is useful when the subject of an event is not the actual origin of the event.
 * For instance when you suggest a revision, the subject of the Event will be the entity being revised,
 * while the originating object will be the Revision itself.
 */
export type EventOriginObject = {
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
};

/** The subject of an event log event. */
export type EventSubject = {
  /** List and filter events for an object */
  events: EventConnection;
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
};


/** The subject of an event log event. */
export type EventSubjectEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};

/** An event subject paired with a count of how many times that subject has appeared */
export type EventSubjectWithCount = {
  __typename: 'EventSubjectWithCount';
  occuranceCount: Scalars['Int']['output'];
  subject?: Maybe<EventSubject>;
};

export enum EvidenceDirection {
  DoesNotSupport = 'DOES_NOT_SUPPORT',
  Na = 'NA',
  Supports = 'SUPPORTS'
}

export type EvidenceDirectionTypeSearchInput = {
  operator: EnumSearchOperator;
  value: EvidenceDirection;
};

export type EvidenceItem = Commentable & EventOriginObject & EventSubject & Flaggable & WithRevisions & {
  __typename: 'EvidenceItem';
  acceptanceEvent?: Maybe<Event>;
  assertions: Array<Assertion>;
  /** List and filter comments. */
  comments: CommentConnection;
  description: Scalars['String']['output'];
  disease?: Maybe<Disease>;
  /** List and filter events for an object */
  events: EventConnection;
  evidenceDirection: EvidenceDirection;
  evidenceLevel: EvidenceLevel;
  evidenceRating?: Maybe<Scalars['Int']['output']>;
  evidenceType: EvidenceType;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  molecularProfile: MolecularProfile;
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  phenotypes: Array<Phenotype>;
  rejectionEvent?: Maybe<Event>;
  /** List and filter revisions. */
  revisions: RevisionConnection;
  significance: EvidenceSignificance;
  source: Source;
  status: EvidenceStatus;
  submissionActivity: SubmitEvidenceItemActivity;
  submissionEvent: Event;
  therapies: Array<Therapy>;
  therapyInteractionType?: Maybe<TherapyInteraction>;
  variantHgvs: Scalars['String']['output'];
  variantOrigin: VariantOrigin;
};


export type EvidenceItemCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type EvidenceItemEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type EvidenceItemFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


export type EvidenceItemRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

/** The connection type for EvidenceItem. */
export type EvidenceItemConnection = {
  __typename: 'EvidenceItemConnection';
  /** A list of edges. */
  edges: Array<EvidenceItemEdge>;
  /** A list of nodes. */
  nodes: Array<EvidenceItem>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type EvidenceItemEdge = {
  __typename: 'EvidenceItemEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<EvidenceItem>;
};

/** Fields on an EvidenceItem that curators may propose revisions to. */
export type EvidenceItemFields = {
  /** The Evidence Items's description/summary text. */
  description: NullableStringInput;
  /** The ID of the disease (if applicable) for this EvidenceItem */
  diseaseId: NullableIntInput;
  /** The evidence direction for this EvidenceItem. */
  evidenceDirection: EvidenceDirection;
  /** The evidence level of the EvidenceItem */
  evidenceLevel: EvidenceLevel;
  /** The Type of the EvidenceItem */
  evidenceType: EvidenceType;
  /** The ID of the Molecular Profile to which this EvidenceItem belongs */
  molecularProfileId: Scalars['Int']['input'];
  /** List of IDs of CIViC Phenotype entries for this EvidenceItem. An empty list indicates none. */
  phenotypeIds: Array<Scalars['Int']['input']>;
  /** The rating for this EvidenceItem */
  rating: Scalars['Int']['input'];
  /** The Clinical Significance of the EvidenceItem */
  significance: EvidenceSignificance;
  /** The ID of the Source from which this EvidenceItem was curated. */
  sourceId: Scalars['Int']['input'];
  /** List of IDs of CIViC Therapy entries for this EvidenceItem. An empty list indicates none. */
  therapyIds: Array<Scalars['Int']['input']>;
  /** Therapy interaction type for cases where more than one Therapy ID is provided. */
  therapyInteractionType: NullableTherapyInteractionTypeInput;
  /** The Variant Origin for this EvidenceItem. */
  variantOrigin: VariantOrigin;
};

export type EvidenceItemSearchFilter = {
  assertion?: InputMaybe<AssertionSearchFilter>;
  booleanOperator?: InputMaybe<BooleanOperator>;
  comment?: InputMaybe<CommentSearchFilter>;
  description?: InputMaybe<StringSearchInput>;
  disease?: InputMaybe<DiseaseSearchFilter>;
  evidenceDirection?: InputMaybe<EvidenceDirectionTypeSearchInput>;
  evidenceLevel?: InputMaybe<EvidenceLevelTypeSearchInput>;
  evidenceRating?: InputMaybe<IntSearchInput>;
  evidenceType?: InputMaybe<EvidenceTypeTypeSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  isFlagged?: InputMaybe<BooleanSearchInput>;
  molecularProfile?: InputMaybe<MolecularProfileSearchFilter>;
  openRevisionCount?: InputMaybe<IntSearchInput>;
  phenotypes?: InputMaybe<PhenotypeSearchFilter>;
  significance?: InputMaybe<EvidenceSignificanceTypeSearchInput>;
  source?: InputMaybe<SourceSearchFilter>;
  status?: InputMaybe<EvidenceStatusTypeSearchInput>;
  subFilters?: InputMaybe<Array<EvidenceItemSearchFilter>>;
  therapies?: InputMaybe<TherapySearchFilter>;
  therapyInteractionType?: InputMaybe<TherapyInteractionTypeSearchInput>;
};

export type EvidenceItemsByStatus = {
  __typename: 'EvidenceItemsByStatus';
  acceptedCount: Scalars['Int']['output'];
  molecularProfileId: Scalars['Int']['output'];
  rejectedCount: Scalars['Int']['output'];
  submittedCount: Scalars['Int']['output'];
};

export type EvidenceItemsByType = {
  __typename: 'EvidenceItemsByType';
  diagnosticCount: Scalars['Int']['output'];
  functionalCount: Scalars['Int']['output'];
  molecularProfileId: Scalars['Int']['output'];
  oncogenicCount: Scalars['Int']['output'];
  predictiveCount: Scalars['Int']['output'];
  predisposingCount: Scalars['Int']['output'];
  prognosticCount: Scalars['Int']['output'];
};

export enum EvidenceLevel {
  A = 'A',
  B = 'B',
  C = 'C',
  D = 'D',
  E = 'E'
}

export type EvidenceLevelTypeSearchInput = {
  operator: EnumSearchOperator;
  value: EvidenceLevel;
};

export enum EvidenceSignificance {
  AdverseResponse = 'ADVERSE_RESPONSE',
  Benign = 'BENIGN',
  BetterOutcome = 'BETTER_OUTCOME',
  DominantNegative = 'DOMINANT_NEGATIVE',
  GainOfFunction = 'GAIN_OF_FUNCTION',
  LikelyBenign = 'LIKELY_BENIGN',
  /** Likely Oncogenic */
  LikelyOncogenic = 'LIKELY_ONCOGENIC',
  LikelyPathogenic = 'LIKELY_PATHOGENIC',
  LossOfFunction = 'LOSS_OF_FUNCTION',
  Na = 'NA',
  Negative = 'NEGATIVE',
  Neomorphic = 'NEOMORPHIC',
  Oncogenicity = 'ONCOGENICITY',
  Pathogenic = 'PATHOGENIC',
  PoorOutcome = 'POOR_OUTCOME',
  Positive = 'POSITIVE',
  Predisposition = 'PREDISPOSITION',
  Protectiveness = 'PROTECTIVENESS',
  ReducedSensitivity = 'REDUCED_SENSITIVITY',
  Resistance = 'RESISTANCE',
  Sensitivityresponse = 'SENSITIVITYRESPONSE',
  UnalteredFunction = 'UNALTERED_FUNCTION',
  UncertainSignificance = 'UNCERTAIN_SIGNIFICANCE',
  Unknown = 'UNKNOWN'
}

export type EvidenceSignificanceTypeSearchInput = {
  operator: EnumSearchOperator;
  value: EvidenceSignificance;
};

export type EvidenceSort = {
  /** Available columns for sorting */
  column: EvidenceSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum EvidenceSortColumns {
  Description = 'DESCRIPTION',
  DiseaseName = 'DISEASE_NAME',
  EvidenceDirection = 'EVIDENCE_DIRECTION',
  EvidenceLevel = 'EVIDENCE_LEVEL',
  EvidenceRating = 'EVIDENCE_RATING',
  EvidenceType = 'EVIDENCE_TYPE',
  Id = 'ID',
  Significance = 'SIGNIFICANCE',
  Status = 'STATUS',
  VariantOrigin = 'VARIANT_ORIGIN'
}

export enum EvidenceStatus {
  Accepted = 'ACCEPTED',
  Rejected = 'REJECTED',
  Submitted = 'SUBMITTED'
}

export enum EvidenceStatusFilter {
  Accepted = 'ACCEPTED',
  All = 'ALL',
  NonRejected = 'NON_REJECTED',
  Rejected = 'REJECTED',
  Submitted = 'SUBMITTED'
}

export type EvidenceStatusTypeSearchInput = {
  operator: EnumSearchOperator;
  value: EvidenceStatus;
};

export enum EvidenceType {
  Diagnostic = 'DIAGNOSTIC',
  Functional = 'FUNCTIONAL',
  Oncogenic = 'ONCOGENIC',
  Predictive = 'PREDICTIVE',
  Predisposing = 'PREDISPOSING',
  Prognostic = 'PROGNOSTIC'
}

export type EvidenceTypeTypeSearchInput = {
  operator: EnumSearchOperator;
  value: EvidenceType;
};

export type ExonCoordinate = EventSubject & WithRevisions & {
  __typename: 'ExonCoordinate';
  chromosome?: Maybe<Scalars['String']['output']>;
  coordinateType: ExonCoordinateType;
  ensemblId?: Maybe<Scalars['String']['output']>;
  ensemblVersion?: Maybe<Scalars['Int']['output']>;
  /** List and filter events for an object */
  events: EventConnection;
  exon?: Maybe<Scalars['Int']['output']>;
  exonOffset?: Maybe<Scalars['Int']['output']>;
  exonOffsetDirection?: Maybe<Direction>;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  referenceBuild?: Maybe<ReferenceBuild>;
  representativeTranscript?: Maybe<Scalars['String']['output']>;
  /** List and filter revisions. */
  revisions: RevisionConnection;
  start?: Maybe<Scalars['Int']['output']>;
  stop?: Maybe<Scalars['Int']['output']>;
  strand?: Maybe<Direction>;
};


export type ExonCoordinateEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type ExonCoordinateRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

export enum ExonCoordinateType {
  FivePrimeEndExonCoordinate = 'FIVE_PRIME_END_EXON_COORDINATE',
  FivePrimeStartExonCoordinate = 'FIVE_PRIME_START_EXON_COORDINATE',
  ThreePrimeEndExonCoordinate = 'THREE_PRIME_END_EXON_COORDINATE',
  ThreePrimeStartExonCoordinate = 'THREE_PRIME_START_EXON_COORDINATE'
}

/** The Feature that a Variant can belong to */
export type Factor = Commentable & EventOriginObject & EventSubject & Flaggable & MolecularProfileComponent & WithRevisions & {
  __typename: 'Factor';
  /** List and filter comments. */
  comments: CommentConnection;
  creationActivity?: Maybe<CreateFeatureActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecationActivity?: Maybe<DeprecateFeatureActivity>;
  deprecationReason?: Maybe<FeatureDeprecationReason>;
  description?: Maybe<Scalars['String']['output']>;
  /** List and filter events for an object */
  events: EventConnection;
  featureAliases: Array<Scalars['String']['output']>;
  featureInstance: FeatureInstance;
  featureType: FeatureInstanceTypes;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  fullName?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  ncitDetails?: Maybe<NcitDetails>;
  ncitId?: Maybe<Scalars['String']['output']>;
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  sources: Array<Source>;
  /** List and filter Gene variants. */
  variants: FactorVariantConnection;
};


/** The Feature that a Variant can belong to */
export type FactorCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** The Feature that a Variant can belong to */
export type FactorEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** The Feature that a Variant can belong to */
export type FactorFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


/** The Feature that a Variant can belong to */
export type FactorRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};


/** The Feature that a Variant can belong to */
export type FactorVariantsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  alleleRegistryId?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  category?: InputMaybe<VariantCategories>;
  factorId?: InputMaybe<Scalars['Int']['input']>;
  featureId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  geneId?: InputMaybe<Scalars['Int']['input']>;
  hasNoVariantType?: InputMaybe<Scalars['Boolean']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<VariantMenuSort>;
  variantTypeIds?: InputMaybe<Array<Scalars['Int']['input']>>;
};

/** The connection type for Factor. */
export type FactorConnection = {
  __typename: 'FactorConnection';
  /** A list of edges. */
  edges: Array<FactorEdge>;
  /** A list of nodes. */
  nodes: Array<Factor>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type FactorEdge = {
  __typename: 'FactorEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Factor>;
};

/** Fields on a Factor that curators may propose revisions to. */
export type FactorFields = {
  /** List of aliases or alternate names for the Factor. */
  aliases: Array<Scalars['String']['input']>;
  /** The Factor's description/summary text. */
  description: NullableStringInput;
  /** The Factor's full name if applicable. */
  fullName: NullableStringInput;
  /** The Factor's display name. */
  name: Scalars['String']['input'];
  /** NCI Thesaurus concept ID for this Factor */
  ncitId: NullableStringInput;
  /** Source IDs cited by the Factor's summary. */
  sourceIds: Array<Scalars['Int']['input']>;
};

export type FactorVariant = Commentable & EventOriginObject & EventSubject & Flaggable & MolecularProfileComponent & VariantInterface & WithRevisions & {
  __typename: 'FactorVariant';
  /** List and filter comments. */
  comments: CommentConnection;
  creationActivity?: Maybe<CreateVariantActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecationActivity?: Maybe<DeprecateVariantActivity>;
  deprecationReason?: Maybe<VariantDeprecationReason>;
  /** List and filter events for an object */
  events: EventConnection;
  feature: Feature;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  molecularProfiles: MolecularProfileConnection;
  name: Scalars['String']['output'];
  ncitDetails?: Maybe<NcitDetails>;
  ncitId?: Maybe<Scalars['String']['output']>;
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  singleVariantMolecularProfile: MolecularProfile;
  singleVariantMolecularProfileId: Scalars['Int']['output'];
  variantAliases: Array<Scalars['String']['output']>;
  variantTypes: Array<VariantType>;
};


export type FactorVariantCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type FactorVariantEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type FactorVariantFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


export type FactorVariantMolecularProfilesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type FactorVariantRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

/** The connection type for FactorVariant. */
export type FactorVariantConnection = {
  __typename: 'FactorVariantConnection';
  /** A list of edges. */
  edges: Array<FactorVariantEdge>;
  /** A list of nodes. */
  nodes: Array<FactorVariant>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type FactorVariantEdge = {
  __typename: 'FactorVariantEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<FactorVariant>;
};

/** Fields on a FactorVariant that curators may propose revisions to. */
export type FactorVariantFields = {
  /** List of aliases or alternate names for the Variant. */
  aliases: Array<Scalars['String']['input']>;
  /** The ID of the Feature this Variant corresponds to. */
  featureId: Scalars['Int']['input'];
  /** The Variant's name. */
  name: Scalars['String']['input'];
  /** NCI Thesaurus concept ID for this Factor */
  ncitId: NullableStringInput;
  /** List of IDs for the variant types for this Variant */
  variantTypeIds: Array<Scalars['Int']['input']>;
};

export type FdaCode = {
  __typename: 'FdaCode';
  code: Scalars['String']['output'];
  description: Scalars['String']['output'];
};

/** The Feature that a Variant can belong to */
export type Feature = Commentable & EventOriginObject & EventSubject & Flaggable & MolecularProfileComponent & WithRevisions & {
  __typename: 'Feature';
  /** List and filter comments. */
  comments: CommentConnection;
  creationActivity?: Maybe<CreateFeatureActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecationActivity?: Maybe<DeprecateFeatureActivity>;
  deprecationReason?: Maybe<FeatureDeprecationReason>;
  description?: Maybe<Scalars['String']['output']>;
  /** List and filter events for an object */
  events: EventConnection;
  featureAliases: Array<Scalars['String']['output']>;
  featureInstance: FeatureInstance;
  featureType: FeatureInstanceTypes;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  fullName?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  sources: Array<Source>;
  /** List and filter variants. */
  variants: VariantInterfaceConnection;
};


/** The Feature that a Variant can belong to */
export type FeatureCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** The Feature that a Variant can belong to */
export type FeatureEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** The Feature that a Variant can belong to */
export type FeatureFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


/** The Feature that a Variant can belong to */
export type FeatureRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};


/** The Feature that a Variant can belong to */
export type FeatureVariantsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  alleleRegistryId?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  category?: InputMaybe<VariantCategories>;
  factorId?: InputMaybe<Scalars['Int']['input']>;
  featureId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  geneId?: InputMaybe<Scalars['Int']['input']>;
  hasNoVariantType?: InputMaybe<Scalars['Boolean']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<VariantMenuSort>;
  variantTypeIds?: InputMaybe<Array<Scalars['Int']['input']>>;
};

export enum FeatureDeprecationReason {
  Duplicate = 'DUPLICATE',
  Invalid = 'INVALID',
  Other = 'OTHER'
}

export type FeatureDeprecationReasonTypeSearchInput = {
  operator: EnumSearchOperator;
  value: FeatureDeprecationReason;
};

/** The specific type of a feature instance */
export type FeatureInstance = Factor | Fusion | Gene;

export enum FeatureInstanceTypes {
  Factor = 'FACTOR',
  Fusion = 'FUSION',
  Gene = 'GENE'
}

export type FeatureInstanceTypesSearchInput = {
  operator: EnumSearchOperator;
  value: FeatureInstanceTypes;
};

export type FeatureSearchFilter = {
  alias?: InputMaybe<StringSearchInput>;
  booleanOperator?: InputMaybe<BooleanOperator>;
  deprecationReason?: InputMaybe<FeatureDeprecationReasonTypeSearchInput>;
  description?: InputMaybe<StringSearchInput>;
  entrezId?: InputMaybe<IntSearchInput>;
  entrezSymbol?: InputMaybe<StringSearchInput>;
  featureInstanceType?: InputMaybe<FeatureInstanceTypesSearchInput>;
  fivePrimePartnerEntrezId?: InputMaybe<IntSearchInput>;
  fivePrimePartnerEntrezSymbol?: InputMaybe<StringSearchInput>;
  hasAssertion?: InputMaybe<BooleanSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  isDeprecated?: InputMaybe<BooleanSearchInput>;
  isFlagged?: InputMaybe<BooleanSearchInput>;
  ncitId?: InputMaybe<StringSearchInput>;
  openRevisionCount?: InputMaybe<IntSearchInput>;
  subFilters?: InputMaybe<Array<FeatureSearchFilter>>;
  threePrimePartnerEntrezId?: InputMaybe<IntSearchInput>;
  threePrimePartnerEntrezSymbol?: InputMaybe<StringSearchInput>;
};

export type FeaturesSort = {
  /** Available columns for sorting */
  column: FeaturesSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum FeaturesSortColumns {
  AssertionCount = 'assertionCount',
  DiseaseName = 'diseaseName',
  EvidenceItemCount = 'evidenceItemCount',
  FeatureAlias = 'featureAlias',
  FeatureFullName = 'featureFullName',
  FeatureName = 'featureName',
  MolecularProfileCount = 'molecularProfileCount',
  TherapyName = 'therapyName',
  VariantCount = 'variantCount'
}

export type FieldName = {
  __typename: 'FieldName';
  /** The user facing representation of the field name. */
  displayName: Scalars['String']['output'];
  /** The internal server representation of the field name. */
  name: Scalars['String']['output'];
};

export type FieldValidationError = {
  __typename: 'FieldValidationError';
  error: Scalars['String']['output'];
  fieldName: Scalars['String']['output'];
};

export type Flag = Commentable & EventOriginObject & EventSubject & {
  __typename: 'Flag';
  /** List and filter comments. */
  comments: CommentConnection;
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** List and filter events for an object */
  events: EventConnection;
  flaggable: Flaggable;
  flaggingUser: User;
  id: Scalars['Int']['output'];
  lastCommentEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  openActivity: FlagEntityActivity;
  resolutionActivity?: Maybe<ResolveFlagActivity>;
  resolvingUser?: Maybe<User>;
  state: FlagState;
};


export type FlagCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type FlagEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};

/** The connection type for Flag. */
export type FlagConnection = {
  __typename: 'FlagConnection';
  /** A list of edges. */
  edges: Array<FlagEdge>;
  /** A list of nodes. */
  nodes: Array<Flag>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
  /**
   * When filtered on a subject, the total number of flags for that subject,
   * irregardless of other filters. Returns null when there is no subject.
   */
  unfilteredCountForSubject?: Maybe<Scalars['Int']['output']>;
  /** List of all users that have flagged this entity. */
  uniqueFlaggingUsers: Array<User>;
  /** List of all users that have resolved a flag on this entity. */
  uniqueResolvingUsers?: Maybe<Array<User>>;
};

/** An edge in a connection. */
export type FlagEdge = {
  __typename: 'FlagEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Flag>;
};

export type FlagEntityActivity = ActivityInterface & {
  __typename: 'FlagEntityActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  flag: Flag;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of FlagEntity */
export type FlagEntityInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the problem you observed with this entity. */
  comment: Scalars['String']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** The entity to flag, specified by its ID and type. */
  subject: FlaggableInput;
};

/** Autogenerated return type of FlagEntity. */
export type FlagEntityPayload = {
  __typename: 'FlagEntityPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created Flag. */
  flag?: Maybe<Flag>;
};

export enum FlagState {
  Open = 'OPEN',
  Resolved = 'RESOLVED'
}

/** A CIViC entity that can be flagged for editor attention. */
export type Flaggable = {
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
};


/** A CIViC entity that can be flagged for editor attention. */
export type FlaggableFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};

/** Enumeration of all entities in CIViC that can be flagged. */
export enum FlaggableEntities {
  Assertion = 'ASSERTION',
  EvidenceItem = 'EVIDENCE_ITEM',
  Feature = 'FEATURE',
  MolecularProfile = 'MOLECULAR_PROFILE',
  Variant = 'VARIANT',
  VariantGroup = 'VARIANT_GROUP'
}

/** Entity to flag */
export type FlaggableInput = {
  /** The type of the entity to flag. */
  entityType: FlaggableEntities;
  /** The ID of the entity. */
  id: Scalars['Int']['input'];
};

export type FloatSearchInput = {
  operator: FloatSearchOperator;
  value: Scalars['Float']['input'];
};

export enum FloatSearchOperator {
  /** Equal To */
  Eq = 'EQ',
  /** Greater Than or Equal To */
  Ge = 'GE',
  /** Greater Than */
  Gt = 'GT',
  /** Less Than or Equal To */
  Le = 'LE',
  /** Less Than */
  Lt = 'LT',
  /** Not Equal To */
  Ne = 'NE'
}

/** The Feature that a Variant can belong to */
export type Fusion = Commentable & EventOriginObject & EventSubject & Flaggable & MolecularProfileComponent & WithRevisions & {
  __typename: 'Fusion';
  /** List and filter comments. */
  comments: CommentConnection;
  creationActivity?: Maybe<CreateFeatureActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecationActivity?: Maybe<DeprecateFeatureActivity>;
  deprecationReason?: Maybe<FeatureDeprecationReason>;
  description?: Maybe<Scalars['String']['output']>;
  /** List and filter events for an object */
  events: EventConnection;
  featureAliases: Array<Scalars['String']['output']>;
  featureInstance: FeatureInstance;
  featureType: FeatureInstanceTypes;
  fivePrimeGene?: Maybe<Gene>;
  fivePrimePartnerStatus: FusionPartnerStatus;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  fullName?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  sources: Array<Source>;
  threePrimeGene?: Maybe<Gene>;
  threePrimePartnerStatus: FusionPartnerStatus;
  /** List and filter variants. */
  variants: VariantInterfaceConnection;
};


/** The Feature that a Variant can belong to */
export type FusionCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** The Feature that a Variant can belong to */
export type FusionEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** The Feature that a Variant can belong to */
export type FusionFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


/** The Feature that a Variant can belong to */
export type FusionRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};


/** The Feature that a Variant can belong to */
export type FusionVariantsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  alleleRegistryId?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  category?: InputMaybe<VariantCategories>;
  factorId?: InputMaybe<Scalars['Int']['input']>;
  featureId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  geneId?: InputMaybe<Scalars['Int']['input']>;
  hasNoVariantType?: InputMaybe<Scalars['Boolean']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<VariantMenuSort>;
  variantTypeIds?: InputMaybe<Array<Scalars['Int']['input']>>;
};

/** The connection type for Fusion. */
export type FusionConnection = {
  __typename: 'FusionConnection';
  /** A list of edges. */
  edges: Array<FusionEdge>;
  /** A list of nodes. */
  nodes: Array<Fusion>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type FusionEdge = {
  __typename: 'FusionEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Fusion>;
};

/** Fields on a Fusion that curators may propose revisions to. */
export type FusionFields = {
  /** List of aliases or alternate names for the Fusion. */
  aliases: Array<Scalars['String']['input']>;
  /** The Fusion's description/summary text. */
  description: NullableStringInput;
  /** Source IDs cited by the Fusion's summary. */
  sourceIds: Array<Scalars['Int']['input']>;
};

/** The fusion partner's status and gene ID (if applicable) */
export type FusionPartnerInput = {
  /** The CIViC gene ID of the partner, if known */
  geneId?: InputMaybe<Scalars['Int']['input']>;
  /** The status of the fusion partner */
  partnerStatus: FusionPartnerStatus;
};

export enum FusionPartnerStatus {
  Known = 'KNOWN',
  Multiple = 'MULTIPLE',
  Unknown = 'UNKNOWN'
}

export type FusionVariant = Commentable & EventOriginObject & EventSubject & Flaggable & MolecularProfileComponent & VariantInterface & WithRevisions & {
  __typename: 'FusionVariant';
  /** List and filter comments. */
  comments: CommentConnection;
  creationActivity?: Maybe<CreateVariantActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecationActivity?: Maybe<DeprecateVariantActivity>;
  deprecationReason?: Maybe<VariantDeprecationReason>;
  /** List and filter events for an object */
  events: EventConnection;
  feature: Feature;
  fivePrimeCoordinates?: Maybe<VariantCoordinate>;
  fivePrimeEndExonCoordinates?: Maybe<ExonCoordinate>;
  fivePrimeStartExonCoordinates?: Maybe<ExonCoordinate>;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  fusion: Fusion;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  molecularProfiles: MolecularProfileConnection;
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  singleVariantMolecularProfile: MolecularProfile;
  singleVariantMolecularProfileId: Scalars['Int']['output'];
  threePrimeCoordinates?: Maybe<VariantCoordinate>;
  threePrimeEndExonCoordinates?: Maybe<ExonCoordinate>;
  threePrimeStartExonCoordinates?: Maybe<ExonCoordinate>;
  variantAliases: Array<Scalars['String']['output']>;
  variantTypes: Array<VariantType>;
  viccCompliantName: Scalars['String']['output'];
};


export type FusionVariantCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type FusionVariantEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type FusionVariantFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


export type FusionVariantMolecularProfilesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type FusionVariantRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

/** Fields on a FusionVariant that curators may propose revisions to. */
export type FusionVariantFields = {
  /** List of aliases or alternate names for the Variant. */
  aliases: Array<Scalars['String']['input']>;
  /** The exon coordinates for this Variant. */
  coordinates: FusionVariantInput;
  /** List of IDs for the variant types for this Variant */
  variantTypeIds: Array<Scalars['Int']['input']>;
};

/** The fields required to create a fusion variant */
export type FusionVariantInput = {
  ensemblVersion: Scalars['Int']['input'];
  fivePrimeExonEnd?: InputMaybe<Scalars['Int']['input']>;
  fivePrimeOffset?: InputMaybe<Scalars['Int']['input']>;
  fivePrimeOffsetDirection?: InputMaybe<Direction>;
  fivePrimeTranscript?: InputMaybe<Scalars['String']['input']>;
  /** The reference build for the genomic coordinates of this Variant. */
  referenceBuild?: InputMaybe<ReferenceBuild>;
  threePrimeExonStart?: InputMaybe<Scalars['Int']['input']>;
  threePrimeOffset?: InputMaybe<Scalars['Int']['input']>;
  threePrimeOffsetDirection?: InputMaybe<Direction>;
  threePrimeTranscript?: InputMaybe<Scalars['String']['input']>;
};

/** The Feature that a Variant can belong to */
export type Gene = Commentable & EventOriginObject & EventSubject & Flaggable & MolecularProfileComponent & WithRevisions & {
  __typename: 'Gene';
  /** List and filter comments. */
  comments: CommentConnection;
  creationActivity?: Maybe<CreateFeatureActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecationActivity?: Maybe<DeprecateFeatureActivity>;
  deprecationReason?: Maybe<FeatureDeprecationReason>;
  description?: Maybe<Scalars['String']['output']>;
  entrezId: Scalars['Int']['output'];
  /** List and filter events for an object */
  events: EventConnection;
  featureAliases: Array<Scalars['String']['output']>;
  featureInstance: FeatureInstance;
  featureType: FeatureInstanceTypes;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  fullName?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  myGeneInfoDetails?: Maybe<Scalars['JSON']['output']>;
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  sources: Array<Source>;
  /** List and filter Gene variants. */
  variants: GeneVariantConnection;
};


/** The Feature that a Variant can belong to */
export type GeneCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** The Feature that a Variant can belong to */
export type GeneEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** The Feature that a Variant can belong to */
export type GeneFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


/** The Feature that a Variant can belong to */
export type GeneRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};


/** The Feature that a Variant can belong to */
export type GeneVariantsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  alleleRegistryId?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  category?: InputMaybe<VariantCategories>;
  factorId?: InputMaybe<Scalars['Int']['input']>;
  featureId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  geneId?: InputMaybe<Scalars['Int']['input']>;
  hasNoVariantType?: InputMaybe<Scalars['Boolean']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<VariantMenuSort>;
  variantTypeIds?: InputMaybe<Array<Scalars['Int']['input']>>;
};

/** The connection type for Gene. */
export type GeneConnection = {
  __typename: 'GeneConnection';
  /** A list of edges. */
  edges: Array<GeneEdge>;
  /** A list of nodes. */
  nodes: Array<Gene>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type GeneEdge = {
  __typename: 'GeneEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Gene>;
};

/** Fields on a Gene that curators may propose revisions to. */
export type GeneFields = {
  /** The Gene's description/summary text. */
  description: NullableStringInput;
  /** Source IDs cited by the Gene's summary. */
  sourceIds: Array<Scalars['Int']['input']>;
};

export type GeneVariant = Commentable & EventOriginObject & EventSubject & Flaggable & MolecularProfileComponent & VariantInterface & WithRevisions & {
  __typename: 'GeneVariant';
  alleleRegistryId?: Maybe<Scalars['String']['output']>;
  clinvarIds: Array<Scalars['String']['output']>;
  /** List and filter comments. */
  comments: CommentConnection;
  coordinates?: Maybe<VariantCoordinate>;
  creationActivity?: Maybe<CreateVariantActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecationActivity?: Maybe<DeprecateVariantActivity>;
  deprecationReason?: Maybe<VariantDeprecationReason>;
  /** List and filter events for an object */
  events: EventConnection;
  feature: Feature;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  hgvsDescriptions: Array<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  maneSelectTranscript?: Maybe<Scalars['String']['output']>;
  molecularProfiles: MolecularProfileConnection;
  myVariantInfo?: Maybe<MyVariantInfo>;
  name: Scalars['String']['output'];
  openCravatAnnotations?: Maybe<Scalars['JSON']['output']>;
  openCravatUrl?: Maybe<Scalars['String']['output']>;
  openRevisionCount: Scalars['Int']['output'];
  /** @deprecated The new Fusion variant type means Gene variants no longer have primary and secondary coordinates. Use 'coordinates' instead. */
  primaryCoordinates?: Maybe<VariantCoordinate>;
  /** List and filter revisions. */
  revisions: RevisionConnection;
  singleVariantMolecularProfile: MolecularProfile;
  singleVariantMolecularProfileId: Scalars['Int']['output'];
  variantAliases: Array<Scalars['String']['output']>;
  variantTypes: Array<VariantType>;
};


export type GeneVariantCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type GeneVariantEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type GeneVariantFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


export type GeneVariantMolecularProfilesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type GeneVariantRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

/** The connection type for GeneVariant. */
export type GeneVariantConnection = {
  __typename: 'GeneVariantConnection';
  /** A list of edges. */
  edges: Array<GeneVariantEdge>;
  /** A list of nodes. */
  nodes: Array<GeneVariant>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

export type GeneVariantCoordinateInput = {
  chromosome?: InputMaybe<Scalars['String']['input']>;
  /** The Ensembl database version. */
  ensemblVersion?: InputMaybe<Scalars['Int']['input']>;
  /** Reference bases for this variant */
  referenceBases: NullableStringInput;
  /** The reference build for the genomic coordinates of this Variant. */
  referenceBuild?: InputMaybe<ReferenceBuild>;
  representativeTranscript?: InputMaybe<Scalars['String']['input']>;
  start?: InputMaybe<Scalars['Int']['input']>;
  stop?: InputMaybe<Scalars['Int']['input']>;
  /** Variant bases for this variant */
  variantBases: NullableStringInput;
};

/** An edge in a connection. */
export type GeneVariantEdge = {
  __typename: 'GeneVariantEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<GeneVariant>;
};

/** Fields on a GeneVariant that curators may propose revisions to. */
export type GeneVariantFields = {
  /** List of aliases or alternate names for the Variant. */
  aliases: Array<Scalars['String']['input']>;
  /** List of ClinVar IDs for the Variant. */
  clinvarIds: ClinvarInput;
  /** The genomic coordinates for this Variant. */
  coordinates: GeneVariantCoordinateInput;
  /** The ID of the Feature this Variant corresponds to. */
  featureId: Scalars['Int']['input'];
  /** List of HGVS descriptions for the Variant. */
  hgvsDescriptions: Array<Scalars['String']['input']>;
  /** The Variant's name. */
  name: Scalars['String']['input'];
  /** List of IDs for the variant types for this Variant */
  variantTypeIds: Array<Scalars['Int']['input']>;
};

/** Autogenerated input type of GenerateApiKey */
export type GenerateApiKeyInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of GenerateApiKey. */
export type GenerateApiKeyPayload = {
  __typename: 'GenerateApiKeyPayload';
  /** The newly created API key. */
  apiKey?: Maybe<ApiKey>;
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  user?: Maybe<User>;
};

export type IntSearchInput = {
  operator: IntSearchOperator;
  value: Scalars['Int']['input'];
};

export enum IntSearchOperator {
  /** Equal To */
  Eq = 'EQ',
  /** Greater Than or Equal To */
  Ge = 'GE',
  /** Greater Than */
  Gt = 'GT',
  /** Less Than or Equal To */
  Le = 'LE',
  /** Less Than */
  Lt = 'LT',
  /** Not Equal To */
  Ne = 'NE'
}

export type LeaderboardOrganization = {
  __typename: 'LeaderboardOrganization';
  actionCount: Scalars['Int']['output'];
  canEndorse: Scalars['Boolean']['output'];
  description: Scalars['String']['output'];
  eventCount: Scalars['Int']['output'];
  events: EventConnection;
  hasEndorsingSubgroups: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  isApprovedVcep: Scalars['Boolean']['output'];
  memberCount: Scalars['Int']['output'];
  members: UserConnection;
  mostRecentActivityTimestamp?: Maybe<Scalars['ISO8601DateTime']['output']>;
  name: Scalars['String']['output'];
  orgAndSuborgsStatsHash: Stats;
  orgStatsHash: Stats;
  profileImagePath?: Maybe<Scalars['String']['output']>;
  rank: Scalars['Int']['output'];
  ranks: Ranks;
  subGroups: Array<Organization>;
  url: Scalars['String']['output'];
};


export type LeaderboardOrganizationEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type LeaderboardOrganizationMembersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type LeaderboardOrganizationProfileImagePathArgs = {
  size?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for LeaderboardOrganization. */
export type LeaderboardOrganizationConnection = {
  __typename: 'LeaderboardOrganizationConnection';
  /** A list of edges. */
  edges: Array<LeaderboardOrganizationEdge>;
  /** A list of nodes. */
  nodes: Array<LeaderboardOrganization>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type LeaderboardOrganizationEdge = {
  __typename: 'LeaderboardOrganizationEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<LeaderboardOrganization>;
};

export type LeaderboardRank = {
  __typename: 'LeaderboardRank';
  actionCount: Scalars['Int']['output'];
  rank: Scalars['Int']['output'];
};

export type LeaderboardUser = {
  __typename: 'LeaderboardUser';
  actionCount: Scalars['Int']['output'];
  apiKeys: Array<ApiKey>;
  areaOfExpertise?: Maybe<AreaOfExpertise>;
  bio?: Maybe<Scalars['String']['output']>;
  country?: Maybe<Country>;
  displayName: Scalars['String']['output'];
  email?: Maybe<Scalars['String']['output']>;
  events: EventConnection;
  facebookProfile?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  joinDate?: Maybe<Scalars['ISO8601DateTime']['output']>;
  linkedinProfile?: Maybe<Scalars['String']['output']>;
  mostRecentActivityTimestamp?: Maybe<Scalars['ISO8601DateTime']['output']>;
  mostRecentConflictOfInterestStatement?: Maybe<Coi>;
  mostRecentEvent?: Maybe<Event>;
  mostRecentOrganizationId?: Maybe<Scalars['Int']['output']>;
  name?: Maybe<Scalars['String']['output']>;
  /** Filterable list of notifications for the logged in user. */
  notifications?: Maybe<NotificationConnection>;
  orcid?: Maybe<Scalars['String']['output']>;
  organizations: Array<Organization>;
  organizationsWithEndorsementPrivileges: Array<Organization>;
  profileImagePath?: Maybe<Scalars['String']['output']>;
  rank: Scalars['Int']['output'];
  ranks: Ranks;
  role: UserRole;
  statsHash: Stats;
  twitterHandle?: Maybe<Scalars['String']['output']>;
  url?: Maybe<Scalars['String']['output']>;
  username: Scalars['String']['output'];
};


export type LeaderboardUserEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type LeaderboardUserNotificationsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeSeen?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  notificationType?: InputMaybe<NotificationReason>;
  subscriptionId?: InputMaybe<Scalars['Int']['input']>;
};


export type LeaderboardUserProfileImagePathArgs = {
  size?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for LeaderboardUser. */
export type LeaderboardUserConnection = {
  __typename: 'LeaderboardUserConnection';
  /** A list of edges. */
  edges: Array<LeaderboardUserEdge>;
  /** A list of nodes. */
  nodes: Array<LeaderboardUser>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type LeaderboardUserEdge = {
  __typename: 'LeaderboardUserEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<LeaderboardUser>;
};

export type LinkableDisease = {
  __typename: 'LinkableDisease';
  deprecated: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
};

export type LinkableFeature = {
  __typename: 'LinkableFeature';
  deprecated: Scalars['Boolean']['output'];
  flagged: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
};

export type LinkableTherapy = {
  __typename: 'LinkableTherapy';
  deprecated: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
};

export type LinkableVariant = {
  __typename: 'LinkableVariant';
  deprecated: Scalars['Boolean']['output'];
  feature?: Maybe<LinkableFeature>;
  flagged: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  matchText?: Maybe<Scalars['String']['output']>;
  name: Scalars['String']['output'];
};

export type LinkableVariantType = {
  __typename: 'LinkableVariantType';
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
};

export type LinkoutData = {
  __typename: 'LinkoutData';
  currentValue: ModeratedField;
  diffValue: ModeratedFieldDiff;
  name: Scalars['String']['output'];
  suggestedValue: ModeratedField;
};

export type ModerateAssertionActivity = ActivityInterface & {
  __typename: 'ModerateAssertionActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of ModerateAssertion */
export type ModerateAssertionInput = {
  /** ID of the Assertion to moderate */
  assertionId: Scalars['Int']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Comment explaining the moderation action. Required when rejecting. */
  comment?: InputMaybe<Scalars['String']['input']>;
  /** The desired status of the Assertion */
  newStatus: EvidenceStatus;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of ModerateAssertion. */
export type ModerateAssertionPayload = {
  __typename: 'ModerateAssertionPayload';
  /** The moderated Assertion */
  assertion: Assertion;
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
};

export type ModerateEvidenceItemActivity = ActivityInterface & {
  __typename: 'ModerateEvidenceItemActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of ModerateEvidenceItem */
export type ModerateEvidenceItemInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Optional comment explaining the moderation action. Required if the new status is 'rejected'. */
  comment?: InputMaybe<Scalars['String']['input']>;
  /** ID of the Evidence Item to moderate */
  evidenceItemId: Scalars['Int']['input'];
  /** The desired status of the Evidence Item */
  newStatus: EvidenceStatus;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of ModerateEvidenceItem. */
export type ModerateEvidenceItemPayload = {
  __typename: 'ModerateEvidenceItemPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The moderated Evidence Item */
  evidenceItem: EvidenceItem;
};

/** Enumeration of all moderated CIViC entities. */
export enum ModeratedEntities {
  Assertion = 'ASSERTION',
  EvidenceItem = 'EVIDENCE_ITEM',
  ExonCoordinates = 'EXON_COORDINATES',
  Feature = 'FEATURE',
  MolecularProfile = 'MOLECULAR_PROFILE',
  Variant = 'VARIANT',
  VariantCoordinates = 'VARIANT_COORDINATES',
  VariantGroup = 'VARIANT_GROUP'
}

/** Fields that can have revisions can be either scalar values or complex objects */
export type ModeratedField = ObjectField | ScalarField;

/** Fields that can have revisions can be either scalar values or complex objects */
export type ModeratedFieldDiff = ObjectFieldDiff | ScalarFieldDiff;

/** Entity to moderate. */
export type ModeratedInput = {
  /** Type of moderated entity. */
  entityType: ModeratedEntities;
  /** ID of moderated entity. */
  id: Scalars['Int']['input'];
};

export type ModeratedObjectField = {
  __typename: 'ModeratedObjectField';
  deleted: Scalars['Boolean']['output'];
  deprecated?: Maybe<Scalars['Boolean']['output']>;
  displayName?: Maybe<Scalars['String']['output']>;
  displayType?: Maybe<Scalars['String']['output']>;
  entityType: Scalars['String']['output'];
  feature?: Maybe<LinkableFeature>;
  flagged?: Maybe<Scalars['Boolean']['output']>;
  id: Scalars['Int']['output'];
  link?: Maybe<Scalars['String']['output']>;
};

export type MolecularProfile = Commentable & EventOriginObject & EventSubject & Flaggable & WithRevisions & {
  __typename: 'MolecularProfile';
  /** The collection of assertions associated with this molecular profile. */
  assertions: AssertionConnection;
  /** List and filter comments. */
  comments: CommentConnection;
  complexMolecularProfileCreationActivity?: Maybe<CreateComplexMolecularProfileActivity>;
  complexMolecularProfileDeprecationActivity?: Maybe<DeprecateComplexMolecularProfileActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecatedVariants: Array<VariantInterface>;
  deprecationReason?: Maybe<MolecularProfileDeprecationReason>;
  description?: Maybe<Scalars['String']['output']>;
  /** List and filter events for an object */
  events: EventConnection;
  evidenceCountsByStatus: EvidenceItemsByStatus;
  evidenceCountsByType: EvidenceItemsByType;
  /** The collection of evidence items associated with this molecular profile. */
  evidenceItems: EvidenceItemConnection;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  id: Scalars['Int']['output'];
  isComplex: Scalars['Boolean']['output'];
  isMultiVariant: Scalars['Boolean']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  molecularProfileAliases: Array<Scalars['String']['output']>;
  molecularProfileScore: Scalars['Float']['output'];
  /** The human readable name of this profile, including gene and variant names. */
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  /** The profile name with its constituent parts as objects, suitable for building tags. */
  parsedName: Array<MolecularProfileSegment>;
  /** The profile name as stored, with ids rather than names. */
  rawName: Scalars['String']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  sources: Array<Source>;
  variantCreationActivity?: Maybe<CreateVariantActivity>;
  variantDeprecationActivity?: Maybe<DeprecateVariantActivity>;
  /** The collection of variants included in this molecular profile. Please note the name for their relation to each other. */
  variants: Array<VariantInterface>;
};


export type MolecularProfileAssertionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeRejected?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type MolecularProfileCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type MolecularProfileEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type MolecularProfileEvidenceItemsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeRejected?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type MolecularProfileFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


export type MolecularProfileRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

export type MolecularProfileAlias = {
  __typename: 'MolecularProfileAlias';
  name: Scalars['String']['output'];
};

/** A taggable/linkable component of a molecular profile */
export type MolecularProfileComponent = {
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
};

export type MolecularProfileComponentInput = {
  /** Boolean operation used to combined the components into a Molecular Profile. */
  booleanOperator?: InputMaybe<BooleanOperator>;
  /** One or more complex (multi-Variant) components that make up the Molecular Profile. */
  complexComponents?: InputMaybe<Array<MolecularProfileComponentInput>>;
  /** One or more single Variants that make up the Molecular Profile. */
  variantComponents?: InputMaybe<Array<VariantComponent>>;
};

/** The connection type for MolecularProfile. */
export type MolecularProfileConnection = {
  __typename: 'MolecularProfileConnection';
  /** A list of edges. */
  edges: Array<MolecularProfileEdge>;
  /** A list of nodes. */
  nodes: Array<MolecularProfile>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

export enum MolecularProfileDeprecationReason {
  Duplicate = 'DUPLICATE',
  Invalid = 'INVALID',
  Other = 'OTHER',
  VariantDeprecated = 'VARIANT_DEPRECATED'
}

export enum MolecularProfileDeprecationReasonMutationInput {
  Duplicate = 'DUPLICATE',
  Invalid = 'INVALID',
  Other = 'OTHER'
}

/** An edge in a connection. */
export type MolecularProfileEdge = {
  __typename: 'MolecularProfileEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<MolecularProfile>;
};

/** Fields on a MolecularProfile that curators may propose revisions to. */
export type MolecularProfileFields = {
  /** List of aliases or alternate names for the MolecularProfile. */
  aliases: Array<Scalars['String']['input']>;
  /** The MolecularProfile's description/summary text. */
  description: NullableStringInput;
  /** Source IDs cited by the MolecularProfile's summary. */
  sourceIds: Array<Scalars['Int']['input']>;
};

export type MolecularProfileNamePreview = {
  __typename: 'MolecularProfileNamePreview';
  deprecatedVariants: Array<VariantInterface>;
  /** The already existing MP matching this name, if it exists */
  existingMolecularProfile?: Maybe<MolecularProfile>;
  segments: Array<MolecularProfileSegment>;
};

export type MolecularProfileSearchFilter = {
  alias?: InputMaybe<StringSearchInput>;
  booleanOperator?: InputMaybe<BooleanOperator>;
  description?: InputMaybe<StringSearchInput>;
  evidenceItemsCount?: InputMaybe<IntSearchInput>;
  hasAssertion?: InputMaybe<BooleanSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  isFlagged?: InputMaybe<BooleanSearchInput>;
  openRevisionCount?: InputMaybe<IntSearchInput>;
  score?: InputMaybe<FloatSearchInput>;
  source?: InputMaybe<SourceSearchFilter>;
  subFilters?: InputMaybe<Array<MolecularProfileSearchFilter>>;
};

/**
 * A segment of a molecular profile. Either a string representing a boolean
 * operator or a tag component representing a gene or variant
 */
export type MolecularProfileSegment = Feature | MolecularProfileTextSegment | Variant;

export type MolecularProfileTextSegment = {
  __typename: 'MolecularProfileTextSegment';
  text: Scalars['String']['output'];
};

export type MolecularProfilesSort = {
  /** Available columns for sorting */
  column: MolecularProfilesSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum MolecularProfilesSortColumns {
  AssertionCount = 'assertionCount',
  EvidenceItemCount = 'evidenceItemCount',
  MolecularProfileScore = 'molecularProfileScore',
  VariantCount = 'variantCount'
}

export type Mutation = {
  __typename: 'Mutation';
  /**
   * Accept multiple revisions by ID. The accepting user must be an editor with a
   * valid conflict of interest statement on file and the revisions must not be
   * their own. The revisions must be for the same subject. The revisions may not
   * conflict, i.e. be for the same field.
   */
  acceptRevisions?: Maybe<AcceptRevisionsPayload>;
  /** Add a comment to any commentable entity. */
  addComment?: Maybe<AddCommentPayload>;
  /** Add a new disease to the database. */
  addDisease?: Maybe<AddDiseasePayload>;
  /**
   * Add a stub record for an external source that is not yet in CIViC.
   * This is for adding a new Source inline while performing other curation activities
   * such as adding new evidence items and is distinct from suggesting a source for curation.
   */
  addRemoteCitation?: Maybe<AddRemoteCitationPayload>;
  /** Add a new therapy to the database. */
  addTherapy?: Maybe<AddTherapyPayload>;
  /** Create a new Feature in the database. */
  createFeature?: Maybe<CreateFeaturePayload>;
  /** Create a new Fusion Feature in the database. */
  createFusionFeature?: Maybe<CreateFusionFeaturePayload>;
  /** Create a new Fusion Variant in the database. */
  createFusionVariant?: Maybe<CreateFusionVariantPayload>;
  /** Create a new Molecular Profile in order to attach Evidence Items to it. */
  createMolecularProfile?: Maybe<CreateMolecularProfilePayload>;
  /** Create a new Variant to the database. */
  createVariant?: Maybe<CreateVariantPayload>;
  /** Mark a comment as deleted. You can only delete your own comments. */
  deleteComment?: Maybe<DeleteCommentPayload>;
  /** Deprecate a complex molecular profile to prevent it from being used in the future. */
  deprecateComplexMolecularProfile?: Maybe<DeprecateComplexMolecularProfilePayload>;
  /**
   * Deprecate a feature to prevent it from being used in the future and implicitly
   * deprecate all the variants and molecular profiles linked to this feature.
   */
  deprecateFeature?: Maybe<DeprecateFeaturePayload>;
  /**
   * Deprecate a variant to prevent it from being used in the future and implicitly
   * deprecate all the molecular profiles linked to this variant.
   */
  deprecateVariant?: Maybe<DeprecateVariantPayload>;
  /** Updated currently logged in Users's profile */
  editUser?: Maybe<EditUserPayload>;
  /** Endorse an Assertion on behalf of an Organization */
  endorseAssertion?: Maybe<EndorseAssertionPayload>;
  /** Flag an entity to signal to the editorial team that you believe there is an issue with it. */
  flagEntity?: Maybe<FlagEntityPayload>;
  /** Generate a new API key for the current user. */
  generateApiKey?: Maybe<GenerateApiKeyPayload>;
  /** Perform moderation actions on an assertion such as accepting, rejecting, or reverting. */
  moderateAssertion?: Maybe<ModerateAssertionPayload>;
  /** Perform moderation actions on an evidence item such as accepting, rejecting, or reverting. */
  moderateEvidenceItem?: Maybe<ModerateEvidenceItemPayload>;
  /**
   * Reject one or more revisions by ID or revision set ID. Any user may reject a
   * Revision that they submitted themselves. Otherwise, the rejecting user must be
   * an editor with valid conflict of interest statement on file.
   */
  rejectRevisions?: Maybe<RejectRevisionsPayload>;
  /**
   * Resolve a flag on a CIViC entity indicating that it was either erroneously flagged or the issue has been resolved.
   * Any user may resolve their own flag however only editors with valid conflict
   * of interest statements can resolve other flags.
   */
  resolveFlag?: Maybe<ResolveFlagPayload>;
  /** Revoke an API key for the current user. */
  revokeApiKey?: Maybe<RevokeApiKeyPayload>;
  /** Revoke an endorsement of an Assertion on behalf of an Organization */
  revokeEndorsement?: Maybe<RevokeEndorsementPayload>;
  /** Propose adding a new Assertion to the CIViC database. */
  submitAssertion?: Maybe<SubmitAssertionPayload>;
  /** Propose adding a new EvidenceItem to the CIViC database. */
  submitEvidence?: Maybe<SubmitEvidenceItemPayload>;
  /** Create a new variant group. */
  submitVariantGroup?: Maybe<SubmitVariantGroupPayload>;
  /** Subscribe to a CIViC entity in order to receive notifications about it. */
  subscribe?: Maybe<SubscribePayload>;
  /** Suggest a Revision to an Assertion entity. */
  suggestAssertionRevision?: Maybe<SuggestAssertionRevisionPayload>;
  /** Suggest a Revision to an EvidenceItem entity. */
  suggestEvidenceItemRevision?: Maybe<SuggestEvidenceItemRevisionPayload>;
  /** Suggest a Revision to a Feature entity of instance type "Factor". */
  suggestFactorRevision?: Maybe<SuggestFactorRevisionPayload>;
  /** Suggest a Revision to a Variant entity. */
  suggestFactorVariantRevision?: Maybe<SuggestFactorVariantRevisionPayload>;
  /** Suggest a Revision to a Feature entity of instance type "Fusion". */
  suggestFusionRevision?: Maybe<SuggestFusionRevisionPayload>;
  /** Suggest a Revision to a Fusion entity. */
  suggestFusionVariantRevision?: Maybe<SuggestFusionVariantRevisionPayload>;
  /** Suggest a Revision to a Feature entity of instance type "Gene". */
  suggestGeneRevision?: Maybe<SuggestGeneRevisionPayload>;
  /** Suggest a Revision to a Variant entity. */
  suggestGeneVariantRevision?: Maybe<SuggestGeneVariantRevisionPayload>;
  /** Suggest a Revision to a MolecularProfile entity. */
  suggestMolecularProfileRevision?: Maybe<SuggestMolecularProfileRevisionPayload>;
  /** Suggest a source for curation in CIViC. */
  suggestSource?: Maybe<SuggestSourcePayload>;
  /** Suggested a Revision to a Variant Group entity */
  suggestVariantGroupRevision?: Maybe<SuggestVariantGroupRevisionPayload>;
  /** Unsubscribe from a CIViC entity to stop receiving notifications about it. */
  unsubscribe?: Maybe<UnsubscribePayload>;
  /** Update the currently logged in User's Conflict of Interest statement */
  updateCoi?: Maybe<UpdateCoiPayload>;
  /** Mark one or more notifications as read/unread. The notification IDs provided must belong to the requesting user. */
  updateNotificationStatus?: Maybe<UpdateNotificationStatusPayload>;
  /** Update the status of a SourceSuggestion by ID. The user updating the SourceSuggestion must be signed in. */
  updateSourceSuggestionStatus?: Maybe<UpdateSourceSuggestionStatusPayload>;
};


export type MutationAcceptRevisionsArgs = {
  input: AcceptRevisionsInput;
};


export type MutationAddCommentArgs = {
  input: AddCommentInput;
};


export type MutationAddDiseaseArgs = {
  input: AddDiseaseInput;
};


export type MutationAddRemoteCitationArgs = {
  input: AddRemoteCitationInput;
};


export type MutationAddTherapyArgs = {
  input: AddTherapyInput;
};


export type MutationCreateFeatureArgs = {
  input: CreateFeatureInput;
};


export type MutationCreateFusionFeatureArgs = {
  input: CreateFusionFeatureInput;
};


export type MutationCreateFusionVariantArgs = {
  input: CreateFusionVariantInput;
};


export type MutationCreateMolecularProfileArgs = {
  input: CreateMolecularProfileInput;
};


export type MutationCreateVariantArgs = {
  input: CreateVariantInput;
};


export type MutationDeleteCommentArgs = {
  input: DeleteCommentInput;
};


export type MutationDeprecateComplexMolecularProfileArgs = {
  input: DeprecateComplexMolecularProfileInput;
};


export type MutationDeprecateFeatureArgs = {
  input: DeprecateFeatureInput;
};


export type MutationDeprecateVariantArgs = {
  input: DeprecateVariantInput;
};


export type MutationEditUserArgs = {
  input: EditUserInput;
};


export type MutationEndorseAssertionArgs = {
  input: EndorseAssertionInput;
};


export type MutationFlagEntityArgs = {
  input: FlagEntityInput;
};


export type MutationGenerateApiKeyArgs = {
  input: GenerateApiKeyInput;
};


export type MutationModerateAssertionArgs = {
  input: ModerateAssertionInput;
};


export type MutationModerateEvidenceItemArgs = {
  input: ModerateEvidenceItemInput;
};


export type MutationRejectRevisionsArgs = {
  input: RejectRevisionsInput;
};


export type MutationResolveFlagArgs = {
  input: ResolveFlagInput;
};


export type MutationRevokeApiKeyArgs = {
  input: RevokeApiKeyInput;
};


export type MutationRevokeEndorsementArgs = {
  input: RevokeEndorsementInput;
};


export type MutationSubmitAssertionArgs = {
  input: SubmitAssertionInput;
};


export type MutationSubmitEvidenceArgs = {
  input: SubmitEvidenceItemInput;
};


export type MutationSubmitVariantGroupArgs = {
  input: SubmitVariantGroupInput;
};


export type MutationSubscribeArgs = {
  input: SubscribeInput;
};


export type MutationSuggestAssertionRevisionArgs = {
  input: SuggestAssertionRevisionInput;
};


export type MutationSuggestEvidenceItemRevisionArgs = {
  input: SuggestEvidenceItemRevisionInput;
};


export type MutationSuggestFactorRevisionArgs = {
  input: SuggestFactorRevisionInput;
};


export type MutationSuggestFactorVariantRevisionArgs = {
  input: SuggestFactorVariantRevisionInput;
};


export type MutationSuggestFusionRevisionArgs = {
  input: SuggestFusionRevisionInput;
};


export type MutationSuggestFusionVariantRevisionArgs = {
  input: SuggestFusionVariantRevisionInput;
};


export type MutationSuggestGeneRevisionArgs = {
  input: SuggestGeneRevisionInput;
};


export type MutationSuggestGeneVariantRevisionArgs = {
  input: SuggestGeneVariantRevisionInput;
};


export type MutationSuggestMolecularProfileRevisionArgs = {
  input: SuggestMolecularProfileRevisionInput;
};


export type MutationSuggestSourceArgs = {
  input: SuggestSourceInput;
};


export type MutationSuggestVariantGroupRevisionArgs = {
  input: SuggestVariantGroupRevisionInput;
};


export type MutationUnsubscribeArgs = {
  input: UnsubscribeInput;
};


export type MutationUpdateCoiArgs = {
  input: UpdateCoiInput;
};


export type MutationUpdateNotificationStatusArgs = {
  input: UpdateNotificationStatusInput;
};


export type MutationUpdateSourceSuggestionStatusArgs = {
  input: UpdateSourceSuggestionStatusInput;
};

export type MyChemInfo = {
  __typename: 'MyChemInfo';
  chebiDefinition?: Maybe<Scalars['String']['output']>;
  chebiId?: Maybe<Scalars['String']['output']>;
  chemblId?: Maybe<Scalars['String']['output']>;
  chemblMoleculeType?: Maybe<Scalars['String']['output']>;
  drugbankId?: Maybe<Scalars['String']['output']>;
  fdaEpcCodes: Array<FdaCode>;
  fdaMoaCodes: Array<FdaCode>;
  firstApproval?: Maybe<Scalars['String']['output']>;
  inchikey?: Maybe<Scalars['String']['output']>;
  indications: Array<Scalars['String']['output']>;
  pharmgkbId?: Maybe<Scalars['String']['output']>;
  pubchemCid?: Maybe<Scalars['String']['output']>;
  rxnorm?: Maybe<Scalars['String']['output']>;
};

export type MyDiseaseInfo = {
  __typename: 'MyDiseaseInfo';
  diseaseOntologyExactSynonyms: Array<Scalars['String']['output']>;
  diseaseOntologyRelatedSynonyms: Array<Scalars['String']['output']>;
  doDef?: Maybe<Scalars['String']['output']>;
  doDefCitations: Array<Scalars['String']['output']>;
  icd10?: Maybe<Scalars['String']['output']>;
  icdo?: Maybe<Scalars['String']['output']>;
  mesh?: Maybe<Scalars['String']['output']>;
  mondoDef?: Maybe<Scalars['String']['output']>;
  mondoId?: Maybe<Scalars['String']['output']>;
  ncit: Array<Scalars['String']['output']>;
  omim?: Maybe<Scalars['String']['output']>;
};

export type MyVariantInfo = {
  __typename: 'MyVariantInfo';
  caddConsequence: Array<Scalars['String']['output']>;
  caddDetail: Array<Scalars['String']['output']>;
  caddPhred?: Maybe<Scalars['Float']['output']>;
  caddScore?: Maybe<Scalars['Float']['output']>;
  clinvarClinicalSignificance: Array<Scalars['String']['output']>;
  clinvarHgvsCoding: Array<Scalars['String']['output']>;
  clinvarHgvsGenomic: Array<Scalars['String']['output']>;
  clinvarHgvsNonCoding: Array<Scalars['String']['output']>;
  clinvarHgvsProtein: Array<Scalars['String']['output']>;
  clinvarId?: Maybe<Scalars['Int']['output']>;
  clinvarOmim?: Maybe<Scalars['String']['output']>;
  cosmicId?: Maybe<Scalars['String']['output']>;
  dbnsfpInterproDomain: Array<Scalars['String']['output']>;
  dbsnpRsid?: Maybe<Scalars['String']['output']>;
  eglClass?: Maybe<Scalars['String']['output']>;
  eglHgvs: Array<Scalars['String']['output']>;
  eglProtein?: Maybe<Scalars['String']['output']>;
  eglTranscript?: Maybe<Scalars['String']['output']>;
  exacAlleleCount?: Maybe<Scalars['Int']['output']>;
  exacAlleleFrequency?: Maybe<Scalars['Float']['output']>;
  exacAlleleNumber?: Maybe<Scalars['Int']['output']>;
  fathmmMklPrediction?: Maybe<Scalars['String']['output']>;
  fathmmMklScore?: Maybe<Scalars['Float']['output']>;
  fathmmPrediction: Array<Scalars['String']['output']>;
  fathmmScore: Array<Scalars['Float']['output']>;
  fitconsScore?: Maybe<Scalars['Float']['output']>;
  gerp?: Maybe<Scalars['Float']['output']>;
  gnomadExomeAlleleCount?: Maybe<Scalars['Int']['output']>;
  gnomadExomeAlleleFrequency?: Maybe<Scalars['Float']['output']>;
  gnomadExomeAlleleNumber?: Maybe<Scalars['Int']['output']>;
  gnomadExomeFilter?: Maybe<Scalars['String']['output']>;
  gnomadGenomeAlleleCount?: Maybe<Scalars['Int']['output']>;
  gnomadGenomeAlleleFrequency?: Maybe<Scalars['Float']['output']>;
  gnomadGenomeAlleleNumber?: Maybe<Scalars['Int']['output']>;
  gnomadGenomeFilter?: Maybe<Scalars['String']['output']>;
  lrtPrediction?: Maybe<Scalars['String']['output']>;
  lrtScore?: Maybe<Scalars['Float']['output']>;
  metalrPrediction?: Maybe<Scalars['String']['output']>;
  metalrScore?: Maybe<Scalars['Float']['output']>;
  metasvmPrediction?: Maybe<Scalars['String']['output']>;
  metasvmScore?: Maybe<Scalars['Float']['output']>;
  mutationassessorPrediction: Array<Scalars['String']['output']>;
  mutationassessorScore: Array<Scalars['Float']['output']>;
  mutationtasterPrediction: Array<Scalars['String']['output']>;
  mutationtasterScore: Array<Scalars['Float']['output']>;
  myVariantInfoId: Scalars['String']['output'];
  phastcons30way?: Maybe<Scalars['Float']['output']>;
  phastcons100way?: Maybe<Scalars['Float']['output']>;
  phyloP30way?: Maybe<Scalars['Float']['output']>;
  phyloP100way?: Maybe<Scalars['Float']['output']>;
  polyphen2HdivPrediction: Array<Scalars['String']['output']>;
  polyphen2HdivScore: Array<Scalars['Float']['output']>;
  polyphen2HvarPrediction: Array<Scalars['String']['output']>;
  polyphen2HvarScore: Array<Scalars['Float']['output']>;
  proveanPrediction: Array<Scalars['String']['output']>;
  proveanScore: Array<Scalars['Float']['output']>;
  revelScore?: Maybe<Array<Scalars['Float']['output']>>;
  siftPrediction: Array<Scalars['String']['output']>;
  siftScore: Array<Scalars['Float']['output']>;
  siphy?: Maybe<Scalars['Float']['output']>;
  snpeffSnpEffect: Array<Scalars['String']['output']>;
  snpeffSnpImpact: Array<Scalars['String']['output']>;
};

export type NccnGuideline = {
  __typename: 'NccnGuideline';
  id: Scalars['Int']['output'];
  name: Scalars['String']['output'];
};

export type NcitDefinition = {
  __typename: 'NcitDefinition';
  definition: Scalars['String']['output'];
  source: Scalars['String']['output'];
};

export type NcitDetails = {
  __typename: 'NcitDetails';
  definitions: Array<NcitDefinition>;
  synonyms: Array<NcitSynonym>;
};

export type NcitSynonym = {
  __typename: 'NcitSynonym';
  name: Scalars['String']['output'];
  source: Scalars['String']['output'];
};

export type NewsItem = {
  __typename: 'NewsItem';
  contentHtml?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  publishedAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  title: Scalars['String']['output'];
};

export type Notification = {
  __typename: 'Notification';
  createdAt: Scalars['ISO8601DateTime']['output'];
  event: Event;
  id: Scalars['Int']['output'];
  notifiedUser: User;
  originatingUser: User;
  seen: Scalars['Boolean']['output'];
  subscription?: Maybe<Subscription>;
  type: NotificationReason;
  updatedAt: Scalars['ISO8601DateTime']['output'];
};

/** The connection type for Notification. */
export type NotificationConnection = {
  __typename: 'NotificationConnection';
  /** A list of edges. */
  edges: Array<NotificationEdge>;
  /** List of event types that have occurred on this entity. */
  eventTypes: Array<EventAction>;
  /** Users who have mentioned you. */
  mentioningUsers: Array<User>;
  /** A list of nodes. */
  nodes: Array<Notification>;
  /** List of subjects of the notifications in the stream */
  notificationSubjects: Array<EventSubjectWithCount>;
  /** List of all organizations who are involved in this notification stream. */
  organizations: Array<Organization>;
  /** Users who have performed an action (other than a mention) that created a notification. */
  originatingUsers: Array<User>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
  /** Count of unread notifications */
  unreadCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type NotificationEdge = {
  __typename: 'NotificationEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Notification>;
};

export enum NotificationReason {
  Mention = 'MENTION',
  Subscription = 'SUBSCRIPTION'
}

/**
 * An input object that represents a field value that can be "unset" or changed to null.
 * To change the field's value to null, pass unset as true, otherwise pass in the desired value as value.
 * This is to work around two issues with the GraphQL spec: lack of support for unions in input types
 * and the inability to have an input object argument be both required _and_ nullable at the same time.
 */
export type NullableAmpLevelTypeInput = {
  /** Set to true if you wish to set the field's value to null. */
  unset?: InputMaybe<Scalars['Boolean']['input']>;
  /** The desired value for the field. Mutually exclusive with unset. */
  value?: InputMaybe<AmpLevel>;
};

/**
 * An input object that represents a field value that can be "unset" or changed to null.
 * To change the field's value to null, pass unset as true, otherwise pass in the desired value as value.
 * This is to work around two issues with the GraphQL spec: lack of support for unions in input types
 * and the inability to have an input object argument be both required _and_ nullable at the same time.
 */
export type NullableAreaOfExpertiseTypeInput = {
  /** Set to true if you wish to set the field's value to null. */
  unset?: InputMaybe<Scalars['Boolean']['input']>;
  /** The desired value for the field. Mutually exclusive with unset. */
  value?: InputMaybe<AreaOfExpertise>;
};

/**
 * An input object that represents a field value that can be "unset" or changed to null.
 * To change the field's value to null, pass unset as true, otherwise pass in the desired value as value.
 * This is to work around two issues with the GraphQL spec: lack of support for unions in input types
 * and the inability to have an input object argument be both required _and_ nullable at the same time.
 */
export type NullableBooleanInput = {
  /** Set to true if you wish to set the field's value to null. */
  unset?: InputMaybe<Scalars['Boolean']['input']>;
  /** The desired value for the field. Mutually exclusive with unset. */
  value?: InputMaybe<Scalars['Boolean']['input']>;
};

/**
 * An input object that represents a field value that can be "unset" or changed to null.
 * To change the field's value to null, pass unset as true, otherwise pass in the desired value as value.
 * This is to work around two issues with the GraphQL spec: lack of support for unions in input types
 * and the inability to have an input object argument be both required _and_ nullable at the same time.
 */
export type NullableIdInput = {
  /** Set to true if you wish to set the field's value to null. */
  unset?: InputMaybe<Scalars['Boolean']['input']>;
  /** The desired value for the field. Mutually exclusive with unset. */
  value?: InputMaybe<Scalars['ID']['input']>;
};

/**
 * An input object that represents a field value that can be "unset" or changed to null.
 * To change the field's value to null, pass unset as true, otherwise pass in the desired value as value.
 * This is to work around two issues with the GraphQL spec: lack of support for unions in input types
 * and the inability to have an input object argument be both required _and_ nullable at the same time.
 */
export type NullableIntInput = {
  /** Set to true if you wish to set the field's value to null. */
  unset?: InputMaybe<Scalars['Boolean']['input']>;
  /** The desired value for the field. Mutually exclusive with unset. */
  value?: InputMaybe<Scalars['Int']['input']>;
};

/**
 * An input object that represents a field value that can be "unset" or changed to null.
 * To change the field's value to null, pass unset as true, otherwise pass in the desired value as value.
 * This is to work around two issues with the GraphQL spec: lack of support for unions in input types
 * and the inability to have an input object argument be both required _and_ nullable at the same time.
 */
export type NullableStringInput = {
  /** Set to true if you wish to set the field's value to null. */
  unset?: InputMaybe<Scalars['Boolean']['input']>;
  /** The desired value for the field. Mutually exclusive with unset. */
  value?: InputMaybe<Scalars['String']['input']>;
};

/**
 * An input object that represents a field value that can be "unset" or changed to null.
 * To change the field's value to null, pass unset as true, otherwise pass in the desired value as value.
 * This is to work around two issues with the GraphQL spec: lack of support for unions in input types
 * and the inability to have an input object argument be both required _and_ nullable at the same time.
 */
export type NullableTherapyInteractionTypeInput = {
  /** Set to true if you wish to set the field's value to null. */
  unset?: InputMaybe<Scalars['Boolean']['input']>;
  /** The desired value for the field. Mutually exclusive with unset. */
  value?: InputMaybe<TherapyInteraction>;
};

export type ObjectField = {
  __typename: 'ObjectField';
  objects: Array<ModeratedObjectField>;
};

export type ObjectFieldDiff = {
  __typename: 'ObjectFieldDiff';
  addedObjects: Array<ModeratedObjectField>;
  currentObjects: Array<ModeratedObjectField>;
  keptObjects: Array<ModeratedObjectField>;
  removedObjects: Array<ModeratedObjectField>;
  suggestedObjects: Array<ModeratedObjectField>;
};

export type OntologyTermSearchInput = {
  operator: OntologyTermSearchOperator;
  value: Scalars['String']['input'];
};

export enum OntologyTermSearchOperator {
  /** Equals */
  Eq = 'EQ',
  /** Include the matched term and any child terms */
  EqSelfOrChildren = 'EQ_SELF_OR_CHILDREN',
  /** Include the matched term and its parent term */
  EqSelfOrParent = 'EQ_SELF_OR_PARENT',
  /** Does not equal */
  Ne = 'NE'
}

export type Organization = {
  __typename: 'Organization';
  canEndorse: Scalars['Boolean']['output'];
  description: Scalars['String']['output'];
  eventCount: Scalars['Int']['output'];
  events: EventConnection;
  hasEndorsingSubgroups: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  isApprovedVcep: Scalars['Boolean']['output'];
  memberCount: Scalars['Int']['output'];
  members: UserConnection;
  mostRecentActivityTimestamp?: Maybe<Scalars['ISO8601DateTime']['output']>;
  name: Scalars['String']['output'];
  orgAndSuborgsStatsHash: Stats;
  orgStatsHash: Stats;
  profileImagePath?: Maybe<Scalars['String']['output']>;
  ranks: Ranks;
  subGroups: Array<Organization>;
  url: Scalars['String']['output'];
};


export type OrganizationEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type OrganizationMembersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type OrganizationProfileImagePathArgs = {
  size?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for Organization. */
export type OrganizationConnection = {
  __typename: 'OrganizationConnection';
  /** A list of edges. */
  edges: Array<OrganizationEdge>;
  /** A list of nodes. */
  nodes: Array<Organization>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type OrganizationEdge = {
  __typename: 'OrganizationEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Organization>;
};

/** Filter on organization id and whether or not to include the organization's subgroups */
export type OrganizationFilter = {
  /** An array of Organization IDs. If any ID matches, the result will be returned. */
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  /** Whether or not to include the organization's subgroup. */
  includeSubgroups?: InputMaybe<Scalars['Boolean']['input']>;
  /** The organization name. */
  name?: InputMaybe<Scalars['String']['input']>;
};

export type OrganizationLeaderboards = {
  __typename: 'OrganizationLeaderboards';
  commentsLeaderboard: LeaderboardOrganizationConnection;
  moderationLeaderboard: LeaderboardOrganizationConnection;
  revisionsLeaderboard: LeaderboardOrganizationConnection;
  submissionsLeaderboard: LeaderboardOrganizationConnection;
};


export type OrganizationLeaderboardsCommentsLeaderboardArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  direction?: InputMaybe<SortDirection>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  window?: InputMaybe<TimeWindow>;
};


export type OrganizationLeaderboardsModerationLeaderboardArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  direction?: InputMaybe<SortDirection>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  window?: InputMaybe<TimeWindow>;
};


export type OrganizationLeaderboardsRevisionsLeaderboardArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  direction?: InputMaybe<SortDirection>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  window?: InputMaybe<TimeWindow>;
};


export type OrganizationLeaderboardsSubmissionsLeaderboardArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  direction?: InputMaybe<SortDirection>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  window?: InputMaybe<TimeWindow>;
};

export type OrganizationSort = {
  /** Available columns for sorting */
  column: OrganizationSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum OrganizationSortColumns {
  ActivityCount = 'ACTIVITY_COUNT',
  Id = 'ID',
  MemberCount = 'MEMBER_COUNT',
  MostRecentActivityTimestamp = 'MOST_RECENT_ACTIVITY_TIMESTAMP',
  Name = 'NAME'
}

/** Information about pagination in a connection. */
export type PageInfo = {
  __typename: 'PageInfo';
  /** When paginating forwards, the cursor to continue. */
  endCursor?: Maybe<Scalars['String']['output']>;
  /** When paginating forwards, are there more items? */
  hasNextPage: Scalars['Boolean']['output'];
  /** When paginating backwards, are there more items? */
  hasPreviousPage: Scalars['Boolean']['output'];
  /** When paginating backwards, the cursor to continue. */
  startCursor?: Maybe<Scalars['String']['output']>;
};

export type Phenotype = {
  __typename: 'Phenotype';
  description?: Maybe<Scalars['String']['output']>;
  hpoId: Scalars['String']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  url: Scalars['String']['output'];
};

/** The connection type for Phenotype. */
export type PhenotypeConnection = {
  __typename: 'PhenotypeConnection';
  /** A list of edges. */
  edges: Array<PhenotypeEdge>;
  /** A list of nodes. */
  nodes: Array<Phenotype>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type PhenotypeEdge = {
  __typename: 'PhenotypeEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Phenotype>;
};

export type PhenotypePopover = {
  __typename: 'PhenotypePopover';
  assertionCount: Scalars['Int']['output'];
  description?: Maybe<Scalars['String']['output']>;
  evidenceItemCount: Scalars['Int']['output'];
  hpoId: Scalars['String']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  molecularProfileCount: Scalars['Int']['output'];
  name: Scalars['String']['output'];
  url: Scalars['String']['output'];
};

export type PhenotypeSearchFilter = {
  booleanOperator?: InputMaybe<BooleanOperator>;
  description?: InputMaybe<StringSearchInput>;
  hpoId?: InputMaybe<StringSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  name?: InputMaybe<StringSearchInput>;
  subFilters?: InputMaybe<Array<PhenotypeSearchFilter>>;
};

export type PhenotypeSort = {
  /** Available columns for sorting */
  column: PhenotypeSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum PhenotypeSortColumns {
  AssertionCount = 'ASSERTION_COUNT',
  EvidenceItemCount = 'EVIDENCE_ITEM_COUNT',
  HpoId = 'HPO_ID',
  Name = 'NAME'
}

export type Query = {
  __typename: 'Query';
  /** Find an ACMG code by CIViC ID */
  acmgCode?: Maybe<AcmgCode>;
  /** Retrieve ACMG Code options as a typeahead */
  acmgCodesTypeahead: Array<AcmgCode>;
  /** List and filter activities */
  activities: ActivityInterfaceConnection;
  /** Find a CIViC activity record by CIViC ID */
  activity?: Maybe<ActivityInterface>;
  /** Find an assertion by CIViC ID */
  assertion?: Maybe<Assertion>;
  /** List and filter assertions. */
  assertions: AssertionConnection;
  browseDiseases: BrowseDiseaseConnection;
  browseFeatures: BrowseFeatureConnection;
  browseMolecularProfiles: BrowseMolecularProfileConnection;
  /** List and filter organizations. */
  browseOrganizations: BrowseOrganizationConnection;
  browsePhenotypes: BrowsePhenotypeConnection;
  browseSources: BrowseSourceConnection;
  browseTherapies: BrowseTherapyConnection;
  /** List and filter users. */
  browseUsers: BrowseUserConnection;
  browseVariantGroups: BrowseVariantGroupConnection;
  browseVariants: BrowseVariantConnection;
  /** Find a ClinGen code by CIViC ID */
  clingenCode?: Maybe<ClingenCode>;
  /** Retrieve Clingen Code options as a typeahead */
  clingenCodesTypeahead: Array<ClingenCode>;
  /** Find a clinical trial by CIViC ID */
  clinicalTrial?: Maybe<ClinicalTrial>;
  /** List and filter Clinical Trials from ClinicalTrials.gov. */
  clinicalTrials: BrowseClinicalTrialConnection;
  /** Find a comment by CIViC ID */
  comment?: Maybe<Comment>;
  /** List and filter comments. */
  comments: CommentConnection;
  contributors: ContributingUsersSummary;
  /** Fetch a list of countries for user profiles. */
  countries: Array<Country>;
  dataReleases: Array<DataRelease>;
  /** Find a disease by CIViC ID */
  disease?: Maybe<Disease>;
  /** Retrieve popover fields for a specific disease. */
  diseasePopover?: Maybe<DiseasePopover>;
  /** Retrieve disease typeahead fields for a search term. */
  diseaseTypeahead: Array<Disease>;
  diseases: DiseaseConnection;
  /** List and filter endorsements. */
  endorsements: EndorsementConnection;
  /** Retrieve entity type typeahead fields for a entity mention search term. */
  entityTypeahead: Array<CommentTagSegment>;
  /** List and filter events for an object */
  events: EventConnection;
  /** Find an evidence item by CIViC ID */
  evidenceItem?: Maybe<EvidenceItem>;
  /** List and filter evidence items. */
  evidenceItems: EvidenceItemConnection;
  /** Find a single gene by CIViC ID or NCIt ID */
  factor?: Maybe<Factor>;
  /** List and filter factors. */
  factors: FactorConnection;
  /** Find a single feature by CIViC ID */
  feature?: Maybe<Feature>;
  /** Retrieve Features of a specific instance type for a search term. */
  featureTypeahead: Array<Feature>;
  /** Find a flag by CIViC ID */
  flag?: Maybe<Flag>;
  /** List and filter flags. */
  flags: FlagConnection;
  /** Find a single gene by CIViC ID */
  fusion?: Maybe<Fusion>;
  /** List and filter fusions. */
  fusions: FusionConnection;
  /** Find a single gene by CIViC ID or Entrez symbol */
  gene?: Maybe<Gene>;
  /** List and filter genes. */
  genes: GeneConnection;
  /** Find a molecular profile by CIViC ID */
  molecularProfile?: Maybe<MolecularProfile>;
  /** List and filter molecular profiles. */
  molecularProfiles: MolecularProfileConnection;
  /** Find a NCCN Guideline by CIViC ID */
  nccnGuideline?: Maybe<NccnGuideline>;
  /** Retrieve NCCN Guideline options as a typeahead */
  nccnGuidelinesTypeahead: Array<NccnGuideline>;
  newsItems: Array<NewsItem>;
  /** List and filter notifications for the logged in user. */
  notifications: NotificationConnection;
  /** Find an organization by CIViC ID */
  organization?: Maybe<Organization>;
  organizationLeaderboards: OrganizationLeaderboards;
  /** List and filter organizations. */
  organizations: OrganizationConnection;
  /** Find a phenotype by CIViC ID */
  phenotype?: Maybe<Phenotype>;
  /** Retrieve popover fields for a specific phenotype. */
  phenotypePopover?: Maybe<PhenotypePopover>;
  /** Retrieve phenotype typeahead fields for a search term. */
  phenotypeTypeahead: Array<Phenotype>;
  /** List and filter Phenotypes from the Human Phenotype Ontology. */
  phenotypes: PhenotypeConnection;
  previewCommentText: Array<CommentBodySegment>;
  previewMolecularProfileName: MolecularProfileNamePreview;
  /** Check to see if a citation ID for a source not already in CIViC exists in an external database. */
  remoteCitation?: Maybe<Scalars['String']['output']>;
  /** Find a revision by CIViC ID */
  revision?: Maybe<Revision>;
  /** List and filter revisions. */
  revisions: RevisionConnection;
  search: Array<SearchResult>;
  searchAssertions: AdvancedSearchResult;
  searchByPermalink: AdvancedSearchResult;
  searchDiseases: AdvancedSearchResult;
  searchEvidenceItems: AdvancedSearchResult;
  searchFeatures: AdvancedSearchResult;
  searchMolecularProfiles: AdvancedSearchResult;
  searchPhenotypes: AdvancedSearchResult;
  searchSources: AdvancedSearchResult;
  searchTherapies: AdvancedSearchResult;
  searchVariantTypes: AdvancedSearchResult;
  searchVariants: AdvancedSearchResult;
  /** Find a source by CIViC ID */
  source?: Maybe<Source>;
  /** Retrieve popover fields for a specific source. */
  sourcePopover?: Maybe<SourcePopover>;
  /** Given the parameters in a source suggestion, fetch the values to populate the add evidence form */
  sourceSuggestionValues: SourceSuggestionValues;
  sourceSuggestions: SourceSuggestionConnection;
  /** Provide suggestions for sources based on a partial citation ID */
  sourceTypeahead: Array<Source>;
  /** List and filter sources. */
  sources: SourceConnection;
  /** Get the active subscription for the entity and logged in user, if any */
  subscriptionForEntity?: Maybe<Subscription>;
  /** List and filter Therapies from the NCI Thesaurus. */
  therapies: TherapyConnection;
  /** Find a therapy by CIViC ID */
  therapy?: Maybe<Therapy>;
  /** Retrieve popover fields for a specific therapy. */
  therapyPopover?: Maybe<TherapyPopover>;
  /** Retrieve therapy typeahead fields for a search term. */
  therapyTypeahead: Array<Therapy>;
  timepointStats: CivicTimepointStats;
  user?: Maybe<User>;
  userLeaderboards: UserLeaderboards;
  /** Retrieve user type typeahead fields for a search term. */
  userTypeahead: Array<User>;
  /** List and filter users. */
  users: UserConnection;
  validateRevisionsForAcceptance: ValidationErrors;
  /** Find a variant by CIViC ID */
  variant?: Maybe<VariantInterface>;
  /** Find a variant group by CIViC ID */
  variantGroup?: Maybe<VariantGroup>;
  /** List and filter variant groups. */
  variantGroups: VariantGroupConnection;
  /** Find a variant type by CIViC ID */
  variantType?: Maybe<VariantType>;
  /** Retrieve popover fields for a specific variant type. */
  variantTypePopover?: Maybe<VariantTypePopover>;
  /** Retrieve variant type typeahead fields for a search term. */
  variantTypeTypeahead: Array<VariantType>;
  /** List and filter Variant Types from the Sequence Ontology. */
  variantTypes: BrowseVariantTypeConnection;
  /** List and filter variants. */
  variants: VariantInterfaceConnection;
  variantsTypeahead: Array<Variant>;
  viewer?: Maybe<User>;
};


export type QueryAcmgCodeArgs = {
  id: Scalars['Int']['input'];
};


export type QueryAcmgCodesTypeaheadArgs = {
  queryTerm: Scalars['String']['input'];
};


export type QueryActivitiesArgs = {
  activityType?: InputMaybe<Array<ActivityTypeInput>>;
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeAutomatedEvents?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  linkedEndorsementId?: InputMaybe<Scalars['Int']['input']>;
  mode?: InputMaybe<EventFeedMode>;
  occurredAfter?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
  occurredBefore?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
  organization?: InputMaybe<OrganizationFilter>;
  sortBy?: InputMaybe<DateSort>;
  subject?: InputMaybe<Array<SubscribableQueryInput>>;
  subjectType?: InputMaybe<Array<ActivitySubjectInput>>;
  userId?: InputMaybe<Array<Scalars['Int']['input']>>;
};


export type QueryActivityArgs = {
  id: Scalars['Int']['input'];
};


export type QueryAssertionArgs = {
  id: Scalars['Int']['input'];
};


export type QueryAssertionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  ampLevel?: InputMaybe<AmpLevel>;
  assertionDirection?: InputMaybe<EvidenceDirection>;
  assertionType?: InputMaybe<EvidenceType>;
  before?: InputMaybe<Scalars['String']['input']>;
  diseaseId?: InputMaybe<Scalars['Int']['input']>;
  diseaseName?: InputMaybe<Scalars['String']['input']>;
  endorsingOrganizations?: InputMaybe<OrganizationFilter>;
  evidenceId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  molecularProfileId?: InputMaybe<Scalars['Int']['input']>;
  molecularProfileName?: InputMaybe<Scalars['String']['input']>;
  organization?: InputMaybe<OrganizationFilter>;
  phenotypeId?: InputMaybe<Scalars['Int']['input']>;
  significance?: InputMaybe<EvidenceSignificance>;
  sortBy?: InputMaybe<AssertionSort>;
  status?: InputMaybe<EvidenceStatusFilter>;
  summary?: InputMaybe<Scalars['String']['input']>;
  therapyId?: InputMaybe<Scalars['Int']['input']>;
  therapyName?: InputMaybe<Scalars['String']['input']>;
  userId?: InputMaybe<Scalars['Int']['input']>;
  variantId?: InputMaybe<Scalars['Int']['input']>;
  variantName?: InputMaybe<Scalars['String']['input']>;
};


export type QueryBrowseDiseasesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  diseaseAlias?: InputMaybe<Scalars['String']['input']>;
  doid?: InputMaybe<Scalars['String']['input']>;
  featureName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<DiseasesSort>;
};


export type QueryBrowseFeaturesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  diseaseName?: InputMaybe<Scalars['String']['input']>;
  featureAlias?: InputMaybe<Scalars['String']['input']>;
  featureFullName?: InputMaybe<Scalars['String']['input']>;
  featureName?: InputMaybe<Scalars['String']['input']>;
  featureType?: InputMaybe<FeatureInstanceTypes>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<FeaturesSort>;
  therapyName?: InputMaybe<Scalars['String']['input']>;
};


export type QueryBrowseMolecularProfilesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  diseaseName?: InputMaybe<Scalars['String']['input']>;
  featureName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  molecularProfileAlias?: InputMaybe<Scalars['String']['input']>;
  molecularProfileName?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<MolecularProfilesSort>;
  therapyName?: InputMaybe<Scalars['String']['input']>;
  variantId?: InputMaybe<Scalars['Int']['input']>;
  variantName?: InputMaybe<Scalars['String']['input']>;
};


export type QueryBrowseOrganizationsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<OrganizationSort>;
};


export type QueryBrowsePhenotypesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  hpoId?: InputMaybe<Scalars['String']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<PhenotypeSort>;
};


export type QueryBrowseSourcesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  author?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  citationId?: InputMaybe<Scalars['Int']['input']>;
  clinicalTrialId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  journal?: InputMaybe<Scalars['String']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  openAccess?: InputMaybe<Scalars['Boolean']['input']>;
  sortBy?: InputMaybe<SourcesSort>;
  sourceType?: InputMaybe<SourceSource>;
  year?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryBrowseTherapiesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  ncitId?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<TherapySort>;
  therapyAlias?: InputMaybe<Scalars['String']['input']>;
};


export type QueryBrowseUsersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  organization?: InputMaybe<OrganizationFilter>;
  role?: InputMaybe<UserRole>;
  sortBy?: InputMaybe<UsersSort>;
  username?: InputMaybe<Scalars['String']['input']>;
};


export type QueryBrowseVariantGroupsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  featureNames?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<VariantGroupsSort>;
  variantNames?: InputMaybe<Scalars['String']['input']>;
};


export type QueryBrowseVariantsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  category?: InputMaybe<VariantCategories>;
  diseaseName?: InputMaybe<Scalars['String']['input']>;
  featureName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  hasNoVariantType?: InputMaybe<Scalars['Boolean']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<VariantsSort>;
  therapyName?: InputMaybe<Scalars['String']['input']>;
  variantAlias?: InputMaybe<Scalars['String']['input']>;
  variantGroupId?: InputMaybe<Scalars['Int']['input']>;
  variantName?: InputMaybe<Scalars['String']['input']>;
  variantTypeId?: InputMaybe<Scalars['Int']['input']>;
  variantTypeName?: InputMaybe<Scalars['String']['input']>;
};


export type QueryClingenCodeArgs = {
  id: Scalars['Int']['input'];
};


export type QueryClingenCodesTypeaheadArgs = {
  queryTerm: Scalars['String']['input'];
};


export type QueryClinicalTrialArgs = {
  id: Scalars['Int']['input'];
};


export type QueryClinicalTrialsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  nctId?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<ClinicalTrialSort>;
};


export type QueryCommentArgs = {
  id: Scalars['Int']['input'];
};


export type QueryCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  subject?: InputMaybe<CommentableInput>;
};


export type QueryContributorsArgs = {
  subscribable: SubscribableInput;
};


export type QueryDiseaseArgs = {
  id: Scalars['Int']['input'];
};


export type QueryDiseasePopoverArgs = {
  id: Scalars['Int']['input'];
};


export type QueryDiseaseTypeaheadArgs = {
  queryTerm: Scalars['String']['input'];
};


export type QueryDiseasesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  doid?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
};


export type QueryEndorsementsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  endorsedAssertionId?: InputMaybe<Scalars['Int']['input']>;
  endorsingOrganizationId?: InputMaybe<Scalars['Int']['input']>;
  endorsingOrganizationIsApprovedVcep?: InputMaybe<Scalars['Boolean']['input']>;
  endorsingUserId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<EndorsementStatus>;
};


export type QueryEntityTypeaheadArgs = {
  queryTerm: Scalars['String']['input'];
};


export type QueryEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  includeAutomatedEvents?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mode?: InputMaybe<EventFeedMode>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  subject?: InputMaybe<SubscribableQueryInput>;
};


export type QueryEvidenceItemArgs = {
  id: Scalars['Int']['input'];
};


export type QueryEvidenceItemsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  assertionId?: InputMaybe<Scalars['Int']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  clinicalTrialId?: InputMaybe<Scalars['Int']['input']>;
  description?: InputMaybe<Scalars['String']['input']>;
  diseaseId?: InputMaybe<Scalars['Int']['input']>;
  diseaseName?: InputMaybe<Scalars['String']['input']>;
  evidenceDirection?: InputMaybe<EvidenceDirection>;
  evidenceLevel?: InputMaybe<EvidenceLevel>;
  evidenceRating?: InputMaybe<Scalars['Int']['input']>;
  evidenceType?: InputMaybe<EvidenceType>;
  first?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  molecularProfileId?: InputMaybe<Scalars['Int']['input']>;
  molecularProfileName?: InputMaybe<Scalars['String']['input']>;
  organization?: InputMaybe<OrganizationFilter>;
  phenotypeId?: InputMaybe<Scalars['Int']['input']>;
  significance?: InputMaybe<EvidenceSignificance>;
  sortBy?: InputMaybe<EvidenceSort>;
  sourceId?: InputMaybe<Scalars['Int']['input']>;
  status?: InputMaybe<EvidenceStatusFilter>;
  therapyId?: InputMaybe<Scalars['Int']['input']>;
  therapyName?: InputMaybe<Scalars['String']['input']>;
  userId?: InputMaybe<Scalars['Int']['input']>;
  variantId?: InputMaybe<Scalars['Int']['input']>;
  variantOrigin?: InputMaybe<VariantOrigin>;
};


export type QueryFactorArgs = {
  id?: InputMaybe<Scalars['Int']['input']>;
  ncitId?: InputMaybe<Scalars['String']['input']>;
};


export type QueryFactorsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  evidenceStatusFilter?: InputMaybe<AssociatedEvidenceStatusFilter>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Array<Scalars['String']['input']>>;
  ncitIt?: InputMaybe<Array<Scalars['String']['input']>>;
};


export type QueryFeatureArgs = {
  id?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryFeatureTypeaheadArgs = {
  featureType?: InputMaybe<FeatureInstanceTypes>;
  queryTerm: Scalars['String']['input'];
};


export type QueryFlagArgs = {
  id: Scalars['Int']['input'];
};


export type QueryFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggable?: InputMaybe<FlaggableInput>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


export type QueryFusionArgs = {
  id?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryFusionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  evidenceStatusFilter?: InputMaybe<AssociatedEvidenceStatusFilter>;
  first?: InputMaybe<Scalars['Int']['input']>;
  genePartnerId?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryGeneArgs = {
  entrezSymbol?: InputMaybe<Scalars['String']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryGenesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  entrezIds?: InputMaybe<Array<Scalars['Int']['input']>>;
  entrezSymbols?: InputMaybe<Array<Scalars['String']['input']>>;
  evidenceStatusFilter?: InputMaybe<AssociatedEvidenceStatusFilter>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryMolecularProfileArgs = {
  id: Scalars['Int']['input'];
};


export type QueryMolecularProfilesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  alleleRegistryId?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  evidenceStatusFilter?: InputMaybe<AssociatedEvidenceStatusFilter>;
  featureId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  geneId?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  variantId?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryNccnGuidelineArgs = {
  id: Scalars['Int']['input'];
};


export type QueryNccnGuidelinesTypeaheadArgs = {
  queryTerm: Scalars['String']['input'];
};


export type QueryNotificationsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeRead?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  notificationReason?: InputMaybe<NotificationReason>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingObject?: InputMaybe<SubscribableInput>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  subscriptionId?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryOrganizationArgs = {
  id: Scalars['Int']['input'];
};


export type QueryOrganizationsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
};


export type QueryPhenotypeArgs = {
  id: Scalars['Int']['input'];
};


export type QueryPhenotypePopoverArgs = {
  id: Scalars['Int']['input'];
};


export type QueryPhenotypeTypeaheadArgs = {
  queryTerm: Scalars['String']['input'];
};


export type QueryPhenotypesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  hpoId?: InputMaybe<Scalars['String']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
};


export type QueryPreviewCommentTextArgs = {
  commentText: Scalars['String']['input'];
};


export type QueryPreviewMolecularProfileNameArgs = {
  structure?: InputMaybe<MolecularProfileComponentInput>;
};


export type QueryRemoteCitationArgs = {
  citationId: Scalars['String']['input'];
  sourceType: SourceSource;
};


export type QueryRevisionArgs = {
  id: Scalars['Int']['input'];
};


export type QueryRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
  subject?: InputMaybe<ModeratedInput>;
};


export type QuerySearchArgs = {
  highlightMatches?: InputMaybe<Scalars['Boolean']['input']>;
  query: Scalars['String']['input'];
  types?: InputMaybe<Array<SearchableEntities>>;
};


export type QuerySearchAssertionsArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: AssertionSearchFilter;
};


export type QuerySearchByPermalinkArgs = {
  permalinkId: Scalars['String']['input'];
};


export type QuerySearchDiseasesArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: DiseaseSearchFilter;
};


export type QuerySearchEvidenceItemsArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: EvidenceItemSearchFilter;
};


export type QuerySearchFeaturesArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: FeatureSearchFilter;
};


export type QuerySearchMolecularProfilesArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: MolecularProfileSearchFilter;
};


export type QuerySearchPhenotypesArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: PhenotypeSearchFilter;
};


export type QuerySearchSourcesArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: SourceSearchFilter;
};


export type QuerySearchTherapiesArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: TherapySearchFilter;
};


export type QuerySearchVariantTypesArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: VariantTypeSearchFilter;
};


export type QuerySearchVariantsArgs = {
  createPermalink?: InputMaybe<Scalars['Boolean']['input']>;
  query: VariantSearchFilter;
};


export type QuerySourceArgs = {
  id: Scalars['Int']['input'];
};


export type QuerySourcePopoverArgs = {
  id: Scalars['Int']['input'];
};


export type QuerySourceSuggestionValuesArgs = {
  diseaseId?: InputMaybe<Scalars['Int']['input']>;
  molecularProfileId?: InputMaybe<Scalars['Int']['input']>;
  sourceId?: InputMaybe<Scalars['Int']['input']>;
};


export type QuerySourceSuggestionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  citation?: InputMaybe<Scalars['String']['input']>;
  citationId?: InputMaybe<Scalars['Int']['input']>;
  comment?: InputMaybe<Scalars['String']['input']>;
  diseaseName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  molecularProfileName?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<SourceSuggestionsSort>;
  sourceId?: InputMaybe<Scalars['Int']['input']>;
  sourceType?: InputMaybe<SourceSource>;
  status?: InputMaybe<SourceSuggestionStatus>;
  submitter?: InputMaybe<Scalars['String']['input']>;
  submitterId?: InputMaybe<Scalars['Int']['input']>;
};


export type QuerySourceTypeaheadArgs = {
  citationId: Scalars['String']['input'];
  sourceType: SourceSource;
};


export type QuerySourcesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  citationId?: InputMaybe<Array<Scalars['String']['input']>>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type QuerySubscriptionForEntityArgs = {
  subscribable: SubscribableInput;
};


export type QueryTherapiesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  hasLinkedEvidence?: InputMaybe<Scalars['Boolean']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  ncitId?: InputMaybe<Scalars['String']['input']>;
  therapyAlias?: InputMaybe<Scalars['String']['input']>;
};


export type QueryTherapyArgs = {
  id: Scalars['Int']['input'];
};


export type QueryTherapyPopoverArgs = {
  id: Scalars['Int']['input'];
};


export type QueryTherapyTypeaheadArgs = {
  queryTerm: Scalars['String']['input'];
};


export type QueryUserArgs = {
  id: Scalars['Int']['input'];
};


export type QueryUserTypeaheadArgs = {
  queryTerm: Scalars['String']['input'];
};


export type QueryUsersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  organization?: InputMaybe<OrganizationFilter>;
  role?: InputMaybe<UserRole>;
  username?: InputMaybe<Scalars['String']['input']>;
};


export type QueryValidateRevisionsForAcceptanceArgs = {
  revisionIds: Array<Scalars['Int']['input']>;
};


export type QueryVariantArgs = {
  id: Scalars['Int']['input'];
};


export type QueryVariantGroupArgs = {
  id: Scalars['Int']['input'];
};


export type QueryVariantGroupsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type QueryVariantTypeArgs = {
  id: Scalars['Int']['input'];
};


export type QueryVariantTypePopoverArgs = {
  id: Scalars['Int']['input'];
};


export type QueryVariantTypeTypeaheadArgs = {
  queryTerm: Scalars['String']['input'];
};


export type QueryVariantTypesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  featureId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  geneId?: InputMaybe<Scalars['Int']['input']>;
  id?: InputMaybe<Scalars['Int']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  soid?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<VariantTypeSort>;
};


export type QueryVariantsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  alleleRegistryId?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  category?: InputMaybe<VariantCategories>;
  factorId?: InputMaybe<Scalars['Int']['input']>;
  featureId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  geneId?: InputMaybe<Scalars['Int']['input']>;
  hasNoVariantType?: InputMaybe<Scalars['Boolean']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<VariantMenuSort>;
  variantTypeIds?: InputMaybe<Array<Scalars['Int']['input']>>;
};


export type QueryVariantsTypeaheadArgs = {
  featureId?: InputMaybe<Scalars['Int']['input']>;
  queryTerm: Scalars['String']['input'];
};

export type Ranks = {
  __typename: 'Ranks';
  commentsRank?: Maybe<LeaderboardRank>;
  moderationRank?: Maybe<LeaderboardRank>;
  revisionsRank?: Maybe<LeaderboardRank>;
  submissionsRank?: Maybe<LeaderboardRank>;
};

export enum ReadStatus {
  Read = 'READ',
  Unread = 'UNREAD'
}

export enum ReferenceBuild {
  Grch37 = 'GRCH37',
  Grch38 = 'GRCH38',
  Ncbi36 = 'NCBI36'
}

export type RejectRevisionsActivity = ActivityInterface & {
  __typename: 'RejectRevisionsActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  revisions: Array<Revision>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of RejectRevisions */
export type RejectRevisionsInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text explaining the reasoning for rejecting this Revision. Will be attached as a comment. */
  comment: Scalars['String']['input'];
  /** A list of IDs of the Revisions to reject. */
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** The ID of a revision set. */
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of RejectRevisions. */
export type RejectRevisionsPayload = {
  __typename: 'RejectRevisionsPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The rejected Revisions. */
  revisions: Array<Revision>;
};

export type ResolveFlagActivity = ActivityInterface & {
  __typename: 'ResolveFlagActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  flag: Flag;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of ResolveFlag */
export type ResolveFlagInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for resolving the flag. Will be attached as a comment. */
  comment: Scalars['String']['input'];
  /** The ID of the flag to resolve. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of ResolveFlag. */
export type ResolveFlagPayload = {
  __typename: 'ResolveFlagPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  flag?: Maybe<Flag>;
};

export type Revision = Commentable & EventOriginObject & EventSubject & {
  __typename: 'Revision';
  acceptanceActivity?: Maybe<AcceptRevisionsActivity>;
  /** List and filter comments. */
  comments: CommentConnection;
  createdAt: Scalars['ISO8601DateTime']['output'];
  creationActivity?: Maybe<SuggestRevisionSetActivity>;
  currentValue?: Maybe<Scalars['JSON']['output']>;
  /** List and filter events for an object */
  events: EventConnection;
  fieldName: Scalars['String']['output'];
  id: Scalars['Int']['output'];
  lastCommentEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  linkoutData: LinkoutData;
  name: Scalars['String']['output'];
  rejectionActivity?: Maybe<RejectRevisionsActivity>;
  resolutionActivity?: Maybe<ActivityInterface>;
  revisionSetId: Scalars['Int']['output'];
  status: RevisionStatus;
  subject: EventSubject;
  suggestedValue?: Maybe<Scalars['JSON']['output']>;
  supersedingActivity?: Maybe<AcceptRevisionsActivity>;
  updatedAt: Scalars['ISO8601DateTime']['output'];
};


export type RevisionCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type RevisionEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};

/** The connection type for Revision. */
export type RevisionConnection = {
  __typename: 'RevisionConnection';
  /** A list of edges. */
  edges: Array<RevisionEdge>;
  /** A list of nodes. */
  nodes: Array<Revision>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** List of all fields that have at least one revision. */
  revisedFieldNames: Array<FieldName>;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
  /**
   * When filtered on a subject, the total number of revisions for that subject,
   * irregardless of other filters. Null when no subject provided.
   */
  unfilteredCountForSubject?: Maybe<Scalars['Int']['output']>;
  /** List of all users that have accepted/rejected/superseded a revision to this entity. */
  uniqueResolvers: Array<User>;
  /** List of all users that have submitted a revision to this entity. */
  uniqueRevisors: Array<User>;
};

/** An edge in a connection. */
export type RevisionEdge = {
  __typename: 'RevisionEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Revision>;
};

export type RevisionResult = {
  __typename: 'RevisionResult';
  /** Name of the field on the moderated entity that the Revision pertains to. */
  fieldName: Scalars['String']['output'];
  /** ID of the Revision. */
  id: Scalars['Int']['output'];
  /** Was this Revision newly created as a result of this request? */
  newlyCreated: Scalars['Boolean']['output'];
  /** An identifier that can be used to group Revisions proposed at the same time. */
  revisionSetId: Scalars['Int']['output'];
};

export type RevisionSet = EventSubject & {
  __typename: 'RevisionSet';
  createdAt: Scalars['ISO8601DateTime']['output'];
  displayName: Scalars['String']['output'];
  /** List and filter events for an object */
  events: EventConnection;
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  revisions: Array<Revision>;
  updatedAt: Scalars['ISO8601DateTime']['output'];
};


export type RevisionSetEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};

export enum RevisionStatus {
  Accepted = 'ACCEPTED',
  New = 'NEW',
  Rejected = 'REJECTED',
  Superseded = 'SUPERSEDED'
}

/** Autogenerated input type of RevokeApiKey */
export type RevokeApiKeyInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** ID of the API key to be revoked. */
  id: Scalars['Int']['input'];
};

/** Autogenerated return type of RevokeApiKey. */
export type RevokeApiKeyPayload = {
  __typename: 'RevokeApiKeyPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** Indicates whether the API key was successfully revoked. */
  success: Scalars['Boolean']['output'];
};

export type RevokeEndorsementActivity = ActivityInterface & {
  __typename: 'RevokeEndorsementActivity';
  assertion: Assertion;
  createdAt: Scalars['ISO8601DateTime']['output'];
  endorsement: Endorsement;
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of RevokeEndorsement */
export type RevokeEndorsementInput = {
  /** ID of the Assertion */
  assertionId: Scalars['Int']['input'];
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for revoking this Endorsement. */
  comment: Scalars['String']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of RevokeEndorsement. */
export type RevokeEndorsementPayload = {
  __typename: 'RevokeEndorsementPayload';
  /** The newly unendorsed Assertion */
  assertion: Assertion;
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
};

export type ScalarField = {
  __typename: 'ScalarField';
  value?: Maybe<Scalars['String']['output']>;
};

export type ScalarFieldDiff = {
  __typename: 'ScalarFieldDiff';
  left: Scalars['String']['output'];
  right: Scalars['String']['output'];
};

export type SearchResult = {
  __typename: 'SearchResult';
  id: Scalars['Int']['output'];
  matchingText: Scalars['String']['output'];
  name: Scalars['String']['output'];
  resultType: SearchableEntities;
};

export enum SearchableEntities {
  Assertion = 'ASSERTION',
  Disease = 'DISEASE',
  EvidenceItem = 'EVIDENCE_ITEM',
  Feature = 'FEATURE',
  MolecularProfile = 'MOLECULAR_PROFILE',
  Revision = 'REVISION',
  Therapy = 'THERAPY',
  Variant = 'VARIANT',
  VariantGroup = 'VARIANT_GROUP'
}

export enum SortDirection {
  Asc = 'ASC',
  Desc = 'DESC'
}

export type Source = Commentable & EventSubject & {
  __typename: 'Source';
  abstract?: Maybe<Scalars['String']['output']>;
  ascoAbstractId?: Maybe<Scalars['Int']['output']>;
  authorString?: Maybe<Scalars['String']['output']>;
  citation?: Maybe<Scalars['String']['output']>;
  citationId: Scalars['String']['output'];
  clinicalTrials?: Maybe<Array<ClinicalTrial>>;
  /** List and filter comments. */
  comments: CommentConnection;
  deprecated: Scalars['Boolean']['output'];
  displayType: Scalars['String']['output'];
  /** List and filter events for an object */
  events: EventConnection;
  fullJournalTitle?: Maybe<Scalars['String']['output']>;
  fullyCurated: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  journal?: Maybe<Scalars['String']['output']>;
  lastCommentEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  openAccess: Scalars['Boolean']['output'];
  pmcId?: Maybe<Scalars['String']['output']>;
  publicationDate?: Maybe<Scalars['String']['output']>;
  publicationDay?: Maybe<Scalars['Int']['output']>;
  publicationMonth?: Maybe<Scalars['Int']['output']>;
  publicationYear?: Maybe<Scalars['Int']['output']>;
  retracted: Scalars['Boolean']['output'];
  retractionDate?: Maybe<Scalars['ISO8601DateTime']['output']>;
  retractionNature?: Maybe<Scalars['String']['output']>;
  retractionReasons?: Maybe<Scalars['String']['output']>;
  sourceType: SourceSource;
  sourceUrl?: Maybe<Scalars['String']['output']>;
  title?: Maybe<Scalars['String']['output']>;
};


export type SourceCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type SourceEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};

/** The connection type for Source. */
export type SourceConnection = {
  __typename: 'SourceConnection';
  /** A list of edges. */
  edges: Array<SourceEdge>;
  /** A list of nodes. */
  nodes: Array<Source>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type SourceEdge = {
  __typename: 'SourceEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Source>;
};

export type SourcePopover = Commentable & EventSubject & {
  __typename: 'SourcePopover';
  abstract?: Maybe<Scalars['String']['output']>;
  ascoAbstractId?: Maybe<Scalars['Int']['output']>;
  authorString?: Maybe<Scalars['String']['output']>;
  citation?: Maybe<Scalars['String']['output']>;
  citationId: Scalars['String']['output'];
  clinicalTrials?: Maybe<Array<ClinicalTrial>>;
  /** List and filter comments. */
  comments: CommentConnection;
  deprecated: Scalars['Boolean']['output'];
  displayType: Scalars['String']['output'];
  /** List and filter events for an object */
  events: EventConnection;
  evidenceItemCount: Scalars['Int']['output'];
  fullJournalTitle?: Maybe<Scalars['String']['output']>;
  fullyCurated: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  journal?: Maybe<Scalars['String']['output']>;
  lastCommentEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  openAccess: Scalars['Boolean']['output'];
  pmcId?: Maybe<Scalars['String']['output']>;
  publicationDate?: Maybe<Scalars['String']['output']>;
  publicationDay?: Maybe<Scalars['Int']['output']>;
  publicationMonth?: Maybe<Scalars['Int']['output']>;
  publicationYear?: Maybe<Scalars['Int']['output']>;
  retracted: Scalars['Boolean']['output'];
  retractionDate?: Maybe<Scalars['ISO8601DateTime']['output']>;
  retractionNature?: Maybe<Scalars['String']['output']>;
  retractionReasons?: Maybe<Scalars['String']['output']>;
  sourceType: SourceSource;
  sourceUrl?: Maybe<Scalars['String']['output']>;
  title?: Maybe<Scalars['String']['output']>;
};


export type SourcePopoverCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type SourcePopoverEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};

export type SourceSearchFilter = {
  abstract?: InputMaybe<StringSearchInput>;
  booleanOperator?: InputMaybe<BooleanOperator>;
  citation?: InputMaybe<StringSearchInput>;
  citationId?: InputMaybe<StringSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  isRetracted?: InputMaybe<BooleanSearchInput>;
  journal?: InputMaybe<StringSearchInput>;
  sourceType?: InputMaybe<SourceSourceTypeSearchInput>;
  subFilters?: InputMaybe<Array<SourceSearchFilter>>;
  title?: InputMaybe<StringSearchInput>;
};

export enum SourceSource {
  Asco = 'ASCO',
  Ash = 'ASH',
  Pubmed = 'PUBMED'
}

export type SourceSourceTypeSearchInput = {
  operator: EnumSearchOperator;
  value: SourceSource;
};

export type SourceStub = {
  __typename: 'SourceStub';
  citationId: Scalars['Int']['output'];
  id: Scalars['Int']['output'];
  sourceType: SourceSource;
};

export type SourceSuggestion = EventOriginObject & EventSubject & {
  __typename: 'SourceSuggestion';
  createdAt: Scalars['ISO8601DateTime']['output'];
  creationActivity: SuggestSourceActivity;
  disease?: Maybe<Disease>;
  /** List and filter events for an object */
  events: EventConnection;
  id: Scalars['Int']['output'];
  initialComment: Scalars['String']['output'];
  lastStatusUpdateActivity?: Maybe<UpdateSourceSuggestionStatusActivity>;
  link: Scalars['String']['output'];
  molecularProfile?: Maybe<MolecularProfile>;
  name: Scalars['String']['output'];
  reason?: Maybe<Scalars['String']['output']>;
  source?: Maybe<Source>;
  status: SourceSuggestionStatus;
  user?: Maybe<User>;
};


export type SourceSuggestionEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};

/** The connection type for SourceSuggestion. */
export type SourceSuggestionConnection = {
  __typename: 'SourceSuggestionConnection';
  /** A list of edges. */
  edges: Array<SourceSuggestionEdge>;
  /** The total number of records in this set. */
  filteredCount: Scalars['Int']['output'];
  /** The last time the data in this browse table was refreshed */
  lastUpdated: Scalars['ISO8601DateTime']['output'];
  /** A list of nodes. */
  nodes: Array<SourceSuggestion>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records of this type, regardless of any filtering. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type SourceSuggestionEdge = {
  __typename: 'SourceSuggestionEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<SourceSuggestion>;
};

export enum SourceSuggestionStatus {
  Curated = 'CURATED',
  New = 'NEW',
  Rejected = 'REJECTED'
}

export type SourceSuggestionValues = {
  __typename: 'SourceSuggestionValues';
  disease?: Maybe<Disease>;
  molecularProfile?: Maybe<MolecularProfile>;
  source?: Maybe<Source>;
};

export type SourceSuggestionsSort = {
  /** Available columns for sorting */
  column: SourceSuggestionsSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum SourceSuggestionsSortColumns {
  Citation = 'CITATION',
  CitationId = 'CITATION_ID',
  CreatedAt = 'CREATED_AT',
  DiseaseName = 'DISEASE_NAME',
  SourceType = 'SOURCE_TYPE',
  Submitter = 'SUBMITTER'
}

export type SourcesSort = {
  /** Available columns for sorting */
  column: SourcesSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum SourcesSortColumns {
  Authors = 'AUTHORS',
  CitationId = 'CITATION_ID',
  EvidenceCount = 'EVIDENCE_COUNT',
  Journal = 'JOURNAL',
  Name = 'NAME',
  SourceType = 'SOURCE_TYPE',
  SuggestionCount = 'SUGGESTION_COUNT',
  Year = 'YEAR'
}

export type Stats = {
  __typename: 'Stats';
  acceptedAssertions: Scalars['Int']['output'];
  acceptedEvidenceItems: Scalars['Int']['output'];
  appliedRevisions: Scalars['Int']['output'];
  comments: Scalars['Int']['output'];
  revisions: Scalars['Int']['output'];
  submittedAssertions: Scalars['Int']['output'];
  submittedEvidenceItems: Scalars['Int']['output'];
  suggestedSources: Scalars['Int']['output'];
};

export type StringSearchInput = {
  operator: StringSearchOperator;
  value: Scalars['String']['input'];
};

export enum StringSearchOperator {
  Contains = 'CONTAINS',
  DoesNotContain = 'DOES_NOT_CONTAIN',
  Eq = 'EQ',
  Ne = 'NE',
  StartsWith = 'STARTS_WITH'
}

export type SubmitAssertionActivity = ActivityInterface & {
  __typename: 'SubmitAssertionActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of SubmitAssertion */
export type SubmitAssertionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing any further context or details about your proposed Assertion. Will be attached as a comment. */
  comment?: InputMaybe<Scalars['String']['input']>;
  /** The desired state of the Assertion's editable fields. */
  fields: AssertionFields;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SubmitAssertion. */
export type SubmitAssertionPayload = {
  __typename: 'SubmitAssertionPayload';
  /** The newly created Assertion */
  assertion: Assertion;
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
};

export type SubmitEvidenceItemActivity = ActivityInterface & {
  __typename: 'SubmitEvidenceItemActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of SubmitEvidenceItem */
export type SubmitEvidenceItemInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing any further context or details about your proposed EvidenceItem. Will be attached as a comment. */
  comment?: InputMaybe<Scalars['String']['input']>;
  /** The desired state of the EvidenceItems's editable fields. */
  fields: EvidenceItemFields;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SubmitEvidenceItem. */
export type SubmitEvidenceItemPayload = {
  __typename: 'SubmitEvidenceItemPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created EvidenceItem */
  evidenceItem: EvidenceItem;
};

/** Autogenerated input type of SubmitVariantGroup */
export type SubmitVariantGroupInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A description of the variant group. */
  description?: InputMaybe<Scalars['String']['input']>;
  /** The name of the disease. */
  name: Scalars['String']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** A list of CIViC source IDs to associate with the variant group. */
  sourceIds: Array<Scalars['Int']['input']>;
  /** A list of CIViC variant IDs to add to the variant group. */
  variantIds: Array<Scalars['Int']['input']>;
};

/** Autogenerated return type of SubmitVariantGroup. */
export type SubmitVariantGroupPayload = {
  __typename: 'SubmitVariantGroupPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created Variant Group */
  variantGroup: VariantGroup;
};

export type Subscribable = {
  __typename: 'Subscribable';
  entityType: SubscribableEntities;
  id: Scalars['Int']['output'];
};

/** Enumeration of all subscribable CIViC entities. */
export enum SubscribableEntities {
  Assertion = 'ASSERTION',
  EvidenceItem = 'EVIDENCE_ITEM',
  Feature = 'FEATURE',
  MolecularProfile = 'MOLECULAR_PROFILE',
  Revision = 'REVISION',
  SourceSuggestion = 'SOURCE_SUGGESTION',
  Variant = 'VARIANT',
  VariantGroup = 'VARIANT_GROUP'
}

/** Entity to subscribe to. */
export type SubscribableInput = {
  /** Type of subscribable entity. */
  entityType: SubscribableEntities;
  /** ID of subscribable entity. */
  id: Scalars['Int']['input'];
};

/** Entity to subscribe to. */
export type SubscribableQueryInput = {
  /** Type of subscribable entity. */
  entityType: SubscribableEntities;
  /** ID of subscribable entity. */
  id: Scalars['Int']['input'];
  /** Include child entities of the requested subscribable */
  includeChildren?: InputMaybe<Scalars['Boolean']['input']>;
};

/** Autogenerated input type of Subscribe */
export type SubscribeInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A list of one or more entities to subscribe to, each identified by its ID and type. */
  subscribables: Array<SubscribableInput>;
  /**
   * Do you want to subscribe to related child entities of the subscribed entities?
   * IE: If you subscribe to a Gene, do you want to receive notifications for its Variants as well?
   */
  subscribeToChildren?: InputMaybe<Scalars['Boolean']['input']>;
};

/** Autogenerated return type of Subscribe. */
export type SubscribePayload = {
  __typename: 'SubscribePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created subscription objects. */
  subscriptions: Array<Subscription>;
};

export type Subscription = {
  __typename: 'Subscription';
  id: Scalars['Int']['output'];
  subscribable: EventSubject;
};

/** Autogenerated input type of SuggestAssertionRevision */
export type SuggestAssertionRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment: Scalars['String']['input'];
  /**
   * The desired state of the Assertion's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: AssertionFields;
  /** The ID of the Assertion to suggest a Revision to. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestAssertionRevision. */
export type SuggestAssertionRevisionPayload = {
  __typename: 'SuggestAssertionRevisionPayload';
  /** The Assertion the user has proposed a Revision to. */
  assertion: Assertion;
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
};

/** Autogenerated input type of SuggestEvidenceItemRevision */
export type SuggestEvidenceItemRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment: Scalars['String']['input'];
  /**
   * The desired state of the EvidenceItems's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: EvidenceItemFields;
  /** The ID of the EvidenceItem to suggest a Revision to. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestEvidenceItemRevision. */
export type SuggestEvidenceItemRevisionPayload = {
  __typename: 'SuggestEvidenceItemRevisionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The EvidenceItem the user has proposed a Revision to. */
  evidenceItem: EvidenceItem;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
};

/** Autogenerated input type of SuggestFactorRevision */
export type SuggestFactorRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment: Scalars['String']['input'];
  /**
   * The desired state of the Factors's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: FactorFields;
  /** The ID of the Feature of instance type "Factor" to suggest a Revision to. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestFactorRevision. */
export type SuggestFactorRevisionPayload = {
  __typename: 'SuggestFactorRevisionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The Factor the user has proposed a Revision to. */
  factor: Factor;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
};

/** Autogenerated input type of SuggestFactorVariantRevision */
export type SuggestFactorVariantRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment?: InputMaybe<Scalars['String']['input']>;
  /**
   * The desired state of the Variant's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: FactorVariantFields;
  /** The ID of the Variant to suggest a Revision to. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestFactorVariantRevision. */
export type SuggestFactorVariantRevisionPayload = {
  __typename: 'SuggestFactorVariantRevisionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
  /** The Variant the user has proposed a Revision to. */
  variant: FactorVariant;
};

/** Autogenerated input type of SuggestFusionRevision */
export type SuggestFusionRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment: Scalars['String']['input'];
  /**
   * The desired state of the Fusion's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: FusionFields;
  /** The ID of the Feature of instance type "Fusion" to suggest a Revision to. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestFusionRevision. */
export type SuggestFusionRevisionPayload = {
  __typename: 'SuggestFusionRevisionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The Fusion the user has proposed a Revision to. */
  fusion: Fusion;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
};

/** Autogenerated input type of SuggestFusionVariantRevision */
export type SuggestFusionVariantRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment?: InputMaybe<Scalars['String']['input']>;
  /**
   * The desired state of the Variant's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: FusionVariantFields;
  /** The ID of the Variant to suggest a Revision to. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestFusionVariantRevision. */
export type SuggestFusionVariantRevisionPayload = {
  __typename: 'SuggestFusionVariantRevisionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
  /** The Variant the user has proposed a Revision to. */
  variant: FusionVariant;
};

/** Autogenerated input type of SuggestGeneRevision */
export type SuggestGeneRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment: Scalars['String']['input'];
  /**
   * The desired state of the Gene's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: GeneFields;
  /** The ID of the Feature of instance type "Gene" to suggest a Revision to. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestGeneRevision. */
export type SuggestGeneRevisionPayload = {
  __typename: 'SuggestGeneRevisionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The Gene the user has proposed a Revision to. */
  gene: Gene;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
};

/** Autogenerated input type of SuggestGeneVariantRevision */
export type SuggestGeneVariantRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment?: InputMaybe<Scalars['String']['input']>;
  /**
   * The desired state of the Variant's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: GeneVariantFields;
  /** The ID of the Variant to suggest a Revision to. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestGeneVariantRevision. */
export type SuggestGeneVariantRevisionPayload = {
  __typename: 'SuggestGeneVariantRevisionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
  /** The Variant the user has proposed a Revision to. */
  variant: GeneVariant;
};

/** Autogenerated input type of SuggestMolecularProfileRevision */
export type SuggestMolecularProfileRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment: Scalars['String']['input'];
  /**
   * The desired state of the Molecular Profile's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: MolecularProfileFields;
  /** The ID of the MolecularProfile to suggest a Revision to. */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestMolecularProfileRevision. */
export type SuggestMolecularProfileRevisionPayload = {
  __typename: 'SuggestMolecularProfileRevisionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The MolecularProfile the user has proposed a Revision to. */
  molecularProfile: MolecularProfile;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
};

export type SuggestRevisionSetActivity = ActivityInterface & {
  __typename: 'SuggestRevisionSetActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  revisionSet: RevisionSet;
  revisions: Array<Revision>;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

export type SuggestSourceActivity = ActivityInterface & {
  __typename: 'SuggestSourceActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  sourceSuggestion: SourceSuggestion;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of SuggestSource */
export type SuggestSourceInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text explaining why this source should be curated for CIViC evidence. */
  comment: Scalars['String']['input'];
  /** Internal CIViC ID for the applicable disease, if any. */
  diseaseId?: InputMaybe<Scalars['Int']['input']>;
  /** Internal CIViC ID for the applicable molecular profile, if any. */
  molecularProfileId?: InputMaybe<Scalars['Int']['input']>;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** Internal CIViC ID for the source to suggest. Use the AddRemoteCitation mutation to populate this if needed. */
  sourceId: Scalars['Int']['input'];
};

/** Autogenerated return type of SuggestSource. */
export type SuggestSourcePayload = {
  __typename: 'SuggestSourcePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The newly created Source Suggestion */
  sourceSuggestion: SourceSuggestion;
};

/** Autogenerated input type of SuggestVariantGroupRevision */
export type SuggestVariantGroupRevisionInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Text describing the reason for the change. Will be attached to the Revision as a comment. */
  comment: Scalars['String']['input'];
  /**
   * The desired state of the VariantGroup's editable fields if the change were applied.
   * If no change is desired for a particular field, pass in the current value of that field.
   */
  fields: VariantGroupFields;
  /** The ID of the VariantGroup you are suggesting a Revision to */
  id: Scalars['Int']['input'];
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of SuggestVariantGroupRevision. */
export type SuggestVariantGroupRevisionPayload = {
  __typename: 'SuggestVariantGroupRevisionPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /**
   * A list of Revisions generated as a result of this suggestion.
   * If an existing Revision exactly matches the proposed one, it will be returned instead.
   * This is indicated via the 'newlyCreated' Boolean.
   * Revisions are stored on a per-field basis.
   * The changesetId can be used to group Revisions proposed at the same time.
   */
  results: Array<RevisionResult>;
  /** The VariantGroup the user has proposed a Revision to. */
  variantGroup: VariantGroup;
};

export enum TaggableEntity {
  Assertion = 'ASSERTION',
  EvidenceItem = 'EVIDENCE_ITEM',
  Feature = 'FEATURE',
  MolecularProfile = 'MOLECULAR_PROFILE',
  Revision = 'REVISION',
  Role = 'ROLE',
  Variant = 'VARIANT',
  VariantGroup = 'VARIANT_GROUP'
}

/** Mentioned entity to filter comments on. */
export type TaggableEntityInput = {
  /** The type of the entity */
  entityType: TaggableEntity;
  /** ID of the mentioned entity */
  id: Scalars['Int']['input'];
};

export type Therapy = {
  __typename: 'Therapy';
  deprecated: Scalars['Boolean']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  myChemInfo?: Maybe<MyChemInfo>;
  name: Scalars['String']['output'];
  ncitId?: Maybe<Scalars['String']['output']>;
  therapyAliases: Array<Scalars['String']['output']>;
  therapyUrl?: Maybe<Scalars['String']['output']>;
};

/** The connection type for Therapy. */
export type TherapyConnection = {
  __typename: 'TherapyConnection';
  /** A list of edges. */
  edges: Array<TherapyEdge>;
  /** A list of nodes. */
  nodes: Array<Therapy>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type TherapyEdge = {
  __typename: 'TherapyEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<Therapy>;
};

export enum TherapyInteraction {
  Combination = 'COMBINATION',
  Sequential = 'SEQUENTIAL',
  Substitutes = 'SUBSTITUTES'
}

export type TherapyInteractionTypeSearchInput = {
  operator: EnumSearchOperator;
  value: TherapyInteraction;
};

export type TherapyPopover = {
  __typename: 'TherapyPopover';
  assertionCount: Scalars['Int']['output'];
  deprecated: Scalars['Boolean']['output'];
  evidenceItemCount: Scalars['Int']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  molecularProfileCount: Scalars['Int']['output'];
  myChemInfo?: Maybe<MyChemInfo>;
  name: Scalars['String']['output'];
  ncitId?: Maybe<Scalars['String']['output']>;
  therapyAliases: Array<Scalars['String']['output']>;
  therapyUrl?: Maybe<Scalars['String']['output']>;
};

export type TherapySearchFilter = {
  booleanOperator?: InputMaybe<BooleanOperator>;
  deprecated?: InputMaybe<BooleanSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  name?: InputMaybe<StringSearchInput>;
  ncitId?: InputMaybe<StringSearchInput>;
  subFilters?: InputMaybe<Array<TherapySearchFilter>>;
  therapyAliases?: InputMaybe<StringSearchInput>;
};

export type TherapySort = {
  /** Available columns for sorting */
  column: TherapySortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum TherapySortColumns {
  AssertionCount = 'ASSERTION_COUNT',
  EvidenceItemCount = 'EVIDENCE_ITEM_COUNT',
  Name = 'NAME',
  NcitId = 'NCIT_ID'
}

export type TimePointCounts = {
  __typename: 'TimePointCounts';
  allTime: Scalars['Int']['output'];
  newThisMonth: Scalars['Int']['output'];
  newThisWeek: Scalars['Int']['output'];
  newThisYear: Scalars['Int']['output'];
};

export enum TimeWindow {
  AllTime = 'ALL_TIME',
  LastMonth = 'LAST_MONTH',
  LastWeek = 'LAST_WEEK',
  LastYear = 'LAST_YEAR'
}

/** Autogenerated input type of Unsubscribe */
export type UnsubscribeInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A list of one or more entities to unsubscribe from, each identified by its ID and type. */
  subscribables: Array<SubscribableInput>;
  /**
   * Do you also wish to stop receiving notifications from child entities?
   * IE: If you unsubscribe from a Gene do you want to stop receiving notifications for its Variants as well?
   */
  unsubscribeFromChildren?: InputMaybe<Scalars['Boolean']['input']>;
};

/** Autogenerated return type of Unsubscribe. */
export type UnsubscribePayload = {
  __typename: 'UnsubscribePayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The entities that were unsubscribed from. */
  unsubscribedEntities: Array<Subscribable>;
};

/** Autogenerated input type of UpdateCoi */
export type UpdateCoiInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** Does the user report having a conflict of interest? Mark true if so. */
  coiPresent: Scalars['Boolean']['input'];
  /** If the user reports a potential conflict of interest please provide a brief summary of it. */
  statement?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of UpdateCoi. */
export type UpdateCoiPayload = {
  __typename: 'UpdateCoiPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  coiStatement: Coi;
};

/** Autogenerated input type of UpdateNotificationStatus */
export type UpdateNotificationStatusInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** A list of one or more Notification IDs. */
  ids: Array<Scalars['Int']['input']>;
  /** The new status of the selected notifications. */
  newStatus: ReadStatus;
};

/** Autogenerated return type of UpdateNotificationStatus. */
export type UpdateNotificationStatusPayload = {
  __typename: 'UpdateNotificationStatusPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** A list of the notifications in their new state. */
  notifications: Array<Notification>;
};

export type UpdateSourceSuggestionStatusActivity = ActivityInterface & {
  __typename: 'UpdateSourceSuggestionStatusActivity';
  createdAt: Scalars['ISO8601DateTime']['output'];
  events: Array<Event>;
  id: Scalars['Int']['output'];
  note?: Maybe<Scalars['String']['output']>;
  organization?: Maybe<Organization>;
  parsedNote: Array<CommentBodySegment>;
  sourceSuggestion: SourceSuggestion;
  subject: EventSubject;
  user: User;
  verbiage: Scalars['String']['output'];
};

/** Autogenerated input type of UpdateSourceSuggestionStatus */
export type UpdateSourceSuggestionStatusInput = {
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: InputMaybe<Scalars['String']['input']>;
  /** The ID of the SourceSuggestion to update. */
  id: Scalars['Int']['input'];
  /** The desired status of the SourceSuggestion. */
  newStatus: SourceSuggestionStatus;
  /**
   * The ID of the organization to credit the user's contributions to.
   * If the user belongs to a single organization or no organizations, this field is not required.
   * This field is required if the user belongs to more than one organization.
   * The user must belong to the organization provided.
   */
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  /** The justification for marking a source as curated/rejected */
  reason?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of UpdateSourceSuggestionStatus. */
export type UpdateSourceSuggestionStatusPayload = {
  __typename: 'UpdateSourceSuggestionStatusPayload';
  /** A unique identifier for the client performing the mutation. */
  clientMutationId?: Maybe<Scalars['String']['output']>;
  /** The updated SourceSuggestion. */
  sourceSuggestion: SourceSuggestion;
};

export type User = {
  __typename: 'User';
  apiKeys: Array<ApiKey>;
  areaOfExpertise?: Maybe<AreaOfExpertise>;
  bio?: Maybe<Scalars['String']['output']>;
  country?: Maybe<Country>;
  displayName: Scalars['String']['output'];
  email?: Maybe<Scalars['String']['output']>;
  events: EventConnection;
  facebookProfile?: Maybe<Scalars['String']['output']>;
  id: Scalars['Int']['output'];
  joinDate?: Maybe<Scalars['ISO8601DateTime']['output']>;
  linkedinProfile?: Maybe<Scalars['String']['output']>;
  mostRecentActivityTimestamp?: Maybe<Scalars['ISO8601DateTime']['output']>;
  mostRecentConflictOfInterestStatement?: Maybe<Coi>;
  mostRecentEvent?: Maybe<Event>;
  mostRecentOrg?: Maybe<Organization>;
  mostRecentOrganizationId?: Maybe<Scalars['Int']['output']>;
  name?: Maybe<Scalars['String']['output']>;
  /** Filterable list of notifications for the logged in user. */
  notifications?: Maybe<NotificationConnection>;
  orcid?: Maybe<Scalars['String']['output']>;
  organizations: Array<Organization>;
  organizationsWithEndorsementPrivileges: Array<Organization>;
  profileImagePath?: Maybe<Scalars['String']['output']>;
  ranks: Ranks;
  role: UserRole;
  statsHash: Stats;
  twitterHandle?: Maybe<Scalars['String']['output']>;
  url?: Maybe<Scalars['String']['output']>;
  username: Scalars['String']['output'];
};


export type UserEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type UserNotificationsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  includeSeen?: InputMaybe<Scalars['Boolean']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  notificationType?: InputMaybe<NotificationReason>;
  subscriptionId?: InputMaybe<Scalars['Int']['input']>;
};


export type UserProfileImagePathArgs = {
  size?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for User. */
export type UserConnection = {
  __typename: 'UserConnection';
  /** A list of edges. */
  edges: Array<UserEdge>;
  /** A list of nodes. */
  nodes: Array<User>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type UserEdge = {
  __typename: 'UserEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<User>;
};

export type UserLeaderboards = {
  __typename: 'UserLeaderboards';
  commentsLeaderboard: LeaderboardUserConnection;
  moderationLeaderboard: LeaderboardUserConnection;
  revisionsLeaderboard: LeaderboardUserConnection;
  submissionsLeaderboard: LeaderboardUserConnection;
};


export type UserLeaderboardsCommentsLeaderboardArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  direction?: InputMaybe<SortDirection>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  role?: InputMaybe<UserRole>;
  window?: InputMaybe<TimeWindow>;
};


export type UserLeaderboardsModerationLeaderboardArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  direction?: InputMaybe<SortDirection>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  role?: InputMaybe<UserRole>;
  window?: InputMaybe<TimeWindow>;
};


export type UserLeaderboardsRevisionsLeaderboardArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  direction?: InputMaybe<SortDirection>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  role?: InputMaybe<UserRole>;
  window?: InputMaybe<TimeWindow>;
};


export type UserLeaderboardsSubmissionsLeaderboardArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  direction?: InputMaybe<SortDirection>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  role?: InputMaybe<UserRole>;
  window?: InputMaybe<TimeWindow>;
};

export enum UserRole {
  Admin = 'ADMIN',
  Curator = 'CURATOR',
  Editor = 'EDITOR'
}

export type UsersSort = {
  /** Available columns for sorting */
  column: UsersSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum UsersSortColumns {
  EvidenceCount = 'EVIDENCE_COUNT',
  Id = 'ID',
  LastAction = 'LAST_ACTION',
  Name = 'NAME',
  RevisionCount = 'REVISION_COUNT',
  Role = 'ROLE'
}

export type ValidationErrors = {
  __typename: 'ValidationErrors';
  genericErrors: Array<Scalars['String']['output']>;
  validationErrors: Array<FieldValidationError>;
};

export type Variant = Commentable & EventOriginObject & EventSubject & Flaggable & MolecularProfileComponent & VariantInterface & WithRevisions & {
  __typename: 'Variant';
  /** List and filter comments. */
  comments: CommentConnection;
  creationActivity?: Maybe<CreateVariantActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecationActivity?: Maybe<DeprecateVariantActivity>;
  deprecationReason?: Maybe<VariantDeprecationReason>;
  /** List and filter events for an object */
  events: EventConnection;
  feature: Feature;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  molecularProfiles: MolecularProfileConnection;
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  singleVariantMolecularProfile: MolecularProfile;
  singleVariantMolecularProfileId: Scalars['Int']['output'];
  variantAliases: Array<Scalars['String']['output']>;
  variantTypes: Array<VariantType>;
};


export type VariantCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type VariantEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type VariantFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


export type VariantMolecularProfilesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


export type VariantRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

export type VariantAlias = {
  __typename: 'VariantAlias';
  name: Scalars['String']['output'];
};

export enum VariantCategories {
  Factor = 'FACTOR',
  Fusion = 'FUSION',
  Gene = 'GENE'
}

/** Representation of a Variant's membership in a Molecular Profile. */
export type VariantComponent = {
  /** When set to true, this means the NOT operator will be applied to the Variant in the Molecluar Profile. */
  not?: Scalars['Boolean']['input'];
  /** The ID of the Variant involved in the Molecular Profile. */
  variantId: Scalars['Int']['input'];
};

export type VariantCoordinate = EventSubject & WithRevisions & {
  __typename: 'VariantCoordinate';
  chromosome?: Maybe<Scalars['String']['output']>;
  coordinateType: VariantCoordinateType;
  ensemblVersion?: Maybe<Scalars['Int']['output']>;
  /** List and filter events for an object */
  events: EventConnection;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  referenceBases?: Maybe<Scalars['String']['output']>;
  referenceBuild?: Maybe<ReferenceBuild>;
  representativeTranscript?: Maybe<Scalars['String']['output']>;
  /** List and filter revisions. */
  revisions: RevisionConnection;
  start?: Maybe<Scalars['Int']['output']>;
  stop?: Maybe<Scalars['Int']['output']>;
  variantBases?: Maybe<Scalars['String']['output']>;
};


export type VariantCoordinateEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type VariantCoordinateRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

export enum VariantCoordinateType {
  FivePrimeFusionCoordinate = 'FIVE_PRIME_FUSION_COORDINATE',
  GeneVariantCoordinate = 'GENE_VARIANT_COORDINATE',
  ThreePrimeFusionCoordinate = 'THREE_PRIME_FUSION_COORDINATE'
}

export enum VariantDeprecationReason {
  Duplicate = 'DUPLICATE',
  FeatureDeprecated = 'FEATURE_DEPRECATED',
  Invalid = 'INVALID',
  Other = 'OTHER'
}

export type VariantDeprecationReasonTypeSearchInput = {
  operator: EnumSearchOperator;
  value: VariantDeprecationReason;
};

export type VariantGroup = Commentable & EventSubject & Flaggable & WithRevisions & {
  __typename: 'VariantGroup';
  /** List and filter comments. */
  comments: CommentConnection;
  description: Scalars['String']['output'];
  /** List and filter events for an object */
  events: EventConnection;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  sources: Array<Source>;
  /** List and filter variants. */
  variants: VariantInterfaceConnection;
};


export type VariantGroupCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type VariantGroupEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


export type VariantGroupFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


export type VariantGroupRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};


export type VariantGroupVariantsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  alleleRegistryId?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  category?: InputMaybe<VariantCategories>;
  factorId?: InputMaybe<Scalars['Int']['input']>;
  featureId?: InputMaybe<Scalars['Int']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  geneId?: InputMaybe<Scalars['Int']['input']>;
  hasNoVariantType?: InputMaybe<Scalars['Boolean']['input']>;
  ids?: InputMaybe<Array<Scalars['Int']['input']>>;
  last?: InputMaybe<Scalars['Int']['input']>;
  name?: InputMaybe<Scalars['String']['input']>;
  sortBy?: InputMaybe<VariantMenuSort>;
  variantTypeIds?: InputMaybe<Array<Scalars['Int']['input']>>;
};

/** The connection type for VariantGroup. */
export type VariantGroupConnection = {
  __typename: 'VariantGroupConnection';
  /** A list of edges. */
  edges: Array<VariantGroupEdge>;
  /** A list of nodes. */
  nodes: Array<VariantGroup>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type VariantGroupEdge = {
  __typename: 'VariantGroupEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<VariantGroup>;
};

/** Fields on a VariantGroup that curators may propose revisions to. */
export type VariantGroupFields = {
  /** The VariantGroups's description/summary text. */
  description: NullableStringInput;
  /** The VariantGroups's name. */
  name: Scalars['String']['input'];
  /** Source IDs cited by the VariantGroup's summary. */
  sourceIds: Array<Scalars['Int']['input']>;
  /** Variants in this VariantGroup. */
  variantIds: Array<Scalars['Int']['input']>;
};

export type VariantGroupsSort = {
  /** Available columns for sorting */
  column: VariantGroupsSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum VariantGroupsSortColumns {
  EvidenceItemCount = 'EVIDENCE_ITEM_COUNT',
  GeneNames = 'GENE_NAMES',
  Name = 'NAME',
  VariantCount = 'VARIANT_COUNT',
  VariantNames = 'VARIANT_NAMES'
}

/** A taggable/linkable component of a molecular profile */
export type VariantInterface = {
  /** List and filter comments. */
  comments: CommentConnection;
  creationActivity?: Maybe<CreateVariantActivity>;
  deprecated: Scalars['Boolean']['output'];
  deprecationActivity?: Maybe<DeprecateVariantActivity>;
  deprecationReason?: Maybe<VariantDeprecationReason>;
  /** List and filter events for an object */
  events: EventConnection;
  feature: Feature;
  flagged: Scalars['Boolean']['output'];
  /** List and filter flags. */
  flags: FlagConnection;
  id: Scalars['Int']['output'];
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastCommentEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  link: Scalars['String']['output'];
  molecularProfiles: MolecularProfileConnection;
  name: Scalars['String']['output'];
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
  singleVariantMolecularProfile: MolecularProfile;
  singleVariantMolecularProfileId: Scalars['Int']['output'];
  variantAliases: Array<Scalars['String']['output']>;
  variantTypes: Array<VariantType>;
};


/** A taggable/linkable component of a molecular profile */
export type VariantInterfaceCommentsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  mentionedEntity?: InputMaybe<TaggableEntityInput>;
  mentionedRole?: InputMaybe<UserRole>;
  mentionedUserId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** A taggable/linkable component of a molecular profile */
export type VariantInterfaceEventsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  eventType?: InputMaybe<EventAction>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  organizationId?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
};


/** A taggable/linkable component of a molecular profile */
export type VariantInterfaceFlagsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  flaggingUserId?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  resolvingUserId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  state?: InputMaybe<FlagState>;
};


/** A taggable/linkable component of a molecular profile */
export type VariantInterfaceMolecularProfilesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


/** A taggable/linkable component of a molecular profile */
export type VariantInterfaceRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

/** The connection type for VariantInterface. */
export type VariantInterfaceConnection = {
  __typename: 'VariantInterfaceConnection';
  /** A list of edges. */
  edges: Array<VariantInterfaceEdge>;
  /** A list of nodes. */
  nodes: Array<VariantInterface>;
  /** Total number of pages, based on filtered count and pagesize. */
  pageCount: Scalars['Int']['output'];
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** The total number of records in this filtered collection. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type VariantInterfaceEdge = {
  __typename: 'VariantInterfaceEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node?: Maybe<VariantInterface>;
};

export type VariantMenuSort = {
  /** Available columns for sorting */
  column: VariantMenuSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum VariantMenuSortColumns {
  CoordinateEnd = 'COORDINATE_END',
  CoordinateStart = 'COORDINATE_START',
  Name = 'NAME'
}

export enum VariantOrigin {
  Combined = 'COMBINED',
  CommonGermline = 'COMMON_GERMLINE',
  Mixed = 'MIXED',
  Na = 'NA',
  RareGermline = 'RARE_GERMLINE',
  Somatic = 'SOMATIC',
  Unknown = 'UNKNOWN'
}

export type VariantOriginTypeSearchInput = {
  operator: EnumSearchOperator;
  value: VariantOrigin;
};

export type VariantSearchFilter = {
  booleanOperator?: InputMaybe<BooleanOperator>;
  comment?: InputMaybe<CommentSearchFilter>;
  coordinates?: InputMaybe<CoordinateSearchInput>;
  deprecationReason?: InputMaybe<VariantDeprecationReasonTypeSearchInput>;
  feature?: InputMaybe<FeatureSearchFilter>;
  id?: InputMaybe<IntSearchInput>;
  isDeprecated?: InputMaybe<BooleanSearchInput>;
  isFlagged?: InputMaybe<BooleanSearchInput>;
  molecularProfile?: InputMaybe<MolecularProfileSearchFilter>;
  name?: InputMaybe<StringSearchInput>;
  openRevisionCount?: InputMaybe<IntSearchInput>;
  singleVariantMolecularProfile?: InputMaybe<MolecularProfileSearchFilter>;
  subFilters?: InputMaybe<Array<VariantSearchFilter>>;
  variantAlias?: InputMaybe<StringSearchInput>;
  variantType?: InputMaybe<VariantTypeSearchFilter>;
};

export type VariantType = {
  __typename: 'VariantType';
  description: Scalars['String']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  soid: Scalars['String']['output'];
  url?: Maybe<Scalars['String']['output']>;
};

export type VariantTypePopover = {
  __typename: 'VariantTypePopover';
  description: Scalars['String']['output'];
  id: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  soid: Scalars['String']['output'];
  url?: Maybe<Scalars['String']['output']>;
  variantCount: Scalars['Int']['output'];
};

export type VariantTypeSearchFilter = {
  booleanOperator?: InputMaybe<BooleanOperator>;
  description?: InputMaybe<StringSearchInput>;
  id?: InputMaybe<IntSearchInput>;
  name?: InputMaybe<StringSearchInput>;
  soid?: InputMaybe<OntologyTermSearchInput>;
  subFilters?: InputMaybe<Array<VariantTypeSearchFilter>>;
};

export type VariantTypeSort = {
  /** Available columns for sorting */
  column: VariantTypeSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum VariantTypeSortColumns {
  Name = 'NAME',
  Soid = 'SOID',
  VariantCount = 'VARIANT_COUNT'
}

export type VariantsSort = {
  /** Available columns for sorting */
  column: VariantsSortColumns;
  /** Sort direction */
  direction: SortDirection;
};

export enum VariantsSortColumns {
  DiseaseName = 'diseaseName',
  EvidenceItemCount = 'evidenceItemCount',
  FeatureName = 'featureName',
  TherapyName = 'therapyName',
  VariantName = 'variantName'
}

/** A CIViC entity that can have revisions proposed to it. */
export type WithRevisions = {
  lastAcceptedRevisionEvent?: Maybe<Event>;
  lastSubmittedRevisionEvent?: Maybe<Event>;
  openRevisionCount: Scalars['Int']['output'];
  /** List and filter revisions. */
  revisions: RevisionConnection;
};


/** A CIViC entity that can have revisions proposed to it. */
export type WithRevisionsRevisionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  fieldName?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  originatingUserId?: InputMaybe<Scalars['Int']['input']>;
  revisionSetId?: InputMaybe<Scalars['Int']['input']>;
  sortBy?: InputMaybe<DateSort>;
  status?: InputMaybe<RevisionStatus>;
};

export type ActivityFeedQueryVariables = Exact<{
  subject?: InputMaybe<Array<SubscribableQueryInput> | SubscribableQueryInput>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  after?: InputMaybe<Scalars['String']['input']>;
  organizationId?: InputMaybe<Array<Scalars['Int']['input']> | Scalars['Int']['input']>;
  includeSubgroups: Scalars['Boolean']['input'];
  userId?: InputMaybe<Array<Scalars['Int']['input']> | Scalars['Int']['input']>;
  activityType?: InputMaybe<Array<ActivityTypeInput> | ActivityTypeInput>;
  subjectType?: InputMaybe<Array<ActivitySubjectInput> | ActivitySubjectInput>;
  linkedEndorsementId?: InputMaybe<Scalars['Int']['input']>;
  includeAutomatedEvents?: InputMaybe<Scalars['Boolean']['input']>;
  includeConnection?: InputMaybe<Scalars['Boolean']['input']>;
  includePageInfo?: InputMaybe<Scalars['Boolean']['input']>;
  mode?: InputMaybe<EventFeedMode>;
  showFilters: Scalars['Boolean']['input'];
  requestDetails: Scalars['Boolean']['input'];
  occurredAfter?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
  occurredBefore?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
  sortBy?: InputMaybe<DateSort>;
}>;


export type ActivityFeedQuery = { __typename: 'Query', activities: { __typename: 'ActivityInterfaceConnection', activityTypes?: Array<ActivityTypeInput>, subjectTypes?: Array<ActivitySubjectInput>, pageCount: number, totalCount: number, unfilteredCount: number, uniqueParticipants?: Array<{ __typename: 'User', id: number, displayName: string, role: UserRole }>, participatingOrganizations?: Array<{ __typename: 'Organization', id: number, name: string }>, edges: Array<{ __typename: 'ActivityInterfaceEdge', cursor: string, node?: { __typename: 'AcceptRevisionsActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, supersededRevisions: Array<{ __typename: 'Revision', id: number, link: string, name: string, fieldName: string, createdAt: any, creationActivity?: { __typename: 'SuggestRevisionSetActivity', user: { __typename: 'User', displayName: string, profileImagePath?: string | undefined, id: number, role: UserRole } } | undefined }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'CommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'CreateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'CreateFeatureActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'CreateVariantActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeleteCommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeprecateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeprecateFeatureActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, variants: Array<{ __typename: 'FactorVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'FusionVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'GeneVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'Variant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeprecateVariantActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'EndorseAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'FlagEntityActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, flag: { __typename: 'Flag', id: number, link: string, name: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'ModerateAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'ModerateEvidenceItemActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'RejectRevisionsActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, createdAt: any, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'ResolveFlagActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'RevokeEndorsementActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'SubmitAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'SubmitEvidenceItemActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'SuggestRevisionSetActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, createdAt: any, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'SuggestSourceActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, sourceSuggestion: { __typename: 'SourceSuggestion', id: number, status: SourceSuggestionStatus, source?: { __typename: 'Source', id: number, name: string, link: string, deprecated: boolean } | undefined, molecularProfile?: { __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean } | undefined, disease?: { __typename: 'Disease', id: number, name: string, link: string, deprecated: boolean } | undefined }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'UpdateSourceSuggestionStatusActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, sourceSuggestion: { __typename: 'SourceSuggestion', status: SourceSuggestionStatus, source?: { __typename: 'Source', id: number, name: string, link: string, deprecated: boolean } | undefined, molecularProfile?: { __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean } | undefined, disease?: { __typename: 'Disease', id: number, name: string, link: string, deprecated: boolean } | undefined }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | undefined }>, pageInfo: { __typename: 'PageInfo', startCursor?: string | undefined, endCursor?: string | undefined, hasNextPage: boolean, hasPreviousPage: boolean } } };

export type ActivitiesPageInfoFieldsFragment = { __typename: 'ActivityInterfaceConnection', pageCount: number, totalCount: number, unfilteredCount: number, pageInfo: { __typename: 'PageInfo', startCursor?: string | undefined, endCursor?: string | undefined, hasNextPage: boolean, hasPreviousPage: boolean } };

export type ActivitiesConnectionFieldsFragment = { __typename: 'ActivityInterfaceConnection', activityTypes?: Array<ActivityTypeInput>, subjectTypes?: Array<ActivitySubjectInput>, uniqueParticipants?: Array<{ __typename: 'User', id: number, displayName: string, role: UserRole }>, participatingOrganizations?: Array<{ __typename: 'Organization', id: number, name: string }>, edges: Array<{ __typename: 'ActivityInterfaceEdge', cursor: string, node?: { __typename: 'AcceptRevisionsActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, supersededRevisions: Array<{ __typename: 'Revision', id: number, link: string, name: string, fieldName: string, createdAt: any, creationActivity?: { __typename: 'SuggestRevisionSetActivity', user: { __typename: 'User', displayName: string, profileImagePath?: string | undefined, id: number, role: UserRole } } | undefined }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'CommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'CreateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'CreateFeatureActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'CreateVariantActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeleteCommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeprecateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeprecateFeatureActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, variants: Array<{ __typename: 'FactorVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'FusionVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'GeneVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'Variant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeprecateVariantActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'EndorseAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'FlagEntityActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, flag: { __typename: 'Flag', id: number, link: string, name: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'ModerateAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'ModerateEvidenceItemActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'RejectRevisionsActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, createdAt: any, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'ResolveFlagActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'RevokeEndorsementActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'SubmitAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'SubmitEvidenceItemActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'SuggestRevisionSetActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, createdAt: any, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'SuggestSourceActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, sourceSuggestion: { __typename: 'SourceSuggestion', id: number, status: SourceSuggestionStatus, source?: { __typename: 'Source', id: number, name: string, link: string, deprecated: boolean } | undefined, molecularProfile?: { __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean } | undefined, disease?: { __typename: 'Disease', id: number, name: string, link: string, deprecated: boolean } | undefined }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'UpdateSourceSuggestionStatusActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, sourceSuggestion: { __typename: 'SourceSuggestion', status: SourceSuggestionStatus, source?: { __typename: 'Source', id: number, name: string, link: string, deprecated: boolean } | undefined, molecularProfile?: { __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean } | undefined, disease?: { __typename: 'Disease', id: number, name: string, link: string, deprecated: boolean } | undefined }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | undefined }> };

type ActivityFeedItemBase_AcceptRevisionsActivity_Fragment = { __typename: 'AcceptRevisionsActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_CommentActivity_Fragment = { __typename: 'CommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_CreateComplexMolecularProfileActivity_Fragment = { __typename: 'CreateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_CreateFeatureActivity_Fragment = { __typename: 'CreateFeatureActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_CreateVariantActivity_Fragment = { __typename: 'CreateVariantActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_DeleteCommentActivity_Fragment = { __typename: 'DeleteCommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_DeprecateComplexMolecularProfileActivity_Fragment = { __typename: 'DeprecateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_DeprecateFeatureActivity_Fragment = { __typename: 'DeprecateFeatureActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_DeprecateVariantActivity_Fragment = { __typename: 'DeprecateVariantActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_EndorseAssertionActivity_Fragment = { __typename: 'EndorseAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_FlagEntityActivity_Fragment = { __typename: 'FlagEntityActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_ModerateAssertionActivity_Fragment = { __typename: 'ModerateAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_ModerateEvidenceItemActivity_Fragment = { __typename: 'ModerateEvidenceItemActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_RejectRevisionsActivity_Fragment = { __typename: 'RejectRevisionsActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_ResolveFlagActivity_Fragment = { __typename: 'ResolveFlagActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_RevokeEndorsementActivity_Fragment = { __typename: 'RevokeEndorsementActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_SubmitAssertionActivity_Fragment = { __typename: 'SubmitAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_SubmitEvidenceItemActivity_Fragment = { __typename: 'SubmitEvidenceItemActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_SuggestRevisionSetActivity_Fragment = { __typename: 'SuggestRevisionSetActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_SuggestSourceActivity_Fragment = { __typename: 'SuggestSourceActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItemBase_UpdateSourceSuggestionStatusActivity_Fragment = { __typename: 'UpdateSourceSuggestionStatusActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

export type ActivityFeedItemBaseFragment = ActivityFeedItemBase_AcceptRevisionsActivity_Fragment | ActivityFeedItemBase_CommentActivity_Fragment | ActivityFeedItemBase_CreateComplexMolecularProfileActivity_Fragment | ActivityFeedItemBase_CreateFeatureActivity_Fragment | ActivityFeedItemBase_CreateVariantActivity_Fragment | ActivityFeedItemBase_DeleteCommentActivity_Fragment | ActivityFeedItemBase_DeprecateComplexMolecularProfileActivity_Fragment | ActivityFeedItemBase_DeprecateFeatureActivity_Fragment | ActivityFeedItemBase_DeprecateVariantActivity_Fragment | ActivityFeedItemBase_EndorseAssertionActivity_Fragment | ActivityFeedItemBase_FlagEntityActivity_Fragment | ActivityFeedItemBase_ModerateAssertionActivity_Fragment | ActivityFeedItemBase_ModerateEvidenceItemActivity_Fragment | ActivityFeedItemBase_RejectRevisionsActivity_Fragment | ActivityFeedItemBase_ResolveFlagActivity_Fragment | ActivityFeedItemBase_RevokeEndorsementActivity_Fragment | ActivityFeedItemBase_SubmitAssertionActivity_Fragment | ActivityFeedItemBase_SubmitEvidenceItemActivity_Fragment | ActivityFeedItemBase_SuggestRevisionSetActivity_Fragment | ActivityFeedItemBase_SuggestSourceActivity_Fragment | ActivityFeedItemBase_UpdateSourceSuggestionStatusActivity_Fragment;

type ActivityFeedItem_AcceptRevisionsActivity_Fragment = { __typename: 'AcceptRevisionsActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, supersededRevisions: Array<{ __typename: 'Revision', id: number, link: string, name: string, fieldName: string, createdAt: any, creationActivity?: { __typename: 'SuggestRevisionSetActivity', user: { __typename: 'User', displayName: string, profileImagePath?: string | undefined, id: number, role: UserRole } } | undefined }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_CommentActivity_Fragment = { __typename: 'CommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_CreateComplexMolecularProfileActivity_Fragment = { __typename: 'CreateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_CreateFeatureActivity_Fragment = { __typename: 'CreateFeatureActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } };

type ActivityFeedItem_CreateVariantActivity_Fragment = { __typename: 'CreateVariantActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_DeleteCommentActivity_Fragment = { __typename: 'DeleteCommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_DeprecateComplexMolecularProfileActivity_Fragment = { __typename: 'DeprecateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_DeprecateFeatureActivity_Fragment = { __typename: 'DeprecateFeatureActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, variants: Array<{ __typename: 'FactorVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'FusionVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'GeneVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'Variant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_DeprecateVariantActivity_Fragment = { __typename: 'DeprecateVariantActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_EndorseAssertionActivity_Fragment = { __typename: 'EndorseAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_FlagEntityActivity_Fragment = { __typename: 'FlagEntityActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, flag: { __typename: 'Flag', id: number, link: string, name: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_ModerateAssertionActivity_Fragment = { __typename: 'ModerateAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_ModerateEvidenceItemActivity_Fragment = { __typename: 'ModerateEvidenceItemActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_RejectRevisionsActivity_Fragment = { __typename: 'RejectRevisionsActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, createdAt: any, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_ResolveFlagActivity_Fragment = { __typename: 'ResolveFlagActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_RevokeEndorsementActivity_Fragment = { __typename: 'RevokeEndorsementActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_SubmitAssertionActivity_Fragment = { __typename: 'SubmitAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_SubmitEvidenceItemActivity_Fragment = { __typename: 'SubmitEvidenceItemActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_SuggestRevisionSetActivity_Fragment = { __typename: 'SuggestRevisionSetActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, createdAt: any, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_SuggestSourceActivity_Fragment = { __typename: 'SuggestSourceActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, sourceSuggestion: { __typename: 'SourceSuggestion', id: number, status: SourceSuggestionStatus, source?: { __typename: 'Source', id: number, name: string, link: string, deprecated: boolean } | undefined, molecularProfile?: { __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean } | undefined, disease?: { __typename: 'Disease', id: number, name: string, link: string, deprecated: boolean } | undefined }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

type ActivityFeedItem_UpdateSourceSuggestionStatusActivity_Fragment = { __typename: 'UpdateSourceSuggestionStatusActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, sourceSuggestion: { __typename: 'SourceSuggestion', status: SourceSuggestionStatus, source?: { __typename: 'Source', id: number, name: string, link: string, deprecated: boolean } | undefined, molecularProfile?: { __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean } | undefined, disease?: { __typename: 'Disease', id: number, name: string, link: string, deprecated: boolean } | undefined }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type ActivityFeedItemFragment = ActivityFeedItem_AcceptRevisionsActivity_Fragment | ActivityFeedItem_CommentActivity_Fragment | ActivityFeedItem_CreateComplexMolecularProfileActivity_Fragment | ActivityFeedItem_CreateFeatureActivity_Fragment | ActivityFeedItem_CreateVariantActivity_Fragment | ActivityFeedItem_DeleteCommentActivity_Fragment | ActivityFeedItem_DeprecateComplexMolecularProfileActivity_Fragment | ActivityFeedItem_DeprecateFeatureActivity_Fragment | ActivityFeedItem_DeprecateVariantActivity_Fragment | ActivityFeedItem_EndorseAssertionActivity_Fragment | ActivityFeedItem_FlagEntityActivity_Fragment | ActivityFeedItem_ModerateAssertionActivity_Fragment | ActivityFeedItem_ModerateEvidenceItemActivity_Fragment | ActivityFeedItem_RejectRevisionsActivity_Fragment | ActivityFeedItem_ResolveFlagActivity_Fragment | ActivityFeedItem_RevokeEndorsementActivity_Fragment | ActivityFeedItem_SubmitAssertionActivity_Fragment | ActivityFeedItem_SubmitEvidenceItemActivity_Fragment | ActivityFeedItem_SuggestRevisionSetActivity_Fragment | ActivityFeedItem_SuggestSourceActivity_Fragment | ActivityFeedItem_UpdateSourceSuggestionStatusActivity_Fragment;

export type ActivityFeedUpdatesQueryVariables = Exact<{
  subject?: InputMaybe<Array<SubscribableQueryInput> | SubscribableQueryInput>;
  organizationId?: InputMaybe<Array<Scalars['Int']['input']> | Scalars['Int']['input']>;
  includeSubgroups?: InputMaybe<Scalars['Boolean']['input']>;
  userId?: InputMaybe<Array<Scalars['Int']['input']> | Scalars['Int']['input']>;
  activityType?: InputMaybe<Array<ActivityTypeInput> | ActivityTypeInput>;
  subjectType?: InputMaybe<Array<ActivitySubjectInput> | ActivitySubjectInput>;
  includeAutomatedEvents?: InputMaybe<Scalars['Boolean']['input']>;
  mode?: InputMaybe<EventFeedMode>;
  occurredAfter?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
}>;


export type ActivityFeedUpdatesQuery = { __typename: 'Query', activities: { __typename: 'ActivityInterfaceConnection', pageCount: number, totalCount: number, unfilteredCount: number, pageInfo: { __typename: 'PageInfo', startCursor?: string | undefined, endCursor?: string | undefined, hasNextPage: boolean, hasPreviousPage: boolean } } };

export type OrgFilterSearchQueryVariables = Exact<{
  name?: InputMaybe<Scalars['String']['input']>;
}>;


export type OrgFilterSearchQuery = { __typename: 'Query', browseOrganizations: { __typename: 'BrowseOrganizationConnection', pageInfo: { __typename: 'PageInfo', endCursor?: string | undefined, hasNextPage: boolean, hasPreviousPage: boolean, startCursor?: string | undefined }, edges: Array<{ __typename: 'BrowseOrganizationEdge', node?: { __typename: 'BrowseOrganization', id: number, name: string } | undefined }> } };

export type UserFilterSearchQueryVariables = Exact<{
  name?: InputMaybe<Scalars['String']['input']>;
}>;


export type UserFilterSearchQuery = { __typename: 'Query', browseUsers: { __typename: 'BrowseUserConnection', pageInfo: { __typename: 'PageInfo', endCursor?: string | undefined, hasNextPage: boolean, hasPreviousPage: boolean, startCursor?: string | undefined }, edges: Array<{ __typename: 'BrowseUserEdge', node?: { __typename: 'BrowseUser', id: number, displayName: string, name?: string | undefined, username: string, role: UserRole } | undefined }> } };

export type AcceptRevisionsActivityDetailFragment = { __typename: 'AcceptRevisionsActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, supersededRevisions: Array<{ __typename: 'Revision', id: number, link: string, name: string, fieldName: string, createdAt: any, creationActivity?: { __typename: 'SuggestRevisionSetActivity', user: { __typename: 'User', displayName: string, profileImagePath?: string | undefined, id: number, role: UserRole } } | undefined }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type CommentActivityDetailFragment = { __typename: 'CommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type CreateComplexMolecularProfileActivityDetailFragment = { __typename: 'CreateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type CreateVariantActivityDetailFragment = { __typename: 'CreateVariantActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type DeleteCommentActivityDetailFragment = { __typename: 'DeleteCommentActivity', id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type DeprecateFeatureActivityDetailFragment = { __typename: 'DeprecateFeatureActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, variants: Array<{ __typename: 'FactorVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'FusionVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'GeneVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'Variant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type DeprecateComplexMolecularProfileActivityDetailFragment = { __typename: 'DeprecateComplexMolecularProfileActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type DeprecateVariantActivityDetailFragment = { __typename: 'DeprecateVariantActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type EndorseAssertionActivityDetailFragment = { __typename: 'EndorseAssertionActivity', id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type FlagEntityActivityDetailFragment = { __typename: 'FlagEntityActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, flag: { __typename: 'Flag', id: number, link: string, name: string }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type ModerateAssertionActivityDetailFragment = { __typename: 'ModerateAssertionActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type ModerateEvidenceItemActivityDetailFragment = { __typename: 'ModerateEvidenceItemActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type RejectRevisionsActivityDetailFragment = { __typename: 'RejectRevisionsActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, createdAt: any, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type ResolveFlagActivityDetailFragment = { __typename: 'ResolveFlagActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type RevokeEndorsementActivityDetailFragment = { __typename: 'RevokeEndorsementActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type SubmitAssertionActivityDetailFragment = { __typename: 'SubmitAssertionActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type SubmitEvidenceItemActivityDetailFragment = { __typename: 'SubmitEvidenceItemActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type SuggestRevisionSetActivityDetailFragment = { __typename: 'SuggestRevisionSetActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, createdAt: any, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type SuggestSourceActivityDetailFragment = { __typename: 'SuggestSourceActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, sourceSuggestion: { __typename: 'SourceSuggestion', id: number, status: SourceSuggestionStatus, source?: { __typename: 'Source', id: number, name: string, link: string, deprecated: boolean } | undefined, molecularProfile?: { __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean } | undefined, disease?: { __typename: 'Disease', id: number, name: string, link: string, deprecated: boolean } | undefined }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type UpdateSourceSuggestionStatusActivityDetailFragment = { __typename: 'UpdateSourceSuggestionStatusActivity', id: number, verbiage: string, createdAt: any, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, sourceSuggestion: { __typename: 'SourceSuggestion', status: SourceSuggestionStatus, source?: { __typename: 'Source', id: number, name: string, link: string, deprecated: boolean } | undefined, molecularProfile?: { __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean } | undefined, disease?: { __typename: 'Disease', id: number, name: string, link: string, deprecated: boolean } | undefined }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> };

export type ActivityFeedItemQueryVariables = Exact<{
  id: Scalars['Int']['input'];
  requestDetails: Scalars['Boolean']['input'];
}>;


export type ActivityFeedItemQuery = { __typename: 'Query', activity?: { __typename: 'AcceptRevisionsActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, revisions: Array<{ __typename: 'Revision', id: number, name: string, status: RevisionStatus, currentValue?: any | undefined, suggestedValue?: any | undefined, fieldName: string, link: string, linkoutData: { __typename: 'LinkoutData', name: string, diffValue: { __typename: 'ObjectFieldDiff', currentObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, addedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, removedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, keptObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }>, suggestedObjects: Array<{ __typename: 'ModeratedObjectField', id: number, displayName?: string | undefined, displayType?: string | undefined, entityType: string, link?: string | undefined, deleted: boolean, deprecated?: boolean | undefined, flagged?: boolean | undefined, feature?: { __typename: 'LinkableFeature', link: string, id: number, name: string, deprecated: boolean, flagged: boolean } | undefined }> } | { __typename: 'ScalarFieldDiff', left: string, right: string } } }>, supersededRevisions: Array<{ __typename: 'Revision', id: number, link: string, name: string, fieldName: string, createdAt: any, creationActivity?: { __typename: 'SuggestRevisionSetActivity', user: { __typename: 'User', displayName: string, profileImagePath?: string | undefined, id: number, role: UserRole } } | undefined }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'CommentActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'CreateComplexMolecularProfileActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'CreateFeatureActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'CreateVariantActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeleteCommentActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, comment: { __typename: 'Comment', id: number, name: string, link: string, deleted: boolean, deletedAt?: any | undefined, title?: string | undefined, comment: string, createdAt: any, commenter: { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }, parsedComment: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }> }, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeprecateComplexMolecularProfileActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeprecateFeatureActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, variants: Array<{ __typename: 'FactorVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'FusionVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'GeneVariant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | { __typename: 'Variant', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'DeprecateVariantActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, molecularProfiles: Array<{ __typename: 'MolecularProfile', id: number, name: string, link: string, deprecated: boolean, flagged: boolean }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'EndorseAssertionActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'FlagEntityActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, flag: { __typename: 'Flag', id: number, link: string, name: string }, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'ModerateAssertionActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string } } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'ExonCoordinate', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string, feature: { __typename: 'Feature', id: number, name: string, link: string } } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'RevisionSet', id: number, name: string, link: string } | { __typename: 'Source', id: number, name: string, link: string } | { __typename: 'SourcePopover', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | { __typename: 'VariantCoordinate', id: number, name: string, link: string } | { __typename: 'VariantGroup', id: number, name: string, link: string }, parsedNote: Array<{ __typename: 'CommentTagSegment', entityId: number, displayName: string, tagType: TaggableEntity, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlagged', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndDeprecated', entityId: number, displayName: string, tagType: TaggableEntity, flagged: boolean, deprecated: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTagSegmentFlaggedAndWithStatus', entityId: number, displayName: string, tagType: TaggableEntity, status: EvidenceStatus, flagged: boolean, link: string, revisionSetId?: number | undefined, feature?: { __typename: 'LinkableFeature', id: number, name: string, link: string, deprecated: boolean, flagged: boolean } | undefined } | { __typename: 'CommentTextSegment', text: string } | { __typename: 'User', id: number, username: string, displayName: string, name?: string | undefined, role: UserRole, profileImagePath?: string | undefined, organizations: Array<{ __typename: 'Organization', id: number, name: string, profileImagePath?: string | undefined }> }>, events: Array<{ __typename: 'Event', id: number, createdAt: any, action: EventAction, originatingObject?: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', id: number, name: string, link: string } | { __typename: 'EvidenceItem', id: number, name: string, link: string } | { __typename: 'Factor', id: number, name: string, link: string } | { __typename: 'FactorVariant', id: number, name: string, link: string } | { __typename: 'Feature', id: number, name: string, link: string } | { __typename: 'Flag', id: number, name: string, link: string } | { __typename: 'Fusion', id: number, name: string, link: string } | { __typename: 'FusionVariant', id: number, name: string, link: string } | { __typename: 'Gene', id: number, name: string, link: string } | { __typename: 'GeneVariant', id: number, name: string, link: string } | { __typename: 'MolecularProfile', id: number, name: string, link: string } | { __typename: 'Revision', id: number, name: string, link: string } | { __typename: 'SourceSuggestion', id: number, name: string, link: string } | { __typename: 'Variant', id: number, name: string, link: string } | undefined, originatingUser: { __typename: 'User', id: number, displayName: string } }> } | { __typename: 'ModerateEvidenceItemActivity', note?: string | undefined, id: number, verbiage: string, createdAt: any, organization?: { __typename: 'Organization', id: number, name: string } | undefined, user: { __typename: 'User', id: number, displayName: string, role: UserRole }, subject: { __typename: 'Assertion', id: number, name: string, link: string } | { __typename: 'Comment', deleted: boolean, deletedAt?: any | undefined, id: number, name: string, link: string, commentable: { __typename: 'Assertion', id: number, na