/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Checksum;

final class Adler32
implements Checksum {
    private static final int BASE = 65521;
    private static final int NMAX = 5552;
    private long adler = 1L;

    Adler32() {
    }

    public void reset(long init) {
        this.adler = init;
    }

    public void reset() {
        this.adler = 1L;
    }

    public long getValue() {
        return this.adler;
    }

    public void update(byte[] buf, int index, int len) {
        long s1 = this.adler & 0xFFFFL;
        long s2 = this.adler >> 16 & 0xFFFFL;
        while (len > 0) {
            int k = len < 5552 ? len : 5552;
            len -= k;
            while (k-- > 0) {
                s2 += (s1 += (long)(buf[index++] & 0xFF));
            }
            s1 %= 65521L;
            s2 %= 65521L;
        }
        this.adler = s2 << 16 | s1;
    }

    public Adler32 copy() {
        Adler32 foo = new Adler32();
        foo.adler = this.adler;
        return foo;
    }

    static long combine(long adler1, long adler2, long len2) {
        long BASEL = 65521L;
        long rem = len2 % BASEL;
        long sum1 = adler1 & 0xFFFFL;
        long sum2 = rem * sum1;
        sum2 %= BASEL;
        sum2 += (adler1 >> 16 & 0xFFFFL) + (adler2 >> 16 & 0xFFFFL) + BASEL - rem;
        if ((sum1 += (adler2 & 0xFFFFL) + BASEL - 1L) >= BASEL) {
            sum1 -= BASEL;
        }
        if (sum1 >= BASEL) {
            sum1 -= BASEL;
        }
        if (sum2 >= BASEL << 1) {
            sum2 -= BASEL << 1;
        }
        if (sum2 >= BASEL) {
            sum2 -= BASEL;
        }
        return sum1 | sum2 << 16;
    }
}

