/*
Copyright 2019 Gravitational, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/gravitational/wormhole/pkg/apis/wormhole.gravitational.io/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// WgnodeLister helps list Wgnodes.
type WgnodeLister interface {
	// List lists all Wgnodes in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.Wgnode, err error)
	// Wgnodes returns an object that can list and get Wgnodes.
	Wgnodes(namespace string) WgnodeNamespaceLister
	WgnodeListerExpansion
}

// wgnodeLister implements the WgnodeLister interface.
type wgnodeLister struct {
	indexer cache.Indexer
}

// NewWgnodeLister returns a new WgnodeLister.
func NewWgnodeLister(indexer cache.Indexer) WgnodeLister {
	return &wgnodeLister{indexer: indexer}
}

// List lists all Wgnodes in the indexer.
func (s *wgnodeLister) List(selector labels.Selector) (ret []*v1beta1.Wgnode, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Wgnode))
	})
	return ret, err
}

// Wgnodes returns an object that can list and get Wgnodes.
func (s *wgnodeLister) Wgnodes(namespace string) WgnodeNamespaceLister {
	return wgnodeNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// WgnodeNamespaceLister helps list and get Wgnodes.
type WgnodeNamespaceLister interface {
	// List lists all Wgnodes in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta1.Wgnode, err error)
	// Get retrieves the Wgnode from the indexer for a given namespace and name.
	Get(name string) (*v1beta1.Wgnode, error)
	WgnodeNamespaceListerExpansion
}

// wgnodeNamespaceLister implements the WgnodeNamespaceLister
// interface.
type wgnodeNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Wgnodes in the indexer for a given namespace.
func (s wgnodeNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.Wgnode, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Wgnode))
	})
	return ret, err
}

// Get retrieves the Wgnode from the indexer for a given namespace and name.
func (s wgnodeNamespaceLister) Get(name string) (*v1beta1.Wgnode, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("wgnode"), name)
	}
	return obj.(*v1beta1.Wgnode), nil
}
