package cudnn

/* Generated by gencudnn. DO NOT EDIT */

// #include <cudnn.h>
import "C"
import "runtime"

type RNNPlan struct {
	internal C.cudnnPersistentRNNPlan_t

	minibatch int
	dataType  DataType
	desc      *RNN
}

func NewRNNPlan(minibatch int, dataType DataType, desc *RNN) (plan *RNNPlan, err error) {
	var internal C.cudnnPersistentRNNPlan_t
	if err = result(C.cudnnCreatePersistentRNNPlan(desc.internal, C.int(minibatch), dataType.C(), &internal)); err != nil {
		return nil, err
	}
	plan = &RNNPlan{
		internal:  internal,
		minibatch: minibatch,
		dataType:  dataType,
		desc:      desc,
	}
	runtime.SetFinalizer(plan, destroyRNNPlan)
	return plan, nil
}

func (p *RNNPlan) Update(rnn *RNN) error {
	if p.desc == rnn {
		return nil
	}
	return result(C.cudnnSetPersistentRNNPlan(rnn.internal, p.internal))
}

func destroyRNNPlan(obj *RNNPlan) { C.cudnnDestroyPersistentRNNPlan(obj.internal) }

// RNN is a representation of cudnnRNNDescriptor_t.
type RNN struct {
	internal C.cudnnRNNDescriptor_t

	hiddenSize        int
	layers            int
	dropoutDescriptor *Dropout
	inputMode         RNNInputMode
	directionMode     DirectionMode
	mode              RNNMode
	algo              RNNAlgo
	dataType          DataType
	matrixMathType    MathType

	// workspace related
	seqLength     int
	workspaceSize uintptr
}

// NewRNN creates a new RNN.
func (handle *Context) NewRNN(hiddenSize int, numLayers int, dropout *Dropout, inputMode RNNInputMode, direction DirectionMode, mode RNNMode, algo RNNAlgo, dataType DataType) (retVal *RNN, err error) {
	var internal C.cudnnRNNDescriptor_t
	if err := result(C.cudnnCreateRNNDescriptor(&internal)); err != nil {
		return nil, err
	}

	if err := result(C.cudnnSetRNNDescriptor(handle.internal, internal, C.int(hiddenSize), C.int(numLayers), dropout.internal, inputMode.C(), direction.C(), mode.C(), algo.C(), dataType.C())); err != nil {
		return nil, err
	}

	retVal = &RNN{
		internal: internal,

		hiddenSize:        hiddenSize,
		layers:            numLayers,
		dropoutDescriptor: dropout,
		inputMode:         inputMode,
		directionMode:     direction,
		mode:              mode,
		algo:              algo,
		dataType:          dataType,
		matrixMathType:    DefaultMath,
	}
	runtime.SetFinalizer(retVal, destroyRNN)
	return retVal, nil
}

func (r *RNN) HiddenSize() int              { return r.hiddenSize }
func (r *RNN) NumLayers() int               { return r.layers }
func (r *RNN) Dropout() *Dropout            { return r.dropoutDescriptor }
func (r *RNN) InputMode() RNNInputMode      { return r.inputMode }
func (r *RNN) DirectionMode() DirectionMode { return r.directionMode }
func (r *RNN) Mode() RNNMode                { return r.mode }
func (r *RNN) Algo() RNNAlgo                { return r.algo }
func (r *RNN) DataType() DataType           { return r.dataType }
func (r *RNN) MatrixMathType() MathType     { return r.matrixMathType }

func (r *RNN) SetMatrixMathType(mathType MathType) error {
	if mathType == r.matrixMathType {
		return nil
	}
	return result(C.cudnnSetRNNMatrixMathType(r.internal, mathType.C()))
}

func destroyRNN(obj *RNN) { C.cudnnDestroyRNNDescriptor(obj.internal) }
