package cudnn

/* Generated by gencudnn. DO NOT EDIT */

// #include <cudnn.h>
import "C"
import (
	"runtime"
	"unsafe"

	"github.com/pkg/errors"
)

// Pooling is a representation of cudnnPoolingDescriptor_t.
type Pooling struct {
	internal C.cudnnPoolingDescriptor_t

	mode              PoolingMode
	maxpoolingNanNopt NanPropagation
	shape             []int
	padding           []int
	strides           []int

	// cache output shapes
	outDims     int // the dims for which the output shape was requested
	outputShape []int
	inputTensor []int
}

// NewPooling creates a new Pooling op.
func NewPooling(mode PoolingMode, maxpoolingNanOpt NanPropagation, shape, strides, padding []int) (retVal *Pooling, err error) {
	var internal C.cudnnPoolingDescriptor_t
	if err = result(C.cudnnCreatePoolingDescriptor(&internal)); err != nil {
		return nil, err
	}

	// checks shapes and strides
	if len(shape) != len(strides) || len(strides) != len(padding) {
		return nil, errors.Errorf(shapeMismatch3, shape, strides, padding)
	}

	switch len(shape) {
	case 0:
		return nil, errors.Errorf("Cannot perform pooling with shape %v", shape)
	case 2:
		windowHeight, windowWidth := shape[0], shape[1]
		verticalPadding, horizontalPadding := padding[0], padding[1]
		verticalStride, horizontalStride := strides[0], strides[1]
		if err = result(C.cudnnSetPooling2dDescriptor(internal, mode.C(), maxpoolingNanOpt.C(), C.int(windowHeight), C.int(windowWidth), C.int(verticalPadding), C.int(horizontalPadding), C.int(verticalStride), C.int(horizontalStride))); err != nil {
			return nil, err
		}
	default:
		nbDims := len(shape)
		shapePtr, shapePtrManaged := ints2CIntPtr(shape)
		defer returnManaged(shapePtrManaged)
		paddingPtr, paddingPtrManaged := ints2CIntPtr(padding)
		defer returnManaged(paddingPtrManaged)
		stridePtr, stridePtrManaged := ints2CIntPtr(strides)
		defer returnManaged(stridePtrManaged)
		if err = result(C.cudnnSetPoolingNdDescriptor(internal, mode.C(), maxpoolingNanOpt.C(), C.int(nbDims), shapePtr, paddingPtr, stridePtr)); err != nil {
			return nil, err
		}
	}

	retVal = &Pooling{
		internal:          internal,
		mode:              mode,
		maxpoolingNanNopt: maxpoolingNanOpt,
		shape:             shape,
		padding:           padding,
		strides:           strides,
	}
	runtime.SetFinalizer(retVal, destroyPooling)
	return retVal, nil
}

// Mode returns the Pooling Mode of the pooling operation.
func (p *Pooling) Mode() PoolingMode { return p.mode }

// NaNPropagation returns the NaN propagation strategy when the pooling type is a max pooling.
func (p *Pooling) NaNPropagation() NanPropagation { return p.maxpoolingNanNopt }

// Shape returns a copy of the input window shape.
func (p *Pooling) Shape() []int { return cloneShape(p.shape) }

// Padding returns a copy of the input padding shape
func (p *Pooling) Padding() []int { return cloneShape(p.padding) }

// Strides returns a copy of the input strides
func (p *Pooling) Strides() []int { return cloneShape(p.strides) }

// OutputShape computes the output shape given the input tensor.
//
// This method caches the outputShape. If a inputTensor is seen before, and the dims is exactly the same, then the cached output shape is used
func (p *Pooling) OutputShape(input *TensorDescriptor, dims int) (retVal []int, err error) {
	if dims == p.outDims && shapeEq(input.shape, p.inputTensor) {
		return cloneShape(p.outputShape), nil
	}
	return p.CalcOutputShape(input, dims)
}

// CalcOutputShape is like  OutputShape, but doesn't go through a check for the cached value.
func (p *Pooling) CalcOutputShape(input *TensorDescriptor, dims int) (retVal []int, err error) {
	p.outDims = dims
	p.inputTensor = cloneShape(input.shape)

	switch dims {
	case 0:
		return nil, errors.Errorf("Cannot work on dims of 0")
	case 2:
		p.outputShape = make([]int, 4)
		n := (*C.int)(unsafe.Pointer(&p.outputShape[0]))
		c := (*C.int)(unsafe.Pointer(&p.outputShape[1]))
		h := (*C.int)(unsafe.Pointer(&p.outputShape[2]))
		w := (*C.int)(unsafe.Pointer(&p.outputShape[3]))
		if err = result(C.cudnnGetPooling2dForwardOutputDim(p.internal, input.internal, n, c, h, w)); err != nil {
			return nil, err
		}

	default:
		p.outputShape = make([]int, dims)
		ptr, ptrManaged := ints2CIntPtr(p.outputShape)
		defer returnManaged(ptrManaged)
		if err = result(C.cudnnGetPoolingNdForwardOutputDim(p.internal, input.internal, C.int(dims), ptr)); err != nil {
			return nil, err
		}
	}
	return cloneShape(p.outputShape), nil
}

func destroyPooling(obj *Pooling) { C.cudnnDestroyPoolingDescriptor(obj.internal) }
