package cudnn

/* Generated by gencudnn. DO NOT EDIT */

// #include <cudnn.h>
import "C"
import (
	"github.com/pkg/errors"
)

// Filter is a representation of cudnnFilterDescriptor_t.
type Filter struct {
	internal C.cudnnFilterDescriptor_t

	dataType DataType
	format   TensorFormat
	shape    []int
}

// NewFilter creates a new Filter.
func NewFilter(dataType DataType, format TensorFormat, shape []int) (retVal *Filter, err error) {
	var internal C.cudnnFilterDescriptor_t
	if err = result(C.cudnnCreateFilterDescriptor(&internal)); err != nil {
		return nil, err
	}
	switch len(shape) {
	case 0, 1, 2, 3:
		return nil, errors.New("Cannot create filter with a shape < 4 dimensions")
	case 4:
		if err = result(C.cudnnSetFilter4dDescriptor(internal, dataType.C(), format.C(), C.int(shape[0]), C.int(shape[1]), C.int(shape[2]), C.int(shape[3]))); err != nil {
			return nil, err
		}
	default:
		filterDimA, filterDimAManaged := ints2CIntPtr(shape)
		defer returnManaged(filterDimAManaged)
		if err = result(C.cudnnSetFilterNdDescriptor(internal, dataType.C(), format.C(), C.int(len(shape)), filterDimA)); err != nil {
			return nil, err
		}
	}
	return &Filter{
		internal: internal,
		format:   format,
		shape:    shape,
	}, nil
}

// DataType returns the data type of the filter
func (f *Filter) DataType() DataType { return f.dataType }

// Filter returns the TensorFormat of the filter
func (f *Filter) Format() TensorFormat { return f.format }

// Shape returns a copy of the shape.
func (f *Filter) Shape() []int {
	retVal := make([]int, len(f.shape))
	copy(retVal, f.shape)
	return retVal
}

func destroyFilter(obj *Filter) { C.cudnnDestroyFilterDescriptor(obj.internal) }
