package cu

// #include <cuda.h>
import "C"
import (
	"unsafe"

	"github.com/pkg/errors"
)

// This file was generated by the genlib program. DO NOT EDIT

func (ctx *Ctx) CurrentDevice() (device Device, err error) {
	return ctx.device, nil
}

func (ctx *Ctx) CurrentFlags() (flags ContextFlags, err error) {
	return ctx.flags, nil
}

func (ctx *Ctx) Synchronize() {
	f := func() error {
		return result(C.cuCtxSynchronize())
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetLimit(limit Limit, value int64) {
	Climit := C.CUlimit(limit)
	Cvalue := C.size_t(value)
	f := func() error {
		return result(C.cuCtxSetLimit(Climit, Cvalue))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Limits(limit Limit) (pvalue int64, err error) {
	Climit := C.CUlimit(limit)
	var Cpvalue C.size_t
	f := func() error {
		return result(C.cuCtxGetLimit(&Cpvalue, Climit))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Limits")
	}
	pvalue = int64(Cpvalue)
	return
}

func (ctx *Ctx) CurrentCacheConfig() (pconfig FuncCacheConfig, err error) {
	var Cpconfig C.CUfunc_cache
	f := func() error {
		return result(C.cuCtxGetCacheConfig(&Cpconfig))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "CurrentCacheConfig")
	}
	pconfig = FuncCacheConfig(Cpconfig)
	return
}

func (ctx *Ctx) SetCurrentCacheConfig(config FuncCacheConfig) {
	Cconfig := C.CUfunc_cache(config)
	f := func() error {
		return result(C.cuCtxSetCacheConfig(Cconfig))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SharedMemConfig() (pConfig SharedConfig, err error) {
	var CpConfig C.CUsharedconfig
	f := func() error {
		return result(C.cuCtxGetSharedMemConfig(&CpConfig))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "SharedMemConfig")
	}
	pConfig = SharedConfig(CpConfig)
	return
}

func (ctx *Ctx) SetSharedMemConfig(config SharedConfig) {
	Cconfig := C.CUsharedconfig(config)
	f := func() error {
		return result(C.cuCtxSetSharedMemConfig(Cconfig))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) StreamPriorityRange() (leastPriority int, greatestPriority int, err error) {
	var CleastPriority C.int
	var CgreatestPriority C.int
	f := func() error {
		return result(C.cuCtxGetStreamPriorityRange(&CleastPriority, &CgreatestPriority))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "StreamPriorityRange")
	}
	leastPriority = int(CleastPriority)
	greatestPriority = int(CgreatestPriority)
	return
}

func (ctx *Ctx) Unload(hmod Module) {
	Chmod := hmod.c()
	f := func() error {
		return result(C.cuModuleUnload(Chmod))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemInfo() (free int64, total int64, err error) {
	var Cfree C.size_t
	var Ctotal C.size_t
	f := func() error {
		return result(C.cuMemGetInfo(&Cfree, &Ctotal))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "MemInfo")
	}
	free = int64(Cfree)
	total = int64(Ctotal)
	return
}

func (ctx *Ctx) MemAlloc(bytesize int64) (dptr DevicePtr, err error) {
	Cbytesize := C.size_t(bytesize)
	var Cdptr C.CUdeviceptr
	f := func() error {
		return result(C.cuMemAlloc(&Cdptr, Cbytesize))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "MemAlloc")
	}
	dptr = DevicePtr(Cdptr)
	return
}

func (ctx *Ctx) MemAllocPitch(WidthInBytes int64, Height int64, ElementSizeBytes uint) (dptr DevicePtr, pPitch int64, err error) {
	CWidthInBytes := C.size_t(WidthInBytes)
	CHeight := C.size_t(Height)
	CElementSizeBytes := C.uint(ElementSizeBytes)
	var Cdptr C.CUdeviceptr
	var CpPitch C.size_t
	f := func() error {
		return result(C.cuMemAllocPitch(&Cdptr, &CpPitch, CWidthInBytes, CHeight, CElementSizeBytes))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "MemAllocPitch")
	}
	dptr = DevicePtr(Cdptr)
	pPitch = int64(CpPitch)
	return
}

func (ctx *Ctx) MemFree(dptr DevicePtr) {
	Cdptr := C.CUdeviceptr(dptr)
	f := func() error {
		return result(C.cuMemFree(Cdptr))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemFreeHost(p unsafe.Pointer) {
	Cp := p
	f := func() error {
		return result(C.cuMemFreeHost(Cp))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemAllocManaged(bytesize int64, flags MemAttachFlags) (dptr DevicePtr, err error) {
	Cbytesize := C.size_t(bytesize)
	Cflags := C.uint(flags)
	var Cdptr C.CUdeviceptr
	f := func() error {
		return result(C.cuMemAllocManaged(&Cdptr, Cbytesize, Cflags))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "MemAllocManaged")
	}
	dptr = DevicePtr(Cdptr)
	return
}

func (ctx *Ctx) Memcpy(dst DevicePtr, src DevicePtr, ByteCount int64) {
	Cdst := C.CUdeviceptr(dst)
	Csrc := C.CUdeviceptr(src)
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpy(Cdst, Csrc, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyPeer(dstDevice DevicePtr, dstContext CUContext, srcDevice DevicePtr, srcContext CUContext, ByteCount int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CdstContext := dstContext.c()
	CsrcDevice := C.CUdeviceptr(srcDevice)
	CsrcContext := srcContext.c()
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpyPeer(CdstDevice, CdstContext, CsrcDevice, CsrcContext, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyHtoD(dstDevice DevicePtr, srcHost unsafe.Pointer, ByteCount int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CsrcHost := srcHost
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpyHtoD(CdstDevice, CsrcHost, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyDtoH(dstHost unsafe.Pointer, srcDevice DevicePtr, ByteCount int64) {
	CdstHost := dstHost
	CsrcDevice := C.CUdeviceptr(srcDevice)
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpyDtoH(CdstHost, CsrcDevice, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyDtoD(dstDevice DevicePtr, srcDevice DevicePtr, ByteCount int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CsrcDevice := C.CUdeviceptr(srcDevice)
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpyDtoD(CdstDevice, CsrcDevice, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyDtoA(dstArray Array, dstOffset int64, srcDevice DevicePtr, ByteCount int64) {
	CdstArray := dstArray.c()
	CdstOffset := C.size_t(dstOffset)
	CsrcDevice := C.CUdeviceptr(srcDevice)
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpyDtoA(CdstArray, CdstOffset, CsrcDevice, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyAtoD(dstDevice DevicePtr, srcArray Array, srcOffset int64, ByteCount int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CsrcArray := srcArray.c()
	CsrcOffset := C.size_t(srcOffset)
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpyAtoD(CdstDevice, CsrcArray, CsrcOffset, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyHtoA(dstArray Array, dstOffset int64, srcHost unsafe.Pointer, ByteCount int64) {
	CdstArray := dstArray.c()
	CdstOffset := C.size_t(dstOffset)
	CsrcHost := srcHost
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpyHtoA(CdstArray, CdstOffset, CsrcHost, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyAtoH(dstHost unsafe.Pointer, srcArray Array, srcOffset int64, ByteCount int64) {
	CdstHost := dstHost
	CsrcArray := srcArray.c()
	CsrcOffset := C.size_t(srcOffset)
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpyAtoH(CdstHost, CsrcArray, CsrcOffset, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyAtoA(dstArray Array, dstOffset int64, srcArray Array, srcOffset int64, ByteCount int64) {
	CdstArray := dstArray.c()
	CdstOffset := C.size_t(dstOffset)
	CsrcArray := srcArray.c()
	CsrcOffset := C.size_t(srcOffset)
	CByteCount := C.size_t(ByteCount)
	f := func() error {
		return result(C.cuMemcpyAtoA(CdstArray, CdstOffset, CsrcArray, CsrcOffset, CByteCount))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Memcpy2D(pCopy Memcpy2dParam) {
	CpCopy := pCopy.c()
	f := func() error {
		return result(C.cuMemcpy2D(CpCopy))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Memcpy2DUnaligned(pCopy Memcpy2dParam) {
	CpCopy := pCopy.c()
	f := func() error {
		return result(C.cuMemcpy2DUnaligned(CpCopy))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Memcpy3D(pCopy Memcpy3dParam) {
	CpCopy := pCopy.c()
	f := func() error {
		return result(C.cuMemcpy3D(CpCopy))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Memcpy3DPeer(pCopy Memcpy3dPeerParam) {
	CpCopy := pCopy.c()
	f := func() error {
		return result(C.cuMemcpy3DPeer(CpCopy))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyAsync(dst DevicePtr, src DevicePtr, ByteCount int64, hStream Stream) {
	Cdst := C.CUdeviceptr(dst)
	Csrc := C.CUdeviceptr(src)
	CByteCount := C.size_t(ByteCount)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpyAsync(Cdst, Csrc, CByteCount, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyPeerAsync(dstDevice DevicePtr, dstContext CUContext, srcDevice DevicePtr, srcContext CUContext, ByteCount int64, hStream Stream) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CdstContext := dstContext.c()
	CsrcDevice := C.CUdeviceptr(srcDevice)
	CsrcContext := srcContext.c()
	CByteCount := C.size_t(ByteCount)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpyPeerAsync(CdstDevice, CdstContext, CsrcDevice, CsrcContext, CByteCount, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyHtoDAsync(dstDevice DevicePtr, srcHost unsafe.Pointer, ByteCount int64, hStream Stream) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CsrcHost := srcHost
	CByteCount := C.size_t(ByteCount)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpyHtoDAsync(CdstDevice, CsrcHost, CByteCount, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyDtoHAsync(dstHost unsafe.Pointer, srcDevice DevicePtr, ByteCount int64, hStream Stream) {
	CdstHost := dstHost
	CsrcDevice := C.CUdeviceptr(srcDevice)
	CByteCount := C.size_t(ByteCount)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpyDtoHAsync(CdstHost, CsrcDevice, CByteCount, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyDtoDAsync(dstDevice DevicePtr, srcDevice DevicePtr, ByteCount int64, hStream Stream) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CsrcDevice := C.CUdeviceptr(srcDevice)
	CByteCount := C.size_t(ByteCount)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpyDtoDAsync(CdstDevice, CsrcDevice, CByteCount, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyHtoAAsync(dstArray Array, dstOffset int64, srcHost unsafe.Pointer, ByteCount int64, hStream Stream) {
	CdstArray := dstArray.c()
	CdstOffset := C.size_t(dstOffset)
	CsrcHost := srcHost
	CByteCount := C.size_t(ByteCount)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpyHtoAAsync(CdstArray, CdstOffset, CsrcHost, CByteCount, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemcpyAtoHAsync(dstHost unsafe.Pointer, srcArray Array, srcOffset int64, ByteCount int64, hStream Stream) {
	CdstHost := dstHost
	CsrcArray := srcArray.c()
	CsrcOffset := C.size_t(srcOffset)
	CByteCount := C.size_t(ByteCount)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpyAtoHAsync(CdstHost, CsrcArray, CsrcOffset, CByteCount, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Memcpy2DAsync(pCopy Memcpy2dParam, hStream Stream) {
	CpCopy := pCopy.c()
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpy2DAsync(CpCopy, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Memcpy3DAsync(pCopy Memcpy3dParam, hStream Stream) {
	CpCopy := pCopy.c()
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpy3DAsync(CpCopy, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Memcpy3DPeerAsync(pCopy Memcpy3dPeerParam, hStream Stream) {
	CpCopy := pCopy.c()
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemcpy3DPeerAsync(CpCopy, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD8(dstDevice DevicePtr, uc byte, N int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	Cuc := C.uchar(uc)
	CN := C.size_t(N)
	f := func() error {
		return result(C.cuMemsetD8(CdstDevice, Cuc, CN))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD16(dstDevice DevicePtr, us uint16, N int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	Cus := C.ushort(us)
	CN := C.size_t(N)
	f := func() error {
		return result(C.cuMemsetD16(CdstDevice, Cus, CN))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD32(dstDevice DevicePtr, ui uint, N int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	Cui := C.uint(ui)
	CN := C.size_t(N)
	f := func() error {
		return result(C.cuMemsetD32(CdstDevice, Cui, CN))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD2D8(dstDevice DevicePtr, dstPitch int64, uc byte, Width int64, Height int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CdstPitch := C.size_t(dstPitch)
	Cuc := C.uchar(uc)
	CWidth := C.size_t(Width)
	CHeight := C.size_t(Height)
	f := func() error {
		return result(C.cuMemsetD2D8(CdstDevice, CdstPitch, Cuc, CWidth, CHeight))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD2D16(dstDevice DevicePtr, dstPitch int64, us uint16, Width int64, Height int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CdstPitch := C.size_t(dstPitch)
	Cus := C.ushort(us)
	CWidth := C.size_t(Width)
	CHeight := C.size_t(Height)
	f := func() error {
		return result(C.cuMemsetD2D16(CdstDevice, CdstPitch, Cus, CWidth, CHeight))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD2D32(dstDevice DevicePtr, dstPitch int64, ui uint, Width int64, Height int64) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CdstPitch := C.size_t(dstPitch)
	Cui := C.uint(ui)
	CWidth := C.size_t(Width)
	CHeight := C.size_t(Height)
	f := func() error {
		return result(C.cuMemsetD2D32(CdstDevice, CdstPitch, Cui, CWidth, CHeight))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD8Async(dstDevice DevicePtr, uc byte, N int64, hStream Stream) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	Cuc := C.uchar(uc)
	CN := C.size_t(N)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemsetD8Async(CdstDevice, Cuc, CN, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD16Async(dstDevice DevicePtr, us uint16, N int64, hStream Stream) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	Cus := C.ushort(us)
	CN := C.size_t(N)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemsetD16Async(CdstDevice, Cus, CN, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD32Async(dstDevice DevicePtr, ui uint, N int64, hStream Stream) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	Cui := C.uint(ui)
	CN := C.size_t(N)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemsetD32Async(CdstDevice, Cui, CN, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD2D8Async(dstDevice DevicePtr, dstPitch int64, uc byte, Width int64, Height int64, hStream Stream) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CdstPitch := C.size_t(dstPitch)
	Cuc := C.uchar(uc)
	CWidth := C.size_t(Width)
	CHeight := C.size_t(Height)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemsetD2D8Async(CdstDevice, CdstPitch, Cuc, CWidth, CHeight, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD2D16Async(dstDevice DevicePtr, dstPitch int64, us uint16, Width int64, Height int64, hStream Stream) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CdstPitch := C.size_t(dstPitch)
	Cus := C.ushort(us)
	CWidth := C.size_t(Width)
	CHeight := C.size_t(Height)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemsetD2D16Async(CdstDevice, CdstPitch, Cus, CWidth, CHeight, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) MemsetD2D32Async(dstDevice DevicePtr, dstPitch int64, ui uint, Width int64, Height int64, hStream Stream) {
	CdstDevice := C.CUdeviceptr(dstDevice)
	CdstPitch := C.size_t(dstPitch)
	Cui := C.uint(ui)
	CWidth := C.size_t(Width)
	CHeight := C.size_t(Height)
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuMemsetD2D32Async(CdstDevice, CdstPitch, Cui, CWidth, CHeight, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Descriptor(hArray Array) (pArrayDescriptor ArrayDesc, err error) {
	ChArray := hArray.c()
	var CpArrayDescriptor C.CUDA_ARRAY_DESCRIPTOR
	f := func() error {
		return result(C.cuArrayGetDescriptor(&CpArrayDescriptor, ChArray))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Descriptor")
	}
	pArrayDescriptor = goArrayDesc(&CpArrayDescriptor)
	return
}

func (ctx *Ctx) DestroyArray(hArray Array) {
	ChArray := hArray.c()
	f := func() error {
		return result(C.cuArrayDestroy(ChArray))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Descriptor3(hArray Array) (pArrayDescriptor Array3Desc, err error) {
	ChArray := hArray.c()
	var CpArrayDescriptor C.CUDA_ARRAY3D_DESCRIPTOR
	f := func() error {
		return result(C.cuArray3DGetDescriptor(&CpArrayDescriptor, ChArray))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Descriptor3")
	}
	pArrayDescriptor = goArray3Desc(&CpArrayDescriptor)
	return
}

func (ctx *Ctx) Priority(hStream Stream) (priority int, err error) {
	ChStream := hStream.c()
	var Cpriority C.int
	f := func() error {
		return result(C.cuStreamGetPriority(ChStream, &Cpriority))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Priority")
	}
	priority = int(Cpriority)
	return
}

func (ctx *Ctx) StreamFlags(hStream Stream) (flags uint, err error) {
	ChStream := hStream.c()
	var Cflags C.uint
	f := func() error {
		return result(C.cuStreamGetFlags(ChStream, &Cflags))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Flags")
	}
	flags = uint(Cflags)
	return
}

func (ctx *Ctx) Wait(hStream Stream, hEvent Event, Flags uint) {
	ChStream := hStream.c()
	ChEvent := hEvent.c()
	CFlags := C.uint(Flags)
	f := func() error {
		return result(C.cuStreamWaitEvent(ChStream, ChEvent, CFlags))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) AttachMemAsync(hStream Stream, dptr DevicePtr, length int64, flags uint) {
	ChStream := hStream.c()
	Cdptr := C.CUdeviceptr(dptr)
	Clength := C.size_t(length)
	Cflags := C.uint(flags)
	f := func() error {
		return result(C.cuStreamAttachMemAsync(ChStream, Cdptr, Clength, Cflags))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) QueryStream(hStream Stream) {
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuStreamQuery(ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SynchronizeStream(hStream Stream) {
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuStreamSynchronize(ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Record(hEvent Event, hStream Stream) {
	ChEvent := hEvent.c()
	ChStream := hStream.c()
	f := func() error {
		return result(C.cuEventRecord(ChEvent, ChStream))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) QueryEvent(hEvent Event) {
	ChEvent := hEvent.c()
	f := func() error {
		return result(C.cuEventQuery(ChEvent))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SynchronizeEvent(hEvent Event) {
	ChEvent := hEvent.c()
	f := func() error {
		return result(C.cuEventSynchronize(ChEvent))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Elapsed(hStart Event, hEnd Event) (pMilliseconds float64, err error) {
	ChStart := hStart.c()
	ChEnd := hEnd.c()
	var CpMilliseconds C.float
	f := func() error {
		return result(C.cuEventElapsedTime(&CpMilliseconds, ChStart, ChEnd))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Elapsed")
	}
	pMilliseconds = float64(CpMilliseconds)
	return
}

func (ctx *Ctx) WaitOnValue32(stream Stream, addr DevicePtr, value uint32, flags uint) {
	Cstream := stream.c()
	Caddr := C.CUdeviceptr(addr)
	Cvalue := C.cuuint32_t(value)
	Cflags := C.uint(flags)
	f := func() error {
		return result(C.cuStreamWaitValue32(Cstream, Caddr, Cvalue, Cflags))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) WriteValue32(stream Stream, addr DevicePtr, value uint32, flags uint) {
	Cstream := stream.c()
	Caddr := C.CUdeviceptr(addr)
	Cvalue := C.cuuint32_t(value)
	Cflags := C.uint(flags)
	f := func() error {
		return result(C.cuStreamWriteValue32(Cstream, Caddr, Cvalue, Cflags))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) FunctionAttribute(fn Function, attrib FunctionAttribute) (pi int, err error) {
	Cfn := fn.c()
	Cattrib := C.CUfunction_attribute(attrib)
	var Cpi C.int
	f := func() error {
		return result(C.cuFuncGetAttribute(&Cpi, Cattrib, Cfn))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Attribute")
	}
	pi = int(Cpi)
	return
}

func (ctx *Ctx) SetCacheConfig(fn Function, config FuncCacheConfig) {
	Cfn := fn.c()
	Cconfig := C.CUfunc_cache(config)
	f := func() error {
		return result(C.cuFuncSetCacheConfig(Cfn, Cconfig))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetFunctionSharedMemConfig(fn Function, config SharedConfig) {
	Cfn := fn.c()
	Cconfig := C.CUsharedconfig(config)
	f := func() error {
		return result(C.cuFuncSetSharedMemConfig(Cfn, Cconfig))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) TexRefSetArray(hTexRef TexRef, hArray Array, Flags uint) {
	ChTexRef := hTexRef.c()
	ChArray := hArray.c()
	CFlags := C.uint(Flags)
	f := func() error {
		return result(C.cuTexRefSetArray(ChTexRef, ChArray, CFlags))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetAddress(hTexRef TexRef, dptr DevicePtr, bytes int64) (ByteOffset int64, err error) {
	ChTexRef := hTexRef.c()
	Cdptr := C.CUdeviceptr(dptr)
	Cbytes := C.size_t(bytes)
	var CByteOffset C.size_t
	f := func() error {
		return result(C.cuTexRefSetAddress(&CByteOffset, ChTexRef, Cdptr, Cbytes))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "SetAddress")
	}
	ByteOffset = int64(CByteOffset)
	return
}

func (ctx *Ctx) SetAddress2D(hTexRef TexRef, desc ArrayDesc, dptr DevicePtr, Pitch int64) {
	ChTexRef := hTexRef.c()
	Cdesc := desc.c()
	Cdptr := C.CUdeviceptr(dptr)
	CPitch := C.size_t(Pitch)
	f := func() error {
		return result(C.cuTexRefSetAddress2D(ChTexRef, Cdesc, Cdptr, CPitch))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetFormat(hTexRef TexRef, fmt Format, NumPackedComponents int) {
	ChTexRef := hTexRef.c()
	Cfmt := C.CUarray_format(fmt)
	CNumPackedComponents := C.int(NumPackedComponents)
	f := func() error {
		return result(C.cuTexRefSetFormat(ChTexRef, Cfmt, CNumPackedComponents))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetAddressMode(hTexRef TexRef, dim int, am AddressMode) {
	ChTexRef := hTexRef.c()
	Cdim := C.int(dim)
	Cam := C.CUaddress_mode(am)
	f := func() error {
		return result(C.cuTexRefSetAddressMode(ChTexRef, Cdim, Cam))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetFilterMode(hTexRef TexRef, fm FilterMode) {
	ChTexRef := hTexRef.c()
	Cfm := C.CUfilter_mode(fm)
	f := func() error {
		return result(C.cuTexRefSetFilterMode(ChTexRef, Cfm))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetMipmapFilterMode(hTexRef TexRef, fm FilterMode) {
	ChTexRef := hTexRef.c()
	Cfm := C.CUfilter_mode(fm)
	f := func() error {
		return result(C.cuTexRefSetMipmapFilterMode(ChTexRef, Cfm))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetMipmapLevelBias(hTexRef TexRef, bias float64) {
	ChTexRef := hTexRef.c()
	Cbias := C.float(bias)
	f := func() error {
		return result(C.cuTexRefSetMipmapLevelBias(ChTexRef, Cbias))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetMipmapLevelClamp(hTexRef TexRef, minMipmapLevelClamp float64, maxMipmapLevelClamp float64) {
	ChTexRef := hTexRef.c()
	CminMipmapLevelClamp := C.float(minMipmapLevelClamp)
	CmaxMipmapLevelClamp := C.float(maxMipmapLevelClamp)
	f := func() error {
		return result(C.cuTexRefSetMipmapLevelClamp(ChTexRef, CminMipmapLevelClamp, CmaxMipmapLevelClamp))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetMaxAnisotropy(hTexRef TexRef, maxAniso uint) {
	ChTexRef := hTexRef.c()
	CmaxAniso := C.uint(maxAniso)
	f := func() error {
		return result(C.cuTexRefSetMaxAnisotropy(ChTexRef, CmaxAniso))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetBorderColor(hTexRef TexRef, pBorderColor [3]float32) {
	ChTexRef := hTexRef.c()
	CpBorderColor := (*C.float)(unsafe.Pointer(&pBorderColor[0]))
	f := func() error {
		return result(C.cuTexRefSetBorderColor(ChTexRef, CpBorderColor))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) SetTexRefFlags(hTexRef TexRef, Flags TexRefFlags) {
	ChTexRef := hTexRef.c()
	CFlags := C.uint(Flags)
	f := func() error {
		return result(C.cuTexRefSetFlags(ChTexRef, CFlags))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) Address(hTexRef TexRef) (pdptr DevicePtr, err error) {
	ChTexRef := hTexRef.c()
	var Cpdptr C.CUdeviceptr
	f := func() error {
		return result(C.cuTexRefGetAddress(&Cpdptr, ChTexRef))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Address")
	}
	pdptr = DevicePtr(Cpdptr)
	return
}

func (ctx *Ctx) Array(hTexRef TexRef) (phArray Array, err error) {
	ChTexRef := hTexRef.c()
	var CphArray C.CUarray
	f := func() error {
		return result(C.cuTexRefGetArray(&CphArray, ChTexRef))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Array")
	}
	phArray = goArray(&CphArray)
	return
}

func (ctx *Ctx) AddressMode(hTexRef TexRef, dim int) (pam AddressMode, err error) {
	ChTexRef := hTexRef.c()
	Cdim := C.int(dim)
	var Cpam C.CUaddress_mode
	f := func() error {
		return result(C.cuTexRefGetAddressMode(&Cpam, ChTexRef, Cdim))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "AddressMode")
	}
	pam = AddressMode(Cpam)
	return
}

func (ctx *Ctx) FilterMode(hTexRef TexRef) (pfm FilterMode, err error) {
	ChTexRef := hTexRef.c()
	var Cpfm C.CUfilter_mode
	f := func() error {
		return result(C.cuTexRefGetFilterMode(&Cpfm, ChTexRef))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "FilterMode")
	}
	pfm = FilterMode(Cpfm)
	return
}

func (ctx *Ctx) Format(hTexRef TexRef) (pFormat Format, pNumChannels int, err error) {
	ChTexRef := hTexRef.c()
	var CpFormat C.CUarray_format
	var CpNumChannels C.int
	f := func() error {
		return result(C.cuTexRefGetFormat(&CpFormat, &CpNumChannels, ChTexRef))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Format")
	}
	pFormat = Format(CpFormat)
	pNumChannels = int(CpNumChannels)
	return
}

func (ctx *Ctx) MaxAnisotropy(hTexRef TexRef) (pmaxAniso int, err error) {
	ChTexRef := hTexRef.c()
	var CpmaxAniso C.int
	f := func() error {
		return result(C.cuTexRefGetMaxAnisotropy(&CpmaxAniso, ChTexRef))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "MaxAnisotropy")
	}
	pmaxAniso = int(CpmaxAniso)
	return
}

func (ctx *Ctx) BorderColor(hTexRef TexRef) (pBorderColor [3]float32, err error) {
	ChTexRef := hTexRef.c()
	CpBorderColor := (*C.float)(unsafe.Pointer(&pBorderColor[0]))
	f := func() error {
		return result(C.cuTexRefGetBorderColor(CpBorderColor, ChTexRef))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "BorderColor")
	}
	return
}

func (ctx *Ctx) TexRefFlags(hTexRef TexRef) (pFlags uint, err error) {
	ChTexRef := hTexRef.c()
	var CpFlags C.uint
	f := func() error {
		return result(C.cuTexRefGetFlags(&CpFlags, ChTexRef))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "Flags")
	}
	pFlags = uint(CpFlags)
	return
}

func (ctx *Ctx) SurfRefSetArray(hSurfRef SurfRef, hArray Array, Flags uint) {
	ChSurfRef := hSurfRef.c()
	ChArray := hArray.c()
	CFlags := C.uint(Flags)
	f := func() error {
		return result(C.cuSurfRefSetArray(ChSurfRef, ChArray, CFlags))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) GetArray(hSurfRef SurfRef) (phArray Array, err error) {
	ChSurfRef := hSurfRef.c()
	var CphArray C.CUarray
	f := func() error {
		return result(C.cuSurfRefGetArray(&CphArray, ChSurfRef))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "GetArray")
	}
	phArray = goArray(&CphArray)
	return
}

func (ctx *Ctx) CanAccessPeer(dev Device, peerDev Device) (canAccessPeer int, err error) {
	Cdev := C.CUdevice(dev)
	CpeerDev := C.CUdevice(peerDev)
	var CcanAccessPeer C.int
	f := func() error {
		return result(C.cuDeviceCanAccessPeer(&CcanAccessPeer, Cdev, CpeerDev))
	}
	if err = ctx.Do(f); err != nil {
		err = errors.Wrap(err, "CanAccessPeer")
	}
	canAccessPeer = int(CcanAccessPeer)
	return
}

func (ctx *Ctx) EnablePeerAccess(peerContext CUContext, Flags uint) {
	CpeerContext := peerContext.c()
	CFlags := C.uint(Flags)
	f := func() error {
		return result(C.cuCtxEnablePeerAccess(CpeerContext, CFlags))
	}
	ctx.err = ctx.Do(f)
}

func (ctx *Ctx) DisablePeerAccess(peerContext CUContext) {
	CpeerContext := peerContext.c()
	f := func() error {
		return result(C.cuCtxDisablePeerAccess(CpeerContext))
	}
	ctx.err = ctx.Do(f)
}
