package cudnn

/* Generated by gencudnn. DO NOT EDIT */

// #include <cudnn.h>
import "C"
import "runtime"

// LRN is a representation of cudnnLRNDescriptor_t.
type LRN struct {
	internal C.cudnnLRNDescriptor_t

	lrnN     uint
	lrnAlpha float64
	lrnBeta  float64
	lrnK     float64
}

// NewLRN creates a new LRN.
func NewLRN(lrnN uint, lrnAlpha float64, lrnBeta float64, lrnK float64) (retVal *LRN, err error) {
	var internal C.cudnnLRNDescriptor_t
	if err := result(C.cudnnCreateLRNDescriptor(&internal)); err != nil {
		return nil, err
	}

	if err := result(C.cudnnSetLRNDescriptor(internal, C.uint(lrnN), C.double(lrnAlpha), C.double(lrnBeta), C.double(lrnK))); err != nil {
		return nil, err
	}

	retVal = &LRN{
		internal: internal,
		lrnN:     lrnN,
		lrnAlpha: lrnAlpha,
		lrnBeta:  lrnBeta,
		lrnK:     lrnK,
	}
	runtime.SetFinalizer(retVal, destroyLRN)
	return retVal, nil
}

// LrnN returns the internal lrnN.
func (l *LRN) LrnN() uint { return l.lrnN }

// LrnAlpha returns the internal lrnAlpha.
func (l *LRN) LrnAlpha() float64 { return l.lrnAlpha }

// LrnBeta returns the internal lrnBeta.
func (l *LRN) LrnBeta() float64 { return l.lrnBeta }

// LrnK returns the internal lrnK.
func (l *LRN) LrnK() float64 { return l.lrnK }

func destroyLRN(obj *LRN) { C.cudnnDestroyLRNDescriptor(obj.internal) }
