package cudnn

/* Generated by gencudnn. DO NOT EDIT */

// #include <cudnn.h>
import "C"

//go:generate stringer -type=ErrQueryMode

type ErrQueryMode int

const (
	Rawcode     ErrQueryMode = C.CUDNN_ERRQUERY_RAWCODE
	Nonblocking ErrQueryMode = C.CUDNN_ERRQUERY_NONBLOCKING
	Blocking    ErrQueryMode = C.CUDNN_ERRQUERY_BLOCKING
)

// C returns the C representation of ErrQueryMode
func (e ErrQueryMode) C() C.cudnnErrQueryMode_t { return C.cudnnErrQueryMode_t(e) }

//go:generate stringer -type=DataType

type DataType int

const (
	Float  DataType = C.CUDNN_DATA_FLOAT
	Double DataType = C.CUDNN_DATA_DOUBLE
	Half   DataType = C.CUDNN_DATA_HALF
	Int8   DataType = C.CUDNN_DATA_INT8
	Int32  DataType = C.CUDNN_DATA_INT32
	Int8x4 DataType = C.CUDNN_DATA_INT8x4
)

// C returns the C representation of DataType
func (e DataType) C() C.cudnnDataType_t { return C.cudnnDataType_t(e) }

//go:generate stringer -type=MathType

type MathType int

const (
	DefaultMath  MathType = C.CUDNN_DEFAULT_MATH
	TensorOpMath MathType = C.CUDNN_TENSOR_OP_MATH
)

// C returns the C representation of MathType
func (e MathType) C() C.cudnnMathType_t { return C.cudnnMathType_t(e) }

//go:generate stringer -type=NanPropagation

type NanPropagation int

const (
	NotPropagateNan NanPropagation = C.CUDNN_NOT_PROPAGATE_NAN
	PropagateNan    NanPropagation = C.CUDNN_PROPAGATE_NAN
)

// C returns the C representation of NanPropagation
func (e NanPropagation) C() C.cudnnNanPropagation_t { return C.cudnnNanPropagation_t(e) }

//go:generate stringer -type=Determinism

type Determinism int

const (
	NonDeterministic Determinism = C.CUDNN_NON_DETERMINISTIC
	Deterministic    Determinism = C.CUDNN_DETERMINISTIC
)

// C returns the C representation of Determinism
func (e Determinism) C() C.cudnnDeterminism_t { return C.cudnnDeterminism_t(e) }

//go:generate stringer -type=TensorFormat

type TensorFormat int

const (
	NCHW      TensorFormat = C.CUDNN_TENSOR_NCHW
	NHWC      TensorFormat = C.CUDNN_TENSOR_NHWC
	NCHWVectC TensorFormat = C.CUDNN_TENSOR_NCHW_VECT_C
)

// C returns the C representation of TensorFormat
func (e TensorFormat) C() C.cudnnTensorFormat_t { return C.cudnnTensorFormat_t(e) }

//go:generate stringer -type=OpTensorOp

type OpTensorOp int

const (
	Add  OpTensorOp = C.CUDNN_OP_TENSOR_ADD
	Mul  OpTensorOp = C.CUDNN_OP_TENSOR_MUL
	Min  OpTensorOp = C.CUDNN_OP_TENSOR_MIN
	Max  OpTensorOp = C.CUDNN_OP_TENSOR_MAX
	Sqrt OpTensorOp = C.CUDNN_OP_TENSOR_SQRT
	Not  OpTensorOp = C.CUDNN_OP_TENSOR_NOT
)

// C returns the C representation of OpTensorOp
func (e OpTensorOp) C() C.cudnnOpTensorOp_t { return C.cudnnOpTensorOp_t(e) }

//go:generate stringer -type=ReduceTensorOp

type ReduceTensorOp int

const (
	ReduceAdd        ReduceTensorOp = C.CUDNN_REDUCE_TENSOR_ADD
	ReduceMul        ReduceTensorOp = C.CUDNN_REDUCE_TENSOR_MUL
	ReduceMin        ReduceTensorOp = C.CUDNN_REDUCE_TENSOR_MIN
	ReduceMax        ReduceTensorOp = C.CUDNN_REDUCE_TENSOR_MAX
	ReduceAmax       ReduceTensorOp = C.CUDNN_REDUCE_TENSOR_AMAX
	ReduceAvg        ReduceTensorOp = C.CUDNN_REDUCE_TENSOR_AVG
	ReduceNorm1      ReduceTensorOp = C.CUDNN_REDUCE_TENSOR_NORM1
	ReduceNorm2      ReduceTensorOp = C.CUDNN_REDUCE_TENSOR_NORM2
	ReduceMulNoZeros ReduceTensorOp = C.CUDNN_REDUCE_TENSOR_MUL_NO_ZEROS
)

// C returns the C representation of ReduceTensorOp
func (e ReduceTensorOp) C() C.cudnnReduceTensorOp_t { return C.cudnnReduceTensorOp_t(e) }

//go:generate stringer -type=ReduceTensorIndices

type ReduceTensorIndices int

const (
	ReduceNoIndices        ReduceTensorIndices = C.CUDNN_REDUCE_TENSOR_NO_INDICES
	ReduceFlattenedIndices ReduceTensorIndices = C.CUDNN_REDUCE_TENSOR_FLATTENED_INDICES
)

// C returns the C representation of ReduceTensorIndices
func (e ReduceTensorIndices) C() C.cudnnReduceTensorIndices_t { return C.cudnnReduceTensorIndices_t(e) }

//go:generate stringer -type=IndicesType

type IndicesType int

const (
	Indices32 IndicesType = C.CUDNN_32BIT_INDICES
	Indices64 IndicesType = C.CUDNN_64BIT_INDICES
	Indices16 IndicesType = C.CUDNN_16BIT_INDICES
	Indices8  IndicesType = C.CUDNN_8BIT_INDICES
)

// C returns the C representation of IndicesType
func (e IndicesType) C() C.cudnnIndicesType_t { return C.cudnnIndicesType_t(e) }

//go:generate stringer -type=SoftmaxAlgorithm

type SoftmaxAlgorithm int

const (
	Fast     SoftmaxAlgorithm = C.CUDNN_SOFTMAX_FAST
	Accurate SoftmaxAlgorithm = C.CUDNN_SOFTMAX_ACCURATE
	Log      SoftmaxAlgorithm = C.CUDNN_SOFTMAX_LOG
)

// C returns the C representation of SoftmaxAlgorithm
func (e SoftmaxAlgorithm) C() C.cudnnSoftmaxAlgorithm_t { return C.cudnnSoftmaxAlgorithm_t(e) }

//go:generate stringer -type=SoftmaxMode

type SoftmaxMode int

const (
	Instance SoftmaxMode = C.CUDNN_SOFTMAX_MODE_INSTANCE
	Channel  SoftmaxMode = C.CUDNN_SOFTMAX_MODE_CHANNEL
)

// C returns the C representation of SoftmaxMode
func (e SoftmaxMode) C() C.cudnnSoftmaxMode_t { return C.cudnnSoftmaxMode_t(e) }

//go:generate stringer -type=PoolingMode

type PoolingMode int

const (
	MaxPooling                 PoolingMode = C.CUDNN_POOLING_MAX
	AverageCountIncludePadding PoolingMode = C.CUDNN_POOLING_AVERAGE_COUNT_INCLUDE_PADDING
	AverageCountExcludePadding PoolingMode = C.CUDNN_POOLING_AVERAGE_COUNT_EXCLUDE_PADDING
	MaxDeterministic           PoolingMode = C.CUDNN_POOLING_MAX_DETERMINISTIC
)

// C returns the C representation of PoolingMode
func (e PoolingMode) C() C.cudnnPoolingMode_t { return C.cudnnPoolingMode_t(e) }

//go:generate stringer -type=ActivationMode

type ActivationMode int

const (
	Sigmoid     ActivationMode = C.CUDNN_ACTIVATION_SIGMOID
	ReLU        ActivationMode = C.CUDNN_ACTIVATION_RELU
	Tanh        ActivationMode = C.CUDNN_ACTIVATION_TANH
	ClippedReLU ActivationMode = C.CUDNN_ACTIVATION_CLIPPED_RELU
	Elu         ActivationMode = C.CUDNN_ACTIVATION_ELU
)

// C returns the C representation of ActivationMode
func (e ActivationMode) C() C.cudnnActivationMode_t { return C.cudnnActivationMode_t(e) }

//go:generate stringer -type=LRNMode

type LRNMode int

const (
	CrossChannelDim1 LRNMode = C.CUDNN_LRN_CROSS_CHANNEL_DIM1
)

// C returns the C representation of LRNMode
func (e LRNMode) C() C.cudnnLRNMode_t { return C.cudnnLRNMode_t(e) }

//go:generate stringer -type=DivNormMode

type DivNormMode int

const (
	PrecomputedMeans DivNormMode = C.CUDNN_DIVNORM_PRECOMPUTED_MEANS
)

// C returns the C representation of DivNormMode
func (e DivNormMode) C() C.cudnnDivNormMode_t { return C.cudnnDivNormMode_t(e) }

//go:generate stringer -type=BatchNormMode

type BatchNormMode int

const (
	PerActivation     BatchNormMode = C.CUDNN_BATCHNORM_PER_ACTIVATION
	Spatial           BatchNormMode = C.CUDNN_BATCHNORM_SPATIAL
	SpatialPersistent BatchNormMode = C.CUDNN_BATCHNORM_SPATIAL_PERSISTENT
)

// C returns the C representation of BatchNormMode
func (e BatchNormMode) C() C.cudnnBatchNormMode_t { return C.cudnnBatchNormMode_t(e) }

//go:generate stringer -type=SamplerType

type SamplerType int

const (
	Bilinear SamplerType = C.CUDNN_SAMPLER_BILINEAR
)

// C returns the C representation of SamplerType
func (e SamplerType) C() C.cudnnSamplerType_t { return C.cudnnSamplerType_t(e) }

//go:generate stringer -type=RNNMode

type RNNMode int

const (
	RNNReLU RNNMode = C.CUDNN_RNN_RELU
	RNNTanh RNNMode = C.CUDNN_RNN_TANH
	LSTM    RNNMode = C.CUDNN_LSTM
	GRU     RNNMode = C.CUDNN_GRU
)

// C returns the C representation of RNNMode
func (e RNNMode) C() C.cudnnRNNMode_t { return C.cudnnRNNMode_t(e) }

//go:generate stringer -type=DirectionMode

type DirectionMode int

const (
	Unidirectional DirectionMode = C.CUDNN_UNIDIRECTIONAL
	Bidirectional  DirectionMode = C.CUDNN_BIDIRECTIONAL
)

// C returns the C representation of DirectionMode
func (e DirectionMode) C() C.cudnnDirectionMode_t { return C.cudnnDirectionMode_t(e) }

//go:generate stringer -type=RNNInputMode

type RNNInputMode int

const (
	LinearInput RNNInputMode = C.CUDNN_LINEAR_INPUT
	SkipInput   RNNInputMode = C.CUDNN_SKIP_INPUT
)

// C returns the C representation of RNNInputMode
func (e RNNInputMode) C() C.cudnnRNNInputMode_t { return C.cudnnRNNInputMode_t(e) }

//go:generate stringer -type=RNNAlgo

type RNNAlgo int

const (
	Standard       RNNAlgo = C.CUDNN_RNN_ALGO_STANDARD
	PersistStatic  RNNAlgo = C.CUDNN_RNN_ALGO_PERSIST_STATIC
	PersistDynamic RNNAlgo = C.CUDNN_RNN_ALGO_PERSIST_DYNAMIC
)

// C returns the C representation of RNNAlgo
func (e RNNAlgo) C() C.cudnnRNNAlgo_t { return C.cudnnRNNAlgo_t(e) }

//go:generate stringer -type=CTCLossAlgo

type CTCLossAlgo int

const (
	DeterministicCTCLoss    CTCLossAlgo = C.CUDNN_CTC_LOSS_ALGO_DETERMINISTIC
	NonDeterministicCTCLoss CTCLossAlgo = C.CUDNN_CTC_LOSS_ALGO_NON_DETERMINISTIC
)

// C returns the C representation of CTCLossAlgo
func (e CTCLossAlgo) C() C.cudnnCTCLossAlgo_t { return C.cudnnCTCLossAlgo_t(e) }
