/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Duration;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalTime;
import sandbox.java.time.OffsetDateTime;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.ZonedDateTime;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Objects;

public final class Instant
implements Temporal,
TemporalAdjuster,
Comparable<Instant>,
Serializable {
    public static final Instant EPOCH;
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    public static final Instant MIN;
    public static final Instant MAX;
    private static final long serialVersionUID = -665713676816604388L;
    private final long seconds;
    private final int nanos;

    public static Instant now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemUTC:()Ljava/time/Clock;");
        Clock clock = Clock.systemUTC();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
        return clock.instant();
    }

    public static Instant now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "clock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
        return clock.instant();
    }

    public static Instant ofEpochSecond(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.create:(JI)Ljava/time/Instant;");
        return Instant.create(l, 0);
    }

    public static Instant ofEpochSecond(long l, long l2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        long l3 = Math.floorDiv(l2, 1000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l4 = Math.addExact(l, l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n = (int)Math.floorMod(l2, 1000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.create:(JI)Ljava/time/Instant;");
        return Instant.create(l4, n);
    }

    public static Instant ofEpochMilli(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        long l2 = Math.floorDiv(l, 1000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n = (int)Math.floorMod(l, 1000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.create:(JI)Ljava/time/Instant;");
        return Instant.create(l2, n * 1000000);
    }

    public static Instant from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof Instant;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (Instant)temporalAccessor;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.getLong:(Ljava/time/temporal/TemporalField;)J");
            long l = temporalAccessor.getLong(ChronoField.INSTANT_SECONDS);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n = temporalAccessor.get(ChronoField.NANO_OF_SECOND);
            long l2 = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(JJ)Ljava/time/Instant;");
            return Instant.ofEpochSecond(l, l2);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain Instant from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string2, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    public static Instant parse(CharSequence charSequence) {
        TemporalQuery<Instant> temporalQuery = Instant::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return DateTimeFormatter.ISO_INSTANT.parse(charSequence, temporalQuery);
    }

    private static Instant create(long l, int n) {
        block5: {
            block4: {
                long l2 = (l | (long)n) - 0L;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 == false) {
                    return EPOCH;
                }
                RuntimeCostAccounter.recordJump();
                if (l < -31557014167219200L) break block4;
                RuntimeCostAccounter.recordJump();
                if (l <= 31556889864403199L) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Instant exceeds minimum or maximum instant");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/Instant");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.<init>:(JI)V");
        return new Instant(l, n);
    }

    private Instant(long l, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.seconds = l;
        this.nanos = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField != ChronoField.INSTANT_SECONDS) {
                RuntimeCostAccounter.recordJump();
                if (temporalField != ChronoField.NANO_OF_SECOND) {
                    RuntimeCostAccounter.recordJump();
                    if (temporalField != ChronoField.MICRO_OF_SECOND) {
                        RuntimeCostAccounter.recordJump();
                        if (temporalField != ChronoField.MILLI_OF_SECOND) return false;
                    }
                }
            }
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl3 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isTimeBased:()Z");
            boolean bl2 = temporalUnit.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordJump();
                if (temporalUnit != ChronoUnit.DAYS) return false;
            }
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isSupportedBy:(Ljava/time/temporal/Temporal;)Z");
        boolean bl4 = temporalUnit.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl4) return false;
        boolean bl5 = true;
        RuntimeCostAccounter.recordJump();
        return bl5;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        return Temporal.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    return this.nanos;
                }
                case 2: {
                    return this.nanos / 1000;
                }
                case 3: {
                    return this.nanos / 1000000;
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
                    ChronoField.INSTANT_SECONDS.checkValidIntValue(this.seconds);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        long l = temporalField.getFrom(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        return valueRange.checkValidIntValue(l, temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    return this.nanos;
                }
                case 2: {
                    return this.nanos / 1000;
                }
                case 3: {
                    return this.nanos / 1000000;
                }
                case 4: {
                    return this.seconds;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    public long getEpochSecond() {
        return this.seconds;
    }

    public int getNano() {
        return this.nanos;
    }

    @Override
    public Instant with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (Instant)temporalAdjuster.adjustInto(this);
    }

    @Override
    public Instant with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
            chronoField.checkValidValue(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 3: {
                    Instant instant;
                    int n = (int)l * 1000000;
                    RuntimeCostAccounter.recordJump();
                    if (n != this.nanos) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.create:(JI)Ljava/time/Instant;");
                        instant = Instant.create(this.seconds, n);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        instant = this;
                    }
                    return instant;
                }
                case 2: {
                    Instant instant;
                    int n = (int)l * 1000;
                    RuntimeCostAccounter.recordJump();
                    if (n != this.nanos) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.create:(JI)Ljava/time/Instant;");
                        instant = Instant.create(this.seconds, n);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        instant = this;
                    }
                    return instant;
                }
                case 1: {
                    Instant instant;
                    long l2 = l - (long)this.nanos;
                    long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l3 != false) {
                        int n = (int)l;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.create:(JI)Ljava/time/Instant;");
                        instant = Instant.create(this.seconds, n);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        instant = this;
                    }
                    return instant;
                }
                case 4: {
                    Instant instant;
                    RuntimeCostAccounter.recordJump();
                    if (l != this.seconds) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.create:(JI)Ljava/time/Instant;");
                        instant = Instant.create(l, this.nanos);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        instant = this;
                    }
                    return instant;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalField.adjustInto(this, l);
    }

    public Instant truncatedTo(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.NANOS) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.getDuration:()Ljava/time/Duration;");
        Duration duration = temporalUnit.getDuration();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.getSeconds:()J");
        long l = duration.getSeconds() - 86400L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Unit is too large to be used for truncation");
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.toNanos:()J");
        long l3 = duration.toNanos();
        RuntimeCostAccounter.recordJump();
        if (86400000000000L % l3 != 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Unit must divide into a standard day without remainder");
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        long l4 = this.seconds % 86400L * 1000000000L + (long)this.nanos;
        long l5 = l4 / l3 * l3;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusNanos:(J)Ljava/time/Instant;");
        return this.plusNanos(l5 - l4);
    }

    @Override
    public Instant plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.addTo:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (Instant)temporalAmount.addTo(this);
    }

    @Override
    public Instant plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusNanos:(J)Ljava/time/Instant;");
                    return this.plusNanos(l);
                }
                case 2: {
                    long l2 = l / 1000000L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plus:(JJ)Ljava/time/Instant;");
                    return this.plus(l2, l % 1000000L * 1000L);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusMillis:(J)Ljava/time/Instant;");
                    return this.plusMillis(l);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusSeconds:(J)Ljava/time/Instant;");
                    return this.plusSeconds(l);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l3 = Math.multiplyExact(l, 60L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusSeconds:(J)Ljava/time/Instant;");
                    return this.plusSeconds(l3);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l4 = Math.multiplyExact(l, 3600L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusSeconds:(J)Ljava/time/Instant;");
                    return this.plusSeconds(l4);
                }
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l5 = Math.multiplyExact(l, 43200L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusSeconds:(J)Ljava/time/Instant;");
                    return this.plusSeconds(l5);
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l6 = Math.multiplyExact(l, 86400L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusSeconds:(J)Ljava/time/Instant;");
                    return this.plusSeconds(l6);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalUnit.addTo(this, l);
    }

    public Instant plusSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plus:(JJ)Ljava/time/Instant;");
        return this.plus(l, 0L);
    }

    public Instant plusMillis(long l) {
        long l2 = l / 1000L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plus:(JJ)Ljava/time/Instant;");
        return this.plus(l2, l % 1000L * 1000000L);
    }

    public Instant plusNanos(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plus:(JJ)Ljava/time/Instant;");
        return this.plus(0L, l);
    }

    private Instant plus(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if ((l | l2) == 0L) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l3 = Math.addExact(this.seconds, l);
        long l4 = l2 / 1000000000L;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        l3 = Math.addExact(l3, l4);
        long l5 = (long)this.nanos + (l2 %= 1000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(JJ)Ljava/time/Instant;");
        return Instant.ofEpochSecond(l3, l5);
    }

    @Override
    public Instant minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.subtractFrom:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (Instant)temporalAmount.subtractFrom(this);
    }

    @Override
    public Instant minus(long l, TemporalUnit temporalUnit) {
        Instant instant;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Instant;");
            Instant instant2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Instant;");
            instant = instant2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Instant;");
            instant = this.plus(l2, temporalUnit);
        }
        return instant;
    }

    public Instant minusSeconds(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusSeconds:(J)Ljava/time/Instant;");
            Instant instant = this.plusSeconds(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusSeconds:(J)Ljava/time/Instant;");
            return instant.plusSeconds(1L);
        }
        long l2 = -l;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusSeconds:(J)Ljava/time/Instant;");
        return this.plusSeconds(l2);
    }

    public Instant minusMillis(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusMillis:(J)Ljava/time/Instant;");
            Instant instant = this.plusMillis(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusMillis:(J)Ljava/time/Instant;");
            return instant.plusMillis(1L);
        }
        long l2 = -l;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusMillis:(J)Ljava/time/Instant;");
        return this.plusMillis(l2);
    }

    public Instant minusNanos(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusNanos:(J)Ljava/time/Instant;");
            Instant instant = this.plusNanos(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusNanos:(J)Ljava/time/Instant;");
            return instant.plusNanos(1L);
        }
        long l2 = -l;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plusNanos:(J)Ljava/time/Instant;");
        return this.plusNanos(l2);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<TemporalUnit> temporalQuery2 = TemporalQueries.precision();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) {
                    return (R)ChronoUnit.NANOS;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<Chronology> temporalQuery3 = TemporalQueries.chronology();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery3) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery4 = TemporalQueries.zoneId();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery4) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery5 = TemporalQueries.zone();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery5) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneOffset> temporalQuery6 = TemporalQueries.offset();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery6) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<LocalDate> temporalQuery7 = TemporalQueries.localDate();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery7) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<LocalTime> temporalQuery8 = TemporalQueries.localTime();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery != temporalQuery8) break block5;
            }
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQuery.queryFrom:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;");
        return temporalQuery.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        Temporal temporal2 = temporal.with(ChronoField.INSTANT_SECONDS, this.seconds);
        long l = this.nanos;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal2.with(ChronoField.NANO_OF_SECOND, l);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/Instant;");
        Instant instant = Instant.from(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.nanosUntil:(Ljava/time/Instant;)J");
                    return this.nanosUntil(instant);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.nanosUntil:(Ljava/time/Instant;)J");
                    return this.nanosUntil(instant) / 1000L;
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.toEpochMilli:()J");
                    long l = instant.toEpochMilli();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.toEpochMilli:()J");
                    long l2 = this.toEpochMilli();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                    return Math.subtractExact(l, l2);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.secondsUntil:(Ljava/time/Instant;)J");
                    return this.secondsUntil(instant);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.secondsUntil:(Ljava/time/Instant;)J");
                    return this.secondsUntil(instant) / 60L;
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.secondsUntil:(Ljava/time/Instant;)J");
                    return this.secondsUntil(instant) / 3600L;
                }
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.secondsUntil:(Ljava/time/Instant;)J");
                    return this.secondsUntil(instant) / 43200L;
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.secondsUntil:(Ljava/time/Instant;)J");
                    return this.secondsUntil(instant) / 86400L;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, instant);
    }

    private long nanosUntil(Instant instant) {
        long l = instant.seconds;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
        long l2 = Math.subtractExact(l, this.seconds);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l3 = Math.multiplyExact(l2, 1000000000L);
        long l4 = instant.nanos - this.nanos;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        return Math.addExact(l3, l4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private long secondsUntil(Instant instant) {
        long l = instant.seconds;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
        long l2 = Math.subtractExact(l, this.seconds);
        long l3 = instant.nanos - this.nanos;
        RuntimeCostAccounter.recordJump();
        if (l2 > 0L) {
            RuntimeCostAccounter.recordJump();
            if (l3 < 0L) {
                RuntimeCostAccounter.recordJump();
                return --l2;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (l2 >= 0L) return l2;
        RuntimeCostAccounter.recordJump();
        if (l3 <= 0L) return l2;
        ++l2;
        return l2;
    }

    public OffsetDateTime atOffset(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.ofInstant:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.ofInstant(this, zoneOffset);
    }

    public ZonedDateTime atZone(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofInstant:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofInstant(this, zoneId);
    }

    public long toEpochMilli() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l = Math.multiplyExact(this.seconds, 1000L);
        return l + (long)(this.nanos / 1000000);
    }

    @Override
    public int compareTo(Instant instant) {
        long l = instant.seconds;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
        int n = Long.compare(this.seconds, l);
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            return n;
        }
        return this.nanos - instant.nanos;
    }

    public boolean isAfter(Instant instant) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.compareTo:(Ljava/time/Instant;)I");
        int n = this.compareTo(instant);
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isBefore(Instant instant) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.compareTo:(Ljava/time/Instant;)I");
        int n = this.compareTo(instant);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof Instant;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        Instant instant = (Instant)object;
        long l = this.seconds - instant.seconds;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 != false) return false;
        int n = instant.nanos;
        RuntimeCostAccounter.recordJump();
        if (this.nanos != n) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32) + 51 * this.nanos;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return DateTimeFormatter.ISO_INSTANT.format(this);
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(2, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeLong:(J)V");
        dataOutput.writeLong(this.seconds);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.nanos);
    }

    static Instant readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readLong:()J");
        long l = dataInput.readLong();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        long l2 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(JJ)Ljava/time/Instant;");
        return Instant.ofEpochSecond(l, l2);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Instant");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.<init>:(JI)V");
        EPOCH = new Instant(0L, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(JJ)Ljava/time/Instant;");
        MIN = Instant.ofEpochSecond(-31557014167219200L, 0L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(JJ)Ljava/time/Instant;");
        MAX = Instant.ofEpochSecond(31556889864403199L, 999999999L);
    }
}

