/*
 * Decompiled with CFR 0.152.
 */
package org.cliffc.high_scale_lib;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.cliffc.high_scale_lib.UtilUnsafe;
import sun.misc.Unsafe;

public class ScalableReadWriteLock2
implements Serializable {
    private static final AtomicReferenceFieldUpdater<ScalableReadWriteLock2, CAT> _catUpdater = AtomicReferenceFieldUpdater.newUpdater(ScalableReadWriteLock2.class, CAT.class, "_cat");
    private static final AtomicIntegerFieldUpdater<ScalableReadWriteLock2> _writerUpdater = AtomicIntegerFieldUpdater.newUpdater(ScalableReadWriteLock2.class, "_writer");
    private volatile int _writer;
    private volatile CAT _cat = new CAT(null, 4, 0);
    private final Collection<Thread> waitingReaders;
    private ThreadLocal<CAT> myCat = new ThreadLocal();

    public ScalableReadWriteLock2() {
        this(false);
    }

    public ScalableReadWriteLock2(boolean spin) {
        this.waitingReaders = spin ? null : new NonBlockingHashSet();
    }

    public void read() {
        try {
            this.read1(false);
        }
        catch (InterruptedException ex) {
            throw new AssertionError();
        }
    }

    public void readInterruptably() throws InterruptedException {
        this.read1(true);
    }

    private void read1(boolean interrupt) throws InterruptedException {
        if (this.waitingReaders != null) {
            this.readPark(interrupt);
        } else {
            this.readSpin(interrupt);
        }
    }

    private void readSpin(boolean interrupt) throws InterruptedException {
        CAT cat;
        SPW sw = new SPW();
        int hash = ScalableReadWriteLock2.hash();
        while (true) {
            if (this._writer != 0) {
                sw.spin(interrupt);
                continue;
            }
            cat = this._cat;
            cat.add(1, hash, this);
            if (this._writer == 0) break;
            cat.add(-1, hash, this);
        }
        this.myCat.set(cat);
    }

    private void readPark(boolean interrupt) throws InterruptedException {
        CAT cat;
        if (this.tryRead()) {
            return;
        }
        boolean wasInterrupted = false;
        Thread current = Thread.currentThread();
        this.waitingReaders.add(current);
        while (true) {
            if (this._writer != 0) {
                cat = this._cat;
                LockSupport.park(this);
                if (Thread.interrupted()) {
                    if (interrupt) {
                        throw new InterruptedException();
                    }
                    wasInterrupted = true;
                }
                if (this.waitingReaders.contains(current)) continue;
                break;
            }
            int hash = ScalableReadWriteLock2.hash(current);
            cat = this._cat;
            cat.add(1, hash, this);
            if (this._writer == 0) {
                this.waitingReaders.remove(current);
                break;
            }
            cat.add(-1, hash, this);
        }
        this.myCat.set(cat);
        if (wasInterrupted) {
            current.interrupt();
        }
    }

    public boolean tryRead() {
        if (this._writer != 0) {
            return false;
        }
        CAT cat = this._cat;
        int hash = ScalableReadWriteLock2.hash();
        cat.add(1, hash, this);
        if (this._writer != 0) {
            cat.add(-1, hash, this);
            return false;
        }
        this.myCat.set(cat);
        return true;
    }

    public void unlockRead() {
        CAT cat = this.myCat.get();
        cat.add(-1, ScalableReadWriteLock2.hash(), this);
        this.myCat.remove();
    }

    public void write() {
        try {
            this.write1(false);
        }
        catch (InterruptedException ex) {
            throw new AssertionError();
        }
    }

    public void writeInterruptably() throws InterruptedException {
        this.write1(true);
    }

    private void write1(boolean interrupt) throws InterruptedException {
        SPW sw = new SPW();
        while (true) {
            if (this._writer == 0 && _writerUpdater.compareAndSet(this, 0, 1)) break;
            sw.spin(interrupt);
        }
        this._cat.awaitZero(interrupt);
    }

    public boolean tryWrite() {
        if (this._writer != 0) {
            return false;
        }
        if (_writerUpdater.compareAndSet(this, 0, 1)) {
            if (this._cat.isZero(this)) {
                return true;
            }
            this._writer = 0;
        }
        return false;
    }

    public void unlockWrite() {
        if (this.waitingReaders == null) {
            this._writer = 0;
        } else {
            CAT cat = this._cat;
            Iterator<Thread> it = this.waitingReaders.iterator();
            while (it.hasNext()) {
                Thread t = it.next();
                cat.add(1, ScalableReadWriteLock2.hash(t), this);
                it.remove();
                LockSupport.unpark(t);
            }
            this._writer = 0;
        }
    }

    public int getLock() {
        if (this._writer != 0) {
            return -1;
        }
        if (!this._cat.isZero(this)) {
            return 1;
        }
        return 0;
    }

    public int internalSize() {
        return this._cat._t.length;
    }

    public void print() {
        System.out.print(this._writer);
        System.out.print(" ");
        this._cat.print();
        System.out.println();
    }

    private boolean CAS_cat(CAT oldcat, CAT newcat) {
        return _catUpdater.compareAndSet(this, oldcat, newcat);
    }

    private static final int hash() {
        return ScalableReadWriteLock2.hash(Thread.currentThread());
    }

    private static final int hash(Thread thread) {
        int h = System.identityHashCode(thread);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h << 2;
    }

    private static class SPW {
        private int count = 0;

        private SPW() {
        }

        void spin(boolean interrupt) throws InterruptedException {
            if (this.count++ > 32) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {}
            } else if (this.count > 12) {
                Thread.yield();
            } else {
                for (int i = 0; i < 2 << this.count; ++i) {
                    if (!interrupt || !Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
            }
        }
    }

    private static class CAT
    implements Serializable {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Lbase = _unsafe.arrayBaseOffset(long[].class);
        private static final int _Lscale = _unsafe.arrayIndexScale(long[].class);
        private static final AtomicLongFieldUpdater<CAT> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CAT.class, "_resizers");
        private static final int MAX_SPIN = 2;
        private volatile CAT _next;
        private final long[] _t;
        volatile long _resizers;

        CAT(CAT next, int sz, int init) {
            this._next = next;
            this._t = new long[sz];
            this._t[0] = init;
        }

        private static long rawIndex(long[] ary, int i) {
            assert (i >= 0 && i < ary.length);
            return _Lbase + i * _Lscale;
        }

        private static final boolean CAS(long[] A, int idx, long old, long nnn) {
            return _unsafe.compareAndSwapLong(A, CAT.rawIndex(A, idx), old, nnn);
        }

        public long add(int x, int hash, ScalableReadWriteLock2 master) {
            long[] t = this._t;
            int idx = hash & t.length - 1;
            long old = t[idx];
            if (x > 0 && old > Long.MAX_VALUE - (long)x) {
                throw new Error("Maximum lock count exceeded");
            }
            if (old + (long)x < 0L) {
                throw new IllegalMonitorStateException();
            }
            boolean ok = CAT.CAS(t, idx, old, old + (long)x);
            if (ok) {
                return old;
            }
            int cnt = 0;
            while (!CAT.CAS(t, idx, old = t[idx], old + (long)x)) {
                ++cnt;
            }
            if (cnt < 2) {
                return old;
            }
            if (t.length >= 0x100000) {
                return old;
            }
            long r = this._resizers;
            int newbytes = t.length << 1 << 3;
            while (!_resizerUpdater.compareAndSet(this, r, r + (long)newbytes)) {
                r = this._resizers;
            }
            r += (long)newbytes;
            if (master._cat != this) {
                return old;
            }
            if (r >> 17 != 0L) {
                try {
                    Thread.sleep(r >> 17);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (master._cat != this) {
                    return old;
                }
            }
            CAT newcat = new CAT(this, t.length * 2, 0);
            master.CAS_cat(this, newcat);
            return old;
        }

        public boolean isZero(ScalableReadWriteLock2 master) {
            if (this._next != null) {
                if (this._next.isZero(master)) {
                    if (master._writer != 0) {
                        this._next = null;
                    }
                } else {
                    return false;
                }
            }
            long[] t = this._t;
            for (int i = 0; i < t.length; ++i) {
                if (t[i] == 0L) continue;
                return false;
            }
            return true;
        }

        public void awaitZero(boolean interrupt) throws InterruptedException {
            SPW spw = new SPW();
            if (this._next != null) {
                this._next.awaitZero(interrupt);
                this._next = null;
            }
            long[] t = this._t;
            for (int i = 0; i < t.length; ++i) {
                while (t[i] != 0L) {
                    spw.spin(interrupt);
                }
            }
        }

        public void print() {
            long[] t = this._t;
            for (int i = 1; i < t.length; ++i) {
                System.out.print("," + t[i]);
            }
            System.out.print("]");
            if (this._next != null) {
                this._next.print();
            }
        }
    }
}

