package net.corda.plugins;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

import java.io.IOException;

import static org.junit.Assert.assertEquals;

public class KotlinAutoGeneratedClassTest {
    private final TemporaryFolder testProjectDir = new TemporaryFolder();
    private final GradleProject testProject = new GradleProject(testProjectDir, "kotlin-auto-generated-class");

    @Rule
    public TestRule rules = RuleChain.outerRule(testProjectDir).around(testProject);

    @Test
    public void testKotlinAutoGeneratedClassMethod() throws IOException {
        assertEquals("public final class net.corda.example.ContainsAutoGeneratedClass extends java.lang.Object\n" +
            "  public <init>()\n" +
            "  public final void methodContainingInlinedFunction()\n" +
            "##", testProject.getApiText());
    }
}