/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.security.MessageDigest;
import sandbox.java.security.NoSuchAlgorithmException;
import sandbox.java.security.SecureRandom;

public final class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = -4856846361193249489L;
    private final long mostSigBits;
    private final long leastSigBits;
    static final /* synthetic */ boolean $assertionsDisabled;

    private UUID(byte[] byArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        long l = 0L;
        long l2 = 0L;
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            int n = byArray.length;
            RuntimeCostAccounter.recordJump();
            if (n != 16) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
                AssertionError assertionError = new AssertionError((Object)"data must be 16 bytes in length");
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= 8) break;
            l = l << 8 | (long)(byArray[n] & 0xFF);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        n = 8;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= 16) break;
            l2 = l2 << 8 | (long)(byArray[n] & 0xFF);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        this.mostSigBits = l;
        this.leastSigBits = l2;
    }

    public UUID(long l, long l2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.mostSigBits = l;
        this.leastSigBits = l2;
    }

    public static UUID randomUUID() {
        SecureRandom secureRandom = Holder.numberGenerator;
        RuntimeCostAccounter.recordArrayAllocation((int)16, (int)1);
        byte[] byArray = new byte[16];
        RuntimeCostAccounter.recordMethodCall((String)"java/security/SecureRandom.nextBytes:([B)V");
        secureRandom.nextBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0x80);
        RuntimeCostAccounter.recordAllocation((String)"java/util/UUID");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.<init>:([B)V");
        return new UUID(byArray);
    }

    public static UUID nameUUIDFromBytes(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/security/MessageDigest.getInstance:(Ljava/lang/String;)Ljava/security/MessageDigest;");
            messageDigest = MessageDigest.getInstance((String)"MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError("MD5 not supported", noSuchAlgorithmException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/security/MessageDigest.digest:([B)[B");
        byte[] byArray2 = messageDigest.digest(byArray);
        byArray2[6] = (byte)(byArray2[6] & 0xF);
        byArray2[6] = (byte)(byArray2[6] | 0x30);
        byArray2[8] = (byte)(byArray2[8] & 0x3F);
        byArray2[8] = (byte)(byArray2[8] | 0x80);
        RuntimeCostAccounter.recordAllocation((String)"java/util/UUID");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.<init>:([B)V");
        return new UUID(byArray2);
    }

    public static UUID fromString(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.split:(Ljava/lang/String;)[Ljava/lang/String;");
        String[] stringArray = string.split("-");
        int n = stringArray.length;
        RuntimeCostAccounter.recordJump();
        if (n != 5) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid UUID string: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= 5) break;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("0x");
            String string3 = stringArray[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n2] = stringBuilder5.toString();
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        String string4 = stringArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.decode:(Ljava/lang/String;)Ljava/lang/Long;");
        Long l = Long.decode(string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l2 = l;
        l2 <<= 16;
        String string5 = stringArray[1];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.decode:(Ljava/lang/String;)Ljava/lang/Long;");
        Long l3 = Long.decode(string5);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        l2 |= l3.longValue();
        l2 <<= 16;
        String string6 = stringArray[2];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.decode:(Ljava/lang/String;)Ljava/lang/Long;");
        Long l4 = Long.decode(string6);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        l2 |= l4.longValue();
        String string7 = stringArray[3];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.decode:(Ljava/lang/String;)Ljava/lang/Long;");
        Long l5 = Long.decode(string7);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l6 = l5;
        l6 <<= 48;
        String string8 = stringArray[4];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.decode:(Ljava/lang/String;)Ljava/lang/Long;");
        Long l7 = Long.decode(string8);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        RuntimeCostAccounter.recordAllocation((String)"java/util/UUID");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.<init>:(JJ)V");
        return new UUID(l2, l6 |= l7.longValue());
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        return (int)(this.mostSigBits >> 12 & 0xFL);
    }

    public int variant() {
        return (int)(this.leastSigBits >>> (int)(64L - (this.leastSigBits >>> 62)) & this.leastSigBits >> 63);
    }

    public long timestamp() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.version:()I");
        int n = this.version();
        RuntimeCostAccounter.recordJump();
        if (n != 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:(Ljava/lang/String;)V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Not a time-based UUID");
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }
        return (this.mostSigBits & 0xFFFL) << 48 | (this.mostSigBits >> 16 & 0xFFFFL) << 32 | this.mostSigBits >>> 32;
    }

    public int clockSequence() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.version:()I");
        int n = this.version();
        RuntimeCostAccounter.recordJump();
        if (n != 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:(Ljava/lang/String;)V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Not a time-based UUID");
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }
        return (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
    }

    public long node() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.version:()I");
        int n = this.version();
        RuntimeCostAccounter.recordJump();
        if (n != 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:(Ljava/lang/String;)V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Not a time-based UUID");
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }
        return this.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.digits:(JI)Ljava/lang/String;");
        String string = UUID.digits(this.mostSigBits >> 32, 8);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("-");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.digits:(JI)Ljava/lang/String;");
        String string2 = UUID.digits(this.mostSigBits >> 16, 4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append("-");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.digits:(JI)Ljava/lang/String;");
        String string3 = UUID.digits(this.mostSigBits, 4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append("-");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.digits:(JI)Ljava/lang/String;");
        String string4 = UUID.digits(this.leastSigBits >> 48, 4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append("-");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/UUID.digits:(JI)Ljava/lang/String;");
        String string5 = UUID.digits(this.leastSigBits, 12);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder10 = stringBuilder9.append(string5);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder10.toString();
    }

    private static String digits(long l, int n) {
        long l2 = 1L << n * 4;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toHexString:(J)Ljava/lang/String;");
        String string = Long.toHexString(l2 | l & l2 - 1L);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
        return string.substring(1);
    }

    public int hashCode() {
        long l = this.mostSigBits ^ this.leastSigBits;
        return (int)(l >> 32) ^ (int)l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (null == object) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = object.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz != UUID.class) {
            return false;
        }
        UUID uUID = (UUID)object;
        long l = this.mostSigBits - uUID.mostSigBits;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 != false) return false;
        long l3 = this.leastSigBits - uUID.leastSigBits;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l4 != false) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    @Override
    public int compareTo(UUID uUID) {
        int n;
        long l = this.mostSigBits - uUID.mostSigBits;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 < 0) {
            n = -1;
            RuntimeCostAccounter.recordJump();
        } else {
            long l3 = this.mostSigBits - uUID.mostSigBits;
            long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l4 > 0) {
                n = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                long l5 = this.leastSigBits - uUID.leastSigBits;
                long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l6 < 0) {
                    n = -1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    long l7 = this.leastSigBits - uUID.leastSigBits;
                    long l8 = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l8 > 0) {
                        n = 1;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = 0;
                    }
                }
            }
        }
        return n;
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = UUID.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
    }

    private static class Holder {
        static final SecureRandom numberGenerator;

        private Holder() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/security/SecureRandom");
            RuntimeCostAccounter.recordMethodCall((String)"java/security/SecureRandom.<init>:()V");
            numberGenerator = new SecureRandom();
        }
    }
}

