/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.lang.reflect.Array;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractCollection;
import sandbox.java.util.AbstractMap;
import sandbox.java.util.AbstractSet;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.EnumMap;
import sandbox.java.util.Iterator;
import sandbox.java.util.Map;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Set;
import sandbox.sun.misc.JavaLangAccess;
import sandbox.sun.misc.SharedSecrets;

public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private final Class<K> keyType;
    private transient K[] keyUniverse;
    private transient Object[] vals;
    private transient int size;
    private static final Object NULL;
    private static final Enum<?>[] ZERO_LENGTH_ENUM_ARRAY;
    private transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 458661240069192865L;

    private Object maskNull(Object object) {
        Object object2;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            object2 = NULL;
            RuntimeCostAccounter.recordJump();
        } else {
            object2 = object;
        }
        return object2;
    }

    private V unmaskNull(Object object) {
        Object object2;
        RuntimeCostAccounter.recordJump();
        if (object == NULL) {
            object2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            object2 = object;
        }
        return (V)object2;
    }

    public EnumMap(Class<K> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
        this.size = 0;
        this.keyType = clazz;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.getKeyUniverse:(Ljava/lang/Class;)[Ljava/lang/Enum;");
        this.keyUniverse = EnumMap.getKeyUniverse(clazz);
        int n = this.keyUniverse.length;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        this.vals = new Object[n];
    }

    public EnumMap(EnumMap<K, ? extends V> enumMap) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
        this.size = 0;
        this.keyType = enumMap.keyType;
        this.keyUniverse = enumMap.keyUniverse;
        Object[] objectArray = enumMap.vals;
        RuntimeCostAccounter.recordMethodCall((String)"[Ljava/lang/Object;.clone:()Ljava/lang/Object;");
        this.vals = (Object[])objectArray.clone();
        this.size = enumMap.size;
    }

    public EnumMap(Map<K, ? extends V> map) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
        this.size = 0;
        boolean bl = map instanceof EnumMap;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            EnumMap enumMap = (EnumMap)map;
            this.keyType = enumMap.keyType;
            this.keyUniverse = enumMap.keyUniverse;
            Object[] objectArray = enumMap.vals;
            RuntimeCostAccounter.recordMethodCall((String)"[Ljava/lang/Object;.clone:()Ljava/lang/Object;");
            this.vals = (Object[])objectArray.clone();
            this.size = enumMap.size;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
            boolean bl2 = map.isEmpty();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Specified map is empty");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
            Set<K> set = map.keySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            Iterator<K> iterator = set.iterator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Enum enum_ = (Enum)iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.getDeclaringClass:()Ljava/lang/Class;");
            this.keyType = enum_.getDeclaringClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.getKeyUniverse:(Ljava/lang/Class;)[Ljava/lang/Enum;");
            this.keyUniverse = EnumMap.getKeyUniverse(this.keyType);
            int n = this.keyUniverse.length;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            this.vals = new Object[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.putAll:(Ljava/util/Map;)V");
            this.putAll(map);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsValue(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        object = this.maskNull(object);
        Object[] objectArray = this.vals;
        int n = objectArray.length;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            Object object2 = objectArray[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            boolean bl = object.equals(object2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return true;
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsKey(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.isValidKey:(Ljava/lang/Object;)Z");
        boolean bl = this.isValidKey(object);
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        Enum enum_ = (Enum)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.ordinal:()I");
        Object object2 = this.vals[enum_.ordinal()];
        RuntimeCostAccounter.recordJump();
        if (object2 == null) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsMapping(Object object, Object object2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.isValidKey:(Ljava/lang/Object;)Z");
        boolean bl = this.isValidKey(object);
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object3 = this.maskNull(object2);
        Enum enum_ = (Enum)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.ordinal:()I");
        Object object4 = this.vals[enum_.ordinal()];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = object3.equals(object4);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    @Override
    public V get(Object object) {
        V v;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.isValidKey:(Ljava/lang/Object;)Z");
        boolean bl = this.isValidKey(object);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Enum enum_ = (Enum)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.ordinal:()I");
            Object object2 = this.vals[enum_.ordinal()];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            v = this.unmaskNull(object2);
            RuntimeCostAccounter.recordJump();
        } else {
            v = null;
        }
        return v;
    }

    @Override
    public V put(K k, V v) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.typeCheck:(Ljava/lang/Enum;)V");
        this.typeCheck(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.ordinal:()I");
        int n = ((Enum)k).ordinal();
        Object object = this.vals[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        this.vals[n] = this.maskNull(v);
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            ++this.size;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        return this.unmaskNull(object);
    }

    @Override
    public V remove(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.isValidKey:(Ljava/lang/Object;)Z");
        boolean bl = this.isValidKey(object);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return null;
        }
        Enum enum_ = (Enum)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.ordinal:()I");
        int n = enum_.ordinal();
        Object object2 = this.vals[n];
        this.vals[n] = null;
        RuntimeCostAccounter.recordJump();
        if (object2 != null) {
            --this.size;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        return this.unmaskNull(object2);
    }

    private boolean removeMapping(Object object, Object object2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.isValidKey:(Ljava/lang/Object;)Z");
        boolean bl = this.isValidKey(object);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        Enum enum_ = (Enum)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.ordinal:()I");
        int n = enum_.ordinal();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object3 = this.maskNull(object2);
        Object object4 = this.vals[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = object3.equals(object4);
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            this.vals[n] = null;
            --this.size;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidKey(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = object.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz != this.keyType) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSuperclass:()Ljava/lang/Class;");
            Class<?> clazz2 = clazz.getSuperclass();
            RuntimeCostAccounter.recordJump();
            if (clazz2 != this.keyType) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        boolean bl = map instanceof EnumMap;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            EnumMap enumMap = (EnumMap)map;
            Class<K> clazz = enumMap.keyType;
            RuntimeCostAccounter.recordJump();
            if (clazz != this.keyType) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.isEmpty:()Z");
                boolean bl2 = enumMap.isEmpty();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    return;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                Class<K> clazz2 = enumMap.keyType;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(clazz2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(" != ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(this.keyType);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder4.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
                ClassCastException classCastException = new ClassCastException(string);
                RuntimeCostAccounter.recordThrow();
                throw classCastException;
            }
            int n = 0;
            while (true) {
                int n2 = this.keyUniverse.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                Object object = enumMap.vals[n];
                RuntimeCostAccounter.recordJump();
                if (object != null) {
                    Object object2 = this.vals[n];
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) {
                        ++this.size;
                    }
                    this.vals[n] = object;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.putAll:(Ljava/util/Map;)V");
            super.putAll(map);
        }
    }

    @Override
    public void clear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([Ljava/lang/Object;Ljava/lang/Object;)V");
        Arrays.fill(this.vals, null);
        this.size = 0;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        RuntimeCostAccounter.recordJump();
        if (set != null) {
            return set;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/EnumMap$KeySet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$KeySet.<init>:(Ljava/util/EnumMap;Ljava/util/EnumMap$1;)V");
        this.keySet = new KeySet(this, null);
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        RuntimeCostAccounter.recordJump();
        if (collection != null) {
            return collection;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/EnumMap$Values");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$Values.<init>:(Ljava/util/EnumMap;Ljava/util/EnumMap$1;)V");
        this.values = new Values(this, null);
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        RuntimeCostAccounter.recordJump();
        if (set != null) {
            return set;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/EnumMap$EntrySet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntrySet.<init>:(Ljava/util/EnumMap;Ljava/util/EnumMap$1;)V");
        this.entrySet = new EntrySet(this, null);
        return this.entrySet;
    }

    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof EnumMap;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            EnumMap enumMap = (EnumMap)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.equals:(Ljava/util/EnumMap;)Z");
            return this.equals(enumMap);
        }
        boolean bl2 = object instanceof Map;
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            return false;
        }
        Map map = (Map)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
        int n = map.size();
        RuntimeCostAccounter.recordJump();
        if (this.size != n) {
            return false;
        }
        int n2 = 0;
        while (true) {
            block8: {
                V v;
                K k;
                block9: {
                    block10: {
                        int n3 = this.keyUniverse.length;
                        RuntimeCostAccounter.recordJump();
                        if (n2 >= n3) break;
                        Object object2 = this.vals[n2];
                        RuntimeCostAccounter.recordJump();
                        if (null == object2) break block8;
                        k = this.keyUniverse[n2];
                        Object object3 = this.vals[n2];
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                        v = this.unmaskNull(object3);
                        RuntimeCostAccounter.recordJump();
                        if (null != v) break block9;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        Object v2 = map.get(k);
                        RuntimeCostAccounter.recordJump();
                        if (null != v2) break block10;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                        boolean bl3 = map.containsKey(k);
                        RuntimeCostAccounter.recordJump();
                        if (bl3) break block8;
                    }
                    return false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                Object v3 = map.get(k);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl4 = v.equals(v3);
                RuntimeCostAccounter.recordJump();
                if (!bl4) {
                    return false;
                }
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean equals(EnumMap<?, ?> enumMap) {
        Class<K> clazz = enumMap.keyType;
        RuntimeCostAccounter.recordJump();
        if (clazz != this.keyType) {
            RuntimeCostAccounter.recordJump();
            if (this.size != 0) return false;
            int n = enumMap.size;
            RuntimeCostAccounter.recordJump();
            if (n != 0) return false;
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }
        int n = 0;
        while (true) {
            int n2 = this.keyUniverse.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) return true;
            Object object = this.vals[n];
            Object object2 = enumMap.vals[n];
            RuntimeCostAccounter.recordJump();
            if (object2 != object) {
                RuntimeCostAccounter.recordJump();
                if (object2 == null) return false;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object2.equals(object);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3 = this.keyUniverse.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            Object object = this.vals[n2];
            RuntimeCostAccounter.recordJump();
            if (null != object) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.entryHashCode:(I)I");
                n += this.entryHashCode(n2);
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    private int entryHashCode(int n) {
        K k = this.keyUniverse[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.hashCode:()I");
        int n2 = ((Enum)k).hashCode();
        Object object = this.vals[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        return n2 ^ object.hashCode();
    }

    @Override
    public EnumMap<K, V> clone() {
        EnumMap enumMap = null;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.clone:()Ljava/lang/Object;");
            enumMap = (EnumMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
            AssertionError assertionError = new AssertionError();
            RuntimeCostAccounter.recordThrow();
            throw assertionError;
        }
        RuntimeCostAccounter.recordJump();
        Object[] objectArray = enumMap.vals;
        RuntimeCostAccounter.recordMethodCall((String)"[Ljava/lang/Object;.clone:()Ljava/lang/Object;");
        enumMap.vals = (Object[])objectArray.clone();
        enumMap.entrySet = null;
        return enumMap;
    }

    private void typeCheck(K k) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = k.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz != this.keyType) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSuperclass:()Ljava/lang/Class;");
            Class<?> clazz2 = clazz.getSuperclass();
            RuntimeCostAccounter.recordJump();
            if (clazz2 != this.keyType) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(clazz);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(" != ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(this.keyType);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder4.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
                ClassCastException classCastException = new ClassCastException(string);
                RuntimeCostAccounter.recordThrow();
                throw classCastException;
            }
        }
    }

    private static <K extends Enum<K>> K[] getKeyUniverse(Class<K> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/SharedSecrets.getJavaLangAccess:()Lsun/misc/JavaLangAccess;");
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/JavaLangAccess.getEnumConstantsShared:(Ljava/lang/Class;)[Ljava/lang/Enum;");
        return javaLangAccess.getEnumConstantsShared(clazz);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
        objectOutputStream.writeInt(this.size);
        int n = this.size;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            Object object = this.vals[n2];
            RuntimeCostAccounter.recordJump();
            if (null != object) {
                K k = this.keyUniverse[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
                objectOutputStream.writeObject(k);
                Object object2 = this.vals[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                V v = this.unmaskNull(object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
                objectOutputStream.writeObject(v);
                --n;
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.getKeyUniverse:(Ljava/lang/Class;)[Ljava/lang/Enum;");
        this.keyUniverse = EnumMap.getKeyUniverse(this.keyType);
        int n = this.keyUniverse.length;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        this.vals = new Object[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readInt:()I");
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            Enum enum_ = (Enum)objectInputStream.readObject();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            Object object = objectInputStream.readObject();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.put:(Ljava/lang/Enum;Ljava/lang/Object;)Ljava/lang/Object;");
            this.put((K)enum_, (V)object);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
    }

    static /* synthetic */ Object access$500(EnumMap enumMap, Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        return enumMap.maskNull(object);
    }

    static /* synthetic */ boolean access$900(EnumMap enumMap, Object object, Object object2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.containsMapping:(Ljava/lang/Object;Ljava/lang/Object;)Z");
        return enumMap.containsMapping(object, object2);
    }

    static /* synthetic */ boolean access$1000(EnumMap enumMap, Object object, Object object2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.removeMapping:(Ljava/lang/Object;Ljava/lang/Object;)Z");
        return enumMap.removeMapping(object, object2);
    }

    static /* synthetic */ Object access$1200(EnumMap enumMap, Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        return enumMap.unmaskNull(object);
    }

    static /* synthetic */ int access$1600(EnumMap enumMap, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.entryHashCode:(I)I");
        return enumMap.entryHashCode(n);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/EnumMap$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$1.<init>:()V");
        NULL = new Object(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public int hashCode() {
                return 0;
            }

            public String toString() {
                return "java.util.EnumMap.NULL";
            }
        };
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        ZERO_LENGTH_ENUM_ARRAY = new Enum[0];
    }

    private class EntryIterator
    extends EnumMapIterator<Map.Entry<K, V>> {
        private sandbox.java.util.EnumMap$EntryIterator.Entry lastReturnedEntry;
        final /* synthetic */ EnumMap this$0;

        private EntryIterator(EnumMap enumMap) {
            this.this$0 = enumMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EnumMapIterator.<init>:(Ljava/util/EnumMap;Ljava/util/EnumMap$1;)V");
            super(enumMap, null);
        }

        @Override
        public Map.Entry<K, V> next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator.hasNext:()Z");
            boolean bl = this.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/EnumMap$EntryIterator$Entry");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator$Entry.<init>:(Ljava/util/EnumMap$EntryIterator;ILjava/util/EnumMap$1;)V");
            this.lastReturnedEntry = new Entry(this, this.index++, null);
            return this.lastReturnedEntry;
        }

        @Override
        public void remove() {
            int n;
            RuntimeCostAccounter.recordJump();
            if (null == this.lastReturnedEntry) {
                n = -1;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator$Entry.access$1500:(Ljava/util/EnumMap$EntryIterator$Entry;)I");
                n = ((Entry)this.lastReturnedEntry).index;
            }
            this.lastReturnedIndex = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EnumMapIterator.remove:()V");
            super.remove();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator$Entry.access$1502:(Ljava/util/EnumMap$EntryIterator$Entry;I)I");
            ((Entry)this.lastReturnedEntry).index = this.lastReturnedIndex;
            this.lastReturnedEntry = null;
        }

        /* synthetic */ EntryIterator(EnumMap enumMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator.<init>:(Ljava/util/EnumMap;)V");
            this(enumMap);
        }

        private class Entry
        implements Map.Entry<K, V> {
            private int index;
            final /* synthetic */ EntryIterator this$1;

            private Entry(EntryIterator entryIterator, int n) {
                this.this$1 = entryIterator;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.index = n;
            }

            @Override
            public K getKey() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator$Entry.checkIndexForEntryUse:()V");
                this.checkIndexForEntryUse();
                EnumMap enumMap = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1100:(Ljava/util/EnumMap;)[Ljava/lang/Enum;");
                return enumMap.keyUniverse[this.index];
            }

            @Override
            public V getValue() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator$Entry.checkIndexForEntryUse:()V");
                this.checkIndexForEntryUse();
                EnumMap enumMap = this.this$1.this$0;
                EnumMap enumMap2 = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                Object object = enumMap2.vals[this.index];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1200:(Ljava/util/EnumMap;Ljava/lang/Object;)Ljava/lang/Object;");
                return EnumMap.access$1200(enumMap, object);
            }

            @Override
            public V setValue(V v) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator$Entry.checkIndexForEntryUse:()V");
                this.checkIndexForEntryUse();
                EnumMap enumMap = this.this$1.this$0;
                EnumMap enumMap2 = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                Object object = enumMap2.vals[this.index];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1200:(Ljava/util/EnumMap;Ljava/lang/Object;)Ljava/lang/Object;");
                Object object2 = EnumMap.access$1200(enumMap, object);
                EnumMap enumMap3 = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                Object[] objectArray = enumMap3.vals;
                EnumMap enumMap4 = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$500:(Ljava/util/EnumMap;Ljava/lang/Object;)Ljava/lang/Object;");
                objectArray[this.index] = EnumMap.access$500(enumMap4, v);
                return object2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object object) {
                RuntimeCostAccounter.recordJump();
                if (this.index < 0) {
                    RuntimeCostAccounter.recordJump();
                    if (object != this) return false;
                    boolean bl = true;
                    RuntimeCostAccounter.recordJump();
                    return bl;
                }
                boolean bl = object instanceof Map.Entry;
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                EnumMap enumMap = this.this$1.this$0;
                EnumMap enumMap2 = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                Object object2 = enumMap2.vals[this.index];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1200:(Ljava/util/EnumMap;Ljava/lang/Object;)Ljava/lang/Object;");
                Object object3 = EnumMap.access$1200(enumMap, object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                EnumMap enumMap3 = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1100:(Ljava/util/EnumMap;)[Ljava/lang/Enum;");
                Enum enum_ = enumMap3.keyUniverse[this.index];
                RuntimeCostAccounter.recordJump();
                if (k != enum_) return false;
                RuntimeCostAccounter.recordJump();
                if (object3 != v) {
                    RuntimeCostAccounter.recordJump();
                    if (object3 == null) return false;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl2 = object3.equals(v);
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) return false;
                }
                boolean bl3 = true;
                RuntimeCostAccounter.recordJump();
                return bl3;
            }

            @Override
            public int hashCode() {
                RuntimeCostAccounter.recordJump();
                if (this.index < 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
                    return super.hashCode();
                }
                EnumMap enumMap = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1600:(Ljava/util/EnumMap;I)I");
                return EnumMap.access$1600(enumMap, this.index);
            }

            public String toString() {
                RuntimeCostAccounter.recordJump();
                if (this.index < 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                    return super.toString();
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                EnumMap enumMap = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1100:(Ljava/util/EnumMap;)[Ljava/lang/Enum;");
                Enum enum_ = enumMap.keyUniverse[this.index];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(enum_);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append("=");
                EnumMap enumMap2 = this.this$1.this$0;
                EnumMap enumMap3 = this.this$1.this$0;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                Object object = enumMap3.vals[this.index];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1200:(Ljava/util/EnumMap;Ljava/lang/Object;)Ljava/lang/Object;");
                Object object2 = EnumMap.access$1200(enumMap2, object);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                return stringBuilder4.toString();
            }

            private void checkIndexForEntryUse() {
                RuntimeCostAccounter.recordJump();
                if (this.index < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                    IllegalStateException illegalStateException = new IllegalStateException("Entry was removed");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
            }

            /* synthetic */ Entry(EntryIterator entryIterator, int n, 1 var3_3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator$Entry.<init>:(Ljava/util/EnumMap$EntryIterator;I)V");
                this(entryIterator, n);
            }
        }
    }

    private class ValueIterator
    extends EnumMapIterator<V> {
        final /* synthetic */ EnumMap this$0;

        private ValueIterator(EnumMap enumMap) {
            this.this$0 = enumMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EnumMapIterator.<init>:(Ljava/util/EnumMap;Ljava/util/EnumMap$1;)V");
            super(enumMap, null);
        }

        @Override
        public V next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$ValueIterator.hasNext:()Z");
            boolean bl = this.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            this.lastReturnedIndex = this.index++;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
            Object object = this.this$0.vals[this.lastReturnedIndex];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1200:(Ljava/util/EnumMap;Ljava/lang/Object;)Ljava/lang/Object;");
            return EnumMap.access$1200(this.this$0, object);
        }

        /* synthetic */ ValueIterator(EnumMap enumMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$ValueIterator.<init>:(Ljava/util/EnumMap;)V");
            this(enumMap);
        }
    }

    private class KeyIterator
    extends EnumMapIterator<K> {
        final /* synthetic */ EnumMap this$0;

        private KeyIterator(EnumMap enumMap) {
            this.this$0 = enumMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EnumMapIterator.<init>:(Ljava/util/EnumMap;Ljava/util/EnumMap$1;)V");
            super(enumMap, null);
        }

        @Override
        public K next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$KeyIterator.hasNext:()Z");
            boolean bl = this.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
            this.lastReturnedIndex = this.index++;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1100:(Ljava/util/EnumMap;)[Ljava/lang/Enum;");
            return this.this$0.keyUniverse[this.lastReturnedIndex];
        }

        /* synthetic */ KeyIterator(EnumMap enumMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$KeyIterator.<init>:(Ljava/util/EnumMap;)V");
            this(enumMap);
        }
    }

    private abstract class EnumMapIterator<T>
    implements Iterator<T> {
        int index;
        int lastReturnedIndex;
        final /* synthetic */ EnumMap this$0;

        private EnumMapIterator(EnumMap enumMap) {
            this.this$0 = enumMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.index = 0;
            this.lastReturnedIndex = -1;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                int n = this.this$0.vals.length;
                RuntimeCostAccounter.recordJump();
                if (this.index >= n) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                Object object = this.this$0.vals[this.index];
                RuntimeCostAccounter.recordJump();
                if (object != null) break;
                ++this.index;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
            int n = this.this$0.vals.length;
            RuntimeCostAccounter.recordJump();
            if (this.index != n) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EnumMapIterator.checkLastReturnedIndex:()V");
            this.checkLastReturnedIndex();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
            Object object = this.this$0.vals[this.lastReturnedIndex];
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                ((EnumMap)this.this$0).vals[this.lastReturnedIndex] = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$210:(Ljava/util/EnumMap;)I");
                this.this$0.size--;
            }
            this.lastReturnedIndex = -1;
        }

        private void checkLastReturnedIndex() {
            RuntimeCostAccounter.recordJump();
            if (this.lastReturnedIndex < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
        }

        /* synthetic */ EnumMapIterator(EnumMap enumMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EnumMapIterator.<init>:(Ljava/util/EnumMap;)V");
            this(enumMap);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final /* synthetic */ EnumMap this$0;

        private EntrySet(EnumMap enumMap) {
            this.this$0 = enumMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/EnumMap$EntryIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntryIterator.<init>:(Ljava/util/EnumMap;Ljava/util/EnumMap$1;)V");
            return new EntryIterator(this.this$0, null);
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Map.Entry;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            Object k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            Object v = entry.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$900:(Ljava/util/EnumMap;Ljava/lang/Object;Ljava/lang/Object;)Z");
            return EnumMap.access$900(this.this$0, k, v);
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = object instanceof Map.Entry;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            Object k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            Object v = entry.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1000:(Ljava/util/EnumMap;Ljava/lang/Object;Ljava/lang/Object;)Z");
            return EnumMap.access$1000(this.this$0, k, v);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$200:(Ljava/util/EnumMap;)I");
            return this.this$0.size;
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.clear:()V");
            this.this$0.clear();
        }

        @Override
        public Object[] toArray() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$200:(Ljava/util/EnumMap;)I");
            int n = this.this$0.size;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            Object[] objectArray = new Object[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntrySet.fillEntryArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            return this.fillEntryArray(objectArray);
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntrySet.size:()I");
            int n = this.size();
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 < n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = objectArray.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
                Class<?> clazz2 = clazz.getComponentType();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
                objectArray = (Object[])Array.newInstance(clazz2, n);
            }
            int n3 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n3 > n) {
                objectArray[n] = null;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntrySet.fillEntryArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            return this.fillEntryArray(objectArray);
        }

        private Object[] fillEntryArray(Object[] objectArray) {
            int n = 0;
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                int n3 = this.this$0.vals.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                Object object = this.this$0.vals[n2];
                RuntimeCostAccounter.recordJump();
                if (object != null) {
                    int n4 = n++;
                    RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleEntry");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1100:(Ljava/util/EnumMap;)[Ljava/lang/Enum;");
                    Enum enum_ = this.this$0.keyUniverse[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                    Object object2 = this.this$0.vals[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$1200:(Ljava/util/EnumMap;Ljava/lang/Object;)Ljava/lang/Object;");
                    Object object3 = EnumMap.access$1200(this.this$0, object2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
                    objectArray[n4] = new AbstractMap.SimpleEntry<Enum, Object>(enum_, object3);
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            return objectArray;
        }

        /* synthetic */ EntrySet(EnumMap enumMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$EntrySet.<init>:(Ljava/util/EnumMap;)V");
            this(enumMap);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        final /* synthetic */ EnumMap this$0;

        private Values(EnumMap enumMap) {
            this.this$0 = enumMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.<init>:()V");
        }

        @Override
        public Iterator<V> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/EnumMap$ValueIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$ValueIterator.<init>:(Ljava/util/EnumMap;Ljava/util/EnumMap$1;)V");
            return new ValueIterator(this.this$0, null);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$200:(Ljava/util/EnumMap;)I");
            return this.this$0.size;
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.containsValue:(Ljava/lang/Object;)Z");
            return this.this$0.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$500:(Ljava/util/EnumMap;Ljava/lang/Object;)Ljava/lang/Object;");
            object = EnumMap.access$500(this.this$0, object);
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                int n2 = this.this$0.vals.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                Object object2 = this.this$0.vals[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(object2);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$600:(Ljava/util/EnumMap;)[Ljava/lang/Object;");
                    ((EnumMap)this.this$0).vals[n] = null;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$210:(Ljava/util/EnumMap;)I");
                    this.this$0.size--;
                    return true;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            return false;
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.clear:()V");
            this.this$0.clear();
        }

        /* synthetic */ Values(EnumMap enumMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$Values.<init>:(Ljava/util/EnumMap;)V");
            this(enumMap);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        final /* synthetic */ EnumMap this$0;

        private KeySet(EnumMap enumMap) {
            this.this$0 = enumMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        }

        @Override
        public Iterator<K> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/EnumMap$KeyIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$KeyIterator.<init>:(Ljava/util/EnumMap;Ljava/util/EnumMap$1;)V");
            return new KeyIterator(this.this$0, null);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$200:(Ljava/util/EnumMap;)I");
            return this.this$0.size;
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.containsKey:(Ljava/lang/Object;)Z");
            return this.this$0.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$200:(Ljava/util/EnumMap;)I");
            int n = this.this$0.size;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.this$0.remove(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.access$200:(Ljava/util/EnumMap;)I");
            int n2 = this.this$0.size;
            RuntimeCostAccounter.recordJump();
            if (n2 != n) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap.clear:()V");
            this.this$0.clear();
        }

        /* synthetic */ KeySet(EnumMap enumMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumMap$KeySet.<init>:(Ljava/util/EnumMap;)V");
            this(enumMap);
        }
    }
}

