/*
 * Copyright 2023 Google LLC
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// WITH_RUNTIME
// TEST PROCESSOR: OverrideeProcessor
// EXPECTED:
// JavaAccessorImpl:
// JavaAccessorImpl.getX() -> KtInterfaceWithProperty.x
// JavaAccessorImpl.getY() -> KtInterfaceWithProperty.y
// JavaAccessorImpl.setY(value:Int) -> KtInterfaceWithProperty.y
// END

// FILE: a.kt
interface KtInterfaceWithProperty {
    val x:Int
    var y:Int
}

// FILE: JavaImpl.java
class JavaAccessorImpl implements KtInterfaceWithProperty {
    public int getX() {
        return 1;
    }
    public int getY() {
        return 1;
    }
    public void setY(int value) {
    }
}
