/*
 * Copyright 2020 Google LLC
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.devtools.ksp.processor

import com.google.devtools.ksp.getClassDeclarationByName
import com.google.devtools.ksp.processing.Resolver
import com.google.devtools.ksp.symbol.*

class MultiModuleTestProcessor : AbstractTestProcessor() {
    private val results = mutableListOf<String>()
    override fun toResult(): List<String> {
        return results
    }

    override fun process(resolver: Resolver): List<KSAnnotated> {
        val target = resolver.getClassDeclarationByName("TestTarget")
        val classes = mutableSetOf<KSClassDeclaration>()
        val classCollector = object : BaseVisitor() {
            override fun visitClassDeclaration(classDeclaration: KSClassDeclaration, data: Unit) {
                if (classes.add(classDeclaration)) {
                    super.visitClassDeclaration(classDeclaration, data)
                }
            }

            override fun visitPropertyDeclaration(property: KSPropertyDeclaration, data: Unit) {
                (property.type.resolve().declaration as? KSClassDeclaration)?.accept(this, Unit)
            }
        }
        target?.accept(classCollector, Unit)
        results.addAll(classes.map { it.toSignature() }.sorted())
        return emptyList()
    }

    private fun KSClassDeclaration.toSignature(): String {
        val id = qualifiedName?.asString() ?: "no-qual-name:($this)"
        return "$id[${origin.name}]"
    }
}
