import com.google.devtools.ksp.processing.*
import com.google.devtools.ksp.symbol.*

class TestProcessor : SymbolProcessor {
    lateinit var codeGenerator: CodeGenerator
    lateinit var logger: KSPLogger
    lateinit var options: Map<String, String>
    var rounds = 0

    fun init(
        options: Map<String, String>,
        kotlinVersion: KotlinVersion,
        codeGenerator: CodeGenerator,
        logger: KSPLogger
    ) {
        this.logger = logger
        this.options = options
        this.codeGenerator = codeGenerator
    }

    override fun process(resolver: Resolver): List<KSAnnotated> {
        if (options.containsKey("error")) {
            throw IllegalStateException("Error on request")
        }
        if (rounds++ == 0) {
            codeGenerator.createNewFile(Dependencies.ALL_FILES, "", "Status", "log").use {
                it.write("OK".toByteArray())
            }
        }
        return emptyList()
    }
}

class TestProcessorProvider : SymbolProcessorProvider {
    override fun create(
        env: SymbolProcessorEnvironment
    ): SymbolProcessor {
        return TestProcessor().apply {
            init(env.options, env.kotlinVersion, env.codeGenerator, env.logger)
        }
    }
}
