// Copyright (C) 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package semantic

// Invalid is a placeholder for an invalid expression or statement.
// They are only generated by the resolver when the source has a syntatic error.
type Invalid struct {
	// If part of the code could be parsed, then this is the partially parsed
	// node. For example Partial would hold a parsed expression if an incomplete
	// statement was formed.
	Partial Node
}

func (Invalid) isNode()       {}
func (Invalid) isExpression() {}
func (Invalid) isStatement()  {}

func (Invalid) ExpressionType() Type { return InvalidType }

// InvalidType is a placeholder for an invalid type.
// They are only generated by the resolver when the source has a syntatic error.
var InvalidType = builtin("<invalid>")
