// Copyright (C) 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ast

// Invalid is used when an error was encountered in the parsing, but we want to
// keep going. If there are no errors, this will never be in the tree.
type Invalid struct {
	ignore bool // filed added so the instances get a unique address
}

func (Invalid) isNode() {}

// InvalidGeneric is a placeholder for an expected, but invalid generic.
// They are only generated by the parser when the source has a syntatic error.
var InvalidGeneric = &Generic{InvalidIdentifier, nil}

// InvalidIdentifier is a placeholder for an expected, but invalid identifier.
// They are only generated by the parser when the source has a syntatic error.
var InvalidIdentifier = &Identifier{"<invalid>"}

// InvalidNumber is a placeholder for an expected, but invalid number.
// They are only generated by the parser when the source has a syntatic error.
var InvalidNumber = &Number{"<invalid>"}

// InvalidString is a placeholder for an expected, but invalid string.
// They are only generated by the parser when the source has a syntatic error.
var InvalidString = &String{"<invalid>"}
