// Copyright (C) 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package semantic_test

import "github.com/google/gapid/gapil/semantic"

var (
	_ = []semantic.Node{
		&semantic.Abort{},
		&semantic.Annotation{},
		&semantic.API{},
		&semantic.ArrayAssign{},
		&semantic.ArrayIndex{},
		&semantic.ArrayInitializer{},
		&semantic.Assert{},
		&semantic.Assign{},
		&semantic.BinaryOp{},
		&semantic.BitTest{},
		&semantic.Block{},
		&semantic.Branch{},
		&semantic.Builtin{},
		&semantic.Call{},
		&semantic.Callable{},
		&semantic.Case{},
		&semantic.Cast{},
		&semantic.Choice{},
		&semantic.Class{},
		&semantic.ClassInitializer{},
		&semantic.Clone{},
		&semantic.Copy{},
		&semantic.Create{},
		&semantic.DeclareLocal{},
		&semantic.Definition{},
		&semantic.DefinitionUsage{},
		&semantic.Enum{},
		&semantic.EnumEntry{},
		&semantic.Fence{},
		&semantic.Field{},
		&semantic.FieldInitializer{},
		&semantic.Function{},
		&semantic.Global{},
		&semantic.Ignore{},
		&semantic.Iteration{},
		&semantic.Length{},
		&semantic.Local{},
		&semantic.Make{},
		&semantic.Map{},
		&semantic.MapAssign{},
		&semantic.MapContains{},
		&semantic.MapIndex{},
		&semantic.MapIteration{},
		&semantic.MapRemove{},
		&semantic.MapClear{},
		&semantic.Member{},
		&semantic.MessageValue{},
		&semantic.New{},
		&semantic.Observed{},
		&semantic.Parameter{},
		&semantic.Pointer{},
		&semantic.PointerRange{},
		&semantic.Print{},
		&semantic.Pseudonym{},
		&semantic.Read{},
		&semantic.Reference{},
		&semantic.Return{},
		&semantic.Select{},
		&semantic.Signature{},
		&semantic.Slice{},
		&semantic.SliceAssign{},
		&semantic.SliceContains{},
		&semantic.SliceIndex{},
		&semantic.SliceRange{},
		&semantic.StaticArray{},
		&semantic.Switch{},
		&semantic.UnaryOp{},
		&semantic.Unknown{},
		&semantic.Write{},
		semantic.BoolValue(false),
		semantic.Documentation{},
		semantic.Float32Value(0),
		semantic.Float64Value(0),
		semantic.Int16Value(0),
		semantic.Int32Value(0),
		semantic.Int64Value(0),
		semantic.Int8Value(0),
		semantic.Invalid{},
		semantic.Null{},
		semantic.Statements{},
		semantic.StringValue(""),
		semantic.Uint16Value(0),
		semantic.Uint32Value(0),
		semantic.Uint64Value(0),
		semantic.Uint8Value(0),
	}

	_ = []semantic.Expression{
		&semantic.ArrayIndex{},
		&semantic.ArrayInitializer{},
		&semantic.BinaryOp{},
		&semantic.BitTest{},
		&semantic.Call{},
		&semantic.Callable{},
		&semantic.Cast{},
		&semantic.ClassInitializer{},
		&semantic.Clone{},
		&semantic.Create{},
		&semantic.Definition{},
		&semantic.DefinitionUsage{},
		&semantic.EnumEntry{},
		&semantic.Field{},
		&semantic.Global{},
		&semantic.Ignore{},
		&semantic.Length{},
		&semantic.Local{},
		&semantic.Make{},
		&semantic.MapContains{},
		&semantic.MapIndex{},
		&semantic.Member{},
		&semantic.MessageValue{},
		&semantic.New{},
		&semantic.Observed{},
		&semantic.Parameter{},
		&semantic.PointerRange{},
		&semantic.Select{},
		&semantic.SliceContains{},
		&semantic.SliceIndex{},
		&semantic.SliceRange{},
		&semantic.UnaryOp{},
		&semantic.Unknown{},
		semantic.BoolValue(false),
		semantic.Float32Value(0),
		semantic.Float64Value(0),
		semantic.Int16Value(0),
		semantic.Int32Value(0),
		semantic.Int64Value(0),
		semantic.Int8Value(0),
		semantic.Invalid{},
		semantic.Null{},
		semantic.StringValue(""),
		semantic.Uint16Value(0),
		semantic.Uint32Value(0),
		semantic.Uint64Value(0),
		semantic.Uint8Value(0),
	}

	_ = []semantic.Statement{
		&semantic.Abort{},
		&semantic.ArrayAssign{},
		&semantic.Assert{},
		&semantic.Assign{},
		&semantic.Block{},
		&semantic.Branch{},
		&semantic.Call{},
		&semantic.Case{},
		&semantic.Copy{},
		&semantic.DeclareLocal{},
		&semantic.Fence{},
		&semantic.Iteration{},
		&semantic.MapAssign{},
		&semantic.MapIteration{},
		&semantic.MapRemove{},
		&semantic.MapClear{},
		&semantic.Print{},
		&semantic.Read{},
		&semantic.Return{},
		&semantic.SliceAssign{},
		&semantic.Switch{},
		&semantic.Write{},
		semantic.Invalid{},
	}

	_ = []semantic.Type{
		&semantic.Builtin{},
		&semantic.Class{},
		&semantic.Enum{},
		&semantic.Map{},
		&semantic.Pointer{},
		&semantic.Pseudonym{},
		&semantic.Reference{},
		&semantic.Signature{},
		&semantic.Slice{},
		&semantic.StaticArray{},
	}
)
